# VMKS exam generator

A simple CLI program for pseudo-randomly generating different variants of an embedded programming exam.
Designed for Technological school "Electronic Systems" in Sofia, Bulgaria.

When a new variant is generated an adjustable subset of questions is picked at random from a question bank.
Both questions and possible answers for multiple choice questions are shuffled.
Supports randomly picking parts of the question text from a predefined list of possible values.
This makes it possible to generate slightly different tasks such as  
"Write a program that prints asterisks in the shape of a square"  
and  
"Write a program that prints hashtags in the shape of a triangle".

### Usage
```
vmks-exam-generator [OPTIONS]

FLAGS:
    -h, --help       Prints help information
    -V, --version    Prints version information

OPTIONS:
    -s, --num-seed <SEED>             Use the number SEED to seed the random number generator
    -q, --question-bank <FILENAME>    XML file specifying the questions
    -S, --text-seed <SEED>            Use the hashsum of the string SEED to seed the random number generator
    -n, --variants <VARIANTS>         Number of variants to generate
```

If no seed is provided for the random number generator then the number of seconds since the start of the UNIX epoch is
used. The default number of variants to generate is 30 and the default name for the question bank file is
"questions.xml".

### Question bank file format
The set of questions used for generating different exam variants is described in XML format.
An example is provided in example_questions.xml.

Being an XML file, naturally the question bank file must start with a declaration of the XML version and encoding:
```<?xml version="1.0" encoding="UTF-8"?>```  
The entire set of questions is enclosed in a pair of opening and closing ```question_bank``` tags.
Questions are separated into groups with the ```question_group``` tags.
```question_group``` is the only type of tag in the current version of VMKS exam generator that can have an attribute.
Specifically, it can have the ```pick``` attribute that selects how many questions from the given group are to be picked.
If the ```pick``` attribute is not specified then all questions from the group will be present in every variant generated.
Each question can be either a multiple choice question or a question with variable segments.

Multiple choice questions are enclosed by a pair of ```question_mc``` tags and contain one ```question_text```
tag pair optionally followed by ```answer_mc``` pairs.
The actual text of the question is placed between the ```question_text``` tags. ```answer_mc``` tag pairs are
used to specify the possible answer choices.

Questions with variable segments consist of any number of ```question_text``` and ```var_text``` tag pairs.
Each ```var_text``` tag pair contains any number of ```option``` pairs which in turn contain
the different values that can appear at this position in the question text.
Parts of the question text that do not change between variants are placed inside ```question_text``` tag pairs.
