// Copyright (c) 2016 The vulkano developers
// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or
// https://www.apache.org/licenses/LICENSE-2.0> or the MIT
// license <LICENSE-MIT or https://opensource.org/licenses/MIT>,
// at your option. All files in the project carrying such
// notice may not be copied, modified, or distributed except
// according to those terms.

#![doc(html_logo_url = "https://raw.githubusercontent.com/vulkano-rs/vulkano/master/logo.png")]
#![allow(non_upper_case_globals)]
#![allow(non_snake_case)]
#![allow(non_camel_case_types)]

use std::ffi::CStr;
use std::fmt;
use std::mem;
use std::os::raw::c_char;
use std::os::raw::c_double;
use std::os::raw::c_ulong;
use std::os::raw::c_void;
use std::ptr;

pub type Flags = u32;
pub type Bool32 = u32;
pub type DeviceSize = u64;
pub type SampleMask = u32;

pub type Instance = usize;
pub type PhysicalDevice = usize;
pub type Device = usize;
pub type Queue = usize;
pub type CommandBuffer = usize;

pub type Semaphore = u64;
pub type Fence = u64;
pub type DeviceMemory = u64;
pub type Buffer = u64;
pub type Image = u64;
pub type Event = u64;
pub type QueryPool = u64;
pub type BufferView = u64;
pub type ImageView = u64;
pub type ShaderModule = u64;
pub type PipelineCache = u64;
pub type PipelineLayout = u64;
pub type RenderPass = u64;
pub type Pipeline = u64;
pub type DescriptorSetLayout = u64;
pub type Sampler = u64;
pub type DescriptorPool = u64;
pub type DescriptorSet = u64;
pub type Framebuffer = u64;
pub type CommandPool = u64;
pub type SurfaceKHR = u64;
pub type SwapchainKHR = u64;
pub type DisplayKHR = u64;
pub type DisplayModeKHR = u64;
pub type DescriptorUpdateTemplateKHR = u64;
pub type DeviceAddress = u64;

pub const LOD_CLAMP_NONE: f32 = 1000.0;
pub const REMAINING_MIP_LEVELS: u32 = 0xffffffff;
pub const REMAINING_ARRAY_LAYERS: u32 = 0xffffffff;
pub const WHOLE_SIZE: u64 = 0xffffffffffffffff;
pub const ATTACHMENT_UNUSED: u32 = 0xffffffff;
pub const TRUE: u32 = 1;
pub const FALSE: u32 = 0;
pub const QUEUE_FAMILY_IGNORED: u32 = 0xffffffff;
pub const QUEUE_FAMILY_EXTERNAL: u32 = 0xfffffffe;
pub const SUBPASS_EXTERNAL: u32 = 0xffffffff;
pub const MAX_PHYSICAL_DEVICE_NAME_SIZE: u32 = 256;
pub const UUID_SIZE: u32 = 16;
pub const MAX_MEMORY_TYPES: u32 = 32;
pub const MAX_MEMORY_HEAPS: u32 = 16;
pub const MAX_EXTENSION_NAME_SIZE: u32 = 256;
pub const MAX_DESCRIPTION_SIZE: u32 = 256;
pub const NULL_HANDLE: u64 = 0;

pub type PipelineCacheHeaderVersion = u32;
pub const PIPELINE_CACHE_HEADER_VERSION_ONE: u32 = 1;

pub type Result = u32;
pub const SUCCESS: u32 = 0;
pub const NOT_READY: u32 = 1;
pub const TIMEOUT: u32 = 2;
pub const EVENT_SET: u32 = 3;
pub const EVENT_RESET: u32 = 4;
pub const INCOMPLETE: u32 = 5;
pub const ERROR_OUT_OF_HOST_MEMORY: u32 = -1i32 as u32;
pub const ERROR_OUT_OF_DEVICE_MEMORY: u32 = -2i32 as u32;
pub const ERROR_INITIALIZATION_FAILED: u32 = -3i32 as u32;
pub const ERROR_DEVICE_LOST: u32 = -4i32 as u32;
pub const ERROR_MEMORY_MAP_FAILED: u32 = -5i32 as u32;
pub const ERROR_LAYER_NOT_PRESENT: u32 = -6i32 as u32;
pub const ERROR_EXTENSION_NOT_PRESENT: u32 = -7i32 as u32;
pub const ERROR_FEATURE_NOT_PRESENT: u32 = -8i32 as u32;
pub const ERROR_INCOMPATIBLE_DRIVER: u32 = -9i32 as u32;
pub const ERROR_TOO_MANY_OBJECTS: u32 = -10i32 as u32;
pub const ERROR_FORMAT_NOT_SUPPORTED: u32 = -11i32 as u32;
pub const ERROR_SURFACE_LOST_KHR: u32 = -1000000000i32 as u32;
pub const ERROR_NATIVE_WINDOW_IN_USE_KHR: u32 = -1000000001i32 as u32;
pub const SUBOPTIMAL_KHR: u32 = 1000001003;
pub const ERROR_OUT_OF_DATE_KHR: u32 = -1000001004i32 as u32;
pub const ERROR_INCOMPATIBLE_DISPLAY_KHR: u32 = -1000003001i32 as u32;
pub const ERROR_VALIDATION_FAILED_EXT: u32 = -1000011001i32 as u32;
pub const ERROR_INVALID_SHADER_NV: u32 = -1000012000i32 as u32;
pub const ERROR_OUT_OF_POOL_MEMORY_KHR: u32 = -1000069000i32 as u32;
pub const ERROR_FULL_SCREEN_EXCLUSIVE_MODE_LOST_EXT: u32 = -1000255000i32 as u32;

pub type StructureType = u32;
pub const STRUCTURE_TYPE_APPLICATION_INFO: u32 = 0;
pub const STRUCTURE_TYPE_INSTANCE_CREATE_INFO: u32 = 1;
pub const STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO: u32 = 2;
pub const STRUCTURE_TYPE_DEVICE_CREATE_INFO: u32 = 3;
pub const STRUCTURE_TYPE_SUBMIT_INFO: u32 = 4;
pub const STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO: u32 = 5;
pub const STRUCTURE_TYPE_MAPPED_MEMORY_RANGE: u32 = 6;
pub const STRUCTURE_TYPE_BIND_SPARSE_INFO: u32 = 7;
pub const STRUCTURE_TYPE_FENCE_CREATE_INFO: u32 = 8;
pub const STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO: u32 = 9;
pub const STRUCTURE_TYPE_EVENT_CREATE_INFO: u32 = 10;
pub const STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO: u32 = 11;
pub const STRUCTURE_TYPE_BUFFER_CREATE_INFO: u32 = 12;
pub const STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO: u32 = 13;
pub const STRUCTURE_TYPE_IMAGE_CREATE_INFO: u32 = 14;
pub const STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO: u32 = 15;
pub const STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: u32 = 16;
pub const STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO: u32 = 17;
pub const STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO: u32 = 18;
pub const STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO: u32 = 19;
pub const STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO: u32 = 20;
pub const STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO: u32 = 21;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO: u32 = 22;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO: u32 = 23;
pub const STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO: u32 = 24;
pub const STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO: u32 = 25;
pub const STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO: u32 = 26;
pub const STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO: u32 = 27;
pub const STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO: u32 = 28;
pub const STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO: u32 = 29;
pub const STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO: u32 = 30;
pub const STRUCTURE_TYPE_SAMPLER_CREATE_INFO: u32 = 31;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO: u32 = 32;
pub const STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO: u32 = 33;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO: u32 = 34;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET: u32 = 35;
pub const STRUCTURE_TYPE_COPY_DESCRIPTOR_SET: u32 = 36;
pub const STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO: u32 = 37;
pub const STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO: u32 = 38;
pub const STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO: u32 = 39;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO: u32 = 40;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO: u32 = 41;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO: u32 = 42;
pub const STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO: u32 = 43;
pub const STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER: u32 = 44;
pub const STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER: u32 = 45;
pub const STRUCTURE_TYPE_MEMORY_BARRIER: u32 = 46;
pub const STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO: u32 = 47;
pub const STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO: u32 = 48;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: u32 = 1000094000;
pub const STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO: u32 = 1000157000;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO: u32 = 1000157001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: u32 = 1000083000;
pub const STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: u32 = 1000127000;
pub const STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: u32 = 1000127001;
pub const STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: u32 = 1000060000;
pub const STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: u32 = 1000060003;
pub const STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: u32 = 1000060004;
pub const STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: u32 = 1000060005;
pub const STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: u32 = 1000060006;
pub const STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: u32 = 1000060013;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: u32 = 1000060014;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES: u32 = 1000070000;
pub const STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: u32 = 1000070001;
pub const STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2: u32 = 1000146000;
pub const STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2: u32 = 1000146001;
pub const STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2: u32 = 1000146002;
pub const STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2: u32 = 1000146003;
pub const STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2: u32 = 1000146004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: u32 = 1000059000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2: u32 = 1000059001;
pub const STRUCTURE_TYPE_FORMAT_PROPERTIES_2: u32 = 1000059002;
pub const STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2: u32 = 1000059003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2: u32 = 1000059004;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2: u32 = 1000059005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2: u32 = 1000059006;
pub const STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2: u32 = 1000059007;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2: u32 = 1000059008;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: u32 = 1000117000;
pub const STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: u32 = 1000117001;
pub const STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: u32 = 1000117002;
pub const STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: u32 = 1000117003;
pub const STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: u32 = 1000053000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: u32 = 1000053001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: u32 = 1000053002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: u32 = 1000120000;
pub const STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: u32 = 1000145000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: u32 = 1000145001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: u32 = 1000145002;
pub const STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2: u32 = 1000145003;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO: u32 = 1000156000;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: u32 = 1000156001;
pub const STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: u32 = 1000156002;
pub const STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: u32 = 1000156003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: u32 = 1000156004;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: u32 = 1000156005;
pub const STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO: u32 = 1000085000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: u32 = 1000071000;
pub const STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: u32 = 1000071001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO: u32 = 1000071002;
pub const STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES: u32 = 1000071003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: u32 = 1000071004;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: u32 = 1000072000;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: u32 = 1000072001;
pub const STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: u32 = 1000072002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO: u32 = 1000112000;
pub const STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES: u32 = 1000112001;
pub const STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: u32 = 1000113000;
pub const STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: u32 = 1000077000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO: u32 = 1000076000;
pub const STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES: u32 = 1000076001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: u32 = 1000168000;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT: u32 = 1000168001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: u32 = 1000063000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: u32 = 49;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: u32 = 50;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: u32 = 51;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: u32 = 52;
pub const STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: u32 = 1000147000;
pub const STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2: u32 = 1000109000;
pub const STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2: u32 = 1000109001;
pub const STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2: u32 = 1000109002;
pub const STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2: u32 = 1000109003;
pub const STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2: u32 = 1000109004;
pub const STRUCTURE_TYPE_SUBPASS_BEGIN_INFO: u32 = 1000109005;
pub const STRUCTURE_TYPE_SUBPASS_END_INFO: u32 = 1000109006;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: u32 = 1000177000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: u32 = 1000196000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: u32 = 1000180000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: u32 = 1000082000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: u32 = 1000197000;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: u32 = 1000161000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: u32 = 1000161001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: u32 = 1000161002;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: u32 = 1000161003;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: u32 = 1000161004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: u32 = 1000199000;
pub const STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: u32 = 1000199001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: u32 = 1000221000;
pub const STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: u32 = 1000246000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: u32 = 1000130000;
pub const STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: u32 = 1000130001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: u32 = 1000211000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: u32 = 1000108000;
pub const STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: u32 = 1000108001;
pub const STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO: u32 = 1000108002;
pub const STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: u32 = 1000108003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: u32 = 1000253000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: u32 = 1000175000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: u32 = 1000241000;
pub const STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: u32 = 1000241001;
pub const STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: u32 = 1000241002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: u32 = 1000261000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: u32 = 1000207000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: u32 = 1000207001;
pub const STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: u32 = 1000207002;
pub const STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: u32 = 1000207003;
pub const STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO: u32 = 1000207004;
pub const STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO: u32 = 1000207005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: u32 = 1000257000;
pub const STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO: u32 = 1000244001;
pub const STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: u32 = 1000257002;
pub const STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: u32 = 1000257003;
pub const STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO: u32 = 1000257004;
pub const STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR: u32 = 1000001000;
pub const STRUCTURE_TYPE_PRESENT_INFO_KHR: u32 = 1000001001;
pub const STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR: u32 = 1000060007;
pub const STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR: u32 = 1000060008;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: u32 = 1000060009;
pub const STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR: u32 = 1000060010;
pub const STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR: u32 = 1000060011;
pub const STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR: u32 = 1000060012;
pub const STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR: u32 = 1000002000;
pub const STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR: u32 = 1000002001;
pub const STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR: u32 = 1000003000;
pub const STRUCTURE_TYPE_XLIB_SURFACE_CREATE_INFO_KHR: u32 = 1000004000;
pub const STRUCTURE_TYPE_XCB_SURFACE_CREATE_INFO_KHR: u32 = 1000005000;
pub const STRUCTURE_TYPE_WAYLAND_SURFACE_CREATE_INFO_KHR: u32 = 1000006000;
pub const STRUCTURE_TYPE_ANDROID_SURFACE_CREATE_INFO_KHR: u32 = 1000008000;
pub const STRUCTURE_TYPE_WIN32_SURFACE_CREATE_INFO_KHR: u32 = 1000009000;
pub const STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: u32 = 1000011000;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD: u32 = 1000018000;
pub const STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT: u32 = 1000022000;
pub const STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT: u32 = 1000022001;
pub const STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT: u32 = 1000022002;
pub const STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV: u32 = 1000026000;
pub const STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV: u32 = 1000026001;
pub const STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV: u32 = 1000026002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: u32 = 1000028000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: u32 = 1000028001;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: u32 = 1000028002;
pub const STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX: u32 = 1000030000;
pub const STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX: u32 = 1000030001;
pub const STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD: u32 = 1000041000;
pub const STRUCTURE_TYPE_STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP: u32 = 1000049000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV: u32 = 1000050000;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: u32 = 1000056000;
pub const STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV: u32 = 1000056001;
pub const STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_NV: u32 = 1000057000;
pub const STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_NV: u32 = 1000057001;
pub const STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV: u32 = 1000058000;
pub const STRUCTURE_TYPE_VALIDATION_FLAGS_EXT: u32 = 1000061000;
pub const STRUCTURE_TYPE_VI_SURFACE_CREATE_INFO_NN: u32 = 1000062000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT: u32 =
    1000066000;
pub const STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT: u32 = 1000067000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT: u32 = 1000067001;
pub const STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR: u32 = 1000073000;
pub const STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR: u32 = 1000073001;
pub const STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR: u32 = 1000073002;
pub const STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR: u32 = 1000073003;
pub const STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR: u32 = 1000074000;
pub const STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR: u32 = 1000074001;
pub const STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR: u32 = 1000074002;
pub const STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR: u32 = 1000075000;
pub const STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR: u32 = 1000078000;
pub const STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR: u32 = 1000078001;
pub const STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR: u32 = 1000078002;
pub const STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR: u32 = 1000078003;
pub const STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR: u32 = 1000079000;
pub const STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR: u32 = 1000079001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR: u32 = 1000080000;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT: u32 =
    1000081000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT: u32 = 1000081001;
pub const STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT: u32 = 1000081002;
pub const STRUCTURE_TYPE_PRESENT_REGIONS_KHR: u32 = 1000084000;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV: u32 = 1000087000;
pub const STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT: u32 = 1000090000;
pub const STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT: u32 = 1000091000;
pub const STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT: u32 = 1000091001;
pub const STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT: u32 = 1000091002;
pub const STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT: u32 = 1000091003;
pub const STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE: u32 = 1000092000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX: u32 =
    1000097000;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV: u32 = 1000098000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT: u32 = 1000099000;
pub const STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT: u32 = 1000099001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT: u32 =
    1000101000;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT: u32 =
    1000101001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT: u32 = 1000102000;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT: u32 = 1000102001;
pub const STRUCTURE_TYPE_HDR_METADATA_EXT: u32 = 1000105000;
pub const STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR: u32 = 1000111000;
pub const STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR: u32 = 1000114000;
pub const STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR: u32 = 1000114001;
pub const STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR: u32 = 1000114002;
pub const STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR: u32 = 1000115000;
pub const STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR: u32 = 1000115001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR: u32 = 1000116000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR: u32 = 1000116001;
pub const STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR: u32 = 1000116002;
pub const STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR: u32 = 1000116003;
pub const STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR: u32 = 1000116004;
pub const STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR: u32 = 1000116005;
pub const STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR: u32 = 1000116006;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR: u32 = 1000119000;
pub const STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR: u32 = 1000119001;
pub const STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR: u32 = 1000119002;
pub const STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR: u32 = 1000121000;
pub const STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR: u32 = 1000121001;
pub const STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR: u32 = 1000121002;
pub const STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR: u32 = 1000121003;
pub const STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR: u32 = 1000121004;
pub const STRUCTURE_TYPE_IOS_SURFACE_CREATE_INFO_MVK: u32 = 1000122000;
pub const STRUCTURE_TYPE_MACOS_SURFACE_CREATE_INFO_MVK: u32 = 1000123000;
pub const STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: u32 = 1000128000;
pub const STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT: u32 = 1000128001;
pub const STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT: u32 = 1000128002;
pub const STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT: u32 = 1000128003;
pub const STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: u32 = 1000128004;
pub const STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_USAGE_ANDROID: u32 = 1000129000;
pub const STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_PROPERTIES_ANDROID: u32 = 1000129001;
pub const STRUCTURE_TYPE_ANDROID_HARDWARE_BUFFER_FORMAT_PROPERTIES_ANDROID: u32 = 1000129002;
pub const STRUCTURE_TYPE_IMPORT_ANDROID_HARDWARE_BUFFER_INFO_ANDROID: u32 = 1000129003;
pub const STRUCTURE_TYPE_MEMORY_GET_ANDROID_HARDWARE_BUFFER_INFO_ANDROID: u32 = 1000129004;
pub const STRUCTURE_TYPE_EXTERNAL_FORMAT_ANDROID: u32 = 1000129005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES_EXT: u32 = 1000138000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES_EXT: u32 = 1000138001;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK_EXT: u32 = 1000138002;
pub const STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO_EXT: u32 = 1000138003;
pub const STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT: u32 = 1000143000;
pub const STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT: u32 = 1000143001;
pub const STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT: u32 = 1000143002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT: u32 = 1000143003;
pub const STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT: u32 = 1000143004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT: u32 = 1000148000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT: u32 = 1000148001;
pub const STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT: u32 = 1000148002;
pub const STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV: u32 = 1000149000;
pub const STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_KHR: u32 = 1000165006;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR: u32 = 1000165007;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR: u32 = 1000150000;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_GEOMETRY_TYPE_INFO_KHR: u32 = 1000150001;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR: u32 = 1000150002;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR: u32 = 1000150003;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR: u32 = 1000150004;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR: u32 = 1000150005;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR: u32 = 1000150006;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_KHR: u32 = 1000150008;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_KHR: u32 = 1000150009;
pub const STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR: u32 = 1000150010;
pub const STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR: u32 = 1000150011;
pub const STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR: u32 = 1000150012;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_FEATURES_KHR: u32 = 1000150013;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_KHR: u32 = 1000150014;
pub const STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR: u32 = 1000150015;
pub const STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR: u32 = 1000150016;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR: u32 = 1000150017;
pub const STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR: u32 = 1000150018;
pub const STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV: u32 = 1000152000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV: u32 = 1000154000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV: u32 = 1000154001;
pub const STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT: u32 = 1000158000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT: u32 = 1000158002;
pub const STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT: u32 = 1000158003;
pub const STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT: u32 = 1000158004;
pub const STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT: u32 = 1000158005;
pub const STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT: u32 = 1000160000;
pub const STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT: u32 = 1000160001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR: u32 = 1000163000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR: u32 = 1000163001;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV: u32 =
    1000164000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV: u32 = 1000164001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV: u32 = 1000164002;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV: u32 =
    1000164005;
pub const STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV: u32 = 1000165000;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV: u32 = 1000165001;
pub const STRUCTURE_TYPE_GEOMETRY_NV: u32 = 1000165003;
pub const STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV: u32 = 1000165004;
pub const STRUCTURE_TYPE_GEOMETRY_AABB_NV: u32 = 1000165005;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV: u32 = 1000165008;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV: u32 = 1000165009;
pub const STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV: u32 = 1000165011;
pub const STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV: u32 = 1000165012;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV: u32 = 1000166000;
pub const STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV: u32 =
    1000166001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT: u32 = 1000170000;
pub const STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT: u32 = 1000170001;
pub const STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO_EXT: u32 = 1000174000;
pub const STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT: u32 = 1000178000;
pub const STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT: u32 = 1000178001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT: u32 = 1000178002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR: u32 = 1000181000;
pub const STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD: u32 = 1000183000;
pub const STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_EXT: u32 = 1000184000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD: u32 = 1000185000;
pub const STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD: u32 = 1000189000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT: u32 = 1000190000;
pub const STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO_EXT: u32 = 1000190001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT: u32 = 1000190002;
pub const STRUCTURE_TYPE_PRESENT_FRAME_TOKEN_GGP: u32 = 1000191000;
pub const STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO_EXT: u32 = 1000192000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_NV: u32 = 1000201000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV: u32 = 1000202000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV: u32 = 1000202001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_NV: u32 = 1000203000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV: u32 = 1000204000;
pub const STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV: u32 = 1000205000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV: u32 = 1000205002;
pub const STRUCTURE_TYPE_CHECKPOINT_DATA_NV: u32 = 1000206000;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV: u32 = 1000206001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL: u32 =
    1000209000;
pub const STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL: u32 = 1000210000;
pub const STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL: u32 = 1000210001;
pub const STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL: u32 = 1000210002;
pub const STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL: u32 = 1000210003;
pub const STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL: u32 = 1000210004;
pub const STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL: u32 = 1000210005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT: u32 = 1000212000;
pub const STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD: u32 = 1000213000;
pub const STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD: u32 = 1000213001;
pub const STRUCTURE_TYPE_IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA: u32 = 1000214000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR: u32 = 1000215000;
pub const STRUCTURE_TYPE_METAL_SURFACE_CREATE_INFO_EXT: u32 = 1000217000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT: u32 = 1000218000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT: u32 = 1000218001;
pub const STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT: u32 = 1000218002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES_EXT: u32 = 1000225000;
pub const STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO_EXT: u32 =
    1000225001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES_EXT: u32 = 1000225002;
pub const STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: u32 = 1000226000;
pub const STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR: u32 = 1000226001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR: u32 = 1000226002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR: u32 = 1000226003;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR: u32 = 1000226004;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD: u32 = 1000227000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD: u32 = 1000229000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT: u32 = 1000234000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT: u32 = 1000237000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT: u32 = 1000238000;
pub const STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT: u32 = 1000238001;
pub const STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR: u32 = 1000239000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV: u32 =
    1000240000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT: u32 = 1000244000;
pub const STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT: u32 = 1000244002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT: u32 = 1000245000;
pub const STRUCTURE_TYPE_VALIDATION_FEATURES_EXT: u32 = 1000247000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV: u32 = 1000249000;
pub const STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV: u32 = 1000249001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV: u32 = 1000249002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV: u32 = 1000250000;
pub const STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV: u32 = 1000250001;
pub const STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV: u32 = 1000250002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT: u32 = 1000251000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT: u32 = 1000252000;
pub const STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_INFO_EXT: u32 = 1000255000;
pub const STRUCTURE_TYPE_SURFACE_CAPABILITIES_FULL_SCREEN_EXCLUSIVE_EXT: u32 = 1000255002;
pub const STRUCTURE_TYPE_SURFACE_FULL_SCREEN_EXCLUSIVE_WIN32_INFO_EXT: u32 = 1000255001;
pub const STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT: u32 = 1000256000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: u32 = 1000259000;
pub const STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: u32 = 1000259001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT: u32 = 1000259002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT: u32 = 1000260000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: u32 = 1000265000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: u32 = 1000267000;
pub const STRUCTURE_TYPE_DEFERRED_OPERATION_INFO_KHR: u32 = 1000268000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: u32 =
    1000269000;
pub const STRUCTURE_TYPE_PIPELINE_INFO_KHR: u32 = 1000269001;
pub const STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR: u32 = 1000269002;
pub const STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR: u32 = 1000269003;
pub const STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR: u32 = 1000269004;
pub const STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR: u32 = 1000269005;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES_EXT: u32 =
    1000276000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV: u32 = 1000277000;
pub const STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV: u32 = 1000277001;
pub const STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV: u32 = 1000277002;
pub const STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV: u32 = 1000277003;
pub const STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV: u32 = 1000277004;
pub const STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV: u32 = 1000277005;
pub const STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV: u32 = 1000277006;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV: u32 = 1000277007;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: u32 = 1000281000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES_EXT: u32 = 1000281001;
pub const STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM: u32 =
    1000282000;
pub const STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM: u32 = 1000282001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: u32 = 1000284000;
pub const STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: u32 = 1000284001;
pub const STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT: u32 = 1000284002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT: u32 = 1000286000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT: u32 = 1000286001;
pub const STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: u32 = 1000287000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: u32 = 1000287001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: u32 = 1000287002;
pub const STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR: u32 = 1000290000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES_EXT: u32 = 1000295000;
pub const STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO_EXT: u32 = 1000295001;
pub const STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO_EXT: u32 = 1000295002;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES_EXT: u32 =
    1000297000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV: u32 = 1000300000;
pub const STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV: u32 = 1000300001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT: u32 = 1000332000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT: u32 = 1000332001;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES_EXT: u32 = 1000335000;
pub const STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR: u32 = 1000337000;
pub const STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR: u32 = 1000337001;
pub const STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR: u32 = 1000337002;
pub const STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR: u32 = 1000337003;
pub const STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR: u32 = 1000337004;
pub const STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR: u32 = 1000337005;
pub const STRUCTURE_TYPE_BUFFER_COPY_2_KHR: u32 = 1000337006;
pub const STRUCTURE_TYPE_IMAGE_COPY_2_KHR: u32 = 1000337007;
pub const STRUCTURE_TYPE_IMAGE_BLIT_2_KHR: u32 = 1000337008;
pub const STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR: u32 = 1000337009;
pub const STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR: u32 = 1000337010;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: u32 = 1000340000;
pub const STRUCTURE_TYPE_DIRECTFB_SURFACE_CREATE_INFO_EXT: u32 = 1000346000;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES;
pub const STRUCTURE_TYPE_DEBUG_REPORT_CREATE_INFO_EXT: u32 =
    STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT;
pub const STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2;
pub const STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR: u32 = STRUCTURE_TYPE_FORMAT_PROPERTIES_2;
pub const STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR: u32 =
    STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2;
pub const STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR: u32 =
    STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2;
pub const STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR: u32 =
    STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2;
pub const STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO_KHR: u32 =
    STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO;
pub const STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO_KHR: u32 =
    STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO;
pub const STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO_KHR: u32 =
    STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO;
pub const STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO_KHR: u32 =
    STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO;
pub const STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO_KHR: u32 =
    STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO;
pub const STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO_KHR: u32 =
    STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO_KHR: u32 =
    STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES;
pub const STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO;
pub const STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES;
pub const STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT16_INT8_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES;
pub const STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO;
pub const STRUCTURE_TYPE_SURFACE_CAPABILITIES2_EXT: u32 = STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES;
pub const STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO;
pub const STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO_KHR: u32 =
    STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO;
pub const STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO_KHR: u32 =
    STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO;
pub const STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2_KHR: u32 =
    STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2;
pub const STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2_KHR: u32 = STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2;
pub const STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2_KHR: u32 = STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2;
pub const STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2_KHR: u32 = STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2;
pub const STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2_KHR: u32 =
    STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2;
pub const STRUCTURE_TYPE_SUBPASS_BEGIN_INFO_KHR: u32 = STRUCTURE_TYPE_SUBPASS_BEGIN_INFO;
pub const STRUCTURE_TYPE_SUBPASS_END_INFO_KHR: u32 = STRUCTURE_TYPE_SUBPASS_END_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO;
pub const STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES;
pub const STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES;
pub const STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO;
pub const STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO;
pub const STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR;
pub const STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR: u32 =
    STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS;
pub const STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES_EXT: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES;
pub const STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO_EXT: u32 =
    STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO;
pub const STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR: u32 =
    STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2;
pub const STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR: u32 =
    STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2;
pub const STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR: u32 =
    STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2;
pub const STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR: u32 = STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2;
pub const STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR: u32 =
    STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2;
pub const STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR: u32 =
    STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO;
pub const STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR: u32 =
    STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO;
pub const STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR: u32 =
    STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES;
pub const STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES;
pub const STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR: u32 = STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO;
pub const STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR: u32 = STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO_EXT: u32 =
    STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES_EXT: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES_EXT: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO_EXT: u32 =
    STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT_EXT: u32 =
    STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT;
pub const STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV: u32 =
    STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_KHR;
pub const STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV: u32 =
    STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES;
pub const STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR: u32 =
    STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES;
pub const STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE_KHR: u32 =
    STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES;
pub const STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO;
pub const STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO_KHR: u32 =
    STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO;
pub const STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO_KHR: u32 = STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO;
pub const STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO_KHR: u32 = STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO;
pub const STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO_INTEL: u32 =
    STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES_EXT: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES;
pub const STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT_KHR: u32 =
    STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT;
pub const STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT_KHR: u32 =
    STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT;
pub const STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_EXT: u32 =
    STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO;
pub const STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO_EXT: u32 =
    STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_KHR: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES;
pub const STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO_KHR: u32 =
    STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO;
pub const STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO;
pub const STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO_KHR: u32 =
    STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO;
pub const STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO_KHR: u32 =
    STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO;
pub const STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES_EXT: u32 =
    STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES;
pub const STRUCTURE_TYPE_MAX_ENUM: u32 = 0x7FFFFFFF;

pub type SystemAllocationScope = u32;
pub const SYSTEM_ALLOCATION_SCOPE_COMMAND: u32 = 0;
pub const SYSTEM_ALLOCATION_SCOPE_OBJECT: u32 = 1;
pub const SYSTEM_ALLOCATION_SCOPE_CACHE: u32 = 2;
pub const SYSTEM_ALLOCATION_SCOPE_DEVICE: u32 = 3;
pub const SYSTEM_ALLOCATION_SCOPE_INSTANCE: u32 = 4;

pub type InternalAllocationType = u32;
pub const INTERNAL_ALLOCATION_TYPE_EXECUTABLE: u32 = 0;

pub type Format = u32;
pub const FORMAT_UNDEFINED: u32 = 0;
pub const FORMAT_R4G4_UNORM_PACK8: u32 = 1;
pub const FORMAT_R4G4B4A4_UNORM_PACK16: u32 = 2;
pub const FORMAT_B4G4R4A4_UNORM_PACK16: u32 = 3;
pub const FORMAT_R5G6B5_UNORM_PACK16: u32 = 4;
pub const FORMAT_B5G6R5_UNORM_PACK16: u32 = 5;
pub const FORMAT_R5G5B5A1_UNORM_PACK16: u32 = 6;
pub const FORMAT_B5G5R5A1_UNORM_PACK16: u32 = 7;
pub const FORMAT_A1R5G5B5_UNORM_PACK16: u32 = 8;
pub const FORMAT_R8_UNORM: u32 = 9;
pub const FORMAT_R8_SNORM: u32 = 10;
pub const FORMAT_R8_USCALED: u32 = 11;
pub const FORMAT_R8_SSCALED: u32 = 12;
pub const FORMAT_R8_UINT: u32 = 13;
pub const FORMAT_R8_SINT: u32 = 14;
pub const FORMAT_R8_SRGB: u32 = 15;
pub const FORMAT_R8G8_UNORM: u32 = 16;
pub const FORMAT_R8G8_SNORM: u32 = 17;
pub const FORMAT_R8G8_USCALED: u32 = 18;
pub const FORMAT_R8G8_SSCALED: u32 = 19;
pub const FORMAT_R8G8_UINT: u32 = 20;
pub const FORMAT_R8G8_SINT: u32 = 21;
pub const FORMAT_R8G8_SRGB: u32 = 22;
pub const FORMAT_R8G8B8_UNORM: u32 = 23;
pub const FORMAT_R8G8B8_SNORM: u32 = 24;
pub const FORMAT_R8G8B8_USCALED: u32 = 25;
pub const FORMAT_R8G8B8_SSCALED: u32 = 26;
pub const FORMAT_R8G8B8_UINT: u32 = 27;
pub const FORMAT_R8G8B8_SINT: u32 = 28;
pub const FORMAT_R8G8B8_SRGB: u32 = 29;
pub const FORMAT_B8G8R8_UNORM: u32 = 30;
pub const FORMAT_B8G8R8_SNORM: u32 = 31;
pub const FORMAT_B8G8R8_USCALED: u32 = 32;
pub const FORMAT_B8G8R8_SSCALED: u32 = 33;
pub const FORMAT_B8G8R8_UINT: u32 = 34;
pub const FORMAT_B8G8R8_SINT: u32 = 35;
pub const FORMAT_B8G8R8_SRGB: u32 = 36;
pub const FORMAT_R8G8B8A8_UNORM: u32 = 37;
pub const FORMAT_R8G8B8A8_SNORM: u32 = 38;
pub const FORMAT_R8G8B8A8_USCALED: u32 = 39;
pub const FORMAT_R8G8B8A8_SSCALED: u32 = 40;
pub const FORMAT_R8G8B8A8_UINT: u32 = 41;
pub const FORMAT_R8G8B8A8_SINT: u32 = 42;
pub const FORMAT_R8G8B8A8_SRGB: u32 = 43;
pub const FORMAT_B8G8R8A8_UNORM: u32 = 44;
pub const FORMAT_B8G8R8A8_SNORM: u32 = 45;
pub const FORMAT_B8G8R8A8_USCALED: u32 = 46;
pub const FORMAT_B8G8R8A8_SSCALED: u32 = 47;
pub const FORMAT_B8G8R8A8_UINT: u32 = 48;
pub const FORMAT_B8G8R8A8_SINT: u32 = 49;
pub const FORMAT_B8G8R8A8_SRGB: u32 = 50;
pub const FORMAT_A8B8G8R8_UNORM_PACK32: u32 = 51;
pub const FORMAT_A8B8G8R8_SNORM_PACK32: u32 = 52;
pub const FORMAT_A8B8G8R8_USCALED_PACK32: u32 = 53;
pub const FORMAT_A8B8G8R8_SSCALED_PACK32: u32 = 54;
pub const FORMAT_A8B8G8R8_UINT_PACK32: u32 = 55;
pub const FORMAT_A8B8G8R8_SINT_PACK32: u32 = 56;
pub const FORMAT_A8B8G8R8_SRGB_PACK32: u32 = 57;
pub const FORMAT_A2R10G10B10_UNORM_PACK32: u32 = 58;
pub const FORMAT_A2R10G10B10_SNORM_PACK32: u32 = 59;
pub const FORMAT_A2R10G10B10_USCALED_PACK32: u32 = 60;
pub const FORMAT_A2R10G10B10_SSCALED_PACK32: u32 = 61;
pub const FORMAT_A2R10G10B10_UINT_PACK32: u32 = 62;
pub const FORMAT_A2R10G10B10_SINT_PACK32: u32 = 63;
pub const FORMAT_A2B10G10R10_UNORM_PACK32: u32 = 64;
pub const FORMAT_A2B10G10R10_SNORM_PACK32: u32 = 65;
pub const FORMAT_A2B10G10R10_USCALED_PACK32: u32 = 66;
pub const FORMAT_A2B10G10R10_SSCALED_PACK32: u32 = 67;
pub const FORMAT_A2B10G10R10_UINT_PACK32: u32 = 68;
pub const FORMAT_A2B10G10R10_SINT_PACK32: u32 = 69;
pub const FORMAT_R16_UNORM: u32 = 70;
pub const FORMAT_R16_SNORM: u32 = 71;
pub const FORMAT_R16_USCALED: u32 = 72;
pub const FORMAT_R16_SSCALED: u32 = 73;
pub const FORMAT_R16_UINT: u32 = 74;
pub const FORMAT_R16_SINT: u32 = 75;
pub const FORMAT_R16_SFLOAT: u32 = 76;
pub const FORMAT_R16G16_UNORM: u32 = 77;
pub const FORMAT_R16G16_SNORM: u32 = 78;
pub const FORMAT_R16G16_USCALED: u32 = 79;
pub const FORMAT_R16G16_SSCALED: u32 = 80;
pub const FORMAT_R16G16_UINT: u32 = 81;
pub const FORMAT_R16G16_SINT: u32 = 82;
pub const FORMAT_R16G16_SFLOAT: u32 = 83;
pub const FORMAT_R16G16B16_UNORM: u32 = 84;
pub const FORMAT_R16G16B16_SNORM: u32 = 85;
pub const FORMAT_R16G16B16_USCALED: u32 = 86;
pub const FORMAT_R16G16B16_SSCALED: u32 = 87;
pub const FORMAT_R16G16B16_UINT: u32 = 88;
pub const FORMAT_R16G16B16_SINT: u32 = 89;
pub const FORMAT_R16G16B16_SFLOAT: u32 = 90;
pub const FORMAT_R16G16B16A16_UNORM: u32 = 91;
pub const FORMAT_R16G16B16A16_SNORM: u32 = 92;
pub const FORMAT_R16G16B16A16_USCALED: u32 = 93;
pub const FORMAT_R16G16B16A16_SSCALED: u32 = 94;
pub const FORMAT_R16G16B16A16_UINT: u32 = 95;
pub const FORMAT_R16G16B16A16_SINT: u32 = 96;
pub const FORMAT_R16G16B16A16_SFLOAT: u32 = 97;
pub const FORMAT_R32_UINT: u32 = 98;
pub const FORMAT_R32_SINT: u32 = 99;
pub const FORMAT_R32_SFLOAT: u32 = 100;
pub const FORMAT_R32G32_UINT: u32 = 101;
pub const FORMAT_R32G32_SINT: u32 = 102;
pub const FORMAT_R32G32_SFLOAT: u32 = 103;
pub const FORMAT_R32G32B32_UINT: u32 = 104;
pub const FORMAT_R32G32B32_SINT: u32 = 105;
pub const FORMAT_R32G32B32_SFLOAT: u32 = 106;
pub const FORMAT_R32G32B32A32_UINT: u32 = 107;
pub const FORMAT_R32G32B32A32_SINT: u32 = 108;
pub const FORMAT_R32G32B32A32_SFLOAT: u32 = 109;
pub const FORMAT_R64_UINT: u32 = 110;
pub const FORMAT_R64_SINT: u32 = 111;
pub const FORMAT_R64_SFLOAT: u32 = 112;
pub const FORMAT_R64G64_UINT: u32 = 113;
pub const FORMAT_R64G64_SINT: u32 = 114;
pub const FORMAT_R64G64_SFLOAT: u32 = 115;
pub const FORMAT_R64G64B64_UINT: u32 = 116;
pub const FORMAT_R64G64B64_SINT: u32 = 117;
pub const FORMAT_R64G64B64_SFLOAT: u32 = 118;
pub const FORMAT_R64G64B64A64_UINT: u32 = 119;
pub const FORMAT_R64G64B64A64_SINT: u32 = 120;
pub const FORMAT_R64G64B64A64_SFLOAT: u32 = 121;
pub const FORMAT_B10G11R11_UFLOAT_PACK32: u32 = 122;
pub const FORMAT_E5B9G9R9_UFLOAT_PACK32: u32 = 123;
pub const FORMAT_D16_UNORM: u32 = 124;
pub const FORMAT_X8_D24_UNORM_PACK32: u32 = 125;
pub const FORMAT_D32_SFLOAT: u32 = 126;
pub const FORMAT_S8_UINT: u32 = 127;
pub const FORMAT_D16_UNORM_S8_UINT: u32 = 128;
pub const FORMAT_D24_UNORM_S8_UINT: u32 = 129;
pub const FORMAT_D32_SFLOAT_S8_UINT: u32 = 130;
pub const FORMAT_BC1_RGB_UNORM_BLOCK: u32 = 131;
pub const FORMAT_BC1_RGB_SRGB_BLOCK: u32 = 132;
pub const FORMAT_BC1_RGBA_UNORM_BLOCK: u32 = 133;
pub const FORMAT_BC1_RGBA_SRGB_BLOCK: u32 = 134;
pub const FORMAT_BC2_UNORM_BLOCK: u32 = 135;
pub const FORMAT_BC2_SRGB_BLOCK: u32 = 136;
pub const FORMAT_BC3_UNORM_BLOCK: u32 = 137;
pub const FORMAT_BC3_SRGB_BLOCK: u32 = 138;
pub const FORMAT_BC4_UNORM_BLOCK: u32 = 139;
pub const FORMAT_BC4_SNORM_BLOCK: u32 = 140;
pub const FORMAT_BC5_UNORM_BLOCK: u32 = 141;
pub const FORMAT_BC5_SNORM_BLOCK: u32 = 142;
pub const FORMAT_BC6H_UFLOAT_BLOCK: u32 = 143;
pub const FORMAT_BC6H_SFLOAT_BLOCK: u32 = 144;
pub const FORMAT_BC7_UNORM_BLOCK: u32 = 145;
pub const FORMAT_BC7_SRGB_BLOCK: u32 = 146;
pub const FORMAT_ETC2_R8G8B8_UNORM_BLOCK: u32 = 147;
pub const FORMAT_ETC2_R8G8B8_SRGB_BLOCK: u32 = 148;
pub const FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK: u32 = 149;
pub const FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK: u32 = 150;
pub const FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK: u32 = 151;
pub const FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK: u32 = 152;
pub const FORMAT_EAC_R11_UNORM_BLOCK: u32 = 153;
pub const FORMAT_EAC_R11_SNORM_BLOCK: u32 = 154;
pub const FORMAT_EAC_R11G11_UNORM_BLOCK: u32 = 155;
pub const FORMAT_EAC_R11G11_SNORM_BLOCK: u32 = 156;
pub const FORMAT_ASTC_4x4_UNORM_BLOCK: u32 = 157;
pub const FORMAT_ASTC_4x4_SRGB_BLOCK: u32 = 158;
pub const FORMAT_ASTC_5x4_UNORM_BLOCK: u32 = 159;
pub const FORMAT_ASTC_5x4_SRGB_BLOCK: u32 = 160;
pub const FORMAT_ASTC_5x5_UNORM_BLOCK: u32 = 161;
pub const FORMAT_ASTC_5x5_SRGB_BLOCK: u32 = 162;
pub const FORMAT_ASTC_6x5_UNORM_BLOCK: u32 = 163;
pub const FORMAT_ASTC_6x5_SRGB_BLOCK: u32 = 164;
pub const FORMAT_ASTC_6x6_UNORM_BLOCK: u32 = 165;
pub const FORMAT_ASTC_6x6_SRGB_BLOCK: u32 = 166;
pub const FORMAT_ASTC_8x5_UNORM_BLOCK: u32 = 167;
pub const FORMAT_ASTC_8x5_SRGB_BLOCK: u32 = 168;
pub const FORMAT_ASTC_8x6_UNORM_BLOCK: u32 = 169;
pub const FORMAT_ASTC_8x6_SRGB_BLOCK: u32 = 170;
pub const FORMAT_ASTC_8x8_UNORM_BLOCK: u32 = 171;
pub const FORMAT_ASTC_8x8_SRGB_BLOCK: u32 = 172;
pub const FORMAT_ASTC_10x5_UNORM_BLOCK: u32 = 173;
pub const FORMAT_ASTC_10x5_SRGB_BLOCK: u32 = 174;
pub const FORMAT_ASTC_10x6_UNORM_BLOCK: u32 = 175;
pub const FORMAT_ASTC_10x6_SRGB_BLOCK: u32 = 176;
pub const FORMAT_ASTC_10x8_UNORM_BLOCK: u32 = 177;
pub const FORMAT_ASTC_10x8_SRGB_BLOCK: u32 = 178;
pub const FORMAT_ASTC_10x10_UNORM_BLOCK: u32 = 179;
pub const FORMAT_ASTC_10x10_SRGB_BLOCK: u32 = 180;
pub const FORMAT_ASTC_12x10_UNORM_BLOCK: u32 = 181;
pub const FORMAT_ASTC_12x10_SRGB_BLOCK: u32 = 182;
pub const FORMAT_ASTC_12x12_UNORM_BLOCK: u32 = 183;
pub const FORMAT_ASTC_12x12_SRGB_BLOCK: u32 = 184;

pub const FORMAT_G8B8G8R8_422_UNORM: u32 = 1000156000;
pub const FORMAT_B8G8R8G8_422_UNORM: u32 = 1000156001;
pub const FORMAT_G8_B8_R8_3PLANE_420_UNORM: u32 = 1000156002;
pub const FORMAT_G8_B8R8_2PLANE_420_UNORM: u32 = 1000156003;
pub const FORMAT_G8_B8_R8_3PLANE_422_UNORM: u32 = 1000156004;
pub const FORMAT_G8_B8R8_2PLANE_422_UNORM: u32 = 1000156005;
pub const FORMAT_G8_B8_R8_3PLANE_444_UNORM: u32 = 1000156006;
pub const FORMAT_R10X6_UNORM_PACK16: u32 = 1000156007;
pub const FORMAT_R10X6G10X6_UNORM_2PACK16: u32 = 1000156008;
pub const FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16: u32 = 1000156009;
pub const FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16: u32 = 1000156010;
pub const FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16: u32 = 1000156011;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16: u32 = 1000156012;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16: u32 = 1000156013;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16: u32 = 1000156014;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16: u32 = 1000156015;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16: u32 = 1000156016;
pub const FORMAT_R12X4_UNORM_PACK16: u32 = 1000156017;
pub const FORMAT_R12X4G12X4_UNORM_2PACK16: u32 = 1000156018;
pub const FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16: u32 = 1000156019;
pub const FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16: u32 = 1000156020;
pub const FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16: u32 = 1000156021;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16: u32 = 1000156022;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16: u32 = 1000156023;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16: u32 = 1000156024;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16: u32 = 1000156025;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16: u32 = 1000156026;
pub const FORMAT_G16B16G16R16_422_UNORM: u32 = 1000156027;
pub const FORMAT_B16G16R16G16_422_UNORM: u32 = 1000156028;
pub const FORMAT_G16_B16_R16_3PLANE_420_UNORM: u32 = 1000156029;
pub const FORMAT_G16_B16R16_2PLANE_420_UNORM: u32 = 1000156030;
pub const FORMAT_G16_B16_R16_3PLANE_422_UNORM: u32 = 1000156031;
pub const FORMAT_G16_B16R16_2PLANE_422_UNORM: u32 = 1000156032;
pub const FORMAT_G16_B16_R16_3PLANE_444_UNORM: u32 = 1000156033;
pub const FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG: u32 = 1000054000;
pub const FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG: u32 = 1000054001;
pub const FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG: u32 = 1000054002;
pub const FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG: u32 = 1000054003;
pub const FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG: u32 = 1000054004;
pub const FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG: u32 = 1000054005;
pub const FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG: u32 = 1000054006;
pub const FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG: u32 = 1000054007;
pub const FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT: u32 = 1000066000;
pub const FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT: u32 = 1000066001;
pub const FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT: u32 = 1000066002;
pub const FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT: u32 = 1000066003;
pub const FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT: u32 = 1000066004;
pub const FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT: u32 = 1000066005;
pub const FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT: u32 = 1000066006;
pub const FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT: u32 = 1000066007;
pub const FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT: u32 = 1000066008;
pub const FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT: u32 = 1000066009;
pub const FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT: u32 = 1000066010;
pub const FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT: u32 = 1000066011;
pub const FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT: u32 = 1000066012;
pub const FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT: u32 = 1000066013;
pub const FORMAT_A4R4G4B4_UNORM_PACK16_EXT: u32 = 1000340000;
pub const FORMAT_A4B4G4R4_UNORM_PACK16_EXT: u32 = 1000340001;
pub const FORMAT_G8B8G8R8_422_UNORM_KHR: u32 = FORMAT_G8B8G8R8_422_UNORM;
pub const FORMAT_B8G8R8G8_422_UNORM_KHR: u32 = FORMAT_B8G8R8G8_422_UNORM;
pub const FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR: u32 = FORMAT_G8_B8_R8_3PLANE_420_UNORM;
pub const FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR: u32 = FORMAT_G8_B8R8_2PLANE_420_UNORM;
pub const FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR: u32 = FORMAT_G8_B8_R8_3PLANE_422_UNORM;
pub const FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR: u32 = FORMAT_G8_B8R8_2PLANE_422_UNORM;
pub const FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR: u32 = FORMAT_G8_B8_R8_3PLANE_444_UNORM;
pub const FORMAT_R10X6_UNORM_PACK16_KHR: u32 = FORMAT_R10X6_UNORM_PACK16;
pub const FORMAT_R10X6G10X6_UNORM_2PACK16_KHR: u32 = FORMAT_R10X6G10X6_UNORM_2PACK16;
pub const FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR: u32 =
    FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16;
pub const FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR: u32 =
    FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16;
pub const FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR: u32 =
    FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR: u32 =
    FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR: u32 =
    FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR: u32 =
    FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16;
pub const FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR: u32 =
    FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16;
pub const FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR: u32 =
    FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16;
pub const FORMAT_R12X4_UNORM_PACK16_KHR: u32 = FORMAT_R12X4_UNORM_PACK16;
pub const FORMAT_R12X4G12X4_UNORM_2PACK16_KHR: u32 = FORMAT_R12X4G12X4_UNORM_2PACK16;
pub const FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR: u32 =
    FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16;
pub const FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR: u32 =
    FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16;
pub const FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR: u32 =
    FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR: u32 =
    FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR: u32 =
    FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR: u32 =
    FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR: u32 =
    FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16;
pub const FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR: u32 =
    FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16;
pub const FORMAT_G16B16G16R16_422_UNORM_KHR: u32 = FORMAT_G16B16G16R16_422_UNORM;
pub const FORMAT_B16G16R16G16_422_UNORM_KHR: u32 = FORMAT_B16G16R16G16_422_UNORM;
pub const FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR: u32 = FORMAT_G16_B16_R16_3PLANE_420_UNORM;
pub const FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR: u32 = FORMAT_G16_B16R16_2PLANE_420_UNORM;
pub const FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR: u32 = FORMAT_G16_B16_R16_3PLANE_422_UNORM;
pub const FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR: u32 = FORMAT_G16_B16R16_2PLANE_422_UNORM;
pub const FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR: u32 = FORMAT_G16_B16_R16_3PLANE_444_UNORM;

pub type ImageType = u32;
pub const IMAGE_TYPE_1D: u32 = 0;
pub const IMAGE_TYPE_2D: u32 = 1;
pub const IMAGE_TYPE_3D: u32 = 2;

pub type ImageTiling = u32;
pub const IMAGE_TILING_OPTIMAL: u32 = 0;
pub const IMAGE_TILING_LINEAR: u32 = 1;

pub type PhysicalDeviceType = u32;
pub const PHYSICAL_DEVICE_TYPE_OTHER: u32 = 0;
pub const PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU: u32 = 1;
pub const PHYSICAL_DEVICE_TYPE_DISCRETE_GPU: u32 = 2;
pub const PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU: u32 = 3;
pub const PHYSICAL_DEVICE_TYPE_CPU: u32 = 4;

pub type QueryType = u32;
pub const QUERY_TYPE_OCCLUSION: u32 = 0;
pub const QUERY_TYPE_PIPELINE_STATISTICS: u32 = 1;
pub const QUERY_TYPE_TIMESTAMP: u32 = 2;

pub type SharingMode = u32;
pub const SHARING_MODE_EXCLUSIVE: u32 = 0;
pub const SHARING_MODE_CONCURRENT: u32 = 1;

pub type ImageLayout = u32;
pub const IMAGE_LAYOUT_UNDEFINED: u32 = 0;
pub const IMAGE_LAYOUT_GENERAL: u32 = 1;
pub const IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL: u32 = 2;
pub const IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL: u32 = 3;
pub const IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL: u32 = 4;
pub const IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL: u32 = 5;
pub const IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL: u32 = 6;
pub const IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL: u32 = 7;
pub const IMAGE_LAYOUT_PREINITIALIZED: u32 = 8;
pub const IMAGE_LAYOUT_PRESENT_SRC_KHR: u32 = 1000001002;

pub type ImageViewType = u32;
pub const IMAGE_VIEW_TYPE_1D: u32 = 0;
pub const IMAGE_VIEW_TYPE_2D: u32 = 1;
pub const IMAGE_VIEW_TYPE_3D: u32 = 2;
pub const IMAGE_VIEW_TYPE_CUBE: u32 = 3;
pub const IMAGE_VIEW_TYPE_1D_ARRAY: u32 = 4;
pub const IMAGE_VIEW_TYPE_2D_ARRAY: u32 = 5;
pub const IMAGE_VIEW_TYPE_CUBE_ARRAY: u32 = 6;

pub type ComponentSwizzle = u32;
pub const COMPONENT_SWIZZLE_IDENTITY: u32 = 0;
pub const COMPONENT_SWIZZLE_ZERO: u32 = 1;
pub const COMPONENT_SWIZZLE_ONE: u32 = 2;
pub const COMPONENT_SWIZZLE_R: u32 = 3;
pub const COMPONENT_SWIZZLE_G: u32 = 4;
pub const COMPONENT_SWIZZLE_B: u32 = 5;
pub const COMPONENT_SWIZZLE_A: u32 = 6;

pub type VertexInputRate = u32;
pub const VERTEX_INPUT_RATE_VERTEX: u32 = 0;
pub const VERTEX_INPUT_RATE_INSTANCE: u32 = 1;

pub type PrimitiveTopology = u32;
pub const PRIMITIVE_TOPOLOGY_POINT_LIST: u32 = 0;
pub const PRIMITIVE_TOPOLOGY_LINE_LIST: u32 = 1;
pub const PRIMITIVE_TOPOLOGY_LINE_STRIP: u32 = 2;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_LIST: u32 = 3;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP: u32 = 4;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_FAN: u32 = 5;
pub const PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY: u32 = 6;
pub const PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY: u32 = 7;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY: u32 = 8;
pub const PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY: u32 = 9;
pub const PRIMITIVE_TOPOLOGY_PATCH_LIST: u32 = 10;

pub type PolygonMode = u32;
pub const POLYGON_MODE_FILL: u32 = 0;
pub const POLYGON_MODE_LINE: u32 = 1;
pub const POLYGON_MODE_POINT: u32 = 2;

pub type FrontFace = u32;
pub const FRONT_FACE_COUNTER_CLOCKWISE: u32 = 0;
pub const FRONT_FACE_CLOCKWISE: u32 = 1;

pub type CompareOp = u32;
pub const COMPARE_OP_NEVER: u32 = 0;
pub const COMPARE_OP_LESS: u32 = 1;
pub const COMPARE_OP_EQUAL: u32 = 2;
pub const COMPARE_OP_LESS_OR_EQUAL: u32 = 3;
pub const COMPARE_OP_GREATER: u32 = 4;
pub const COMPARE_OP_NOT_EQUAL: u32 = 5;
pub const COMPARE_OP_GREATER_OR_EQUAL: u32 = 6;
pub const COMPARE_OP_ALWAYS: u32 = 7;

pub type StencilOp = u32;
pub const STENCIL_OP_KEEP: u32 = 0;
pub const STENCIL_OP_ZERO: u32 = 1;
pub const STENCIL_OP_REPLACE: u32 = 2;
pub const STENCIL_OP_INCREMENT_AND_CLAMP: u32 = 3;
pub const STENCIL_OP_DECREMENT_AND_CLAMP: u32 = 4;
pub const STENCIL_OP_INVERT: u32 = 5;
pub const STENCIL_OP_INCREMENT_AND_WRAP: u32 = 6;
pub const STENCIL_OP_DECREMENT_AND_WRAP: u32 = 7;

pub type LogicOp = u32;
pub const LOGIC_OP_CLEAR: u32 = 0;
pub const LOGIC_OP_AND: u32 = 1;
pub const LOGIC_OP_AND_REVERSE: u32 = 2;
pub const LOGIC_OP_COPY: u32 = 3;
pub const LOGIC_OP_AND_INVERTED: u32 = 4;
pub const LOGIC_OP_NO_OP: u32 = 5;
pub const LOGIC_OP_XOR: u32 = 6;
pub const LOGIC_OP_OR: u32 = 7;
pub const LOGIC_OP_NOR: u32 = 8;
pub const LOGIC_OP_EQUIVALENT: u32 = 9;
pub const LOGIC_OP_INVERT: u32 = 10;
pub const LOGIC_OP_OR_REVERSE: u32 = 11;
pub const LOGIC_OP_COPY_INVERTED: u32 = 12;
pub const LOGIC_OP_OR_INVERTED: u32 = 13;
pub const LOGIC_OP_NAND: u32 = 14;
pub const LOGIC_OP_SET: u32 = 15;

pub type BlendFactor = u32;
pub const BLEND_FACTOR_ZERO: u32 = 0;
pub const BLEND_FACTOR_ONE: u32 = 1;
pub const BLEND_FACTOR_SRC_COLOR: u32 = 2;
pub const BLEND_FACTOR_ONE_MINUS_SRC_COLOR: u32 = 3;
pub const BLEND_FACTOR_DST_COLOR: u32 = 4;
pub const BLEND_FACTOR_ONE_MINUS_DST_COLOR: u32 = 5;
pub const BLEND_FACTOR_SRC_ALPHA: u32 = 6;
pub const BLEND_FACTOR_ONE_MINUS_SRC_ALPHA: u32 = 7;
pub const BLEND_FACTOR_DST_ALPHA: u32 = 8;
pub const BLEND_FACTOR_ONE_MINUS_DST_ALPHA: u32 = 9;
pub const BLEND_FACTOR_CONSTANT_COLOR: u32 = 10;
pub const BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR: u32 = 11;
pub const BLEND_FACTOR_CONSTANT_ALPHA: u32 = 12;
pub const BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA: u32 = 13;
pub const BLEND_FACTOR_SRC_ALPHA_SATURATE: u32 = 14;
pub const BLEND_FACTOR_SRC1_COLOR: u32 = 15;
pub const BLEND_FACTOR_ONE_MINUS_SRC1_COLOR: u32 = 16;
pub const BLEND_FACTOR_SRC1_ALPHA: u32 = 17;
pub const BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA: u32 = 18;

pub type BlendOp = u32;
pub const BLEND_OP_ADD: u32 = 0;
pub const BLEND_OP_SUBTRACT: u32 = 1;
pub const BLEND_OP_REVERSE_SUBTRACT: u32 = 2;
pub const BLEND_OP_MIN: u32 = 3;
pub const BLEND_OP_MAX: u32 = 4;

pub type DynamicState = u32;
pub const DYNAMIC_STATE_VIEWPORT: u32 = 0;
pub const DYNAMIC_STATE_SCISSOR: u32 = 1;
pub const DYNAMIC_STATE_LINE_WIDTH: u32 = 2;
pub const DYNAMIC_STATE_DEPTH_BIAS: u32 = 3;
pub const DYNAMIC_STATE_BLEND_CONSTANTS: u32 = 4;
pub const DYNAMIC_STATE_DEPTH_BOUNDS: u32 = 5;
pub const DYNAMIC_STATE_STENCIL_COMPARE_MASK: u32 = 6;
pub const DYNAMIC_STATE_STENCIL_WRITE_MASK: u32 = 7;
pub const DYNAMIC_STATE_STENCIL_REFERENCE: u32 = 8;

pub type Filter = u32;
pub const FILTER_NEAREST: u32 = 0;
pub const FILTER_LINEAR: u32 = 1;

pub type SamplerMipmapMode = u32;
pub const SAMPLER_MIPMAP_MODE_NEAREST: u32 = 0;
pub const SAMPLER_MIPMAP_MODE_LINEAR: u32 = 1;

pub type SamplerAddressMode = u32;
pub const SAMPLER_ADDRESS_MODE_REPEAT: u32 = 0;
pub const SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT: u32 = 1;
pub const SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE: u32 = 2;
pub const SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER: u32 = 3;
pub const SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE: u32 = 4;

pub type BorderColor = u32;
pub const BORDER_COLOR_FLOAT_TRANSPARENT_BLACK: u32 = 0;
pub const BORDER_COLOR_INT_TRANSPARENT_BLACK: u32 = 1;
pub const BORDER_COLOR_FLOAT_OPAQUE_BLACK: u32 = 2;
pub const BORDER_COLOR_INT_OPAQUE_BLACK: u32 = 3;
pub const BORDER_COLOR_FLOAT_OPAQUE_WHITE: u32 = 4;
pub const BORDER_COLOR_INT_OPAQUE_WHITE: u32 = 5;

pub type DescriptorType = u32;
pub const DESCRIPTOR_TYPE_SAMPLER: u32 = 0;
pub const DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER: u32 = 1;
pub const DESCRIPTOR_TYPE_SAMPLED_IMAGE: u32 = 2;
pub const DESCRIPTOR_TYPE_STORAGE_IMAGE: u32 = 3;
pub const DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER: u32 = 4;
pub const DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER: u32 = 5;
pub const DESCRIPTOR_TYPE_UNIFORM_BUFFER: u32 = 6;
pub const DESCRIPTOR_TYPE_STORAGE_BUFFER: u32 = 7;
pub const DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC: u32 = 8;
pub const DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC: u32 = 9;
pub const DESCRIPTOR_TYPE_INPUT_ATTACHMENT: u32 = 10;

pub type AttachmentLoadOp = u32;
pub const ATTACHMENT_LOAD_OP_LOAD: u32 = 0;
pub const ATTACHMENT_LOAD_OP_CLEAR: u32 = 1;
pub const ATTACHMENT_LOAD_OP_DONT_CARE: u32 = 2;

pub type AttachmentStoreOp = u32;
pub const ATTACHMENT_STORE_OP_STORE: u32 = 0;
pub const ATTACHMENT_STORE_OP_DONT_CARE: u32 = 1;

pub type PipelineBindPoint = u32;
pub const PIPELINE_BIND_POINT_GRAPHICS: u32 = 0;
pub const PIPELINE_BIND_POINT_COMPUTE: u32 = 1;

pub type CommandBufferLevel = u32;
pub const COMMAND_BUFFER_LEVEL_PRIMARY: u32 = 0;
pub const COMMAND_BUFFER_LEVEL_SECONDARY: u32 = 1;

pub type IndexType = u32;
pub const INDEX_TYPE_UINT16: u32 = 0;
pub const INDEX_TYPE_UINT32: u32 = 1;

pub type SubpassContents = u32;
pub const SUBPASS_CONTENTS_INLINE: u32 = 0;
pub const SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS: u32 = 1;

pub type InstanceCreateFlags = Flags;

pub type FormatFeatureFlagBits = u32;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_BIT: u32 = 0x00000001;
pub const FORMAT_FEATURE_STORAGE_IMAGE_BIT: u32 = 0x00000002;
pub const FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT: u32 = 0x00000004;
pub const FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT: u32 = 0x00000008;
pub const FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT: u32 = 0x00000010;
pub const FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT: u32 = 0x00000020;
pub const FORMAT_FEATURE_VERTEX_BUFFER_BIT: u32 = 0x00000040;
pub const FORMAT_FEATURE_COLOR_ATTACHMENT_BIT: u32 = 0x00000080;
pub const FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT: u32 = 0x00000100;
pub const FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT: u32 = 0x00000200;
pub const FORMAT_FEATURE_BLIT_SRC_BIT: u32 = 0x00000400;
pub const FORMAT_FEATURE_BLIT_DST_BIT: u32 = 0x00000800;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT: u32 = 0x00001000;
pub const FORMAT_FEATURE_TRANSFER_SRC_BIT: u32 = 0x00004000;
pub const FORMAT_FEATURE_TRANSFER_DST_BIT: u32 = 0x00008000;
pub const FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT: u32 = 0x00020000;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT: u32 = 0x00040000;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT: u32 =
    0x00080000;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT: u32 =
    0x00100000;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT: u32 = 0x00200000;
pub const FORMAT_FEATURE_DISJOINT_BIT: u32 = 0x00400000;
pub const FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT: u32 = 0x00800000;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT: u32 = 0x00010000;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG: u32 = 0x00002000;
pub const FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR: u32 = 0x20000000;
pub const FORMAT_FEATURE_FRAGMENT_DENSITY_MAP_BIT_EXT: u32 = 0x01000000;

pub const FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR: u32 = FORMAT_FEATURE_TRANSFER_SRC_BIT;
pub const FORMAT_FEATURE_TRANSFER_DST_BIT_KHR: u32 = FORMAT_FEATURE_TRANSFER_DST_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT_EXT: u32 =
    FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT;
pub const FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR: u32 =
    FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR: u32 =
    FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR:
    u32 = FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR:
    u32 = FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR: u32 = FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT;
pub const FORMAT_FEATURE_DISJOINT_BIT_KHR: u32 = FORMAT_FEATURE_DISJOINT_BIT;
pub const FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR: u32 =
    FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT;
pub const FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_EXT: u32 =
    FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_CUBIC_BIT_IMG;
pub type FormatFeatureFlags = Flags;

pub type ImageUsageFlagBits = u32;
pub const IMAGE_USAGE_TRANSFER_SRC_BIT: u32 = 0x00000001;
pub const IMAGE_USAGE_TRANSFER_DST_BIT: u32 = 0x00000002;
pub const IMAGE_USAGE_SAMPLED_BIT: u32 = 0x00000004;
pub const IMAGE_USAGE_STORAGE_BIT: u32 = 0x00000008;
pub const IMAGE_USAGE_COLOR_ATTACHMENT_BIT: u32 = 0x00000010;
pub const IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT: u32 = 0x00000020;
pub const IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT: u32 = 0x00000040;
pub const IMAGE_USAGE_INPUT_ATTACHMENT_BIT: u32 = 0x00000080;
pub type ImageUsageFlags = Flags;

pub type ImageCreateFlagBits = u32;
pub const IMAGE_CREATE_SPARSE_BINDING_BIT: u32 = 0x00000001;
pub const IMAGE_CREATE_SPARSE_RESIDENCY_BIT: u32 = 0x00000002;
pub const IMAGE_CREATE_SPARSE_ALIASED_BIT: u32 = 0x00000004;
pub const IMAGE_CREATE_MUTABLE_FORMAT_BIT: u32 = 0x00000008;
pub const IMAGE_CREATE_CUBE_COMPATIBLE_BIT: u32 = 0x00000010;
pub const IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR: u32 = 0x00000020;
pub type ImageCreateFlags = Flags;

pub type SampleCountFlagBits = u32;
pub const SAMPLE_COUNT_1_BIT: u32 = 0x00000001;
pub const SAMPLE_COUNT_2_BIT: u32 = 0x00000002;
pub const SAMPLE_COUNT_4_BIT: u32 = 0x00000004;
pub const SAMPLE_COUNT_8_BIT: u32 = 0x00000008;
pub const SAMPLE_COUNT_16_BIT: u32 = 0x00000010;
pub const SAMPLE_COUNT_32_BIT: u32 = 0x00000020;
pub const SAMPLE_COUNT_64_BIT: u32 = 0x00000040;
pub type SampleCountFlags = Flags;

pub type QueueFlagBits = u32;
pub const QUEUE_GRAPHICS_BIT: u32 = 0x00000001;
pub const QUEUE_COMPUTE_BIT: u32 = 0x00000002;
pub const QUEUE_TRANSFER_BIT: u32 = 0x00000004;
pub const QUEUE_SPARSE_BINDING_BIT: u32 = 0x00000008;
pub type QueueFlags = Flags;

pub type MemoryPropertyFlagBits = u32;
pub const MEMORY_PROPERTY_DEVICE_LOCAL_BIT: u32 = 0x00000001;
pub const MEMORY_PROPERTY_HOST_VISIBLE_BIT: u32 = 0x00000002;
pub const MEMORY_PROPERTY_HOST_COHERENT_BIT: u32 = 0x00000004;
pub const MEMORY_PROPERTY_HOST_CACHED_BIT: u32 = 0x00000008;
pub const MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT: u32 = 0x00000010;
pub type MemoryPropertyFlags = Flags;

pub type MemoryHeapFlagBits = u32;
pub const MEMORY_HEAP_DEVICE_LOCAL_BIT: u32 = 0x00000001;
pub const MEMORY_HEAP_MULTI_INSTANCE_BIT: u32 = 0x00000002;
pub type MemoryHeapFlags = Flags;
pub type DeviceCreateFlags = Flags;
pub type DeviceQueueCreateFlags = Flags;

pub type PipelineStageFlagBits = u32;
pub const PIPELINE_STAGE_TOP_OF_PIPE_BIT: u32 = 0x00000001;
pub const PIPELINE_STAGE_DRAW_INDIRECT_BIT: u32 = 0x00000002;
pub const PIPELINE_STAGE_VERTEX_INPUT_BIT: u32 = 0x00000004;
pub const PIPELINE_STAGE_VERTEX_SHADER_BIT: u32 = 0x00000008;
pub const PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT: u32 = 0x00000010;
pub const PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT: u32 = 0x00000020;
pub const PIPELINE_STAGE_GEOMETRY_SHADER_BIT: u32 = 0x00000040;
pub const PIPELINE_STAGE_FRAGMENT_SHADER_BIT: u32 = 0x00000080;
pub const PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT: u32 = 0x00000100;
pub const PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT: u32 = 0x00000200;
pub const PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT: u32 = 0x00000400;
pub const PIPELINE_STAGE_COMPUTE_SHADER_BIT: u32 = 0x00000800;
pub const PIPELINE_STAGE_TRANSFER_BIT: u32 = 0x00001000;
pub const PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT: u32 = 0x00002000;
pub const PIPELINE_STAGE_HOST_BIT: u32 = 0x00004000;
pub const PIPELINE_STAGE_ALL_GRAPHICS_BIT: u32 = 0x00008000;
pub const PIPELINE_STAGE_ALL_COMMANDS_BIT: u32 = 0x00010000;
pub type PipelineStageFlags = Flags;
pub type MemoryMapFlags = Flags;

pub type ImageAspectFlagBits = u32;
pub const IMAGE_ASPECT_COLOR_BIT: u32 = 0x00000001;
pub const IMAGE_ASPECT_DEPTH_BIT: u32 = 0x00000002;
pub const IMAGE_ASPECT_STENCIL_BIT: u32 = 0x00000004;
pub const IMAGE_ASPECT_METADATA_BIT: u32 = 0x00000008;
pub const IMAGE_ASPECT_PLANE_0_BIT: u32 = 0x00000010;
pub const IMAGE_ASPECT_PLANE_1_BIT: u32 = 0x00000020;
pub const IMAGE_ASPECT_PLANE_2_BIT: u32 = 0x00000040;
pub const IMAGE_ASPECT_MEMORY_PLANE_0_BIT_EXT: u32 = 0x00000080;
pub const IMAGE_ASPECT_MEMORY_PLANE_1_BIT_EXT: u32 = 0x00000100;
pub const IMAGE_ASPECT_MEMORY_PLANE_2_BIT_EXT: u32 = 0x00000200;
pub const IMAGE_ASPECT_MEMORY_PLANE_3_BIT_EXT: u32 = 0x00000400;
pub const IMAGE_ASPECT_PLANE_0_BIT_KHR: u32 = IMAGE_ASPECT_PLANE_0_BIT;
pub const IMAGE_ASPECT_PLANE_1_BIT_KHR: u32 = IMAGE_ASPECT_PLANE_1_BIT;
pub const IMAGE_ASPECT_PLANE_2_BIT_KHR: u32 = IMAGE_ASPECT_PLANE_2_BIT;
pub const IMAGE_ASPECT_FLAG_BITS_MAX_ENUM: u32 = 0x7FFFFFFF;
pub type ImageAspectFlags = Flags;

pub type SparseImageFormatFlagBits = u32;
pub const SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT: u32 = 0x00000001;
pub const SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT: u32 = 0x00000002;
pub const SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT: u32 = 0x00000004;
pub type SparseImageFormatFlags = Flags;

pub type SparseMemoryBindFlagBits = u32;
pub const SPARSE_MEMORY_BIND_METADATA_BIT: u32 = 0x00000001;
pub type SparseMemoryBindFlags = Flags;

pub type FenceCreateFlagBits = u32;
pub const FENCE_CREATE_SIGNALED_BIT: u32 = 0x00000001;
pub type FenceCreateFlags = Flags;
pub type SemaphoreCreateFlags = Flags;
pub type EventCreateFlags = Flags;
pub type QueryPoolCreateFlags = Flags;

pub type QueryPipelineStatisticFlagBits = u32;
pub const QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT: u32 = 0x00000001;
pub const QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT: u32 = 0x00000002;
pub const QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT: u32 = 0x00000004;
pub const QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT: u32 = 0x00000008;
pub const QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT: u32 = 0x00000010;
pub const QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT: u32 = 0x00000020;
pub const QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT: u32 = 0x00000040;
pub const QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT: u32 = 0x00000080;
pub const QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT: u32 = 0x00000100;
pub const QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT: u32 = 0x00000200;
pub const QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT: u32 = 0x00000400;
pub type QueryPipelineStatisticFlags = Flags;

pub type QueryResultFlagBits = u32;
pub const QUERY_RESULT_64_BIT: u32 = 0x00000001;
pub const QUERY_RESULT_WAIT_BIT: u32 = 0x00000002;
pub const QUERY_RESULT_WITH_AVAILABILITY_BIT: u32 = 0x00000004;
pub const QUERY_RESULT_PARTIAL_BIT: u32 = 0x00000008;
pub type QueryResultFlags = Flags;

pub type BufferCreateFlagBits = u32;
pub const BUFFER_CREATE_SPARSE_BINDING_BIT: u32 = 0x00000001;
pub const BUFFER_CREATE_SPARSE_RESIDENCY_BIT: u32 = 0x00000002;
pub const BUFFER_CREATE_SPARSE_ALIASED_BIT: u32 = 0x00000004;
pub type BufferCreateFlags = Flags;

pub type BufferUsageFlagBits = u32;
pub const BUFFER_USAGE_TRANSFER_SRC_BIT: u32 = 0x00000001;
pub const BUFFER_USAGE_TRANSFER_DST_BIT: u32 = 0x00000002;
pub const BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT: u32 = 0x00000004;
pub const BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT: u32 = 0x00000008;
pub const BUFFER_USAGE_UNIFORM_BUFFER_BIT: u32 = 0x00000010;
pub const BUFFER_USAGE_STORAGE_BUFFER_BIT: u32 = 0x00000020;
pub const BUFFER_USAGE_INDEX_BUFFER_BIT: u32 = 0x00000040;
pub const BUFFER_USAGE_VERTEX_BUFFER_BIT: u32 = 0x00000080;
pub const BUFFER_USAGE_INDIRECT_BUFFER_BIT: u32 = 0x00000100;
pub const BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT: u32 = 0x00020000;
pub type BufferUsageFlags = Flags;
pub type BufferViewCreateFlags = Flags;
pub type ImageViewCreateFlags = Flags;
pub type ShaderModuleCreateFlags = Flags;
pub type PipelineCacheCreateFlags = Flags;

pub type PipelineCreateFlagBits = u32;
pub const PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT: u32 = 0x00000001;
pub const PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT: u32 = 0x00000002;
pub const PIPELINE_CREATE_DERIVATIVE_BIT: u32 = 0x00000004;
pub type PipelineCreateFlags = Flags;
pub type PipelineShaderStageCreateFlags = Flags;

pub type ShaderStageFlagBits = u32;
pub const SHADER_STAGE_VERTEX_BIT: u32 = 0x00000001;
pub const SHADER_STAGE_TESSELLATION_CONTROL_BIT: u32 = 0x00000002;
pub const SHADER_STAGE_TESSELLATION_EVALUATION_BIT: u32 = 0x00000004;
pub const SHADER_STAGE_GEOMETRY_BIT: u32 = 0x00000008;
pub const SHADER_STAGE_FRAGMENT_BIT: u32 = 0x00000010;
pub const SHADER_STAGE_COMPUTE_BIT: u32 = 0x00000020;
pub const SHADER_STAGE_ALL_GRAPHICS: u32 = 0x1F;
pub const SHADER_STAGE_ALL: u32 = 0x7FFFFFFF;
pub type PipelineVertexInputStateCreateFlags = Flags;
pub type PipelineInputAssemblyStateCreateFlags = Flags;
pub type PipelineTessellationStateCreateFlags = Flags;
pub type PipelineViewportStateCreateFlags = Flags;
pub type PipelineRasterizationStateCreateFlags = Flags;

pub type CullModeFlagBits = u32;
pub const CULL_MODE_NONE: u32 = 0;
pub const CULL_MODE_FRONT_BIT: u32 = 0x00000001;
pub const CULL_MODE_BACK_BIT: u32 = 0x00000002;
pub const CULL_MODE_FRONT_AND_BACK: u32 = 0x3;
pub type CullModeFlags = Flags;
pub type PipelineMultisampleStateCreateFlags = Flags;
pub type PipelineDepthStencilStateCreateFlags = Flags;
pub type PipelineColorBlendStateCreateFlags = Flags;

pub type ColorComponentFlagBits = u32;
pub const COLOR_COMPONENT_R_BIT: u32 = 0x00000001;
pub const COLOR_COMPONENT_G_BIT: u32 = 0x00000002;
pub const COLOR_COMPONENT_B_BIT: u32 = 0x00000004;
pub const COLOR_COMPONENT_A_BIT: u32 = 0x00000008;
pub type ColorComponentFlags = Flags;
pub type PipelineDynamicStateCreateFlags = Flags;
pub type PipelineLayoutCreateFlags = Flags;
pub type ShaderStageFlags = Flags;
pub type SubgroupFeatureFlags = Flags;
pub type SamplerCreateFlags = Flags;
pub type DescriptorSetLayoutCreateFlags = Flags;

pub type DescriptorPoolCreateFlagBits = u32;
pub const DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT: u32 = 0x00000001;
pub type DescriptorPoolCreateFlags = Flags;
pub type DescriptorPoolResetFlags = Flags;
pub type FramebufferCreateFlags = Flags;
pub type RenderPassCreateFlags = Flags;

pub type AttachmentDescriptionFlagBits = u32;
pub const ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT: u32 = 0x00000001;
pub type AttachmentDescriptionFlags = Flags;
pub type SubpassDescriptionFlags = Flags;

pub type AccessFlagBits = u32;
pub const ACCESS_INDIRECT_COMMAND_READ_BIT: u32 = 0x00000001;
pub const ACCESS_INDEX_READ_BIT: u32 = 0x00000002;
pub const ACCESS_VERTEX_ATTRIBUTE_READ_BIT: u32 = 0x00000004;
pub const ACCESS_UNIFORM_READ_BIT: u32 = 0x00000008;
pub const ACCESS_INPUT_ATTACHMENT_READ_BIT: u32 = 0x00000010;
pub const ACCESS_SHADER_READ_BIT: u32 = 0x00000020;
pub const ACCESS_SHADER_WRITE_BIT: u32 = 0x00000040;
pub const ACCESS_COLOR_ATTACHMENT_READ_BIT: u32 = 0x00000080;
pub const ACCESS_COLOR_ATTACHMENT_WRITE_BIT: u32 = 0x00000100;
pub const ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT: u32 = 0x00000200;
pub const ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT: u32 = 0x00000400;
pub const ACCESS_TRANSFER_READ_BIT: u32 = 0x00000800;
pub const ACCESS_TRANSFER_WRITE_BIT: u32 = 0x00001000;
pub const ACCESS_HOST_READ_BIT: u32 = 0x00002000;
pub const ACCESS_HOST_WRITE_BIT: u32 = 0x00004000;
pub const ACCESS_MEMORY_READ_BIT: u32 = 0x00008000;
pub const ACCESS_MEMORY_WRITE_BIT: u32 = 0x00010000;
pub type AccessFlags = Flags;

pub type DependencyFlagBits = u32;
pub const DEPENDENCY_BY_REGION_BIT: u32 = 0x00000001;
pub type DependencyFlags = Flags;

pub type CommandPoolCreateFlagBits = u32;
pub const COMMAND_POOL_CREATE_TRANSIENT_BIT: u32 = 0x00000001;
pub const COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT: u32 = 0x00000002;
pub type CommandPoolCreateFlags = Flags;

pub type CommandPoolResetFlagBits = u32;
pub const COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT: u32 = 0x00000001;
pub type CommandPoolResetFlags = Flags;

pub type CommandPoolTrimFlagsKHR = Flags;

pub type CommandBufferUsageFlagBits = u32;
pub const COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT: u32 = 0x00000001;
pub const COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT: u32 = 0x00000002;
pub const COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT: u32 = 0x00000004;
pub type CommandBufferUsageFlags = Flags;

pub type QueryControlFlagBits = u32;
pub const QUERY_CONTROL_PRECISE_BIT: u32 = 0x00000001;
pub type QueryControlFlags = Flags;

pub type CommandBufferResetFlagBits = u32;
pub const COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT: u32 = 0x00000001;
pub type CommandBufferResetFlags = Flags;

pub type StencilFaceFlagBits = u32;
pub const STENCIL_FACE_FRONT_BIT: u32 = 0x00000001;
pub const STENCIL_FACE_BACK_BIT: u32 = 0x00000002;
pub const STENCIL_FRONT_AND_BACK: u32 = 0x3;
pub type StencilFaceFlags = Flags;

pub type DisplayPlaneAlphaFlagBitsKHR = u32;
pub const DISPLAY_PLANE_ALPHA_OPAQUE_BIT_KHR: u32 = 0x00000001;
pub const DISPLAY_PLANE_ALPHA_GLOBAL_BIT_KHR: u32 = 0x00000002;
pub const DISPLAY_PLANE_ALPHA_PER_PIXEL_BIT_KHR: u32 = 0x00000004;
pub const DISPLAY_PLANE_ALPHA_PER_PIXEL_PREMULTIPLIED_BIT_KHR: u32 = 0x00000008;
pub type DisplayModeCreateFlagsKHR = Flags;
pub type DisplayPlaneAlphaFlagsKHR = Flags;
pub type DisplaySurfaceCreateFlagsKHR = Flags;

pub type ColorSpaceKHR = u32;
pub const COLOR_SPACE_SRGB_NONLINEAR_KHR: u32 = 0;
pub const COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT: u32 = 1000104001;
pub const COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT: u32 = 1000104002;
pub const COLOR_SPACE_DCI_P3_LINEAR_EXT: u32 = 1000104003;
pub const COLOR_SPACE_DCI_P3_NONLINEAR_EXT: u32 = 1000104004;
pub const COLOR_SPACE_BT709_LINEAR_EXT: u32 = 1000104005;
pub const COLOR_SPACE_BT709_NONLINEAR_EXT: u32 = 1000104006;
pub const COLOR_SPACE_BT2020_LINEAR_EXT: u32 = 1000104007;
pub const COLOR_SPACE_HDR10_ST2084_EXT: u32 = 1000104008;
pub const COLOR_SPACE_DOLBYVISION_EXT: u32 = 1000104009;
pub const COLOR_SPACE_HDR10_HLG_EXT: u32 = 1000104010;
pub const COLOR_SPACE_ADOBERGB_LINEAR_EXT: u32 = 1000104011;
pub const COLOR_SPACE_ADOBERGB_NONLINEAR_EXT: u32 = 1000104012;
pub const COLOR_SPACE_PASS_THROUGH_EXT: u32 = 1000104013;

pub type PresentModeKHR = u32;
pub const PRESENT_MODE_IMMEDIATE_KHR: u32 = 0;
pub const PRESENT_MODE_MAILBOX_KHR: u32 = 1;
pub const PRESENT_MODE_FIFO_KHR: u32 = 2;
pub const PRESENT_MODE_FIFO_RELAXED_KHR: u32 = 3;
pub const PRESENT_MODE_SHARED_DEMAND_REFRESH_KHR: u32 = 1000111000;
pub const PRESENT_MODE_SHARED_CONTINUOUS_REFRESH_KHR: u32 = 1000111001;

pub type SurfaceTransformFlagBitsKHR = u32;
pub const SURFACE_TRANSFORM_IDENTITY_BIT_KHR: u32 = 0x00000001;
pub const SURFACE_TRANSFORM_ROTATE_90_BIT_KHR: u32 = 0x00000002;
pub const SURFACE_TRANSFORM_ROTATE_180_BIT_KHR: u32 = 0x00000004;
pub const SURFACE_TRANSFORM_ROTATE_270_BIT_KHR: u32 = 0x00000008;
pub const SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR: u32 = 0x00000010;
pub const SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR: u32 = 0x00000020;
pub const SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR: u32 = 0x00000040;
pub const SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR: u32 = 0x00000080;
pub const SURFACE_TRANSFORM_INHERIT_BIT_KHR: u32 = 0x00000100;
pub type SurfaceTransformFlagsKHR = Flags;

pub type CompositeAlphaFlagBitsKHR = u32;
pub const COMPOSITE_ALPHA_OPAQUE_BIT_KHR: u32 = 0x00000001;
pub const COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR: u32 = 0x00000002;
pub const COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR: u32 = 0x00000004;
pub const COMPOSITE_ALPHA_INHERIT_BIT_KHR: u32 = 0x00000008;
pub type CompositeAlphaFlagsKHR = Flags;

pub type ExternalMemoryHandleTypeFlagBits = u32;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT: u32 = 0x00000001;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT: u32 = 0x00000002;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT: u32 = 0x00000004;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT: u32 = 0x00000008;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT: u32 = 0x00000010;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT: u32 = 0x00000020;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT: u32 = 0x00000040;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT: u32 = 0x00000200;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_ANDROID_HARDWARE_BUFFER_BIT_ANDROID: u32 = 0x00000400;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT: u32 = 0x00000080;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT: u32 = 0x00000100;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR: u32 =
    EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR: u32 =
    EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR: u32 =
    EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT_KHR: u32 =
    EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT_KHR: u32 =
    EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT_KHR: u32 =
    EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT;
pub const EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT_KHR: u32 =
    EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT;
pub type ExternalMemoryHandleTypeFlags = Flags;

pub type ObjectType = u32;
pub const OBJECT_TYPE_UNKNOWN: u32 = 0;
pub const OBJECT_TYPE_INSTANCE: u32 = 1;
pub const OBJECT_TYPE_PHYSICAL_DEVICE: u32 = 2;
pub const OBJECT_TYPE_DEVICE: u32 = 3;
pub const OBJECT_TYPE_QUEUE: u32 = 4;
pub const OBJECT_TYPE_SEMAPHORE: u32 = 5;
pub const OBJECT_TYPE_COMMAND_BUFFER: u32 = 6;
pub const OBJECT_TYPE_FENCE: u32 = 7;
pub const OBJECT_TYPE_DEVICE_MEMORY: u32 = 8;
pub const OBJECT_TYPE_BUFFER: u32 = 9;
pub const OBJECT_TYPE_IMAGE: u32 = 10;
pub const OBJECT_TYPE_EVENT: u32 = 11;
pub const OBJECT_TYPE_QUERY_POOL: u32 = 12;
pub const OBJECT_TYPE_BUFFER_VIEW: u32 = 13;
pub const OBJECT_TYPE_IMAGE_VIEW: u32 = 14;
pub const OBJECT_TYPE_SHADER_MODULE: u32 = 15;
pub const OBJECT_TYPE_PIPELINE_CACHE: u32 = 16;
pub const OBJECT_TYPE_PIPELINE_LAYOUT: u32 = 17;
pub const OBJECT_TYPE_RENDER_PASS: u32 = 18;
pub const OBJECT_TYPE_PIPELINE: u32 = 19;
pub const OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT: u32 = 20;
pub const OBJECT_TYPE_SAMPLER: u32 = 21;
pub const OBJECT_TYPE_DESCRIPTOR_POOL: u32 = 22;
pub const OBJECT_TYPE_DESCRIPTOR_SET: u32 = 23;
pub const OBJECT_TYPE_FRAMEBUFFER: u32 = 24;
pub const OBJECT_TYPE_COMMAND_POOL: u32 = 25;
pub const OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION: u32 = 1000156000;
pub const OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE: u32 = 1000085000;
pub const OBJECT_TYPE_SURFACE_KHR: u32 = 1000000000;
pub const OBJECT_TYPE_SWAPCHAIN_KHR: u32 = 1000001000;
pub const OBJECT_TYPE_DISPLAY_KHR: u32 = 1000002000;
pub const OBJECT_TYPE_DISPLAY_MODE_KHR: u32 = 1000002001;
pub const OBJECT_TYPE_OBJECT_TABLE_NVX: u32 = 1000086000;
pub const OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NVX: u32 = 1000086001;
pub const OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT: u32 = 1000128000;
pub const OBJECT_TYPE_VALIDATION_CACHE_EXT: u32 = 1000160000;
pub const OBJECT_TYPE_ACCELERATION_STRUCTURE_NV: u32 = 1000165000;
pub const OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL: u32 = 1000210000;
pub const OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_KHR: u32 = OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE;
pub const OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION_KHR: u32 = OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION;

pub type DebugUtilsMessageSeverityFlagBitsEXT = u32;
pub const DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT: u32 = 0x00000001;
pub const DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT: u32 = 0x00000010;
pub const DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT: u32 = 0x00000100;
pub const DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT: u32 = 0x00001000;
pub type DebugUtilsMessageSeverityFlagsEXT = Flags;

pub type DebugUtilsMessageTypeFlagBitsEXT = u32;
pub const DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT: u32 = 0x00000001;
pub const DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT: u32 = 0x00000002;
pub const DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT: u32 = 0x00000004;
pub type DebugUtilsMessageTypeFlagsEXT = Flags;

pub type DebugUtilsMessengerCreateFlagsEXT = Flags;

pub type DebugUtilsMessengerCallbackDataFlagsEXT = Flags;

pub type DebugUtilsMessengerEXT = u64;

pub type MacOSSurfaceCreateFlagsMVK = u32;

pub type IOSSurfaceCreateFlagsMVK = u32;

pub type DescriptorSetLayoutCreateFlagBits = u32;
pub const DESCRIPTOR_SET_LAYOUT_CREATE_PUSH_DESCRIPTOR_BIT_KHR: u32 = 0x00000001;

pub type DescriptorUpdateTemplateTypeKHR = u32;
pub const DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR: u32 = 0;
pub const DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR: u32 = 1;
pub const DESCRIPTOR_UPDATE_TEMPLATE_TYPE_BEGIN_RANGE_KHR: u32 =
    DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR;
pub const DESCRIPTOR_UPDATE_TEMPLATE_TYPE_END_RANGE_KHR: u32 =
    DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR;
pub const DESCRIPTOR_UPDATE_TEMPLATE_TYPE_RANGE_SIZE_KHR: u32 =
    DESCRIPTOR_UPDATE_TEMPLATE_TYPE_PUSH_DESCRIPTORS_KHR
        - DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET_KHR
        + 1;
pub type DescriptorUpdateTemplateCreateFlagsKHR = Flags;

pub type PFN_vkAllocationFunction =
    extern "system" fn(*mut c_void, usize, usize, SystemAllocationScope) -> *mut c_void;
pub type PFN_vkReallocationFunction = extern "system" fn(
    *mut c_void,
    *mut c_void,
    usize,
    usize,
    SystemAllocationScope,
) -> *mut c_void;
pub type PFN_vkFreeFunction = extern "system" fn(*mut c_void, *mut c_void);
pub type PFN_vkInternalAllocationNotification = extern "system" fn(
    *mut c_void,
    usize,
    InternalAllocationType,
    SystemAllocationScope,
) -> *mut c_void;
pub type PFN_vkInternalFreeNotification = extern "system" fn(
    *mut c_void,
    usize,
    InternalAllocationType,
    SystemAllocationScope,
) -> *mut c_void;
pub type PFN_vkDebugUtilsMessengerCallbackEXT = extern "system" fn(
    DebugUtilsMessageSeverityFlagBitsEXT,
    DebugUtilsMessageTypeFlagsEXT,
    *const DebugUtilsMessengerCallbackDataEXT,
    *mut c_void,
) -> Bool32;

pub type PFN_vkVoidFunction = extern "system" fn() -> ();

pub type FullScreenExclusiveEXT = u32;
pub const FULL_SCREEN_EXCLUSIVE_DEFAUlT_EXT: u32 = 0;
pub const FULL_SCREEN_EXCLUSIVE_ALLOWED_EXT: u32 = 1;
pub const FULL_SCREEN_EXCLUSIVE_DISALLOWED_EXT: u32 = 2;
pub const FULL_SCREEN_EXCLUSIVE_APPLICATION_CONTROLLED_EXT: u32 = 3;
pub const FULL_SCREEN_EXCLUSIVE_MAX_ENUM_EXT: u32 = 0x7FFFFFFF;

#[repr(C)]
pub struct ApplicationInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pApplicationName: *const c_char,
    pub applicationVersion: u32,
    pub pEngineName: *const c_char,
    pub engineVersion: u32,
    pub apiVersion: u32,
}

#[repr(C)]
pub struct InstanceCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: InstanceCreateFlags,
    pub pApplicationInfo: *const ApplicationInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const c_char,
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const c_char,
}

#[repr(C)]
pub struct AllocationCallbacks {
    pub pUserData: *mut c_void,
    pub pfnAllocation: PFN_vkAllocationFunction,
    pub pfnReallocation: PFN_vkReallocationFunction,
    pub pfnFree: PFN_vkFreeFunction,
    pub pfnInternalAllocation: PFN_vkInternalAllocationNotification,
    pub pfnInternalFree: PFN_vkInternalFreeNotification,
}

#[derive(Default)]
#[repr(C)]
pub struct PhysicalDeviceFeatures {
    pub robustBufferAccess: Bool32,
    pub fullDrawIndexUint32: Bool32,
    pub imageCubeArray: Bool32,
    pub independentBlend: Bool32,
    pub geometryShader: Bool32,
    pub tessellationShader: Bool32,
    pub sampleRateShading: Bool32,
    pub dualSrcBlend: Bool32,
    pub logicOp: Bool32,
    pub multiDrawIndirect: Bool32,
    pub drawIndirectFirstInstance: Bool32,
    pub depthClamp: Bool32,
    pub depthBiasClamp: Bool32,
    pub fillModeNonSolid: Bool32,
    pub depthBounds: Bool32,
    pub wideLines: Bool32,
    pub largePoints: Bool32,
    pub alphaToOne: Bool32,
    pub multiViewport: Bool32,
    pub samplerAnisotropy: Bool32,
    pub textureCompressionETC2: Bool32,
    pub textureCompressionASTC_LDR: Bool32,
    pub textureCompressionBC: Bool32,
    pub occlusionQueryPrecise: Bool32,
    pub pipelineStatisticsQuery: Bool32,
    pub vertexPipelineStoresAndAtomics: Bool32,
    pub fragmentStoresAndAtomics: Bool32,
    pub shaderTessellationAndGeometryPointSize: Bool32,
    pub shaderImageGatherExtended: Bool32,
    pub shaderStorageImageExtendedFormats: Bool32,
    pub shaderStorageImageMultisample: Bool32,
    pub shaderStorageImageReadWithoutFormat: Bool32,
    pub shaderStorageImageWriteWithoutFormat: Bool32,
    pub shaderUniformBufferArrayDynamicIndexing: Bool32,
    pub shaderSampledImageArrayDynamicIndexing: Bool32,
    pub shaderStorageBufferArrayDynamicIndexing: Bool32,
    pub shaderStorageImageArrayDynamicIndexing: Bool32,
    pub shaderClipDistance: Bool32,
    pub shaderCullDistance: Bool32,
    pub shaderFloat64: Bool32,
    pub shaderInt64: Bool32,
    pub shaderInt16: Bool32,
    pub shaderResourceResidency: Bool32,
    pub shaderResourceMinLod: Bool32,
    pub sparseBinding: Bool32,
    pub sparseResidencyBuffer: Bool32,
    pub sparseResidencyImage2D: Bool32,
    pub sparseResidencyImage3D: Bool32,
    pub sparseResidency2Samples: Bool32,
    pub sparseResidency4Samples: Bool32,
    pub sparseResidency8Samples: Bool32,
    pub sparseResidency16Samples: Bool32,
    pub sparseResidencyAliased: Bool32,
    pub variableMultisampleRate: Bool32,
    pub inheritedQueries: Bool32,
}

#[repr(C)]
pub struct FormatProperties {
    pub linearTilingFeatures: FormatFeatureFlags,
    pub optimalTilingFeatures: FormatFeatureFlags,
    pub bufferFeatures: FormatFeatureFlags,
}

#[repr(C)]
pub struct Extent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}

#[repr(C)]
pub struct ImageFormatProperties {
    pub maxExtent: Extent3D,
    pub maxMipLevels: u32,
    pub maxArrayLayers: u32,
    pub sampleCounts: SampleCountFlags,
    pub maxResourceSize: DeviceSize,
}

#[repr(C)]
pub struct PhysicalDeviceLimits {
    pub maxImageDimension1D: u32,
    pub maxImageDimension2D: u32,
    pub maxImageDimension3D: u32,
    pub maxImageDimensionCube: u32,
    pub maxImageArrayLayers: u32,
    pub maxTexelBufferElements: u32,
    pub maxUniformBufferRange: u32,
    pub maxStorageBufferRange: u32,
    pub maxPushConstantsSize: u32,
    pub maxMemoryAllocationCount: u32,
    pub maxSamplerAllocationCount: u32,
    pub bufferImageGranularity: DeviceSize,
    pub sparseAddressSpaceSize: DeviceSize,
    pub maxBoundDescriptorSets: u32,
    pub maxPerStageDescriptorSamplers: u32,
    pub maxPerStageDescriptorUniformBuffers: u32,
    pub maxPerStageDescriptorStorageBuffers: u32,
    pub maxPerStageDescriptorSampledImages: u32,
    pub maxPerStageDescriptorStorageImages: u32,
    pub maxPerStageDescriptorInputAttachments: u32,
    pub maxPerStageResources: u32,
    pub maxDescriptorSetSamplers: u32,
    pub maxDescriptorSetUniformBuffers: u32,
    pub maxDescriptorSetUniformBuffersDynamic: u32,
    pub maxDescriptorSetStorageBuffers: u32,
    pub maxDescriptorSetStorageBuffersDynamic: u32,
    pub maxDescriptorSetSampledImages: u32,
    pub maxDescriptorSetStorageImages: u32,
    pub maxDescriptorSetInputAttachments: u32,
    pub maxVertexInputAttributes: u32,
    pub maxVertexInputBindings: u32,
    pub maxVertexInputAttributeOffset: u32,
    pub maxVertexInputBindingStride: u32,
    pub maxVertexOutputComponents: u32,
    pub maxTessellationGenerationLevel: u32,
    pub maxTessellationPatchSize: u32,
    pub maxTessellationControlPerVertexInputComponents: u32,
    pub maxTessellationControlPerVertexOutputComponents: u32,
    pub maxTessellationControlPerPatchOutputComponents: u32,
    pub maxTessellationControlTotalOutputComponents: u32,
    pub maxTessellationEvaluationInputComponents: u32,
    pub maxTessellationEvaluationOutputComponents: u32,
    pub maxGeometryShaderInvocations: u32,
    pub maxGeometryInputComponents: u32,
    pub maxGeometryOutputComponents: u32,
    pub maxGeometryOutputVertices: u32,
    pub maxGeometryTotalOutputComponents: u32,
    pub maxFragmentInputComponents: u32,
    pub maxFragmentOutputAttachments: u32,
    pub maxFragmentDualSrcAttachments: u32,
    pub maxFragmentCombinedOutputResources: u32,
    pub maxComputeSharedMemorySize: u32,
    pub maxComputeWorkGroupCount: [u32; 3],
    pub maxComputeWorkGroupInvocations: u32,
    pub maxComputeWorkGroupSize: [u32; 3],
    pub subPixelPrecisionBits: u32,
    pub subTexelPrecisionBits: u32,
    pub mipmapPrecisionBits: u32,
    pub maxDrawIndexedIndexValue: u32,
    pub maxDrawIndirectCount: u32,
    pub maxSamplerLodBias: f32,
    pub maxSamplerAnisotropy: f32,
    pub maxViewports: u32,
    pub maxViewportDimensions: [u32; 2],
    pub viewportBoundsRange: [f32; 2],
    pub viewportSubPixelBits: u32,
    pub minMemoryMapAlignment: usize,
    pub minTexelBufferOffsetAlignment: DeviceSize,
    pub minUniformBufferOffsetAlignment: DeviceSize,
    pub minStorageBufferOffsetAlignment: DeviceSize,
    pub minTexelOffset: i32,
    pub maxTexelOffset: u32,
    pub minTexelGatherOffset: i32,
    pub maxTexelGatherOffset: u32,
    pub minInterpolationOffset: f32,
    pub maxInterpolationOffset: f32,
    pub subPixelInterpolationOffsetBits: u32,
    pub maxFramebufferWidth: u32,
    pub maxFramebufferHeight: u32,
    pub maxFramebufferLayers: u32,
    pub framebufferColorSampleCounts: SampleCountFlags,
    pub framebufferDepthSampleCounts: SampleCountFlags,
    pub framebufferStencilSampleCounts: SampleCountFlags,
    pub framebufferNoAttachmentsSampleCounts: SampleCountFlags,
    pub maxColorAttachments: u32,
    pub sampledImageColorSampleCounts: SampleCountFlags,
    pub sampledImageIntegerSampleCounts: SampleCountFlags,
    pub sampledImageDepthSampleCounts: SampleCountFlags,
    pub sampledImageStencilSampleCounts: SampleCountFlags,
    pub storageImageSampleCounts: SampleCountFlags,
    pub maxSampleMaskWords: u32,
    pub timestampComputeAndGraphics: Bool32,
    pub timestampPeriod: f32,
    pub maxClipDistances: u32,
    pub maxCullDistances: u32,
    pub maxCombinedClipAndCullDistances: u32,
    pub discreteQueuePriorities: u32,
    pub pointSizeRange: [f32; 2],
    pub lineWidthRange: [f32; 2],
    pub pointSizeGranularity: f32,
    pub lineWidthGranularity: f32,
    pub strictLines: Bool32,
    pub standardSampleLocations: Bool32,
    pub optimalBufferCopyOffsetAlignment: DeviceSize,
    pub optimalBufferCopyRowPitchAlignment: DeviceSize,
    pub nonCoherentAtomSize: DeviceSize,
}

#[repr(C)]
pub struct PhysicalDeviceSparseProperties {
    pub residencyStandard2DBlockShape: Bool32,
    pub residencyStandard2DMultisampleBlockShape: Bool32,
    pub residencyStandard3DBlockShape: Bool32,
    pub residencyAlignedMipSize: Bool32,
    pub residencyNonResidentStrict: Bool32,
}

#[repr(C)]
pub struct PhysicalDeviceProperties {
    pub apiVersion: u32,
    pub driverVersion: u32,
    pub vendorID: u32,
    pub deviceID: u32,
    pub deviceType: PhysicalDeviceType,
    pub deviceName: [c_char; MAX_PHYSICAL_DEVICE_NAME_SIZE as usize],
    pub pipelineCacheUUID: [u8; UUID_SIZE as usize],
    pub limits: PhysicalDeviceLimits,
    pub sparseProperties: PhysicalDeviceSparseProperties,
}

#[repr(C)]
pub struct QueueFamilyProperties {
    pub queueFlags: QueueFlags,
    pub queueCount: u32,
    pub timestampValidBits: u32,
    pub minImageTransferGranularity: Extent3D,
}

#[repr(C)]
pub struct MemoryType {
    pub propertyFlags: MemoryPropertyFlags,
    pub heapIndex: u32,
}

#[repr(C)]
pub struct MemoryHeap {
    pub size: DeviceSize,
    pub flags: MemoryHeapFlags,
}

#[repr(C)]
pub struct PhysicalDeviceMemoryProperties {
    pub memoryTypeCount: u32,
    pub memoryTypes: [MemoryType; MAX_MEMORY_TYPES as usize],
    pub memoryHeapCount: u32,
    pub memoryHeaps: [MemoryHeap; MAX_MEMORY_HEAPS as usize],
}

#[repr(C)]
pub struct DeviceQueueCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queueFamilyIndex: u32,
    pub queueCount: u32,
    pub pQueuePriorities: *const f32,
}

#[repr(C)]
pub struct DeviceCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DeviceCreateFlags,
    pub queueCreateInfoCount: u32,
    pub pQueueCreateInfos: *const DeviceQueueCreateInfo,
    pub enabledLayerCount: u32,
    pub ppEnabledLayerNames: *const *const c_char,
    pub enabledExtensionCount: u32,
    pub ppEnabledExtensionNames: *const *const c_char,
    pub pEnabledFeatures: *const PhysicalDeviceFeatures,
}

#[repr(C)]
pub struct ExtensionProperties {
    pub extensionName: [c_char; MAX_EXTENSION_NAME_SIZE as usize],
    pub specVersion: u32,
}

#[repr(C)]
pub struct LayerProperties {
    pub layerName: [c_char; MAX_EXTENSION_NAME_SIZE as usize],
    pub specVersion: u32,
    pub implementationVersion: u32,
    pub description: [c_char; MAX_DESCRIPTION_SIZE as usize],
}

#[repr(C)]
pub struct SubmitInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const Semaphore,
    pub pWaitDstStageMask: *const PipelineStageFlags,
    pub commandBufferCount: u32,
    pub pCommandBuffers: *const CommandBuffer,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const Semaphore,
}

#[repr(C)]
pub struct MemoryAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub allocationSize: DeviceSize,
    pub memoryTypeIndex: u32,
}

#[repr(C)]
pub struct MappedMemoryRange {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub memory: DeviceMemory,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}

#[repr(C)]
pub struct MemoryRequirements {
    pub size: DeviceSize,
    pub alignment: DeviceSize,
    pub memoryTypeBits: u32,
}

#[repr(C)]
pub struct SparseImageFormatProperties {
    pub aspectMask: ImageAspectFlags,
    pub imageGranularity: Extent3D,
    pub flags: SparseImageFormatFlags,
}

#[repr(C)]
pub struct SparseImageMemoryRequirements {
    pub formatProperties: SparseImageFormatProperties,
    pub imageMipTailFirstLod: u32,
    pub imageMipTailSize: DeviceSize,
    pub imageMipTailOffset: DeviceSize,
    pub imageMipTailStride: DeviceSize,
}

#[repr(C)]
pub struct SparseMemoryBind {
    pub resourceOffset: DeviceSize,
    pub size: DeviceSize,
    pub memory: DeviceMemory,
    pub memoryOffset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}

#[repr(C)]
pub struct SparseBufferMemoryBindInfo {
    pub buffer: Buffer,
    pub bindCount: u32,
    pub pBinds: *const SparseMemoryBind,
}

#[repr(C)]
pub struct SparseImageOpaqueMemoryBindInfo {
    pub image: Image,
    pub bindCount: u32,
    pub pBinds: *const SparseMemoryBind,
}

#[repr(C)]
pub struct ImageSubresource {
    pub aspectMask: ImageAspectFlags,
    pub mipLevel: u32,
    pub arrayLayer: u32,
}

#[repr(C)]
pub struct Offset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}

#[repr(C)]
pub struct SparseImageMemoryBind {
    pub subresource: ImageSubresource,
    pub offset: Offset3D,
    pub extent: Extent3D,
    pub memory: DeviceMemory,
    pub memoryOffset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}

#[repr(C)]
pub struct SparseImageMemoryBindInfo {
    pub image: Image,
    pub bindCount: u32,
    pub pBinds: *const SparseImageMemoryBind,
}

#[repr(C)]
pub struct BindSparseInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const Semaphore,
    pub bufferBindCount: u32,
    pub pBufferBinds: *const SparseBufferMemoryBindInfo,
    pub imageOpaqueBindCount: u32,
    pub pImageOpaqueBinds: *const SparseImageOpaqueMemoryBindInfo,
    pub imageBindCount: u32,
    pub pImageBinds: *const SparseImageMemoryBindInfo,
    pub signalSemaphoreCount: u32,
    pub pSignalSemaphores: *const Semaphore,
}

#[repr(C)]
pub struct FenceCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: FenceCreateFlags,
}

#[repr(C)]
pub struct SemaphoreCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SemaphoreCreateFlags,
}

#[repr(C)]
pub struct EventCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: EventCreateFlags,
}

#[repr(C)]
pub struct QueryPoolCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: QueryPoolCreateFlags,
    pub queryType: QueryType,
    pub queryCount: u32,
    pub pipelineStatistics: QueryPipelineStatisticFlags,
}

#[repr(C)]
pub struct BufferCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: BufferCreateFlags,
    pub size: DeviceSize,
    pub usage: BufferUsageFlags,
    pub sharingMode: SharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
}

#[repr(C)]
pub struct BufferViewCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: BufferViewCreateFlags,
    pub buffer: Buffer,
    pub format: Format,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}

#[repr(C)]
pub struct ImageCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ImageCreateFlags,
    pub imageType: ImageType,
    pub format: Format,
    pub extent: Extent3D,
    pub mipLevels: u32,
    pub arrayLayers: u32,
    pub samples: SampleCountFlagBits,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub sharingMode: SharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
    pub initialLayout: ImageLayout,
}

#[repr(C)]
pub struct BufferDeviceAddressInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub buffer: Buffer,
}

#[repr(C)]
pub struct SubresourceLayout {
    pub offset: DeviceSize,
    pub size: DeviceSize,
    pub rowPitch: DeviceSize,
    pub arrayPitch: DeviceSize,
    pub depthPitch: DeviceSize,
}

#[repr(C)]
pub struct ComponentMapping {
    pub r: ComponentSwizzle,
    pub g: ComponentSwizzle,
    pub b: ComponentSwizzle,
    pub a: ComponentSwizzle,
}

#[repr(C)]
pub struct ImageSubresourceRange {
    pub aspectMask: ImageAspectFlags,
    pub baseMipLevel: u32,
    pub levelCount: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}

#[repr(C)]
pub struct ImageViewCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ImageViewCreateFlags,
    pub image: Image,
    pub viewType: ImageViewType,
    pub format: Format,
    pub components: ComponentMapping,
    pub subresourceRange: ImageSubresourceRange,
}

#[repr(C)]
pub struct ShaderModuleCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ShaderModuleCreateFlags,
    pub codeSize: usize,
    pub pCode: *const u32,
}

#[repr(C)]
pub struct PipelineCacheCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCacheCreateFlags,
    pub initialDataSize: usize,
    pub pInitialData: *const c_void,
}

#[repr(C)]
pub struct SpecializationMapEntry {
    pub constantID: u32,
    pub offset: u32,
    pub size: usize,
}

#[repr(C)]
pub struct SpecializationInfo {
    pub mapEntryCount: u32,
    pub pMapEntries: *const SpecializationMapEntry,
    pub dataSize: usize,
    pub pData: *const c_void,
}

#[repr(C)]
pub struct PipelineShaderStageCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineShaderStageCreateFlags,
    pub stage: ShaderStageFlagBits,
    pub module: ShaderModule,
    pub pName: *const c_char,
    pub pSpecializationInfo: *const SpecializationInfo,
}

#[repr(C)]
pub struct VertexInputBindingDescription {
    pub binding: u32,
    pub stride: u32,
    pub inputRate: VertexInputRate,
}

#[repr(C)]
pub struct VertexInputAttributeDescription {
    pub location: u32,
    pub binding: u32,
    pub format: Format,
    pub offset: u32,
}

#[repr(C)]
pub struct PipelineVertexInputStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineVertexInputStateCreateFlags,
    pub vertexBindingDescriptionCount: u32,
    pub pVertexBindingDescriptions: *const VertexInputBindingDescription,
    pub vertexAttributeDescriptionCount: u32,
    pub pVertexAttributeDescriptions: *const VertexInputAttributeDescription,
}

#[repr(C)]
pub struct PipelineInputAssemblyStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineInputAssemblyStateCreateFlags,
    pub topology: PrimitiveTopology,
    pub primitiveRestartEnable: Bool32,
}

#[repr(C)]
pub struct PipelineTessellationStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineTessellationStateCreateFlags,
    pub patchControlPoints: u32,
}

#[repr(C)]
pub struct Viewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub minDepth: f32,
    pub maxDepth: f32,
}

#[repr(C)]
pub struct Offset2D {
    pub x: i32,
    pub y: i32,
}

#[repr(C)]
pub struct Extent2D {
    pub width: u32,
    pub height: u32,
}

#[repr(C)]
pub struct Rect2D {
    pub offset: Offset2D,
    pub extent: Extent2D,
}

#[repr(C)]
pub struct PipelineViewportStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineViewportStateCreateFlags,
    pub viewportCount: u32,
    pub pViewports: *const Viewport,
    pub scissorCount: u32,
    pub pScissors: *const Rect2D,
}

#[repr(C)]
pub struct PipelineRasterizationStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineRasterizationStateCreateFlags,
    pub depthClampEnable: Bool32,
    pub rasterizerDiscardEnable: Bool32,
    pub polygonMode: PolygonMode,
    pub cullMode: CullModeFlags,
    pub frontFace: FrontFace,
    pub depthBiasEnable: Bool32,
    pub depthBiasConstantFactor: f32,
    pub depthBiasClamp: f32,
    pub depthBiasSlopeFactor: f32,
    pub lineWidth: f32,
}

#[repr(C)]
pub struct PipelineMultisampleStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineMultisampleStateCreateFlags,
    pub rasterizationSamples: SampleCountFlagBits,
    pub sampleShadingEnable: Bool32,
    pub minSampleShading: f32,
    pub pSampleMask: *const SampleMask,
    pub alphaToCoverageEnable: Bool32,
    pub alphaToOneEnable: Bool32,
}

#[repr(C)]
pub struct StencilOpState {
    pub failOp: StencilOp,
    pub passOp: StencilOp,
    pub depthFailOp: StencilOp,
    pub compareOp: CompareOp,
    pub compareMask: u32,
    pub writeMask: u32,
    pub reference: u32,
}

#[repr(C)]
pub struct PipelineDepthStencilStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineDepthStencilStateCreateFlags,
    pub depthTestEnable: Bool32,
    pub depthWriteEnable: Bool32,
    pub depthCompareOp: CompareOp,
    pub depthBoundsTestEnable: Bool32,
    pub stencilTestEnable: Bool32,
    pub front: StencilOpState,
    pub back: StencilOpState,
    pub minDepthBounds: f32,
    pub maxDepthBounds: f32,
}

#[repr(C)]
pub struct PipelineColorBlendAttachmentState {
    pub blendEnable: Bool32,
    pub srcColorBlendFactor: BlendFactor,
    pub dstColorBlendFactor: BlendFactor,
    pub colorBlendOp: BlendOp,
    pub srcAlphaBlendFactor: BlendFactor,
    pub dstAlphaBlendFactor: BlendFactor,
    pub alphaBlendOp: BlendOp,
    pub colorWriteMask: ColorComponentFlags,
}

#[repr(C)]
pub struct PipelineColorBlendStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineColorBlendStateCreateFlags,
    pub logicOpEnable: Bool32,
    pub logicOp: LogicOp,
    pub attachmentCount: u32,
    pub pAttachments: *const PipelineColorBlendAttachmentState,
    pub blendConstants: [f32; 4],
}

#[repr(C)]
pub struct PipelineDynamicStateCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineDynamicStateCreateFlags,
    pub dynamicStateCount: u32,
    pub pDynamicStates: *const DynamicState,
}

#[repr(C)]
pub struct GraphicsPipelineCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stageCount: u32,
    pub pStages: *const PipelineShaderStageCreateInfo,
    pub pVertexInputState: *const PipelineVertexInputStateCreateInfo,
    pub pInputAssemblyState: *const PipelineInputAssemblyStateCreateInfo,
    pub pTessellationState: *const PipelineTessellationStateCreateInfo,
    pub pViewportState: *const PipelineViewportStateCreateInfo,
    pub pRasterizationState: *const PipelineRasterizationStateCreateInfo,
    pub pMultisampleState: *const PipelineMultisampleStateCreateInfo,
    pub pDepthStencilState: *const PipelineDepthStencilStateCreateInfo,
    pub pColorBlendState: *const PipelineColorBlendStateCreateInfo,
    pub pDynamicState: *const PipelineDynamicStateCreateInfo,
    pub layout: PipelineLayout,
    pub renderPass: RenderPass,
    pub subpass: u32,
    pub basePipelineHandle: Pipeline,
    pub basePipelineIndex: i32,
}

#[repr(C)]
pub struct ComputePipelineCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage: PipelineShaderStageCreateInfo,
    pub layout: PipelineLayout,
    pub basePipelineHandle: Pipeline,
    pub basePipelineIndex: i32,
}

#[repr(C)]
pub struct PushConstantRange {
    pub stageFlags: ShaderStageFlags,
    pub offset: u32,
    pub size: u32,
}

#[repr(C)]
pub struct PipelineLayoutCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: PipelineLayoutCreateFlags,
    pub setLayoutCount: u32,
    pub pSetLayouts: *const DescriptorSetLayout,
    pub pushConstantRangeCount: u32,
    pub pPushConstantRanges: *const PushConstantRange,
}

#[repr(C)]
pub struct SamplerCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SamplerCreateFlags,
    pub magFilter: Filter,
    pub minFilter: Filter,
    pub mipmapMode: SamplerMipmapMode,
    pub addressModeU: SamplerAddressMode,
    pub addressModeV: SamplerAddressMode,
    pub addressModeW: SamplerAddressMode,
    pub mipLodBias: f32,
    pub anisotropyEnable: Bool32,
    pub maxAnisotropy: f32,
    pub compareEnable: Bool32,
    pub compareOp: CompareOp,
    pub minLod: f32,
    pub maxLod: f32,
    pub borderColor: BorderColor,
    pub unnormalizedCoordinates: Bool32,
}

#[repr(C)]
pub struct DescriptorSetLayoutBinding {
    pub binding: u32,
    pub descriptorType: DescriptorType,
    pub descriptorCount: u32,
    pub stageFlags: ShaderStageFlags,
    pub pImmutableSamplers: *const Sampler,
}

#[repr(C)]
pub struct DescriptorSetLayoutCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DescriptorSetLayoutCreateFlags,
    pub bindingCount: u32,
    pub pBindings: *const DescriptorSetLayoutBinding,
}

#[repr(C)]
pub struct DescriptorPoolSize {
    pub ty: DescriptorType,
    pub descriptorCount: u32,
}

#[repr(C)]
pub struct DescriptorPoolCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DescriptorPoolCreateFlags,
    pub maxSets: u32,
    pub poolSizeCount: u32,
    pub pPoolSizes: *const DescriptorPoolSize,
}

#[repr(C)]
pub struct DescriptorSetAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub descriptorPool: DescriptorPool,
    pub descriptorSetCount: u32,
    pub pSetLayouts: *const DescriptorSetLayout,
}

#[repr(C)]
pub struct DescriptorImageInfo {
    pub sampler: Sampler,
    pub imageView: ImageView,
    pub imageLayout: ImageLayout,
}

#[repr(C)]
pub struct DescriptorBufferInfo {
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}

#[repr(C)]
pub struct WriteDescriptorSet {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub dstSet: DescriptorSet,
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
    pub descriptorType: DescriptorType,
    pub pImageInfo: *const DescriptorImageInfo,
    pub pBufferInfo: *const DescriptorBufferInfo,
    pub pTexelBufferView: *const BufferView,
}

#[repr(C)]
pub struct CopyDescriptorSet {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcSet: DescriptorSet,
    pub srcBinding: u32,
    pub srcArrayElement: u32,
    pub dstSet: DescriptorSet,
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
}

#[repr(C)]
pub struct FramebufferCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: FramebufferCreateFlags,
    pub renderPass: RenderPass,
    pub attachmentCount: u32,
    pub pAttachments: *const ImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
}

#[repr(C)]
pub struct AttachmentDescription {
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlagBits,
    pub loadOp: AttachmentLoadOp,
    pub storeOp: AttachmentStoreOp,
    pub stencilLoadOp: AttachmentLoadOp,
    pub stencilStoreOp: AttachmentStoreOp,
    pub initialLayout: ImageLayout,
    pub finalLayout: ImageLayout,
}

#[repr(C)]
pub struct AttachmentReference {
    pub attachment: u32,
    pub layout: ImageLayout,
}

#[repr(C)]
pub struct SubpassDescription {
    pub flags: SubpassDescriptionFlags,
    pub pipelineBindPoint: PipelineBindPoint,
    pub inputAttachmentCount: u32,
    pub pInputAttachments: *const AttachmentReference,
    pub colorAttachmentCount: u32,
    pub pColorAttachments: *const AttachmentReference,
    pub pResolveAttachments: *const AttachmentReference,
    pub pDepthStencilAttachment: *const AttachmentReference,
    pub preserveAttachmentCount: u32,
    pub pPreserveAttachments: *const u32,
}

#[repr(C)]
pub struct SubpassDependency {
    pub srcSubpass: u32,
    pub dstSubpass: u32,
    pub srcStageMask: PipelineStageFlags,
    pub dstStageMask: PipelineStageFlags,
    pub srcAccessMask: AccessFlags,
    pub dstAccessMask: AccessFlags,
    pub dependencyFlags: DependencyFlags,
}

#[repr(C)]
pub struct RenderPassCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachmentCount: u32,
    pub pAttachments: *const AttachmentDescription,
    pub subpassCount: u32,
    pub pSubpasses: *const SubpassDescription,
    pub dependencyCount: u32,
    pub pDependencies: *const SubpassDependency,
}

#[repr(C)]
pub struct CommandPoolCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: CommandPoolCreateFlags,
    pub queueFamilyIndex: u32,
}

#[repr(C)]
pub struct CommandBufferAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub commandPool: CommandPool,
    pub level: CommandBufferLevel,
    pub commandBufferCount: u32,
}

#[repr(C)]
pub struct CommandBufferInheritanceInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub renderPass: RenderPass,
    pub subpass: u32,
    pub framebuffer: Framebuffer,
    pub occlusionQueryEnable: Bool32,
    pub queryFlags: QueryControlFlags,
    pub pipelineStatistics: QueryPipelineStatisticFlags,
}

#[repr(C)]
pub struct CommandBufferBeginInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: CommandBufferUsageFlags,
    pub pInheritanceInfo: *const CommandBufferInheritanceInfo,
}

#[repr(C)]
pub struct BufferCopy {
    pub srcOffset: DeviceSize,
    pub dstOffset: DeviceSize,
    pub size: DeviceSize,
}

#[repr(C)]
pub struct ImageSubresourceLayers {
    pub aspectMask: ImageAspectFlags,
    pub mipLevel: u32,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}

#[repr(C)]
pub struct ImageCopy {
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffset: Offset3D,
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffset: Offset3D,
    pub extent: Extent3D,
}

#[repr(C)]
pub struct ImageBlit {
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffsets: [Offset3D; 2],
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffsets: [Offset3D; 2],
}

#[repr(C)]
pub struct BufferImageCopy {
    pub bufferOffset: DeviceSize,
    pub bufferRowLength: u32,
    pub bufferImageHeight: u32,
    pub imageSubresource: ImageSubresourceLayers,
    pub imageOffset: Offset3D,
    pub imageExtent: Extent3D,
}

#[repr(C)]
#[derive(Copy, Clone)]
pub union ClearColorValue {
    pub float32: [f32; 4],
    pub int32: [i32; 4],
    pub uint32: [u32; 4],
}

#[repr(C)]
#[derive(Copy, Clone)]
pub struct ClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}

#[repr(C)]
pub union ClearValue {
    pub color: ClearColorValue,
    pub depthStencil: ClearDepthStencilValue,
}

#[repr(C)]
pub struct ClearAttachment {
    pub aspectMask: ImageAspectFlags,
    pub colorAttachment: u32,
    pub clearValue: ClearValue,
}

#[repr(C)]
pub struct ClearRect {
    pub rect: Rect2D,
    pub baseArrayLayer: u32,
    pub layerCount: u32,
}

#[repr(C)]
pub struct ImageResolve {
    pub srcSubresource: ImageSubresourceLayers,
    pub srcOffset: Offset3D,
    pub dstSubresource: ImageSubresourceLayers,
    pub dstOffset: Offset3D,
    pub extent: Extent3D,
}

#[repr(C)]
pub struct MemoryBarrier {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcAccessMask: AccessFlags,
    pub dstAccessMask: AccessFlags,
}

#[repr(C)]
pub struct BufferMemoryBarrier {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcAccessMask: AccessFlags,
    pub dstAccessMask: AccessFlags,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}

#[repr(C)]
pub struct ImageMemoryBarrier {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcAccessMask: AccessFlags,
    pub dstAccessMask: AccessFlags,
    pub oldLayout: ImageLayout,
    pub newLayout: ImageLayout,
    pub srcQueueFamilyIndex: u32,
    pub dstQueueFamilyIndex: u32,
    pub image: Image,
    pub subresourceRange: ImageSubresourceRange,
}

#[repr(C)]
pub struct RenderPassBeginInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub renderPass: RenderPass,
    pub framebuffer: Framebuffer,
    pub renderArea: Rect2D,
    pub clearValueCount: u32,
    pub pClearValues: *const ClearValue,
}

#[repr(C)]
pub struct DispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}

#[repr(C)]
pub struct DrawIndexedIndirectCommand {
    pub indexCount: u32,
    pub instanceCount: u32,
    pub firstIndex: u32,
    pub vertexOffset: i32,
    pub firstInstance: u32,
}

#[repr(C)]
pub struct DrawIndirectCommand {
    pub vertexCount: u32,
    pub instanceCount: u32,
    pub firstVertex: u32,
    pub firstInstance: u32,
}

#[repr(C)]
pub struct SurfaceCapabilitiesKHR {
    pub minImageCount: u32,
    pub maxImageCount: u32,
    pub currentExtent: Extent2D,
    pub minImageExtent: Extent2D,
    pub maxImageExtent: Extent2D,
    pub maxImageArrayLayers: u32,
    pub supportedTransforms: SurfaceTransformFlagsKHR,
    pub currentTransform: SurfaceTransformFlagBitsKHR,
    pub supportedCompositeAlpha: CompositeAlphaFlagsKHR,
    pub supportedUsageFlags: ImageUsageFlags,
}

#[repr(C)]
pub struct SurfaceFormatKHR {
    pub format: Format,
    pub colorSpace: ColorSpaceKHR,
}

pub type SwapchainCreateFlagsKHR = Flags;

#[repr(C)]
pub struct SwapchainCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: SwapchainCreateFlagsKHR,
    pub surface: SurfaceKHR,
    pub minImageCount: u32,
    pub imageFormat: Format,
    pub imageColorSpace: ColorSpaceKHR,
    pub imageExtent: Extent2D,
    pub imageArrayLayers: u32,
    pub imageUsage: ImageUsageFlags,
    pub imageSharingMode: SharingMode,
    pub queueFamilyIndexCount: u32,
    pub pQueueFamilyIndices: *const u32,
    pub preTransform: SurfaceTransformFlagBitsKHR,
    pub compositeAlpha: CompositeAlphaFlagBitsKHR,
    pub presentMode: PresentModeKHR,
    pub clipped: Bool32,
    pub oldSwapchain: SwapchainKHR,
}

#[repr(C)]
pub struct PresentInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub waitSemaphoreCount: u32,
    pub pWaitSemaphores: *const Semaphore,
    pub swapchainCount: u32,
    pub pSwapchains: *const SwapchainKHR,
    pub pImageIndices: *const u32,
    pub pResults: *mut Result,
}

#[repr(C)]
pub struct DisplayPropertiesKHR {
    pub display: DisplayKHR,
    pub displayName: *const c_char,
    pub physicalDimensions: Extent2D,
    pub physicalResolution: Extent2D,
    pub supportedTransforms: SurfaceTransformFlagsKHR,
    pub planeReorderPossible: Bool32,
    pub persistentContent: Bool32,
}

#[repr(C)]
pub struct DisplayModeParametersKHR {
    pub visibleRegion: Extent2D,
    pub refreshRate: u32,
}

#[repr(C)]
pub struct DisplayModePropertiesKHR {
    pub displayMode: DisplayModeKHR,
    pub parameters: DisplayModeParametersKHR,
}

#[repr(C)]
pub struct DisplayModeCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DisplayModeCreateFlagsKHR,
    pub parameters: DisplayModeParametersKHR,
}

#[repr(C)]
pub struct DisplayPlaneCapabilitiesKHR {
    pub supportedAlpha: DisplayPlaneAlphaFlagsKHR,
    pub minSrcPosition: Offset2D,
    pub maxSrcPosition: Offset2D,
    pub minSrcExtent: Extent2D,
    pub maxSrcExtent: Extent2D,
    pub minDstPosition: Offset2D,
    pub maxDstPosition: Offset2D,
    pub minDstExtent: Extent2D,
    pub maxDstExtent: Extent2D,
}

#[repr(C)]
pub struct DisplayPlanePropertiesKHR {
    pub currentDisplay: DisplayKHR,
    pub currentStackIndex: u32,
}

#[repr(C)]
pub struct DisplaySurfaceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DisplaySurfaceCreateFlagsKHR,
    pub displayMode: DisplayModeKHR,
    pub planeIndex: u32,
    pub planeStackIndex: u32,
    pub transform: SurfaceTransformFlagBitsKHR,
    pub globalAlpha: f32,
    pub alphaMode: DisplayPlaneAlphaFlagBitsKHR,
    pub imageExtent: Extent2D,
}

#[repr(C)]
pub struct DisplayPresentInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub srcRect: Rect2D,
    pub dstRect: Rect2D,
    pub persistent: Bool32,
}

pub type XlibSurfaceCreateFlagsKHR = Flags;

#[repr(C)]
pub struct XlibSurfaceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: XlibSurfaceCreateFlagsKHR,
    pub dpy: *mut c_void,
    pub window: c_ulong,
}

pub type XcbSurfaceCreateFlagsKHR = Flags;

#[repr(C)]
pub struct XcbSurfaceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: XcbSurfaceCreateFlagsKHR,
    pub connection: *const c_void,
    pub window: u32,
}

pub type WaylandSurfaceCreateFlagsKHR = Flags;

#[repr(C)]
pub struct WaylandSurfaceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: WaylandSurfaceCreateFlagsKHR,
    pub display: *mut c_void,
    pub surface: *mut c_void,
}

pub type AndroidSurfaceCreateFlagsKHR = Flags;

#[repr(C)]
pub struct AndroidSurfaceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: AndroidSurfaceCreateFlagsKHR,
    pub window: *mut c_void,
}

pub type Win32SurfaceCreateFlagsKHR = Flags;

#[repr(C)]
pub struct Win32SurfaceCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: Win32SurfaceCreateFlagsKHR,
    pub hinstance: *mut c_void,
    pub hwnd: *mut c_void,
}

#[repr(C)]
pub struct IOSSurfaceCreateInfoMVK {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: IOSSurfaceCreateFlagsMVK,
    pub pView: *const c_void,
}

#[repr(C)]
pub struct MacOSSurfaceCreateInfoMVK {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: MacOSSurfaceCreateFlagsMVK,
    pub pView: *const c_void,
}

#[repr(C)]
pub struct MVKDeviceConfiguration {
    pub supportDisplayContentsScale: Bool32,
    pub imageFlipY: Bool32,
    pub shaderConversionFlipFragmentY: Bool32,
    pub shaderConversionFlipVertexY: Bool32,
    pub shaderConversionLogging: Bool32,
    pub performanceTracking: Bool32,
    pub performanceLoggingFrameCount: u32,
}

#[repr(C)]
pub struct MVKPhysicalDeviceMetalFeatures {
    pub depthClipMode: Bool32,
    pub indirectDrawing: Bool32,
    pub baseVertexInstanceDrawing: Bool32,
    pub maxVertexBufferCount: u32,
    pub maxFragmentBufferCount: u32,
    pub bufferAlignment: DeviceSize,
    pub pushConstantsAlignment: DeviceSize,
}

#[repr(C)]
pub struct MVKSwapchainPerformance {
    pub lastFrameInterval: c_double,
    pub averageFrameInterval: c_double,
    pub averageFramesPerSecond: c_double,
}

#[repr(C)]
pub struct PhysicalDeviceFeatures2 {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub features: PhysicalDeviceFeatures,
}

impl Default for PhysicalDeviceFeatures2 {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2,
            pNext: ptr::null_mut(),
            features: Default::default(),
        }
    }
}

pub type PhysicalDeviceFeatures2KHR = PhysicalDeviceFeatures2;

#[repr(C)]
pub struct PhysicalDeviceProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut PhysicalDeviceSubgroupProperties,
    pub properties: PhysicalDeviceProperties,
}

#[repr(C)]
pub struct PhysicalDeviceSubgroupProperties {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub subgroupSize: u32,
    pub supportedStages: ShaderStageFlags,
    pub supportedOperations: SubgroupFeatureFlags,
    pub quadOperationsInAllStages: Bool32,
}

#[repr(C)]
pub struct FormatProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub formatProperties: FormatProperties,
}

#[repr(C)]
pub struct ImageFormatProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub imageFormatProperties: ImageFormatProperties,
}

#[repr(C)]
pub struct PhysicalDeviceImageFormatInfo2KHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub format: Format,
    pub imageType: ImageType,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub flags: ImageCreateFlags,
}

#[repr(C)]
pub struct QueueFamilyProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub queueFamilyProperties: QueueFamilyProperties,
}

#[repr(C)]
pub struct PhysicalDeviceMemoryProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub memoryProperties: PhysicalDeviceMemoryProperties,
}

#[repr(C)]
pub struct SparseImageFormatProperties2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub properties: SparseImageFormatProperties,
}

#[repr(C)]
pub struct PhysicalDeviceSparseImageFormatInfo2KHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub format: Format,
    pub imageType: ImageType,
    pub samples: SampleCountFlagBits,
    pub usage: ImageUsageFlags,
    pub tiling: ImageTiling,
}

#[repr(C)]
pub struct PhysicalDeviceBufferAddressFeaturesEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub bufferDeviceAddress: Bool32,
    pub bufferDeviceAddressCaptureReplay: Bool32,
    pub bufferDeviceAddressMultiDevice: Bool32,
}

impl Default for PhysicalDeviceBufferAddressFeaturesEXT {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_ADDRESS_FEATURES_EXT,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

#[repr(C)]
pub struct PhysicalDeviceVariablePointersFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub variablePointersStorageBuffer: Bool32,
    pub variablePointers: Bool32,
}

impl Default for PhysicalDeviceVariablePointersFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceVariablePointersFeaturesKHR = PhysicalDeviceVariablePointersFeatures;

#[repr(C)]
pub struct PhysicalDeviceShaderAtomicInt64Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderBufferInt64Atomics: Bool32,
    pub shaderSharedInt64Atomics: Bool32,
}

impl Default for PhysicalDeviceShaderAtomicInt64Features {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceShaderAtomicInt64FeaturesKHR = PhysicalDeviceShaderAtomicInt64Features;

#[repr(C)]
pub struct PhysicalDevice8BitStorageFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub storageBuffer8BitAccess: Bool32,
    pub uniformAndStorageBuffer8BitAccess: Bool32,
    pub storagePushConstant8: Bool32,
}

impl Default for PhysicalDevice8BitStorageFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDevice8BitStorageFeaturesKHR = PhysicalDevice8BitStorageFeatures;

#[repr(C)]
pub struct PhysicalDevice16BitStorageFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub storageBuffer16BitAccess: Bool32,
    pub uniformAndStorageBuffer16BitAccess: Bool32,
    pub storagePushConstant16: Bool32,
    pub storageInputOutput16: Bool32,
}

impl Default for PhysicalDevice16BitStorageFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDevice16BitStorageFeaturesKHR = PhysicalDevice16BitStorageFeatures;

#[repr(C)]
pub struct PhysicalDeviceShaderFloat16Int8Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderFloat16: Bool32,
    pub shaderInt8: Bool32,
}

impl Default for PhysicalDeviceShaderFloat16Int8Features {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceShaderFloat16Int8FeaturesKHR = PhysicalDeviceShaderFloat16Int8Features;

#[repr(C)]
pub struct PhysicalDeviceMultiviewFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub multiview: Bool32,
    pub multiviewGeometryShader: Bool32,
    pub multiviewTessellationShader: Bool32,
}

impl Default for PhysicalDeviceMultiviewFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceMultiviewFeaturesKHR = PhysicalDeviceMultiviewFeatures;

#[repr(C)]
pub struct PhysicalDeviceSamplerYcbcrConversionFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub samplerYcbcrConversion: Bool32,
}

impl Default for PhysicalDeviceSamplerYcbcrConversionFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceSamplerYcbcrConversionFeaturesKHR =
    PhysicalDeviceSamplerYcbcrConversionFeatures;

#[repr(C)]
pub struct PhysicalDeviceProtectedMemoryFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub protectedMemory: Bool32,
}

impl Default for PhysicalDeviceProtectedMemoryFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

#[repr(C)]
pub struct PhysicalDeviceDescriptorIndexingFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderInputAttachmentArrayDynamicIndexing: Bool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: Bool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: Bool32,
    pub shaderUniformBufferArrayNonUniformIndexing: Bool32,
    pub shaderSampledImageArrayNonUniformIndexing: Bool32,
    pub shaderStorageBufferArrayNonUniformIndexing: Bool32,
    pub shaderStorageImageArrayNonUniformIndexing: Bool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: Bool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: Bool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: Bool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: Bool32,
    pub descriptorBindingSampledImageUpdateAfterBind: Bool32,
    pub descriptorBindingStorageImageUpdateAfterBind: Bool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: Bool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: Bool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: Bool32,
    pub descriptorBindingUpdateUnusedWhilePending: Bool32,
    pub descriptorBindingPartiallyBound: Bool32,
    pub descriptorBindingVariableDescriptorCount: Bool32,
    pub runtimeDescriptorArray: Bool32,
}

impl Default for PhysicalDeviceDescriptorIndexingFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceDescriptorIndexingFeaturesEXT = PhysicalDeviceDescriptorIndexingFeatures;

#[repr(C)]
pub struct PhysicalDeviceScalarBlockLayoutFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub scalarBlockLayout: Bool32,
}

impl Default for PhysicalDeviceScalarBlockLayoutFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceScalarBlockLayoutFeaturesEXT = PhysicalDeviceScalarBlockLayoutFeatures;

#[repr(C)]
pub struct PhysicalDeviceImagelessFramebufferFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub imagelessFramebuffer: Bool32,
}

impl Default for PhysicalDeviceImagelessFramebufferFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceImagelessFramebufferFeaturesKHR = PhysicalDeviceImagelessFramebufferFeatures;

#[repr(C)]
pub struct PhysicalDeviceUniformBufferStandardLayoutFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub uniformBufferStandardLayout: Bool32,
}

impl Default for PhysicalDeviceUniformBufferStandardLayoutFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceUniformBufferStandardLayoutFeaturesKHR =
    PhysicalDeviceUniformBufferStandardLayoutFeatures;

#[repr(C)]
pub struct PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderSubgroupExtendedTypes: Bool32,
}

impl Default for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR =
    PhysicalDeviceShaderSubgroupExtendedTypesFeatures;

#[repr(C)]
pub struct PhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub separateDepthStencilLayouts: Bool32,
}

impl Default for PhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceSeparateDepthStencilLayoutsFeaturesKHR =
    PhysicalDeviceSeparateDepthStencilLayoutsFeatures;

#[repr(C)]
pub struct PhysicalDeviceHostQueryResetFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub hostQueryReset: Bool32,
}

impl Default for PhysicalDeviceHostQueryResetFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceHostQueryResetFeaturesEXT = PhysicalDeviceHostQueryResetFeatures;

#[repr(C)]
pub struct PhysicalDeviceTimelineSemaphoreFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub timelineSemaphore: Bool32,
}

impl Default for PhysicalDeviceTimelineSemaphoreFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceTimelineSemaphoreFeaturesKHR = PhysicalDeviceTimelineSemaphoreFeatures;

#[repr(C)]
pub struct PhysicalDeviceBufferDeviceAddressFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub bufferDeviceAddress: Bool32,
    pub bufferDeviceAddressCaptureReplay: Bool32,
    pub bufferDeviceAddressMultiDevice: Bool32,
}

impl Default for PhysicalDeviceBufferDeviceAddressFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceBufferDeviceAddressFeaturesKHR = PhysicalDeviceBufferDeviceAddressFeatures;

#[repr(C)]
pub struct PhysicalDeviceVulkanMemoryModelFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub vulkanMemoryModel: Bool32,
    pub vulkanMemoryModelDeviceScope: Bool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: Bool32,
}

impl Default for PhysicalDeviceVulkanMemoryModelFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type PhysicalDeviceVulkanMemoryModelFeaturesKHR = PhysicalDeviceVulkanMemoryModelFeatures;

#[repr(C)]
pub struct PhysicalDeviceShaderDrawParametersFeatures {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub shaderDrawParameters: Bool32,
}

impl Default for PhysicalDeviceShaderDrawParametersFeatures {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub type ViSurfaceCreateFlagsNN = Flags;

#[repr(C)]
pub struct ViSurfaceCreateInfoNN {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: ViSurfaceCreateFlagsNN,
    pub window: *const c_void,
}

#[repr(C)]
pub struct PhysicalDevicePushDescriptorPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub maxPushDescriptors: u32,
}

#[repr(C)]
pub struct DescriptorUpdateTemplateEntryKHR {
    pub dstBinding: u32,
    pub dstArrayElement: u32,
    pub descriptorCount: u32,
    pub descriptorType: DescriptorType,
    pub offset: usize,
    pub stride: usize,
}

#[repr(C)]
pub struct DescriptorUpdateTemplateCreateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DescriptorUpdateTemplateCreateFlagsKHR,
    pub descriptorUpdateEntryCount: u32,
    pub pDescriptorUpdateEntries: *const DescriptorUpdateTemplateEntryKHR,
    pub templateType: DescriptorUpdateTemplateTypeKHR,
    pub descriptorSetLayout: DescriptorSetLayout,
    pub pipelineBindPoint: PipelineBindPoint,
    pub pipelineLayout: PipelineLayout,
    pub set: u32,
}

#[repr(C)]
pub struct MemoryDedicatedRequirementsKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub prefersDedicatedAllocation: Bool32,
    pub requiresDedicatedAllocation: Bool32,
}

#[repr(C)]
pub struct MemoryDedicatedAllocateInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub image: Image,
    pub buffer: Buffer,
}

#[repr(C)]
pub struct BufferMemoryRequirementsInfo2KHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub buffer: Buffer,
}

#[repr(C)]
pub struct ImageMemoryRequirementsInfo2KHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub image: Image,
}

#[repr(C)]
pub struct MemoryRequirements2KHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub memoryRequirements: MemoryRequirements,
}

#[repr(C)]
pub struct RectLayerKHR {
    pub offset: Offset2D,
    pub extent: Extent2D,
    pub layer: u32,
}

#[repr(C)]
pub struct PresentRegionKHR {
    pub rectangleCount: u32,
    pub pRectangles: *const RectLayerKHR,
}

#[repr(C)]
pub struct PresentRegionsKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub swapchainCount: u32,
    pub pRegions: *const PresentRegionKHR,
}

#[repr(C)]
pub struct DebugUtilsMessengerCreateInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DebugUtilsMessengerCreateFlagsEXT,
    pub messageSeverity: DebugUtilsMessageSeverityFlagsEXT,
    pub messageType: DebugUtilsMessageTypeFlagsEXT,
    pub pfnUserCallback: PFN_vkDebugUtilsMessengerCallbackEXT,
    pub pUserData: *mut c_void,
}

#[repr(C)]
pub struct DebugUtilsMessengerCallbackDataEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub flags: DebugUtilsMessengerCallbackDataFlagsEXT,
    pub pMessageIdName: *const c_char,
    pub messageIdNumber: i32,
    pub pMessage: *const c_char,
    pub queueLabelCount: u32,
    pub pQueueLabels: *const DebugUtilsLabelEXT,
    pub cmdBufLabelCount: u32,
    pub pCmdBufLabels: *const DebugUtilsLabelEXT,
    pub objectCount: u32,
    pub pObject: *const DebugUtilsObjectNameInfoEXT,
}

#[repr(C)]
pub struct DebugUtilsLabelEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub pLabelName: *const c_char,
    pub color: [f32; 4],
}

#[repr(C)]
pub struct DebugUtilsObjectNameInfoEXT {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub objectType: ObjectType,
    pub objectHandle: u64,
    pub pObjectName: *const c_char,
}

#[repr(C)]
pub struct SurfaceFullScreenExclusiveInfoEXT {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub fullScreenExclusive: FullScreenExclusiveEXT,
}

#[repr(C)]
pub struct ExportMemoryAllocateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalMemoryHandleTypeFlagBits,
}

#[repr(C)]
pub struct ExternalMemoryBufferCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalMemoryHandleTypeFlagBits,
}

#[repr(C)]
pub struct ExternalMemoryImageCreateInfo {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleTypes: ExternalMemoryHandleTypeFlagBits,
}

#[repr(C)]
pub struct MemoryFdPropertiesKHR {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
    pub memoryTypeBits: u32,
}

#[repr(C)]
pub struct MemoryGetFdInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub memory: DeviceMemory,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
}

#[repr(C)]
pub struct ImportMemoryFdInfoKHR {
    pub sType: StructureType,
    pub pNext: *const c_void,
    pub handleType: ExternalMemoryHandleTypeFlagBits,
    pub fd: i32,
}

#[repr(C)]
pub struct PhysicalDeviceVulkan11Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub storageBuffer16BitAccess: Bool32,
    pub uniformAndStorageBuffer16BitAccess: Bool32,
    pub storagePushConstant16: Bool32,
    pub storageInputOutput16: Bool32,
    pub multiview: Bool32,
    pub multiviewGeometryShader: Bool32,
    pub multiviewTessellationShader: Bool32,
    pub variablePointersStorageBuffer: Bool32,
    pub variablePointers: Bool32,
    pub protectedMemory: Bool32,
    pub samplerYcbcrConversion: Bool32,
    pub shaderDrawParameters: Bool32,
}

impl Default for PhysicalDeviceVulkan11Features {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

pub struct PhysicalDeviceVulkan12Features {
    pub sType: StructureType,
    pub pNext: *mut c_void,
    pub samplerMirrorClampToEdge: Bool32,
    pub drawIndirectCount: Bool32,
    pub storageBuffer8BitAccess: Bool32,
    pub uniformAndStorageBuffer8BitAccess: Bool32,
    pub storagePushConstant8: Bool32,
    pub shaderBufferInt64Atomics: Bool32,
    pub shaderSharedInt64Atomics: Bool32,
    pub shaderFloat16: Bool32,
    pub shaderInt8: Bool32,
    pub descriptorIndexing: Bool32,
    pub shaderInputAttachmentArrayDynamicIndexing: Bool32,
    pub shaderUniformTexelBufferArrayDynamicIndexing: Bool32,
    pub shaderStorageTexelBufferArrayDynamicIndexing: Bool32,
    pub shaderUniformBufferArrayNonUniformIndexing: Bool32,
    pub shaderSampledImageArrayNonUniformIndexing: Bool32,
    pub shaderStorageBufferArrayNonUniformIndexing: Bool32,
    pub shaderStorageImageArrayNonUniformIndexing: Bool32,
    pub shaderInputAttachmentArrayNonUniformIndexing: Bool32,
    pub shaderUniformTexelBufferArrayNonUniformIndexing: Bool32,
    pub shaderStorageTexelBufferArrayNonUniformIndexing: Bool32,
    pub descriptorBindingUniformBufferUpdateAfterBind: Bool32,
    pub descriptorBindingSampledImageUpdateAfterBind: Bool32,
    pub descriptorBindingStorageImageUpdateAfterBind: Bool32,
    pub descriptorBindingStorageBufferUpdateAfterBind: Bool32,
    pub descriptorBindingUniformTexelBufferUpdateAfterBind: Bool32,
    pub descriptorBindingStorageTexelBufferUpdateAfterBind: Bool32,
    pub descriptorBindingUpdateUnusedWhilePending: Bool32,
    pub descriptorBindingPartiallyBound: Bool32,
    pub descriptorBindingVariableDescriptorCount: Bool32,
    pub runtimeDescriptorArray: Bool32,
    pub samplerFilterMinmax: Bool32,
    pub scalarBlockLayout: Bool32,
    pub imagelessFramebuffer: Bool32,
    pub uniformBufferStandardLayout: Bool32,
    pub shaderSubgroupExtendedTypes: Bool32,
    pub separateDepthStencilLayouts: Bool32,
    pub hostQueryReset: Bool32,
    pub timelineSemaphore: Bool32,
    pub bufferDeviceAddress: Bool32,
    pub bufferDeviceAddressCaptureReplay: Bool32,
    pub bufferDeviceAddressMultiDevice: Bool32,
    pub vulkanMemoryModel: Bool32,
    pub vulkanMemoryModelDeviceScope: Bool32,
    pub vulkanMemoryModelAvailabilityVisibilityChains: Bool32,
    pub shaderOutputViewportIndex: Bool32,
    pub shaderOutputLayer: Bool32,
    pub subgroupBroadcastDynamicId: Bool32,
}

impl Default for PhysicalDeviceVulkan12Features {
    fn default() -> Self {
        Self {
            sType: STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES,
            pNext: ptr::null_mut(),
            ..unsafe { mem::zeroed() }
        }
    }
}

macro_rules! ptrs {
    ($struct_name:ident, { $($name:ident => ($($param_n:ident: $param_ty:ty),*) -> $ret:ty,)+ }) => (
        pub struct $struct_name {
            $(
                pub $name: extern "system" fn($($param_ty),*) -> $ret,
            )+
        }

        impl fmt::Debug for $struct_name {
            #[inline]
            fn fmt(&self, fmt: &mut fmt::Formatter) -> ::std::result::Result<(), fmt::Error> {
                write!(fmt, "<Vulkan functions>")       // TODO:
            }
        }

        unsafe impl Send for $struct_name {}
        unsafe impl Sync for $struct_name {}

        impl $struct_name {
            pub fn load<F>(mut f: F) -> $struct_name
                where F: FnMut(&CStr) -> *const c_void
            {
                $struct_name {
                    $(
                        $name: unsafe {
                            extern "system" fn $name($(_: $param_ty),*) { panic!("function pointer `{}` not loaded", stringify!($name)) }
                            let name = CStr::from_bytes_with_nul_unchecked(concat!("vk", stringify!($name), "\0").as_bytes());
                            let val = f(name);
                            if val.is_null() { mem::transmute($name as *const ()) } else { mem::transmute(val) }
                        },
                    )+
                }
            }

            $(
                #[inline]
                pub unsafe fn $name(&self $(, $param_n: $param_ty)*) -> $ret {
                    let ptr = self.$name;
                    ptr($($param_n),*)
                }
            )+
        }
    )
}

ptrs!(Static, {
    GetInstanceProcAddr => (instance: Instance, pName: *const c_char) -> PFN_vkVoidFunction,
});

ptrs!(EntryPoints, {
    CreateInstance => (pCreateInfo: *const InstanceCreateInfo, pAllocator: *const AllocationCallbacks, pInstance: *mut Instance) -> Result,
    EnumerateInstanceExtensionProperties => (pLayerName: *const c_char, pPropertyCount: *mut u32, pProperties: *mut ExtensionProperties) -> Result,
    EnumerateInstanceLayerProperties => (pPropertyCount: *mut u32, pProperties: *mut LayerProperties) -> Result,
});

ptrs!(InstancePointers, {
    DestroyInstance => (instance: Instance, pAllocator: *const AllocationCallbacks) -> (),
    GetDeviceProcAddr => (device: Device, pName: *const c_char) -> PFN_vkVoidFunction,
    EnumeratePhysicalDevices => (instance: Instance, pPhysicalDeviceCount: *mut u32, pPhysicalDevices: *mut PhysicalDevice) -> Result,
    EnumerateDeviceExtensionProperties => (physicalDevice: PhysicalDevice, pLayerName: *const c_char, pPropertyCount: *mut u32, pProperties: *mut ExtensionProperties) -> Result,
    EnumerateDeviceLayerProperties => (physicalDevice: PhysicalDevice, pPropertyCount: *mut u32, pProperties: *mut LayerProperties) -> Result,
    CreateDevice => (physicalDevice: PhysicalDevice, pCreateInfo: *const DeviceCreateInfo, pAllocator: *const AllocationCallbacks, pDevice: *mut Device) -> Result,
    GetPhysicalDeviceFeatures => (physicalDevice: PhysicalDevice, pFeatures: *mut PhysicalDeviceFeatures) -> (),
    GetPhysicalDeviceFormatProperties => (physicalDevice: PhysicalDevice, format: Format, pFormatProperties: *mut FormatProperties) -> (),
    GetPhysicalDeviceImageFormatProperties => (physicalDevice: PhysicalDevice, format: Format, ty: ImageType, tiling: ImageTiling, usage: ImageUsageFlags, flags: ImageCreateFlags, pImageFormatProperties: *mut ImageFormatProperties) -> Result,
    GetPhysicalDeviceProperties => (physicalDevice: PhysicalDevice, pProperties: *mut PhysicalDeviceProperties) -> (),
    GetPhysicalDeviceQueueFamilyProperties => (physicalDevice: PhysicalDevice, pQueueFamilyPropertyCount: *mut u32, pQueueFamilyProperties: *mut QueueFamilyProperties) -> (),
    GetPhysicalDeviceMemoryProperties => (physicalDevice: PhysicalDevice, pMemoryProperties: *mut PhysicalDeviceMemoryProperties) -> (),
    GetPhysicalDeviceSparseImageFormatProperties => (physicalDevice: PhysicalDevice, format: Format, ty: ImageType, samples: SampleCountFlagBits, usage: ImageUsageFlags, tiling: ImageTiling, pPropertyCount: *mut u32, pProperties: *mut SparseImageFormatProperties) -> (),
    DestroySurfaceKHR => (instance: Instance, surface: SurfaceKHR, pAllocator: *const AllocationCallbacks) -> (),
    CreateXlibSurfaceKHR => (instance: Instance, pCreateInfo: *const XlibSurfaceCreateInfoKHR, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    GetPhysicalDeviceXlibPresentationSupportKHR => (physicalDevice: PhysicalDevice, queueFamilyIndex: u32, dpy: *mut c_void, visualID: u32/* FIXME: VisualID */) -> Bool32,
    CreateXcbSurfaceKHR => (instance: Instance, pCreateInfo: *const XcbSurfaceCreateInfoKHR, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    GetPhysicalDeviceXcbPresentationSupportKHR => (physicalDevice: PhysicalDevice, queueFamilyIndex: u32, connection: *mut c_void, visual_id: u32 /* FIXME: xcb_visualid */) -> Bool32,
    CreateWaylandSurfaceKHR => (instance: Instance, pCreateInfo: *const WaylandSurfaceCreateInfoKHR, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    GetPhysicalDeviceWaylandPresentationSupportKHR => (physicalDevice: PhysicalDevice, queueFamilyIndex: u32, display: *mut c_void) -> Bool32,
    CreateAndroidSurfaceKHR => (instance: Instance, pCreateInfo: *const AndroidSurfaceCreateInfoKHR, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    CreateWin32SurfaceKHR => (instance: Instance, pCreateInfo: *const Win32SurfaceCreateInfoKHR, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    GetPhysicalDeviceWin32PresentationSupportKHR => (physicalDevice: PhysicalDevice, queueFamilyIndex: u32) -> Bool32,
    GetPhysicalDeviceDisplayPropertiesKHR => (physicalDevice: PhysicalDevice, pPropertyCount: *mut u32, pProperties: *mut DisplayPropertiesKHR) -> Result,
    GetPhysicalDeviceDisplayPlanePropertiesKHR => (physicalDevice: PhysicalDevice, pPropertyCount: *mut u32, pProperties: *mut DisplayPlanePropertiesKHR) -> Result,
    GetDisplayPlaneSupportedDisplaysKHR => (physicalDevice: PhysicalDevice, planeIndex: u32, pDisplayCount: *mut u32, pDisplays: *mut DisplayKHR) -> Result,
    GetDisplayModePropertiesKHR => (physicalDevice: PhysicalDevice, display: DisplayKHR, pPropertyCount: *mut u32, pProperties: *mut DisplayModePropertiesKHR) -> Result,
    CreateDisplayModeKHR => (physicalDevice: PhysicalDevice, display: DisplayKHR, pCreateInfo: *const DisplayModeCreateInfoKHR, pAllocator: *const AllocationCallbacks, pMode: *mut DisplayModeKHR) -> Result,
    GetDisplayPlaneCapabilitiesKHR => (physicalDevice: PhysicalDevice, mode: DisplayModeKHR, planeIndex: u32, pCapabilities: *mut DisplayPlaneCapabilitiesKHR) -> Result,
    CreateDisplayPlaneSurfaceKHR => (instance: Instance, pCreateInfo: *const DisplaySurfaceCreateInfoKHR, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    GetPhysicalDeviceSurfaceSupportKHR => (physicalDevice: PhysicalDevice, queueFamilyIndex: u32, surface: SurfaceKHR, pSupported: *mut Bool32) -> Result,
    GetPhysicalDeviceSurfaceCapabilitiesKHR => (physicalDevice: PhysicalDevice, surface: SurfaceKHR, pSurfaceCapabilities: *mut SurfaceCapabilitiesKHR) -> Result,
    GetPhysicalDeviceSurfaceFormatsKHR => (physicalDevice: PhysicalDevice, surface: SurfaceKHR, pSurfaceFormatCount: *mut u32, pSurfaceFormats: *mut SurfaceFormatKHR) -> Result,
    GetPhysicalDeviceSurfacePresentModesKHR => (physicalDevice: PhysicalDevice, surface: SurfaceKHR, pPresentModeCount: *mut u32, pPresentModes: *mut PresentModeKHR) -> Result,
    CreateDebugUtilsMessengerEXT => (instance: Instance, pCreateInfo: *const DebugUtilsMessengerCreateInfoEXT, pAllocator: *const AllocationCallbacks, pMessenger: *const DebugUtilsMessengerEXT) -> Result,
    DestroyDebugUtilsMessengerEXT => (instance: Instance, messenger: DebugUtilsMessengerEXT, pAllocator: *const AllocationCallbacks) -> Result,
    CreateIOSSurfaceMVK => (instance: Instance, pCreateInfo: *const IOSSurfaceCreateInfoMVK, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    CreateMacOSSurfaceMVK => (instance: Instance, pCreateInfo: *const MacOSSurfaceCreateInfoMVK, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    ActivateMoltenVKLicenseMVK => (licenseID: *const c_char, licenseKey: *const c_char, acceptLicenseTermsAndConditions: Bool32) -> Result,
    ActivateMoltenVKLicensesMVK => () -> Result,
    GetMoltenVKDeviceConfigurationMVK => (device: Device, pConfiguration: *mut MVKDeviceConfiguration) -> Result,
    SetMoltenVKDeviceConfigurationMVK => (device: Device, pConfiguration: *mut MVKDeviceConfiguration) -> Result,
    GetPhysicalDeviceMetalFeaturesMVK => (physicalDevice: PhysicalDevice, pMetalFeatures: *mut MVKPhysicalDeviceMetalFeatures) -> Result,
    GetSwapchainPerformanceMVK => (device: Device, swapchain: SwapchainKHR, pSwapchainPerf: *mut MVKSwapchainPerformance) -> Result,
    CreateViSurfaceNN => (instance: Instance, pCreateInfo: *const ViSurfaceCreateInfoNN, pAllocator: *const AllocationCallbacks, pSurface: *mut SurfaceKHR) -> Result,
    GetPhysicalDeviceFeatures2KHR => (physicalDevice: PhysicalDevice, pFeatures: *mut PhysicalDeviceFeatures2KHR) -> (),
    GetPhysicalDeviceProperties2KHR => (physicalDevice: PhysicalDevice, pProperties: *mut PhysicalDeviceProperties2KHR) -> (),
    GetPhysicalDeviceFormatProperties2KHR => (physicalDevice: PhysicalDevice, pFormatProperties: *mut FormatProperties2KHR) -> (),
    GetPhysicalDeviceImageFormatProperties2KHR => (physicalDevice: PhysicalDevice, pImageFormatInfo: *const PhysicalDeviceImageFormatInfo2KHR, pImageFormatProperties: *mut ImageFormatProperties2KHR) -> Result,
    GetPhysicalDeviceQueueFamilyProperties2KHR => (physicalDevice: PhysicalDevice, pQueueFamilyPropertiesCount: *mut u32, pQueueFamilyProperties: *mut QueueFamilyProperties2KHR) -> (),
    GetPhysicalDeviceMemoryProperties2KHR => (physicalDevice: PhysicalDevice, pMemoryProperties: *mut PhysicalDeviceMemoryProperties2KHR) -> (),
    GetPhysicalDeviceSparseImageFormatProperties2KHR => (physicalDevice: PhysicalDevice, pFormatInfo: *const PhysicalDeviceSparseImageFormatInfo2KHR, pPropertyCount: *mut u32, pProperties: *mut SparseImageFormatProperties2KHR) -> (),
});

ptrs!(DevicePointers, {
    DestroyDevice => (device: Device, pAllocator: *const AllocationCallbacks) -> (),
    GetDeviceQueue => (device: Device, queueFamilyIndex: u32, queueIndex: u32, pQueue: *mut Queue) -> (),
    QueueSubmit => (queue: Queue, submitCount: u32, pSubmits: *const SubmitInfo, fence: Fence) -> Result,
    QueueWaitIdle => (queue: Queue) -> Result,
    DeviceWaitIdle => (device: Device) -> Result,
    AllocateMemory => (device: Device, pAllocateInfo: *const MemoryAllocateInfo, pAllocator: *const AllocationCallbacks, pMemory: *mut DeviceMemory) -> Result,
    FreeMemory => (device: Device, memory: DeviceMemory, pAllocator: *const AllocationCallbacks) -> (),
    MapMemory => (device: Device, memory: DeviceMemory, offset: DeviceSize, size: DeviceSize, flags: MemoryMapFlags, ppData: *mut *mut c_void) -> Result,
    UnmapMemory => (device: Device, memory: DeviceMemory) -> (),
    FlushMappedMemoryRanges => (device: Device, memoryRangeCount: u32, pMemoryRanges: *const MappedMemoryRange) -> Result,
    InvalidateMappedMemoryRanges => (device: Device, memoryRangeCount: u32, pMemoryRanges: *const MappedMemoryRange) -> Result,
    GetDeviceMemoryCommitment => (device: Device, memory: DeviceMemory, pCommittedMemoryInBytes: *mut DeviceSize) -> (),
    BindBufferMemory => (device: Device, buffer: Buffer, memory: DeviceMemory, memoryOffset: DeviceSize) -> Result,
    BindImageMemory => (device: Device, image: Image, memory: DeviceMemory, memoryOffset: DeviceSize) -> Result,
    GetBufferMemoryRequirements => (device: Device, buffer: Buffer, pMemoryRequirements: *mut MemoryRequirements) -> (),
    GetImageMemoryRequirements => (device: Device, image: Image, pMemoryRequirements: *mut MemoryRequirements) -> (),
    GetImageSparseMemoryRequirements => (device: Device, image: Image, pSparseMemoryRequirementCount: *mut u32, pSparseMemoryRequirements: *mut SparseImageMemoryRequirements) -> (),
    QueueBindSparse => (queue: Queue, bindInfoCount: u32, pBindInfo: *const BindSparseInfo, fence: Fence) -> Result,
    CreateFence => (device: Device, pCreateInfo: *const FenceCreateInfo, pAllocator: *const AllocationCallbacks, pFence: *mut Fence) -> Result,
    DestroyFence => (device: Device, fence: Fence, pAllocator: *const AllocationCallbacks) -> (),
    ResetFences => (device: Device, fenceCount: u32, pFences: *const Fence) -> Result,
    GetFenceStatus => (device: Device, fence: Fence) -> Result,
    WaitForFences => (device: Device, fenceCount: u32, pFences: *const Fence, waitAll: Bool32, timeout: u64) -> Result,
    CreateSemaphore => (device: Device, pCreateInfo: *const SemaphoreCreateInfo, pAllocator: *const AllocationCallbacks, pSemaphore: *mut Semaphore) -> Result,
    DestroySemaphore => (device: Device, semaphore: Semaphore, pAllocator: *const AllocationCallbacks) -> (),
    CreateEvent => (device: Device, pCreateInfo: *const EventCreateInfo, pAllocator: *const AllocationCallbacks, pEvent: *mut Event) -> Result,
    DestroyEvent => (device: Device, event: Event, pAllocator: *const AllocationCallbacks) -> (),
    GetEventStatus => (device: Device, event: Event) -> Result,
    SetEvent => (device: Device, event: Event) -> Result,
    ResetEvent => (device: Device, event: Event) -> Result,
    CreateQueryPool => (device: Device, pCreateInfo: *const QueryPoolCreateInfo, pAllocator: *const AllocationCallbacks, pQueryPool: *mut QueryPool) -> Result,
    DestroyQueryPool => (device: Device, queryPool: QueryPool, pAllocator: *const AllocationCallbacks) -> (),
    GetQueryPoolResults => (device: Device, queryPool: QueryPool, firstQuery: u32, queryCount: u32, dataSize: usize, pData: *mut c_void, stride: DeviceSize, flags: QueryResultFlags) -> Result,
    CreateBuffer => (device: Device, pCreateInfo: *const BufferCreateInfo, pAllocator: *const AllocationCallbacks, pBuffer: *mut Buffer) -> Result,
    DestroyBuffer => (device: Device, buffer: Buffer, pAllocator: *const AllocationCallbacks) -> (),
    CreateBufferView => (device: Device, pCreateInfo: *const BufferViewCreateInfo, pAllocator: *const AllocationCallbacks, pView: *mut BufferView) -> Result,
    DestroyBufferView => (device: Device, bufferView: BufferView, pAllocator: *const AllocationCallbacks) -> (),
    CreateImage => (device: Device, pCreateInfo: *const ImageCreateInfo, pAllocator: *const AllocationCallbacks, pImage: *mut Image) -> Result,
    DestroyImage => (device: Device, image: Image, pAllocator: *const AllocationCallbacks) -> (),
    GetImageSubresourceLayout => (device: Device, image: Image, pSubresource: *const ImageSubresource, pLayout: *mut SubresourceLayout) -> (),
    CreateImageView => (device: Device, pCreateInfo: *const ImageViewCreateInfo, pAllocator: *const AllocationCallbacks, pView: *mut ImageView) -> Result,
    DestroyImageView => (device: Device, imageView: ImageView, pAllocator: *const AllocationCallbacks) -> (),
    CreateShaderModule => (device: Device, pCreateInfo: *const ShaderModuleCreateInfo, pAllocator: *const AllocationCallbacks, pShaderModule: *mut ShaderModule) -> Result,
    DestroyShaderModule => (device: Device, shaderModule: ShaderModule, pAllocator: *const AllocationCallbacks) -> (),
    CreatePipelineCache => (device: Device, pCreateInfo: *const PipelineCacheCreateInfo, pAllocator: *const AllocationCallbacks, pPipelineCache: *mut PipelineCache) -> Result,
    DestroyPipelineCache => (device: Device, pipelineCache: PipelineCache, pAllocator: *const AllocationCallbacks) -> (),
    GetPipelineCacheData => (device: Device, pipelineCache: PipelineCache, pDataSize: *mut usize, pData: *mut c_void) -> Result,
    MergePipelineCaches => (device: Device, dstCache: PipelineCache, srcCacheCount: u32, pSrcCaches: *const PipelineCache) -> Result,
    CreateGraphicsPipelines => (device: Device, pipelineCache: PipelineCache, createInfoCount: u32, pCreateInfos: *const GraphicsPipelineCreateInfo, pAllocator: *const AllocationCallbacks, pPipelines: *mut Pipeline) -> Result,
    CreateComputePipelines => (device: Device, pipelineCache: PipelineCache, createInfoCount: u32, pCreateInfos: *const ComputePipelineCreateInfo, pAllocator: *const AllocationCallbacks, pPipelines: *mut Pipeline) -> Result,
    DestroyPipeline => (device: Device, pipeline: Pipeline, pAllocator: *const AllocationCallbacks) -> (),
    CreatePipelineLayout => (device: Device, pCreateInfo: *const PipelineLayoutCreateInfo, pAllocator: *const AllocationCallbacks, pPipelineLayout: *mut PipelineLayout) -> Result,
    DestroyPipelineLayout => (device: Device, pipelineLayout: PipelineLayout, pAllocator: *const AllocationCallbacks) -> (),
    CreateSampler => (device: Device, pCreateInfo: *const SamplerCreateInfo, pAllocator: *const AllocationCallbacks, pSampler: *mut Sampler) -> Result,
    DestroySampler => (device: Device, sampler: Sampler, pAllocator: *const AllocationCallbacks) -> (),
    CreateDescriptorSetLayout => (device: Device, pCreateInfo: *const DescriptorSetLayoutCreateInfo, pAllocator: *const AllocationCallbacks, pSetLayout: *mut DescriptorSetLayout) -> Result,
    DestroyDescriptorSetLayout => (device: Device, descriptorSetLayout: DescriptorSetLayout, pAllocator: *const AllocationCallbacks) -> (),
    CreateDescriptorPool => (device: Device, pCreateInfo: *const DescriptorPoolCreateInfo, pAllocator: *const AllocationCallbacks, pDescriptorPool: *mut DescriptorPool) -> Result,
    DestroyDescriptorPool => (device: Device, descriptorPool: DescriptorPool, pAllocator: *const AllocationCallbacks) -> (),
    ResetDescriptorPool => (device: Device, descriptorPool: DescriptorPool, flags: DescriptorPoolResetFlags) -> Result,
    AllocateDescriptorSets => (device: Device, pAllocateInfo: *const DescriptorSetAllocateInfo, pDescriptorSets: *mut DescriptorSet) -> Result,
    FreeDescriptorSets => (device: Device, descriptorPool: DescriptorPool, descriptorSetCount: u32, pDescriptorSets: *const DescriptorSet) -> Result,
    UpdateDescriptorSets => (device: Device, descriptorWriteCount: u32, pDescriptorWrites: *const WriteDescriptorSet, descriptorCopyCount: u32, pDescriptorCopies: *const CopyDescriptorSet) -> (),
    CreateFramebuffer => (device: Device, pCreateInfo: *const FramebufferCreateInfo, pAllocator: *const AllocationCallbacks, pFramebuffer: *mut Framebuffer) -> Result,
    DestroyFramebuffer => (device: Device, framebuffer: Framebuffer, pAllocator: *const AllocationCallbacks) -> (),
    CreateRenderPass => (device: Device, pCreateInfo: *const RenderPassCreateInfo, pAllocator: *const AllocationCallbacks, pRenderPass: *mut RenderPass) -> Result,
    DestroyRenderPass => (device: Device, renderPass: RenderPass, pAllocator: *const AllocationCallbacks) -> (),
    GetRenderAreaGranularity => (device: Device, renderPass: RenderPass, pGranularity: *mut Extent2D) -> (),
    CreateCommandPool => (device: Device, pCreateInfo: *const CommandPoolCreateInfo, pAllocator: *const AllocationCallbacks, pCommandPool: *mut CommandPool) -> Result,
    DestroyCommandPool => (device: Device, commandPool: CommandPool, pAllocator: *const AllocationCallbacks) -> (),
    ResetCommandPool => (device: Device, commandPool: CommandPool, flags: CommandPoolResetFlags) -> Result,
    TrimCommandPoolKHR => (device: Device, commandPool: CommandPool, flags: CommandPoolTrimFlagsKHR) -> (),
    AllocateCommandBuffers => (device: Device, pAllocateInfo: *const CommandBufferAllocateInfo, pCommandBuffers: *mut CommandBuffer) -> Result,
    FreeCommandBuffers => (device: Device, commandPool: CommandPool, commandBufferCount: u32, pCommandBuffers: *const CommandBuffer) -> (),
    BeginCommandBuffer => (commandBuffer: CommandBuffer, pBeginInfo: *const CommandBufferBeginInfo) -> Result,
    EndCommandBuffer => (commandBuffer: CommandBuffer) -> Result,
    ResetCommandBuffer => (commandBuffer: CommandBuffer, flags: CommandBufferResetFlags) -> Result,
    CmdBindPipeline => (commandBuffer: CommandBuffer, pipelineBindPoint: PipelineBindPoint, pipeline: Pipeline) -> (),
    CmdSetViewport => (commandBuffer: CommandBuffer, firstViewport: u32, viewportCount: u32, pViewports: *const Viewport) -> (),
    CmdSetScissor => (commandBuffer: CommandBuffer, firstScissor: u32, scissorCount: u32, pScissors: *const Rect2D) -> (),
    CmdSetLineWidth => (commandBuffer: CommandBuffer, lineWidth: f32) -> (),
    CmdSetDepthBias => (commandBuffer: CommandBuffer, depthBiasConstantFactor: f32, depthBiasClamp: f32, depthBiasSlopeFactor: f32) -> (),
    CmdSetBlendConstants => (commandBuffer: CommandBuffer, blendConstants: &[f32; 4]) -> (),
    CmdSetDepthBounds => (commandBuffer: CommandBuffer, minDepthBounds: f32, maxDepthBounds: f32) -> (),
    CmdSetStencilCompareMask => (commandBuffer: CommandBuffer, faceMask: StencilFaceFlags, compareMask: u32) -> (),
    CmdSetStencilWriteMask => (commandBuffer: CommandBuffer, faceMask: StencilFaceFlags, writeMask: u32) -> (),
    CmdSetStencilReference => (commandBuffer: CommandBuffer, faceMask: StencilFaceFlags, reference: u32) -> (),
    CmdBindDescriptorSets => (commandBuffer: CommandBuffer, pipelineBindPoint: PipelineBindPoint, layout: PipelineLayout, firstSet: u32, descriptorSetCount: u32, pDescriptorSets: *const DescriptorSet, dynamicOffsetCount: u32, pDynamicOffsets: *const u32) -> (),
    CmdBindIndexBuffer => (commandBuffer: CommandBuffer, buffer: Buffer, offset: DeviceSize, indexType: IndexType) -> (),
    CmdBindVertexBuffers => (commandBuffer: CommandBuffer, firstBinding: u32, bindingCount: u32, pBuffers: *const Buffer, pOffsets: *const DeviceSize) -> (),
    CmdDraw => (commandBuffer: CommandBuffer, vertexCount: u32, instanceCount: u32, firstVertex: u32, firstInstance: u32) -> (),
    CmdDrawIndexed => (commandBuffer: CommandBuffer, indexCount: u32, instanceCount: u32, firstIndex: u32, vertexOffset: i32, firstInstance: u32) -> (),
    CmdDrawIndirect => (commandBuffer: CommandBuffer, buffer: Buffer, offset: DeviceSize, drawCount: u32, stride: u32) -> (),
    CmdDrawIndexedIndirect => (commandBuffer: CommandBuffer, buffer: Buffer, offset: DeviceSize, drawCount: u32, stride: u32) -> (),
    CmdDispatch => (commandBuffer: CommandBuffer, x: u32, y: u32, z: u32) -> (),
    CmdDispatchIndirect => (commandBuffer: CommandBuffer, buffer: Buffer, offset: DeviceSize) -> (),
    CmdCopyBuffer => (commandBuffer: CommandBuffer, srcBuffer: Buffer, dstBuffer: Buffer, regionCount: u32, pRegions: *const BufferCopy) -> (),
    CmdCopyImage => (commandBuffer: CommandBuffer, srcImage: Image, srcImageLayout: ImageLayout, dstImage: Image, dstImageLayout: ImageLayout, regionCount: u32, pRegions: *const ImageCopy) -> (),
    CmdBlitImage => (commandBuffer: CommandBuffer, srcImage: Image, srcImageLayout: ImageLayout, dstImage: Image, dstImageLayout: ImageLayout, regionCount: u32, pRegions: *const ImageBlit, filter: Filter) -> (),
    CmdCopyBufferToImage => (commandBuffer: CommandBuffer, srcBuffer: Buffer, dstImage: Image, dstImageLayout: ImageLayout, regionCount: u32, pRegions: *const BufferImageCopy) -> (),
    CmdCopyImageToBuffer => (commandBuffer: CommandBuffer, srcImage: Image, srcImageLayout: ImageLayout, dstBuffer: Buffer, regionCount: u32, pRegions: *const BufferImageCopy) -> (),
    CmdUpdateBuffer => (commandBuffer: CommandBuffer, dstBuffer: Buffer, dstOffset: DeviceSize, dataSize: DeviceSize, pData: *const u32) -> (),
    CmdFillBuffer => (commandBuffer: CommandBuffer, dstBuffer: Buffer, dstOffset: DeviceSize, size: DeviceSize, data: u32) -> (),
    CmdClearColorImage => (commandBuffer: CommandBuffer, image: Image, imageLayout: ImageLayout, pColor: *const ClearColorValue, rangeCount: u32, pRanges: *const ImageSubresourceRange) -> (),
    CmdClearDepthStencilImage => (commandBuffer: CommandBuffer, image: Image, imageLayout: ImageLayout, pDepthStencil: *const ClearDepthStencilValue, rangeCount: u32, pRanges: *const ImageSubresourceRange) -> (),
    CmdClearAttachments => (commandBuffer: CommandBuffer, attachmentCount: u32, pAttachments: *const ClearAttachment, rectCount: u32, pRects: *const ClearRect) -> (),
    CmdResolveImage => (commandBuffer: CommandBuffer, srcImage: Image, srcImageLayout: ImageLayout, dstImage: Image, dstImageLayout: ImageLayout, regionCount: u32, pRegions: *const ImageResolve) -> (),
    CmdSetEvent => (commandBuffer: CommandBuffer, event: Event, stageMask: PipelineStageFlags) -> (),
    CmdResetEvent => (commandBuffer: CommandBuffer, event: Event, stageMask: PipelineStageFlags) -> (),
    CmdWaitEvents => (commandBuffer: CommandBuffer, eventCount: u32, pEvents: *const Event, srcStageMask: PipelineStageFlags, dstStageMask: PipelineStageFlags, memoryBarrierCount: u32, pMemoryBarriers: *const MemoryBarrier, bufferMemoryBarrierCount: u32, pBufferMemoryBarriers: *const BufferMemoryBarrier, imageMemoryBarrierCount: u32, pImageMemoryBarriers: *const ImageMemoryBarrier) -> (),
    CmdPipelineBarrier => (commandBuffer: CommandBuffer, srcStageMask: PipelineStageFlags, dstStageMask: PipelineStageFlags, dependencyFlags: DependencyFlags, memoryBarrierCount: u32, pMemoryBarriers: *const MemoryBarrier, bufferMemoryBarrierCount: u32, pBufferMemoryBarriers: *const BufferMemoryBarrier, imageMemoryBarrierCount: u32, pImageMemoryBarriers: *const ImageMemoryBarrier) -> (),
    CmdBeginQuery => (commandBuffer: CommandBuffer, queryPool: QueryPool, query: u32, flags: QueryControlFlags) -> (),
    CmdEndQuery => (commandBuffer: CommandBuffer, queryPool: QueryPool, query: u32) -> (),
    CmdResetQueryPool => (commandBuffer: CommandBuffer, queryPool: QueryPool, firstQuery: u32, queryCount: u32) -> (),
    CmdWriteTimestamp => (commandBuffer: CommandBuffer, pipelineStage: PipelineStageFlagBits, queryPool: QueryPool, query: u32) -> (),
    CmdCopyQueryPoolResults => (commandBuffer: CommandBuffer, queryPool: QueryPool, firstQuery: u32, queryCount: u32, dstBuffer: Buffer, dstOffset: DeviceSize, stride: DeviceSize, flags: QueryResultFlags) -> (),
    CmdPushConstants => (commandBuffer: CommandBuffer, layout: PipelineLayout, stageFlags: ShaderStageFlags, offset: u32, size: u32, pValues: *const c_void) -> (),
    CmdBeginRenderPass => (commandBuffer: CommandBuffer, pRenderPassBegin: *const RenderPassBeginInfo, contents: SubpassContents) -> (),
    CmdNextSubpass => (commandBuffer: CommandBuffer, contents: SubpassContents) -> (),
    CmdEndRenderPass => (commandBuffer: CommandBuffer) -> (),
    CmdExecuteCommands => (commandBuffer: CommandBuffer, commandBufferCount: u32, pCommandBuffers: *const CommandBuffer) -> (),
    CreateSwapchainKHR => (device: Device, pCreateInfo: *const SwapchainCreateInfoKHR, pAllocator: *const AllocationCallbacks, pSwapchain: *mut SwapchainKHR) -> Result,
    DestroySwapchainKHR => (device: Device, swapchain: SwapchainKHR, pAllocator: *const AllocationCallbacks) -> (),
    GetSwapchainImagesKHR => (device: Device, swapchain: SwapchainKHR, pSwapchainImageCount: *mut u32, pSwapchainImages: *mut Image) -> Result,
    AcquireNextImageKHR => (device: Device, swapchain: SwapchainKHR, timeout: u64, semaphore: Semaphore, fence: Fence, pImageIndex: *mut u32) -> Result,
    QueuePresentKHR => (queue: Queue, pPresentInfo: *const PresentInfoKHR) -> Result,
    CreateSharedSwapchainsKHR => (device: Device, swapchainCount: u32, pCreateInfos: *const SwapchainCreateInfoKHR, pAllocator: *const AllocationCallbacks, pSwapchains: *mut SwapchainKHR) -> Result,
    CmdPushDescriptorSetKHR => (commandBuffer: CommandBuffer, pipelineBindPoint: PipelineBindPoint, layout: PipelineLayout, set: u32, descriptorWriteCount: u32, pDescriptorWrites: *const WriteDescriptorSet) -> (),
    CreateDescriptorUpdateTemplateKHR => (device: Device, pCreateInfo: *const DescriptorUpdateTemplateCreateInfoKHR, pAllocator: *const AllocationCallbacks, pDescriptorUpdateTemplate: *mut DescriptorUpdateTemplateKHR) -> Result,
    DestroyDescriptorUpdateTemplateKHR => (device: Device, descriptorUpdateTemplate: DescriptorUpdateTemplateKHR, pAllocator: *const AllocationCallbacks) -> (),
    UpdateDescriptorSetWithTemplateKHR => (device: Device, descriptorSet: DescriptorSet, descriptorUpdateTemplate: DescriptorUpdateTemplateKHR, pData: *const c_void) -> (),
    CmdPushDescriptorSetWithTemplateKHR => (commandBuffer: CommandBuffer, descriptorUpdateTemplate: DescriptorUpdateTemplateKHR, layout: PipelineLayout, set: u32, pData: *const c_void) -> (),
    GetImageMemoryRequirements2KHR => (device: Device, pInfo: *const ImageMemoryRequirementsInfo2KHR, pMemoryRequirements: *mut MemoryRequirements2KHR) -> (),
    GetBufferMemoryRequirements2KHR => (device: Device, pInfo: *const BufferMemoryRequirementsInfo2KHR, pMemoryRequirements: *mut MemoryRequirements2KHR) -> (),
    SetDebugUtilsObjectNameEXT => (device: Device, pNameInfo: *const DebugUtilsObjectNameInfoEXT) -> Result,
    CmdBeginDebugUtilsLabelEXT => (commandBuffer: CommandBuffer, pLabelInfo: *const DebugUtilsLabelEXT) -> Result,
    CmdEndDebugUtilsLabelEXT => (commandBuffer: CommandBuffer) -> Result,
    CmdInsertDebugUtilsLabelEXT => (commandBuffer: CommandBuffer, pLabelInfo: *const DebugUtilsLabelEXT) -> Result,
    AcquireFullScreenExclusiveModeEXT => (device: Device, swapchain: SwapchainKHR) -> Result,
    ReleaseFullScreenExclusiveModeEXT => (device: Device, swapchain: SwapchainKHR) -> Result,
    GetBufferDeviceAddressEXT => (device: Device, pInfo: *const BufferDeviceAddressInfo) -> DeviceAddress,
    GetMemoryFdKHR => (device: Device, pGetFdInfo: *const MemoryGetFdInfoKHR, pFd: *mut i32) -> Result,
    GetMemoryFdPropertiesKHR => (device: Device, handleType: ExternalMemoryHandleTypeFlagBits, fd: i32, pMemoryFdProperties: *mut MemoryFdPropertiesKHR) -> Result,
});
