# Changelog

0.2.1 版本后各个接口方法已经基本趋于稳定，后面将不会做大的调整。

## [0.4.10] - 2021-04-22

### 修复

- 修复 `texts(limit_depth: usize)` 方法获取文本节点时，可能会漏掉内容标签的问题，参数由 `u32` 统一为 `usize`
- 修复 element trait 的 `set_text()` 方法实体进行转义时，仅转义 `<>&` 这三个特殊字符，单双引号不再进行转义，和浏览器保持一致

### 修改

- 增加 `texts_by(limit_depth: usize, handle: Box<dyn Fn(usize, &BoxDynText) -> bool ))` 方法，方便获取节点时，可以根据节点类型等进行排除

- `element` trait 增加 `text_chars()` 方法，和 `text_contents()` 方法不同，当内容中包含 html 实体转义字符时，该方法不会进行转义，而是保留原始字符

## [0.4.9] - 2021-04-14

### 修复

- 修复 `prev_until` 获取结果节点顺序为逆序的问题

## [0.4.8] - 2021-03-27

### 修复

- 修复节点插入时，当有不可插入节点时提示节点多次`BorrowMut`的问题

### 修改

- 升级 `rphtml` 去掉一些无用的逻辑判断，加速解析速度
- 增加更多 `mutation` 相关操作的测试用例

## [0.4.7] - 2021-03-26

### 修改

- 修改 `set_attribute` 时，value 值带引号时将对引号进行实体转义的逻辑
- 增加更多的测试用例，基本覆盖到所有代码逻辑，去掉一些不太实用的接口代码

## [0.4.6] - 2021-03-26

### 修复

- 修复 `add` 方法错误书写变量名及使用 range 时丢失最后一个元素的问题
- 修复 `unique_parents` 时判断了所有父元素导致逻辑错误的问题

### 修改

- 增加更多测试用例及逻辑细节

### 修改

- 重构了 `find` 方法的处理逻辑，相比以前代码更清晰

## [0.4.5] - 2021-03-24

### 修复

- 修复 `has_ele` 方法判断 Combinator 为 `ParentAll` 可能出错的问题，这个可能会影响到最终结果集，有使用 0.4.4 版本的需要升级以修复该问题

### 修改

- 重构了 `find` 方法的处理逻辑，相比以前代码更清晰

### 其它

- 继续增加更多测试用例，基本覆盖到所有重要的处理逻辑

## [0.4.4] - 2021-03-24

### 修复

- 修复 `add` 方法合并时可能出现计算错误的问题

### 修改

- 增加 `has_attr` 属性判断方法，统一错误选择器的错误处理，

### 其它

- 增加更多测试用例，去掉一些冗余逻辑

## [0.4.3] - 2021-03-24

### 修复

- 修复在使用 `:last-child` 及 `:nth-last-child` 在整体匹配情况下 `index` 位置取反的问题

### 其它

- 增加更多测试用例，进一步提升代码测试覆盖率

## [0.4.2] - 2021-03-23

### 修复

- 修复使用 `nth-` 的伪类选择器，当 n 为负数时，匹配元素顺序可能颠倒的问题
- 修复`[attribute]`属性选择器当属性为空查找的边界情况，与浏览器选择器保持一致

### 其它

- 增加了更多测试用例，去掉了一些冗余代码

## [0.4.1] - 2021-03-21

### 修复

- 修改`:last-of-type(index)`及`:nth-last-of-type(index)`指定 index 值查找时，没有保持节点顺序的问题

### 修改

- 增加更多测试用例以及更多在线示例

## [0.4.0] - 2021-03-20 :star:

### Broken change

- 针对节点的文本操作由原来的`&str`类型改为了`String`类型

### 优化

- 优化了 rphtml 和 htmlentity，在 html 解析和 render 等文本处理的时间上有了很大的性能提升
- 优化了选择器的处理逻辑，去掉了中间的数据处理，查找速度上比以前更快

## [0.3.2] - 2021-03-06

### 修复

- 修复使用 prevAll 可能导致节点顺序不对的问题

### 优化

- 去除子元素查找时不必要的节点复制，使得查找速度更快

## [0.3.1] - 2021-03-05

### BUG 修复

- 修复因更新 `get_attribute` 属性查找方式后 `set_attribute` 及 `get_attribute` 方法没有同步逻辑导致的属性不同步问题

## [0.3.0] - 2021-03-05

### BUG 修复

- 修复 `Nth` pattern 正则匹配的错误，导致 `:nth-child(10)` 中索引`10`不能被正确解析的问题

### 修改

- 为保证节点超找速度，将 `mesdoc` 整合到项目中，将不再单独维护，重写了实现 `IElementTrait` 等的对象类型，避免了查找时不必要的复制
- 进一步优化了各个伪类选择器，相比 goquery 库都有更快的查找速度
- 优化了规则、命名常量、文件拆分等细节，整体更清晰
- `rphtml` 库增加了标签属性名小写 name 映射，方便更快定位到属性，加快属性选择器的查找速度
- performance 下增加了更全面的选择器查找速度对比示例

## [0.2.7] - 2021-03-05

### 修改

- 重写 `mesdoc` 节点匹配逻辑，规则处理逻辑等，节点查找速度有了较大提升，修复了 `parent` 没有去重的问题等
- 增加更多测试用例和性能对比测试等

## [0.2.6] - 2021-03-04

### 修改

- 修复 `rphtml` 解析属性值错误处理反斜杠的逻辑

## [0.2.6] - 2021-03-03

### 修改

- 优化 `get_attribute` 逻辑
- `rphtml` 判断属性名的逻辑和 `mesdoc` 保持一致
- 增加更多性能对比测试代码

## [0.2.5] - 2021-03-03

### 修改

- 优化 `find` 查找子节点时的性能，当节点数目较大时有很大的性能提升
- 增加更多与 go + goquery 等的查找性能对比测试

## [0.2.4] - 2021-03-02

### 修改

- 修复 issue #2 中提到的标签名、属性名大小写问题，增加标签名支持英文冒号:

## [0.2.3] - 2021-02-24

### 修改

- 修改 `load` 及 `load_catch` 方法默认解析 html 采用最兼容的模式
- 增加 `load_options` 及 `load_options_catch` 两个方法，上述两个方法是对应此两个方法、使用最兼容模式参数的调用。
- 对应增加导出 `html::ParseOptions`，以便需要调用新增 options 方法调用时使用

## [0.2.2] - 2021-02-24

### 修改

- 升级 `rphtml`，去除掉了 wasm 的部分，修改部分数据结构和逻辑，使得解析更为快速且保持更好的兼容性
- 修复了 `rphtml` 中节点判断 `is_document` 的逻辑，新增加了解析参数允许纠错没有实体转译的 `<` 等
- `visdom` 中因 `rphtml` 升级导致的部分同步修改

## [0.2.1] - 2021-02-20

### 修改

- 修改 `mesdoc` 中 `slice` 方法支持 `RangeBounds` 参数
- 重新导出 `mesdoc` 中各个 trait 里用到的返回类型等，方便在逻辑处理时可能会用到时做各种处理

## [0.2.0] - 2021-02-19

### 修改

- 修复 `rphtml` 中解析 `pre` 标签、自闭合标签不正确的问题，重新修改文档节点与根节点的引用关系
- `mesdoc` 中针对 `IDocumentTrait` 增加 `source_code`, `title`, `body`, `head` 方法等，方便快速获取文档信息，同时针对 `Elements` 增加 `document` 方法方便快速获取 `IDocumentTrait` 文档节点
- `visdom` 中修改针对 `rphtml` 和 `mesdoc` 升级做对应的修改

## [0.1.12] - 2021-02-17

### 修改

- 优化 `mesdoc` 中元素去重逻辑

## [0.1.11] - 2021-02-17

### 修改

- 升级 `mesdoc`，修复部分选择器没有去重的问题

## [0.1.10] - 2021-02-16

### 修改

- 进一步完善 `mesdoc` 中的代码细节，减少耦合逻辑
- 升级 rphtml, 修改`pre`等标签的调用 `html` 方法没有被`encode`的问题
- 增加更多测试代码

## [0.1.9] - 2021-02-16

### 修改

- `mesdoc` 补充 `id` 选择器的逻辑，完善可从缓存中快速获取的元素
- 修改 README 等

## [0.1.8] - 2021-02-15

### 修改

- `mesdoc` 去掉无用的生命周期声明，优化 `:only-child` 伪类选择器和 `select` 方法
- 修改 README 等

## [0.1.7] - 2021-02-14

### 修改

- 将 `mesdoc` 中伪类选择器`:first-child`,`:last-child`,`:first-of-type`,`:last-of-type`改为别名选择器，减少代码
- 微调 `mesdoc` 中 `filter` 方法的实现，逻辑更为清晰

## [0.1.6] - 2021-02-13

### 修改

- 优化 `mesdoc` `:nth-child`等伪类选择器的性能
- 重写了`mesdoc` 中 `filter` 方法的逻辑，去掉了 id 选择器 `in_cache` 的逻辑，减少复杂度
- 修复了部分选择器不能正确匹配的问题

## [0.1.5] - 2021-02-10

### 修改

- 继续优化 `mesdoc` 中伪类选择器的性能

## [0.1.4] - 2021-02-09

### 修改

- 优化 `mesdoc` 中部分伪类选择器的性能
- 增加更多测试

### 修改

- 修复 `mesdoc` 中 `[attr|=value]` 选择器逻辑逻辑不正确的问题，优化 `value` 正则的匹配逻辑
- `mesdoc` 新增 `:contains` 内容选择器
- 增加更多测试用例、完善文档

## [0.1.3] - 2021-02-09

### 修改

- 修复 `mesdoc` 中 `[attr|=value]` 选择器逻辑逻辑不正确的问题，优化 `value` 正则的匹配逻辑
- `mesdoc` 新增 `:contains` 内容选择器
- 增加更多测试用例、完善文档

## [0.1.2] - 2021-02-08

### 修改

- 将 `mesdoc` 中 `unique` 方法改为对外公共方法 `add`，增加 eq 的快捷方法`first`,`last`
- 修复 `mesdoc` `add` 排序方法存在的错误逻辑，增强了缓存的逻辑
- 修改部分判断逻辑为函数式写法
- 增加更多测试用例以及修改文档中的错误、完善部分文档说明

## [0.1.1] - 2021-02-07

### 修改

- 修复 `mesdoc` 中对比元素位置时的 bug
- 修复了 `mesdoc` 内 `parent`、`prev_all` 等所有需要去重的方法缺少去重而导致的重复节点错误
- 重写了 `mesdoc` 中 `closest` 和 `siblings` 方法，增加去重和排序
- 修改针对 text 节点`set_text`方法为直接修改内容，修复了原方法设置父节点错误导致的问题
- 增加 rust doc 注释和更多测试用例

## [0.1.0] - 2021-02-06

### 修改

- 去掉了 `mesdoc` 的 sort 方法
- 重写了 `unique` 方法以实现快速合并选择器的重复节点，速度有了大幅提升
- 修复了节点操作缺少父节点字段导致的节点丢失
