#![cfg(not(windows))]
use std::env::vars_os;
use std::io;
use std::os::unix::ffi::OsStringExt;
use viro::Viro;

fn main() -> io::Result<()> {
    let mut viro = Viro::new();
    for (key, val) in vars_os() {
        viro.insert::<Vec<u8>, Vec<u8>>(key.into_vec(), val.into_vec());
    }
    viro.read_stdin()?;
    viro.write_stdout()?;
    Ok(())
}
