# viro

Loads your environment so you don't have to.

Offers a data structure for serializing and deserializing environment variables, to allow for easy
loading of `/etc/profile` scripts in non-POSIX shells like `fish`. The `viro` binary is only
available for unix-based systems at the moment; see the "Roadmap" section of this README for
details.

## License

Available via the [Anti-Capitalist Software License][ACSL] for individuals, non-profit
organisations, and worker-owned businesses.

[ACSL]: ./LICENSE.md

## Installation

First, build `viro` for your system with the `sync-stdio` feature and install it in `/usr/bin`,
alongside the `viro-profile` script.

Depending on whether you want to use systemd or no d, merge the `/usr` provided in either
`systemd/usr` or `nod/usr` with your own.

## Usage

Because bash does not have a standardized config directory, you will need to source the scripts in
`/usr/share/bash/bashrc.d` in order to make this work. If you chose to use systemd, you must also
enable the `profile.service` for your user.

## Roadmap

For now, the `viro` crate has no actual support for converting environment variables into byte
sequences, and the `viro` binary simply assumes that the conversion is trivial, as it is on
POSIX-compliant systems. However, on systems like Windows, a more complicated conversion will be
necessary to convert between genuine environment variables and byte slices using a format like
[WTF-8].

Additionally, there are currently no attempts to escape `\x3D` (equals sign) and `\x00` (NUL) bytes
when outputting variables, and this simply alters the output. A future version of this crate will
want to offer these, but I have no plans to implement this at the moment.

[WTF-8]: https://simonsapin.github.io/wtf-8
