/* automatically generated by rust-bindgen 0.58.1 */

#![allow(dead_code,non_upper_case_globals,non_camel_case_types,non_snake_case)]

pub const VMBINFINITE: u32 = 4294967295;
pub type VmbInt8_t = ::std::os::raw::c_char;
pub type VmbUint8_t = ::std::os::raw::c_uchar;
pub type VmbInt16_t = ::std::os::raw::c_short;
pub type VmbUint16_t = ::std::os::raw::c_ushort;
pub type VmbInt32_t = ::std::os::raw::c_int;
pub type VmbUint32_t = ::std::os::raw::c_uint;
pub type VmbInt64_t = ::std::os::raw::c_longlong;
pub type VmbUint64_t = ::std::os::raw::c_ulonglong;
pub type VmbHandle_t = *mut ::std::os::raw::c_void;
pub type VmbBool_t = ::std::os::raw::c_char;
pub mod VmbBoolVal {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbBoolTrue: Type = 1;
    pub const VmbBoolFalse: Type = 0;
}
pub type VmbUchar_t = ::std::os::raw::c_uchar;
pub mod VmbErrorType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbErrorSuccess: Type = 0;
    pub const VmbErrorInternalFault: Type = -1;
    pub const VmbErrorApiNotStarted: Type = -2;
    pub const VmbErrorNotFound: Type = -3;
    pub const VmbErrorBadHandle: Type = -4;
    pub const VmbErrorDeviceNotOpen: Type = -5;
    pub const VmbErrorInvalidAccess: Type = -6;
    pub const VmbErrorBadParameter: Type = -7;
    pub const VmbErrorStructSize: Type = -8;
    pub const VmbErrorMoreData: Type = -9;
    pub const VmbErrorWrongType: Type = -10;
    pub const VmbErrorInvalidValue: Type = -11;
    pub const VmbErrorTimeout: Type = -12;
    pub const VmbErrorOther: Type = -13;
    pub const VmbErrorResources: Type = -14;
    pub const VmbErrorInvalidCall: Type = -15;
    pub const VmbErrorNoTL: Type = -16;
    pub const VmbErrorNotImplemented: Type = -17;
    pub const VmbErrorNotSupported: Type = -18;
    pub const VmbErrorIncomplete: Type = -19;
    pub const VmbErrorIO: Type = -20;
}
pub type VmbError_t = VmbInt32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct VmbVersionInfo_t {
    pub major: VmbUint32_t,
    pub minor: VmbUint32_t,
    pub patch: VmbUint32_t,
}
#[test]
fn bindgen_test_layout_VmbVersionInfo_t() {
    assert_eq!(
        ::std::mem::size_of::<VmbVersionInfo_t>(),
        12usize,
        concat!("Size of: ", stringify!(VmbVersionInfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<VmbVersionInfo_t>(),
        4usize,
        concat!("Alignment of ", stringify!(VmbVersionInfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbVersionInfo_t>())).major as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbVersionInfo_t),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbVersionInfo_t>())).minor as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbVersionInfo_t),
            "::",
            stringify!(minor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbVersionInfo_t>())).patch as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbVersionInfo_t),
            "::",
            stringify!(patch)
        )
    );
}
pub mod VmbPixelType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbPixelMono: Type = 16777216;
    pub const VmbPixelColor: Type = 33554432;
}
pub mod VmbPixelOccupyType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbPixelOccupy8Bit: Type = 524288;
    pub const VmbPixelOccupy10Bit: Type = 655360;
    pub const VmbPixelOccupy12Bit: Type = 786432;
    pub const VmbPixelOccupy14Bit: Type = 917504;
    pub const VmbPixelOccupy16Bit: Type = 1048576;
    pub const VmbPixelOccupy24Bit: Type = 1572864;
    pub const VmbPixelOccupy32Bit: Type = 2097152;
    pub const VmbPixelOccupy48Bit: Type = 3145728;
    pub const VmbPixelOccupy64Bit: Type = 4194304;
}
pub mod VmbPixelFormatType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbPixelFormatMono8: Type = 17301505;
    pub const VmbPixelFormatMono10: Type = 17825795;
    pub const VmbPixelFormatMono10p: Type = 17432646;
    pub const VmbPixelFormatMono12: Type = 17825797;
    pub const VmbPixelFormatMono12Packed: Type = 17563654;
    pub const VmbPixelFormatMono12p: Type = 17563719;
    pub const VmbPixelFormatMono14: Type = 17825829;
    pub const VmbPixelFormatMono16: Type = 17825799;
    pub const VmbPixelFormatBayerGR8: Type = 17301512;
    pub const VmbPixelFormatBayerRG8: Type = 17301513;
    pub const VmbPixelFormatBayerGB8: Type = 17301514;
    pub const VmbPixelFormatBayerBG8: Type = 17301515;
    pub const VmbPixelFormatBayerGR10: Type = 17825804;
    pub const VmbPixelFormatBayerRG10: Type = 17825805;
    pub const VmbPixelFormatBayerGB10: Type = 17825806;
    pub const VmbPixelFormatBayerBG10: Type = 17825807;
    pub const VmbPixelFormatBayerGR12: Type = 17825808;
    pub const VmbPixelFormatBayerRG12: Type = 17825809;
    pub const VmbPixelFormatBayerGB12: Type = 17825810;
    pub const VmbPixelFormatBayerBG12: Type = 17825811;
    pub const VmbPixelFormatBayerGR12Packed: Type = 17563690;
    pub const VmbPixelFormatBayerRG12Packed: Type = 17563691;
    pub const VmbPixelFormatBayerGB12Packed: Type = 17563692;
    pub const VmbPixelFormatBayerBG12Packed: Type = 17563693;
    pub const VmbPixelFormatBayerGR10p: Type = 17432662;
    pub const VmbPixelFormatBayerRG10p: Type = 17432664;
    pub const VmbPixelFormatBayerGB10p: Type = 17432660;
    pub const VmbPixelFormatBayerBG10p: Type = 17432658;
    pub const VmbPixelFormatBayerGR12p: Type = 17563735;
    pub const VmbPixelFormatBayerRG12p: Type = 17563737;
    pub const VmbPixelFormatBayerGB12p: Type = 17563733;
    pub const VmbPixelFormatBayerBG12p: Type = 17563731;
    pub const VmbPixelFormatBayerGR16: Type = 17825838;
    pub const VmbPixelFormatBayerRG16: Type = 17825839;
    pub const VmbPixelFormatBayerGB16: Type = 17825840;
    pub const VmbPixelFormatBayerBG16: Type = 17825841;
    pub const VmbPixelFormatRgb8: Type = 35127316;
    pub const VmbPixelFormatBgr8: Type = 35127317;
    pub const VmbPixelFormatRgb10: Type = 36700184;
    pub const VmbPixelFormatBgr10: Type = 36700185;
    pub const VmbPixelFormatRgb12: Type = 36700186;
    pub const VmbPixelFormatBgr12: Type = 36700187;
    pub const VmbPixelFormatRgb14: Type = 36700254;
    pub const VmbPixelFormatBgr14: Type = 36700234;
    pub const VmbPixelFormatRgb16: Type = 36700211;
    pub const VmbPixelFormatBgr16: Type = 36700235;
    pub const VmbPixelFormatArgb8: Type = 35651606;
    pub const VmbPixelFormatRgba8: Type = 35651606;
    pub const VmbPixelFormatBgra8: Type = 35651607;
    pub const VmbPixelFormatRgba10: Type = 37748831;
    pub const VmbPixelFormatBgra10: Type = 37748812;
    pub const VmbPixelFormatRgba12: Type = 37748833;
    pub const VmbPixelFormatBgra12: Type = 37748814;
    pub const VmbPixelFormatRgba14: Type = 37748835;
    pub const VmbPixelFormatBgra14: Type = 37748816;
    pub const VmbPixelFormatRgba16: Type = 37748836;
    pub const VmbPixelFormatBgra16: Type = 37748817;
    pub const VmbPixelFormatYuv411: Type = 34340894;
    pub const VmbPixelFormatYuv422: Type = 34603039;
    pub const VmbPixelFormatYuv444: Type = 35127328;
    pub const VmbPixelFormatYCbCr411_8_CbYYCrYY: Type = 34340924;
    pub const VmbPixelFormatYCbCr422_8_CbYCrY: Type = 34603075;
    pub const VmbPixelFormatYCbCr8_CbYCr: Type = 35127354;
    pub const VmbPixelFormatLast: Type = 35127355;
}
pub type VmbPixelFormat_t = VmbUint32_t;
extern "C" {
    pub static gVimbaHandle: VmbHandle_t;
}
pub mod VmbInterfaceType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbInterfaceUnknown: Type = 0;
    pub const VmbInterfaceFirewire: Type = 1;
    pub const VmbInterfaceEthernet: Type = 2;
    pub const VmbInterfaceUsb: Type = 3;
    pub const VmbInterfaceCL: Type = 4;
    pub const VmbInterfaceCSI2: Type = 5;
}
pub type VmbInterface_t = VmbUint32_t;
pub mod VmbAccessModeType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbAccessModeNone: Type = 0;
    pub const VmbAccessModeFull: Type = 1;
    pub const VmbAccessModeRead: Type = 2;
    pub const VmbAccessModeConfig: Type = 4;
    pub const VmbAccessModeLite: Type = 8;
}
pub type VmbAccessMode_t = VmbUint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct VmbInterfaceInfo_t {
    pub interfaceIdString: *const ::std::os::raw::c_char,
    pub interfaceType: VmbInterface_t,
    pub interfaceName: *const ::std::os::raw::c_char,
    pub serialString: *const ::std::os::raw::c_char,
    pub permittedAccess: VmbAccessMode_t,
}
#[test]
fn bindgen_test_layout_VmbInterfaceInfo_t() {
    assert_eq!(
        ::std::mem::size_of::<VmbInterfaceInfo_t>(),
        40usize,
        concat!("Size of: ", stringify!(VmbInterfaceInfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<VmbInterfaceInfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(VmbInterfaceInfo_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbInterfaceInfo_t>())).interfaceIdString as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbInterfaceInfo_t),
            "::",
            stringify!(interfaceIdString)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbInterfaceInfo_t>())).interfaceType as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbInterfaceInfo_t),
            "::",
            stringify!(interfaceType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbInterfaceInfo_t>())).interfaceName as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbInterfaceInfo_t),
            "::",
            stringify!(interfaceName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbInterfaceInfo_t>())).serialString as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbInterfaceInfo_t),
            "::",
            stringify!(serialString)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbInterfaceInfo_t>())).permittedAccess as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbInterfaceInfo_t),
            "::",
            stringify!(permittedAccess)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct VmbCameraInfo_t {
    pub cameraIdString: *const ::std::os::raw::c_char,
    pub cameraName: *const ::std::os::raw::c_char,
    pub modelName: *const ::std::os::raw::c_char,
    pub serialString: *const ::std::os::raw::c_char,
    pub permittedAccess: VmbAccessMode_t,
    pub interfaceIdString: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_VmbCameraInfo_t() {
    assert_eq!(
        ::std::mem::size_of::<VmbCameraInfo_t>(),
        48usize,
        concat!("Size of: ", stringify!(VmbCameraInfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<VmbCameraInfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(VmbCameraInfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbCameraInfo_t>())).cameraIdString as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbCameraInfo_t),
            "::",
            stringify!(cameraIdString)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbCameraInfo_t>())).cameraName as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbCameraInfo_t),
            "::",
            stringify!(cameraName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbCameraInfo_t>())).modelName as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbCameraInfo_t),
            "::",
            stringify!(modelName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbCameraInfo_t>())).serialString as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbCameraInfo_t),
            "::",
            stringify!(serialString)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbCameraInfo_t>())).permittedAccess as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbCameraInfo_t),
            "::",
            stringify!(permittedAccess)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbCameraInfo_t>())).interfaceIdString as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbCameraInfo_t),
            "::",
            stringify!(interfaceIdString)
        )
    );
}
pub mod VmbFeatureDataType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbFeatureDataUnknown: Type = 0;
    pub const VmbFeatureDataInt: Type = 1;
    pub const VmbFeatureDataFloat: Type = 2;
    pub const VmbFeatureDataEnum: Type = 3;
    pub const VmbFeatureDataString: Type = 4;
    pub const VmbFeatureDataBool: Type = 5;
    pub const VmbFeatureDataCommand: Type = 6;
    pub const VmbFeatureDataRaw: Type = 7;
    pub const VmbFeatureDataNone: Type = 8;
}
pub type VmbFeatureData_t = VmbUint32_t;
pub mod VmbFeatureVisibilityType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbFeatureVisibilityUnknown: Type = 0;
    pub const VmbFeatureVisibilityBeginner: Type = 1;
    pub const VmbFeatureVisibilityExpert: Type = 2;
    pub const VmbFeatureVisibilityGuru: Type = 3;
    pub const VmbFeatureVisibilityInvisible: Type = 4;
}
pub type VmbFeatureVisibility_t = VmbUint32_t;
impl VmbFeatureFlagsType {
    pub const VmbFeatureFlagsNone: VmbFeatureFlagsType = VmbFeatureFlagsType(0);
}
impl VmbFeatureFlagsType {
    pub const VmbFeatureFlagsRead: VmbFeatureFlagsType = VmbFeatureFlagsType(1);
}
impl VmbFeatureFlagsType {
    pub const VmbFeatureFlagsWrite: VmbFeatureFlagsType = VmbFeatureFlagsType(2);
}
impl VmbFeatureFlagsType {
    pub const VmbFeatureFlagsVolatile: VmbFeatureFlagsType = VmbFeatureFlagsType(8);
}
impl VmbFeatureFlagsType {
    pub const VmbFeatureFlagsModifyWrite: VmbFeatureFlagsType = VmbFeatureFlagsType(16);
}
impl ::std::ops::BitOr<VmbFeatureFlagsType> for VmbFeatureFlagsType {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        VmbFeatureFlagsType(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for VmbFeatureFlagsType {
    #[inline]
    fn bitor_assign(&mut self, rhs: VmbFeatureFlagsType) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<VmbFeatureFlagsType> for VmbFeatureFlagsType {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        VmbFeatureFlagsType(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for VmbFeatureFlagsType {
    #[inline]
    fn bitand_assign(&mut self, rhs: VmbFeatureFlagsType) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct VmbFeatureFlagsType(pub ::std::os::raw::c_int);
pub type VmbFeatureFlags_t = VmbUint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct VmbFeatureInfo {
    pub name: *const ::std::os::raw::c_char,
    pub featureDataType: VmbFeatureData_t,
    pub featureFlags: VmbFeatureFlags_t,
    pub category: *const ::std::os::raw::c_char,
    pub displayName: *const ::std::os::raw::c_char,
    pub pollingTime: VmbUint32_t,
    pub unit: *const ::std::os::raw::c_char,
    pub representation: *const ::std::os::raw::c_char,
    pub visibility: VmbFeatureVisibility_t,
    pub tooltip: *const ::std::os::raw::c_char,
    pub description: *const ::std::os::raw::c_char,
    pub sfncNamespace: *const ::std::os::raw::c_char,
    pub isStreamable: VmbBool_t,
    pub hasAffectedFeatures: VmbBool_t,
    pub hasSelectedFeatures: VmbBool_t,
}
#[test]
fn bindgen_test_layout_VmbFeatureInfo() {
    assert_eq!(
        ::std::mem::size_of::<VmbFeatureInfo>(),
        96usize,
        concat!("Size of: ", stringify!(VmbFeatureInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<VmbFeatureInfo>(),
        8usize,
        concat!("Alignment of ", stringify!(VmbFeatureInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).featureDataType as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(featureDataType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).featureFlags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(featureFlags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).category as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(category)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).displayName as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(displayName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).pollingTime as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(pollingTime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).unit as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(unit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).representation as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(representation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).visibility as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(visibility)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).tooltip as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(tooltip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).description as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).sfncNamespace as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(sfncNamespace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureInfo>())).isStreamable as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(isStreamable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbFeatureInfo>())).hasAffectedFeatures as *const _ as usize
        },
        89usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(hasAffectedFeatures)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbFeatureInfo>())).hasSelectedFeatures as *const _ as usize
        },
        90usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureInfo),
            "::",
            stringify!(hasSelectedFeatures)
        )
    );
}
pub type VmbFeatureInfo_t = VmbFeatureInfo;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct VmbFeatureEnumEntry {
    pub name: *const ::std::os::raw::c_char,
    pub displayName: *const ::std::os::raw::c_char,
    pub visibility: VmbFeatureVisibility_t,
    pub tooltip: *const ::std::os::raw::c_char,
    pub description: *const ::std::os::raw::c_char,
    pub sfncNamespace: *const ::std::os::raw::c_char,
    pub intValue: VmbInt64_t,
}
#[test]
fn bindgen_test_layout_VmbFeatureEnumEntry() {
    assert_eq!(
        ::std::mem::size_of::<VmbFeatureEnumEntry>(),
        56usize,
        concat!("Size of: ", stringify!(VmbFeatureEnumEntry))
    );
    assert_eq!(
        ::std::mem::align_of::<VmbFeatureEnumEntry>(),
        8usize,
        concat!("Alignment of ", stringify!(VmbFeatureEnumEntry))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureEnumEntry>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureEnumEntry),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureEnumEntry>())).displayName as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureEnumEntry),
            "::",
            stringify!(displayName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureEnumEntry>())).visibility as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureEnumEntry),
            "::",
            stringify!(visibility)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureEnumEntry>())).tooltip as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureEnumEntry),
            "::",
            stringify!(tooltip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureEnumEntry>())).description as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureEnumEntry),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbFeatureEnumEntry>())).sfncNamespace as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureEnumEntry),
            "::",
            stringify!(sfncNamespace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFeatureEnumEntry>())).intValue as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeatureEnumEntry),
            "::",
            stringify!(intValue)
        )
    );
}
pub type VmbFeatureEnumEntry_t = VmbFeatureEnumEntry;
pub mod VmbFrameStatusType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbFrameStatusComplete: Type = 0;
    pub const VmbFrameStatusIncomplete: Type = -1;
    pub const VmbFrameStatusTooSmall: Type = -2;
    pub const VmbFrameStatusInvalid: Type = -3;
}
pub type VmbFrameStatus_t = VmbInt32_t;
impl VmbFrameFlagsType {
    pub const VmbFrameFlagsNone: VmbFrameFlagsType = VmbFrameFlagsType(0);
}
impl VmbFrameFlagsType {
    pub const VmbFrameFlagsDimension: VmbFrameFlagsType = VmbFrameFlagsType(1);
}
impl VmbFrameFlagsType {
    pub const VmbFrameFlagsOffset: VmbFrameFlagsType = VmbFrameFlagsType(2);
}
impl VmbFrameFlagsType {
    pub const VmbFrameFlagsFrameID: VmbFrameFlagsType = VmbFrameFlagsType(4);
}
impl VmbFrameFlagsType {
    pub const VmbFrameFlagsTimestamp: VmbFrameFlagsType = VmbFrameFlagsType(8);
}
impl ::std::ops::BitOr<VmbFrameFlagsType> for VmbFrameFlagsType {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        VmbFrameFlagsType(self.0 | other.0)
    }
}
impl ::std::ops::BitOrAssign for VmbFrameFlagsType {
    #[inline]
    fn bitor_assign(&mut self, rhs: VmbFrameFlagsType) {
        self.0 |= rhs.0;
    }
}
impl ::std::ops::BitAnd<VmbFrameFlagsType> for VmbFrameFlagsType {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        VmbFrameFlagsType(self.0 & other.0)
    }
}
impl ::std::ops::BitAndAssign for VmbFrameFlagsType {
    #[inline]
    fn bitand_assign(&mut self, rhs: VmbFrameFlagsType) {
        self.0 &= rhs.0;
    }
}
#[repr(transparent)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct VmbFrameFlagsType(pub ::std::os::raw::c_int);
pub type VmbFrameFlags_t = VmbUint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct VmbFrame_t {
    pub buffer: *mut ::std::os::raw::c_void,
    pub bufferSize: VmbUint32_t,
    pub context: [*mut ::std::os::raw::c_void; 4usize],
    pub receiveStatus: VmbFrameStatus_t,
    pub receiveFlags: VmbFrameFlags_t,
    pub imageSize: VmbUint32_t,
    pub ancillarySize: VmbUint32_t,
    pub pixelFormat: VmbPixelFormat_t,
    pub width: VmbUint32_t,
    pub height: VmbUint32_t,
    pub offsetX: VmbUint32_t,
    pub offsetY: VmbUint32_t,
    pub frameID: VmbUint64_t,
    pub timestamp: VmbUint64_t,
}
#[test]
fn bindgen_test_layout_VmbFrame_t() {
    assert_eq!(
        ::std::mem::size_of::<VmbFrame_t>(),
        104usize,
        concat!("Size of: ", stringify!(VmbFrame_t))
    );
    assert_eq!(
        ::std::mem::align_of::<VmbFrame_t>(),
        8usize,
        concat!("Alignment of ", stringify!(VmbFrame_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).buffer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).bufferSize as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(bufferSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).context as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(context)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).receiveStatus as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(receiveStatus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).receiveFlags as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(receiveFlags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).imageSize as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(imageSize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).ancillarySize as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(ancillarySize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).pixelFormat as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(pixelFormat)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).width as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).height as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(height)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).offsetX as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(offsetX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).offsetY as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(offsetY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).frameID as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(frameID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<VmbFrame_t>())).timestamp as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFrame_t),
            "::",
            stringify!(timestamp)
        )
    );
}
pub mod VmbFeaturePersistType {
    pub type Type = ::std::os::raw::c_int;
    pub const VmbFeaturePersistAll: Type = 0;
    pub const VmbFeaturePersistStreamable: Type = 1;
    pub const VmbFeaturePersistNoLUT: Type = 2;
}
pub type VmbFeaturePersist_t = VmbUint32_t;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct VmbFeaturePersistSettings_t {
    pub persistType: VmbFeaturePersist_t,
    pub maxIterations: VmbUint32_t,
    pub loggingLevel: VmbUint32_t,
}
#[test]
fn bindgen_test_layout_VmbFeaturePersistSettings_t() {
    assert_eq!(
        ::std::mem::size_of::<VmbFeaturePersistSettings_t>(),
        12usize,
        concat!("Size of: ", stringify!(VmbFeaturePersistSettings_t))
    );
    assert_eq!(
        ::std::mem::align_of::<VmbFeaturePersistSettings_t>(),
        4usize,
        concat!("Alignment of ", stringify!(VmbFeaturePersistSettings_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbFeaturePersistSettings_t>())).persistType as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeaturePersistSettings_t),
            "::",
            stringify!(persistType)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbFeaturePersistSettings_t>())).maxIterations as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeaturePersistSettings_t),
            "::",
            stringify!(maxIterations)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<VmbFeaturePersistSettings_t>())).loggingLevel as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(VmbFeaturePersistSettings_t),
            "::",
            stringify!(loggingLevel)
        )
    );
}
pub type VmbInvalidationCallback = ::std::option::Option<
    unsafe extern "C" fn(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pUserContext: *mut ::std::os::raw::c_void,
    ),
>;
pub type VmbFrameCallback =
    ::std::option::Option<unsafe extern "C" fn(cameraHandle: VmbHandle_t, pFrame: *mut VmbFrame_t)>;
extern "C" {
    pub fn VmbVersionQuery(
        pVersionInfo: *mut VmbVersionInfo_t,
        sizeofVersionInfo: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbStartup() -> VmbError_t;
}
extern "C" {
    pub fn VmbShutdown();
}
extern "C" {
    pub fn VmbCamerasList(
        pCameraInfo: *mut VmbCameraInfo_t,
        listLength: VmbUint32_t,
        pNumFound: *mut VmbUint32_t,
        sizeofCameraInfo: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbCameraInfoQuery(
        idString: *const ::std::os::raw::c_char,
        pInfo: *mut VmbCameraInfo_t,
        sizeofCameraInfo: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbCameraOpen(
        idString: *const ::std::os::raw::c_char,
        accessMode: VmbAccessMode_t,
        pCameraHandle: *mut VmbHandle_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbCameraClose(cameraHandle: VmbHandle_t) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeaturesList(
        handle: VmbHandle_t,
        pFeatureInfoList: *mut VmbFeatureInfo_t,
        listLength: VmbUint32_t,
        pNumFound: *mut VmbUint32_t,
        sizeofFeatureInfo: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureInfoQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pFeatureInfo: *mut VmbFeatureInfo_t,
        sizeofFeatureInfo: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureListAffected(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pFeatureInfoList: *mut VmbFeatureInfo_t,
        listLength: VmbUint32_t,
        pNumFound: *mut VmbUint32_t,
        sizeofFeatureInfo: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureListSelected(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pFeatureInfoList: *mut VmbFeatureInfo_t,
        listLength: VmbUint32_t,
        pNumFound: *mut VmbUint32_t,
        sizeofFeatureInfo: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureAccessQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pIsReadable: *mut VmbBool_t,
        pIsWriteable: *mut VmbBool_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureIntGet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pValue: *mut VmbInt64_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureIntSet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        value: VmbInt64_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureIntRangeQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pMin: *mut VmbInt64_t,
        pMax: *mut VmbInt64_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureIntIncrementQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pValue: *mut VmbInt64_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureFloatGet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pValue: *mut f64,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureFloatSet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        value: f64,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureFloatRangeQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pMin: *mut f64,
        pMax: *mut f64,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureFloatIncrementQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pHasIncrement: *mut VmbBool_t,
        pValue: *mut f64,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureEnumGet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pValue: *mut *const ::std::os::raw::c_char,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureEnumSet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureEnumRangeQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pNameArray: *mut *const ::std::os::raw::c_char,
        arrayLength: VmbUint32_t,
        pNumFilled: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureEnumIsAvailable(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        pIsAvailable: *mut VmbBool_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureEnumAsInt(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
        pIntVal: *mut VmbInt64_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureEnumAsString(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        intValue: VmbInt64_t,
        pStringValue: *mut *const ::std::os::raw::c_char,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureEnumEntryGet(
        handle: VmbHandle_t,
        featureName: *const ::std::os::raw::c_char,
        entryName: *const ::std::os::raw::c_char,
        pFeatureEnumEntry: *mut VmbFeatureEnumEntry_t,
        sizeofFeatureEnumEntry: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureStringGet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        buffer: *mut ::std::os::raw::c_char,
        bufferSize: VmbUint32_t,
        pSizeFilled: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureStringSet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureStringMaxlengthQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pMaxLength: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureBoolGet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pValue: *mut VmbBool_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureBoolSet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        value: VmbBool_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureCommandRun(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureCommandIsDone(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pIsDone: *mut VmbBool_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureRawGet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pBuffer: *mut ::std::os::raw::c_char,
        bufferSize: VmbUint32_t,
        pSizeFilled: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureRawSet(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pBuffer: *const ::std::os::raw::c_char,
        bufferSize: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureRawLengthQuery(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        pLength: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureInvalidationRegister(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        callback: VmbInvalidationCallback,
        pUserContext: *mut ::std::os::raw::c_void,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFeatureInvalidationUnregister(
        handle: VmbHandle_t,
        name: *const ::std::os::raw::c_char,
        callback: VmbInvalidationCallback,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFrameAnnounce(
        cameraHandle: VmbHandle_t,
        pFrame: *const VmbFrame_t,
        sizeofFrame: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbFrameRevoke(cameraHandle: VmbHandle_t, pFrame: *const VmbFrame_t) -> VmbError_t;
}
extern "C" {
    pub fn VmbFrameRevokeAll(cameraHandle: VmbHandle_t) -> VmbError_t;
}
extern "C" {
    pub fn VmbCaptureStart(cameraHandle: VmbHandle_t) -> VmbError_t;
}
extern "C" {
    pub fn VmbCaptureEnd(cameraHandle: VmbHandle_t) -> VmbError_t;
}
extern "C" {
    pub fn VmbCaptureFrameQueue(
        cameraHandle: VmbHandle_t,
        pFrame: *const VmbFrame_t,
        callback: VmbFrameCallback,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbCaptureFrameWait(
        cameraHandle: VmbHandle_t,
        pFrame: *const VmbFrame_t,
        timeout: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbCaptureQueueFlush(cameraHandle: VmbHandle_t) -> VmbError_t;
}
extern "C" {
    pub fn VmbInterfacesList(
        pInterfaceInfo: *mut VmbInterfaceInfo_t,
        listLength: VmbUint32_t,
        pNumFound: *mut VmbUint32_t,
        sizeofInterfaceInfo: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbInterfaceOpen(
        idString: *const ::std::os::raw::c_char,
        pInterfaceHandle: *mut VmbHandle_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbInterfaceClose(interfaceHandle: VmbHandle_t) -> VmbError_t;
}
extern "C" {
    pub fn VmbAncillaryDataOpen(
        pFrame: *mut VmbFrame_t,
        pAncillaryDataHandle: *mut VmbHandle_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbAncillaryDataClose(ancillaryDataHandle: VmbHandle_t) -> VmbError_t;
}
extern "C" {
    pub fn VmbMemoryRead(
        handle: VmbHandle_t,
        address: VmbUint64_t,
        bufferSize: VmbUint32_t,
        dataBuffer: *mut ::std::os::raw::c_char,
        pSizeComplete: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbMemoryWrite(
        handle: VmbHandle_t,
        address: VmbUint64_t,
        bufferSize: VmbUint32_t,
        dataBuffer: *const ::std::os::raw::c_char,
        pSizeComplete: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbRegistersRead(
        handle: VmbHandle_t,
        readCount: VmbUint32_t,
        pAddressArray: *const VmbUint64_t,
        pDataArray: *mut VmbUint64_t,
        pNumCompleteReads: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbRegistersWrite(
        handle: VmbHandle_t,
        writeCount: VmbUint32_t,
        pAddressArray: *const VmbUint64_t,
        pDataArray: *const VmbUint64_t,
        pNumCompleteWrites: *mut VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbCameraSettingsSave(
        handle: VmbHandle_t,
        fileName: *const ::std::os::raw::c_char,
        pSettings: *mut VmbFeaturePersistSettings_t,
        sizeofSettings: VmbUint32_t,
    ) -> VmbError_t;
}
extern "C" {
    pub fn VmbCameraSettingsLoad(
        handle: VmbHandle_t,
        fileName: *const ::std::os::raw::c_char,
        pSettings: *mut VmbFeaturePersistSettings_t,
        sizeofSettings: VmbUint32_t,
    ) -> VmbError_t;
}
