# viaspf changelog

## 0.4.0-alpha.3 (2022-01-20)

**This is a backwards-incompatible release.** The API has undergone a complete
overhaul. **This new API will freeze once 0.4.0 is released; until then changes
are still possible.**

Most importantly, the library is now asynchronous. API functions are `async` and
need to be `await`ed. If you want to continue using viaspf in a synchronous
context, you must yourself block on the future returned from these functions
using an async runtime.

In addition, inputs to the API functions are now more strongly typed. Validation
of the sender identity becomes a responsibility of the caller. See the
documentation for code examples.

The minimum Rust version is now 1.56.1.

### Added

* An asynchronous `expand_explain_string` function is now provided for
  macro-expanding *explain strings* (SPF record macro strings).

### Changed

* The minimum supported Rust version is now 1.56.1, using Rust edition 2021.
* The (synchronous) `evaluate_spf` function has been replaced with the
  new asynchronous `evaluate_sender` function. The arguments of this function
  are no longer stringly-typed, instead you must parse the inputs into the
  new argument types yourself.
* The field `QueryResult::result` has been renamed to `QueryResult::spf_result`.
* The module `viaspf::record` has been extracted into separate crate
  `viaspf-record`.
* The `Lookup` trait and supporting types are now located in module
  `viaspf::lookup`. `Lookup` now has supertraits `Send` and `Sync`.
* When the feature `trust-dns-resolver` is enabled, the trait `Lookup` is now
  implemented for the Tokio-based asynchronous
  `trust_dns_resolver::TokioAsyncResolver` instead of the synchronous
  `trust_dns_resolver::Resolver`.
* Expanding the `t` macro does no longer panic when the current system time is
  before the UNIX epoch.
* The timeout is now a precise timeout, not a best-effort approximation.
* The changelog is now maintained in a more structured format, similar to
  https://keepachangelog.com.

### Removed

* The configurable ‘default explanation’ returned in the `ExplanationString`
  when no external explanation was found has been removed. Use the new
  `expand_explain_string` function for macro-expanding an explanation.

## 0.3.2 (2021-10-18)

* Make `trust-dns-resolver` an optional dependency. When the feature
  `trust-dns-resolver` is enabled, the trait `Lookup` is implemented for
  `trust_dns_resolver::Resolver`. Such a `Resolver` can then be passed to
  `evaluate_spf` without further ceremony.

  The `spfquery` example now requires the feature `trust-dns-resolver`.

* Relax argument validation requirements when constructing a `DomainSpec`.
* Update dependencies in `Cargo.lock`.

## 0.3.1 (2021-03-10)

* Fix panic while parsing an invalid SPF record containing a non-ASCII UTF-8
  byte sequence.

## 0.3.0 (2021-01-31)

* Validate a sender address’s *local-part* more accurately in line with RFC 5321
  (instead of RFC 3696).
* Rewrite parsing implementation using standard library only, and drop
  dependency on `nom`.
* Update dev dependency `trust-dns-resolver` to version 0.20.
* Update dependencies in `Cargo.lock`.
* Increase minimum supported Rust version to 1.45.0.

## 0.2.1 (2020-12-12)

* Improve parsing of *domain-spec* tokens. Previously, an SPF record containing
  a mechanism that specified a *domain-spec* ending with a *macro-expand* token,
  followed by a CIDR prefix length (eg, `a:mail.%{d}/24`) could not be parsed.

## 0.2.0 (2020-11-03)

* (breaking change) Require that the closure passed to
  `ConfigBuilder::modify_exp_with` is `Send + Sync`. This allows `ConfigBuilder`
  and `Config` to become `Send` and `Sync`
  ([glts/viaspf#1](https://gitlab.com/glts/viaspf/-/issues/1)).
* Loosen version requirement for dev dependency `trust-dns-resolver` from an
  exact version (`=`) to the default caret version (`^`). This dependency is
  still in alpha and it makes little sense to pin a moving target.

## 0.1.0 (2020-10-22)

Initial release.
