#[repr(transparent)] 
pub struct Exception(u32);

impl Exception {
    pub fn into_result(self) -> Result<(), Error> {
        match self.0 {
            0 => {
                Ok(())
            }
            1 => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                Err(Error::IexInvalidArgument(s))
            }
            2 => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                Err(Error::IexBase(s))
            }
            3 => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                Err(Error::IexLogicError(s))
            }
            4 => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                Err(Error::IexIo(s))
            }
            5 => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                Err(Error::IexInput(s))
            }
            6 => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                Err(Error::IexOutOfMemory(s))
            }
            7 => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                Err(Error::IexInvalidType(s))
            }
            8 => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                Err(Error::IexNoPreviewImage(s))
            }

            std::u32::MAX => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                panic!("Unhandled exception: {}", s)
            }
            _ => {
                let s = unsafe { std::ffi::CStr::from_ptr(vfxpreopenexr_get_exception_string()).to_string_lossy().to_string()};
                panic!("Unexpected exception value: {} - {}", self.0, s)
            }
        }
    }
}

#[derive(Debug, PartialEq)]
pub enum Error {
    IexInvalidArgument(String),
    IexBase(String),
    IexLogicError(String),
    IexIo(String),
    IexInput(String),
    IexOutOfMemory(String),
    IexInvalidType(String),
    IexNoPreviewImage(String),
}

impl std::error::Error for Error {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        None
    }
}

use std::fmt;
impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {

        match self {
                    Error::IexInvalidArgument(s) => write!(f, "IexInvalidArgument: {}", s),
                Error::IexBase(s) => write!(f, "IexBase: {}", s),
                Error::IexLogicError(s) => write!(f, "IexLogicError: {}", s),
                Error::IexIo(s) => write!(f, "IexIo: {}", s),
                Error::IexInput(s) => write!(f, "IexInput: {}", s),
                Error::IexOutOfMemory(s) => write!(f, "IexOutOfMemory: {}", s),
                Error::IexInvalidType(s) => write!(f, "IexInvalidType: {}", s),
                Error::IexNoPreviewImage(s) => write!(f, "IexNoPreviewImage: {}", s),

        }
    }
}
extern {
    pub fn vfxpreopenexr_get_exception_string() -> *const std::os::raw::c_char;
}

pub mod std_vector;
pub use std_vector::std__vector_std__string__t as std_vector_string_t;
pub use std_vector::std__vector_float__t as std_vector_float_t;

pub use std_vector::std__vector_std__string__ctor as std_vector_string_ctor;
pub use std_vector::std__vector_std__string__dtor as std_vector_string_dtor;
pub use std_vector::std__vector_std__string__size as std_vector_string_size;
pub use std_vector::std__vector_std__string__index as std_vector_string_index;
pub use std_vector::std__vector_std__string__data as std_vector_string_data;
pub use std_vector::std__vector_std__string__data_const as std_vector_string_data_const;
pub use std_vector::std__vector_std__string__push_back as std_vector_string_push_back;
pub use std_vector::std__vector_float__ctor as std_vector_float_ctor;
pub use std_vector::std__vector_float__dtor as std_vector_float_dtor;
pub use std_vector::std__vector_float__size as std_vector_float_size;
pub use std_vector::std__vector_float__index as std_vector_float_index;
pub use std_vector::std__vector_float__data as std_vector_float_data;
pub use std_vector::std__vector_float__data_const as std_vector_float_data_const;
pub use std_vector::std__vector_float__push_back as std_vector_float_push_back;
pub mod imf_huf;

pub mod imf_keycode;
pub use imf_keycode::Imf_3_0__KeyCode_t as Imf_KeyCode_t;

pub use imf_keycode::Imf_3_0__KeyCode_sizeof as Imf_KeyCode_sizeof;
pub use imf_keycode::Imf_3_0__KeyCode_alignof as Imf_KeyCode_alignof;
pub use imf_keycode::Imf_3_0__KeyCode_ctor as Imf_KeyCode_ctor;
pub use imf_keycode::Imf_3_0__KeyCode_copy as Imf_KeyCode_copy;
pub use imf_keycode::Imf_3_0__KeyCode_dtor as Imf_KeyCode_dtor;
pub use imf_keycode::Imf_3_0__KeyCode__assign as Imf_KeyCode__assign;
pub use imf_keycode::Imf_3_0__KeyCode_filmMfcCode as Imf_KeyCode_filmMfcCode;
pub use imf_keycode::Imf_3_0__KeyCode_setFilmMfcCode as Imf_KeyCode_setFilmMfcCode;
pub use imf_keycode::Imf_3_0__KeyCode_filmType as Imf_KeyCode_filmType;
pub use imf_keycode::Imf_3_0__KeyCode_setFilmType as Imf_KeyCode_setFilmType;
pub use imf_keycode::Imf_3_0__KeyCode_prefix as Imf_KeyCode_prefix;
pub use imf_keycode::Imf_3_0__KeyCode_setPrefix as Imf_KeyCode_setPrefix;
pub use imf_keycode::Imf_3_0__KeyCode_count as Imf_KeyCode_count;
pub use imf_keycode::Imf_3_0__KeyCode_setCount as Imf_KeyCode_setCount;
pub use imf_keycode::Imf_3_0__KeyCode_perfOffset as Imf_KeyCode_perfOffset;
pub use imf_keycode::Imf_3_0__KeyCode_setPerfOffset as Imf_KeyCode_setPerfOffset;
pub use imf_keycode::Imf_3_0__KeyCode_perfsPerFrame as Imf_KeyCode_perfsPerFrame;
pub use imf_keycode::Imf_3_0__KeyCode_setPerfsPerFrame as Imf_KeyCode_setPerfsPerFrame;
pub use imf_keycode::Imf_3_0__KeyCode_perfsPerCount as Imf_KeyCode_perfsPerCount;
pub use imf_keycode::Imf_3_0__KeyCode_setPerfsPerCount as Imf_KeyCode_setPerfsPerCount;
pub mod imf_imagelevel;
pub use imf_imagelevel::Imf_3_0__ImageLevel_t as Imf_ImageLevel_t;

pub use imf_imagelevel::Imf_3_0__ImageLevel_image as Imf_ImageLevel_image;
pub use imf_imagelevel::Imf_3_0__ImageLevel_image_const as Imf_ImageLevel_image_const;
pub use imf_imagelevel::Imf_3_0__ImageLevel_xLevelNumber as Imf_ImageLevel_xLevelNumber;
pub use imf_imagelevel::Imf_3_0__ImageLevel_yLevelNumber as Imf_ImageLevel_yLevelNumber;
pub use imf_imagelevel::Imf_3_0__ImageLevel_dataWindow as Imf_ImageLevel_dataWindow;
pub mod imf_tiledescription;
pub use imf_tiledescription::Imf_3_0__TileDescription_t as Imf_TileDescription_t;

pub use imf_tiledescription::Imf_3_0__LevelMode_e as Imf_LevelMode;
pub use imf_tiledescription::Imf_LevelMode_ONE_LEVEL;
pub use imf_tiledescription::Imf_LevelMode_MIPMAP_LEVELS;
pub use imf_tiledescription::Imf_LevelMode_RIPMAP_LEVELS;
pub use imf_tiledescription::Imf_LevelMode_NUM_LEVELMODES;
pub use imf_tiledescription::LevelMode;
pub use imf_tiledescription::Imf_3_0__LevelRoundingMode_e as Imf_LevelRoundingMode;
pub use imf_tiledescription::Imf_LevelRoundingMode_ROUND_DOWN;
pub use imf_tiledescription::Imf_LevelRoundingMode_ROUND_UP;
pub use imf_tiledescription::Imf_LevelRoundingMode_NUM_ROUNDINGMODES;
pub use imf_tiledescription::LevelRoundingMode;
pub use imf_tiledescription::Imf_3_0__TileDescription_ctor as Imf_TileDescription_ctor;
pub use imf_tiledescription::Imf_3_0__TileDescription__eq as Imf_TileDescription__eq;
pub mod imf_rational;
pub use imf_rational::Imf_3_0__Rational_t as Imf_Rational_t;

pub use imf_rational::Imf_3_0__Rational_default as Imf_Rational_default;
pub use imf_rational::Imf_3_0__Rational_ctor as Imf_Rational_ctor;
pub use imf_rational::Imf_3_0__Rational_from_f64 as Imf_Rational_from_f64;
pub use imf_rational::Imf_3_0__Rational_as_f64 as Imf_Rational_as_f64;
pub mod imf_rgba;
pub use imf_rgba::Imf_3_0__Rgba_t as Imf_Rgba_t;

pub use imf_rgba::Imf_3_0__RgbaChannels_e as Imf_RgbaChannels;
pub use imf_rgba::Imf_RgbaChannels_WRITE_R;
pub use imf_rgba::Imf_RgbaChannels_WRITE_G;
pub use imf_rgba::Imf_RgbaChannels_WRITE_B;
pub use imf_rgba::Imf_RgbaChannels_WRITE_RGB;
pub use imf_rgba::Imf_RgbaChannels_WRITE_A;
pub use imf_rgba::Imf_RgbaChannels_WRITE_RGBA;
pub use imf_rgba::Imf_RgbaChannels_WRITE_Y;
pub use imf_rgba::Imf_RgbaChannels_WRITE_YA;
pub use imf_rgba::Imf_RgbaChannels_WRITE_C;
pub use imf_rgba::Imf_RgbaChannels_WRITE_YC;
pub use imf_rgba::Imf_RgbaChannels_WRITE_YCA;
pub use imf_rgba::RgbaChannels;
pub use imf_rgba::Imf_3_0__Rgba_ctor as Imf_Rgba_ctor;
pub use imf_rgba::Imf_3_0__Rgba_ctor_1 as Imf_Rgba_ctor_1;
pub use imf_rgba::Imf_3_0__Rgba_copy as Imf_Rgba_copy;
pub use imf_rgba::Imf_3_0__Rgba_move as Imf_Rgba_move;
pub use imf_rgba::Imf_3_0__Rgba_dtor as Imf_Rgba_dtor;
pub mod imf_framebuffer;
pub use imf_framebuffer::Imf_3_0__Slice_t as Imf_Slice_t;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_t as Imf_FrameBuffer_t;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__Iterator_t as Imf_FrameBuffer_Iterator_t;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator_t as Imf_FrameBuffer_ConstIterator_t;

pub use imf_framebuffer::Imf_3_0__Slice_sizeof as Imf_Slice_sizeof;
pub use imf_framebuffer::Imf_3_0__Slice_alignof as Imf_Slice_alignof;
pub use imf_framebuffer::Imf_3_0__Slice_ctor as Imf_Slice_ctor;
pub use imf_framebuffer::Imf_3_0__Slice_with_origin_1 as Imf_Slice_with_origin;
pub use imf_framebuffer::Imf_3_0__Slice_with_window_1 as Imf_Slice_with_window;
pub use imf_framebuffer::Imf_3_0__Slice_dtor as Imf_Slice_dtor;
pub use imf_framebuffer::Imf_3_0__Slice_copy as Imf_Slice_copy;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_insert as Imf_FrameBuffer_insert;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_findSlice as Imf_FrameBuffer_findSlice;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_findSlice_const as Imf_FrameBuffer_findSlice_const;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_begin as Imf_FrameBuffer_begin;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_begin_const as Imf_FrameBuffer_begin_const;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_end as Imf_FrameBuffer_end;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_end_const as Imf_FrameBuffer_end_const;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_find as Imf_FrameBuffer_find;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_find_1 as Imf_FrameBuffer_find_1;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_copy as Imf_FrameBuffer_copy;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_dtor as Imf_FrameBuffer_dtor;
pub use imf_framebuffer::Imf_3_0__FrameBuffer_ctor as Imf_FrameBuffer_ctor;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__Iterator_sizeof as Imf_FrameBuffer_Iterator_sizeof;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__Iterator_alignof as Imf_FrameBuffer_Iterator_alignof;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__Iterator_ctor as Imf_FrameBuffer_Iterator_ctor;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__Iterator__op_inc as Imf_FrameBuffer_Iterator__op_inc;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__Iterator_name as Imf_FrameBuffer_Iterator_name;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__Iterator_slice as Imf_FrameBuffer_Iterator_slice;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__Iterator_copy as Imf_FrameBuffer_Iterator_copy;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator_sizeof as Imf_FrameBuffer_ConstIterator_sizeof;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator_alignof as Imf_FrameBuffer_ConstIterator_alignof;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator_ctor as Imf_FrameBuffer_ConstIterator_ctor;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator_from_mut as Imf_FrameBuffer_ConstIterator_from_mut;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator__op_inc as Imf_FrameBuffer_ConstIterator__op_inc;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator_name as Imf_FrameBuffer_ConstIterator_name;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator_slice as Imf_FrameBuffer_ConstIterator_slice;
pub use imf_framebuffer::Imf_3_0__FrameBuffer__ConstIterator_copy as Imf_FrameBuffer_ConstIterator_copy;
pub use imf_framebuffer::Imf_3_0_frame_buffer_const_iter_eq as Imf_frame_buffer_const_iter_eq;
pub mod imf_deepscanlineoutputfile;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_t as Imf_DeepScanLineOutputFile_t;

pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_ctor as Imf_DeepScanLineOutputFile_ctor;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_dtor as Imf_DeepScanLineOutputFile_dtor;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_fileName as Imf_DeepScanLineOutputFile_fileName;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_header as Imf_DeepScanLineOutputFile_header;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_setFrameBuffer as Imf_DeepScanLineOutputFile_setFrameBuffer;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_frameBuffer as Imf_DeepScanLineOutputFile_frameBuffer;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_writePixels as Imf_DeepScanLineOutputFile_writePixels;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_currentScanLine as Imf_DeepScanLineOutputFile_currentScanLine;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_copyPixels_from_file as Imf_DeepScanLineOutputFile_copyPixels_from_file;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_copyPixels_from_part as Imf_DeepScanLineOutputFile_copyPixels_from_part;
pub use imf_deepscanlineoutputfile::Imf_3_0__DeepScanLineOutputFile_updatePreviewImage as Imf_DeepScanLineOutputFile_updatePreviewImage;
pub mod imf_flatimageio;

pub use imf_flatimageio::Imf_3_0_saveFlatImage_with_header as Imf_saveFlatImage_with_header;
pub use imf_flatimageio::Imf_3_0_saveFlatImage as Imf_saveFlatImage;
pub use imf_flatimageio::Imf_3_0_loadFlatImage_with_header as Imf_loadFlatImage_with_header;
pub use imf_flatimageio::Imf_3_0_loadFlatImage as Imf_loadFlatImage;
pub use imf_flatimageio::Imf_3_0_saveFlatScanLineImage_with_header as Imf_saveFlatScanLineImage_with_header;
pub use imf_flatimageio::Imf_3_0_saveFlatScanLineImage as Imf_saveFlatScanLineImage;
pub use imf_flatimageio::Imf_3_0_loadFlatScanLineImage_with_header as Imf_loadFlatScanLineImage_with_header;
pub use imf_flatimageio::Imf_3_0_loadFlatScanLineImage as Imf_loadFlatScanLineImage;
pub use imf_flatimageio::Imf_3_0_saveFlatTiledImage_with_header as Imf_saveFlatTiledImage_with_header;
pub use imf_flatimageio::Imf_3_0_saveFlatTiledImage as Imf_saveFlatTiledImage;
pub use imf_flatimageio::Imf_3_0_loadFlatTiledImage_with_header as Imf_loadFlatTiledImage_with_header;
pub use imf_flatimageio::Imf_3_0_loadFlatTiledImage as Imf_loadFlatTiledImage;
pub mod imf_wav;

pub use imf_wav::Imf_3_0_wav2Encode as Imf_wav2Encode;
pub use imf_wav::Imf_3_0_wav2Decode as Imf_wav2Decode;
pub mod imf_deepscanlineinputpart;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_t as Imf_DeepScanLineInputPart_t;

pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_sizeof as Imf_DeepScanLineInputPart_sizeof;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_alignof as Imf_DeepScanLineInputPart_alignof;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_ctor as Imf_DeepScanLineInputPart_ctor;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_fileName as Imf_DeepScanLineInputPart_fileName;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_header as Imf_DeepScanLineInputPart_header;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_version as Imf_DeepScanLineInputPart_version;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_setFrameBuffer as Imf_DeepScanLineInputPart_setFrameBuffer;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_frameBuffer as Imf_DeepScanLineInputPart_frameBuffer;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_isComplete as Imf_DeepScanLineInputPart_isComplete;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_readPixels as Imf_DeepScanLineInputPart_readPixels;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_readPixels_from_frame_buffer as Imf_DeepScanLineInputPart_readPixels_from_frame_buffer;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_rawPixelData as Imf_DeepScanLineInputPart_rawPixelData;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_readPixelSampleCounts as Imf_DeepScanLineInputPart_readPixelSampleCounts;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_readPixelSampleCounts_into_frame_buffer as Imf_DeepScanLineInputPart_readPixelSampleCounts_into_frame_buffer;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_firstScanLineInChunk as Imf_DeepScanLineInputPart_firstScanLineInChunk;
pub use imf_deepscanlineinputpart::Imf_3_0__DeepScanLineInputPart_lastScanLineInChunk as Imf_DeepScanLineInputPart_lastScanLineInChunk;
pub mod imf_deeptiledinputfile;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_t as Imf_DeepTiledInputFile_t;

pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_ctor as Imf_DeepTiledInputFile_ctor;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_from_stream as Imf_DeepTiledInputFile_from_stream;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_dtor as Imf_DeepTiledInputFile_dtor;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_fileName as Imf_DeepTiledInputFile_fileName;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_header as Imf_DeepTiledInputFile_header;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_version as Imf_DeepTiledInputFile_version;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_setFrameBuffer as Imf_DeepTiledInputFile_setFrameBuffer;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_frameBuffer as Imf_DeepTiledInputFile_frameBuffer;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_isComplete as Imf_DeepTiledInputFile_isComplete;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_tileXSize as Imf_DeepTiledInputFile_tileXSize;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_tileYSize as Imf_DeepTiledInputFile_tileYSize;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_levelMode as Imf_DeepTiledInputFile_levelMode;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_levelRoundingMode as Imf_DeepTiledInputFile_levelRoundingMode;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_numLevels as Imf_DeepTiledInputFile_numLevels;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_numXLevels as Imf_DeepTiledInputFile_numXLevels;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_numYLevels as Imf_DeepTiledInputFile_numYLevels;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_isValidLevel as Imf_DeepTiledInputFile_isValidLevel;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_totalTiles as Imf_DeepTiledInputFile_totalTiles;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_levelWidth as Imf_DeepTiledInputFile_levelWidth;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_levelHeight as Imf_DeepTiledInputFile_levelHeight;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_numXTiles as Imf_DeepTiledInputFile_numXTiles;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_numYTiles as Imf_DeepTiledInputFile_numYTiles;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_dataWindowForLevel as Imf_DeepTiledInputFile_dataWindowForLevel;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_dataWindowForTile as Imf_DeepTiledInputFile_dataWindowForTile;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_readTile as Imf_DeepTiledInputFile_readTile;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_readTiles as Imf_DeepTiledInputFile_readTiles;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_rawTileData as Imf_DeepTiledInputFile_rawTileData;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_readPixelSampleCount as Imf_DeepTiledInputFile_readPixelSampleCount;
pub use imf_deeptiledinputfile::Imf_3_0__DeepTiledInputFile_readPixelSampleCounts as Imf_DeepTiledInputFile_readPixelSampleCounts;
pub mod imf_framespersecond;

pub use imf_framespersecond::Imf_3_0_fps_23_976 as Imf_fps_23_976;
pub use imf_framespersecond::Imf_3_0_fps_24 as Imf_fps_24;
pub use imf_framespersecond::Imf_3_0_fps_25 as Imf_fps_25;
pub use imf_framespersecond::Imf_3_0_fps_29_97 as Imf_fps_29_97;
pub use imf_framespersecond::Imf_3_0_fps_30 as Imf_fps_30;
pub use imf_framespersecond::Imf_3_0_fps_47_952 as Imf_fps_47_952;
pub use imf_framespersecond::Imf_3_0_fps_48 as Imf_fps_48;
pub use imf_framespersecond::Imf_3_0_fps_50 as Imf_fps_50;
pub use imf_framespersecond::Imf_3_0_fps_59_94 as Imf_fps_59_94;
pub use imf_framespersecond::Imf_3_0_fps_60 as Imf_fps_60;
pub use imf_framespersecond::Imf_3_0_guessExactFps_f64 as Imf_guessExactFps_f64;
pub use imf_framespersecond::Imf_3_0_guessExactFps as Imf_guessExactFps;
pub mod imf_io;
pub use imf_io::Imf_3_0__OStream_t as Imf_OStream_t;
pub use imf_io::Imf_3_0__IStream_t as Imf_IStream_t;

pub use imf_io::Imf_3_0__OStream_dtor as Imf_OStream_dtor;
pub use imf_io::Imf_3_0__OStream_write as Imf_OStream_write;
pub use imf_io::Imf_3_0__OStream_tellp as Imf_OStream_tellp;
pub use imf_io::Imf_3_0__OStream_seekp as Imf_OStream_seekp;
pub use imf_io::Imf_3_0__OStream_fileName as Imf_OStream_fileName;
pub use imf_io::Imf_3_0__IStream_dtor as Imf_IStream_dtor;
pub use imf_io::Imf_3_0__IStream_isMemoryMapped as Imf_IStream_isMemoryMapped;
pub use imf_io::Imf_3_0__IStream_read as Imf_IStream_read;
pub use imf_io::Imf_3_0__IStream_readMemoryMapped as Imf_IStream_readMemoryMapped;
pub use imf_io::Imf_3_0__IStream_tellg as Imf_IStream_tellg;
pub use imf_io::Imf_3_0__IStream_seekg as Imf_IStream_seekg;
pub use imf_io::Imf_3_0__IStream_clear as Imf_IStream_clear;
pub use imf_io::Imf_3_0__IStream_fileName as Imf_IStream_fileName;
pub mod imf_outputpart;
pub use imf_outputpart::Imf_3_0__OutputPart_t as Imf_OutputPart_t;

pub use imf_outputpart::Imf_3_0__OutputPart_sizeof as Imf_OutputPart_sizeof;
pub use imf_outputpart::Imf_3_0__OutputPart_alignof as Imf_OutputPart_alignof;
pub use imf_outputpart::Imf_3_0__OutputPart_ctor as Imf_OutputPart_ctor;
pub use imf_outputpart::Imf_3_0__OutputPart_fileName as Imf_OutputPart_fileName;
pub use imf_outputpart::Imf_3_0__OutputPart_header as Imf_OutputPart_header;
pub use imf_outputpart::Imf_3_0__OutputPart_setFrameBuffer as Imf_OutputPart_setFrameBuffer;
pub use imf_outputpart::Imf_3_0__OutputPart_frameBuffer as Imf_OutputPart_frameBuffer;
pub use imf_outputpart::Imf_3_0__OutputPart_writePixels as Imf_OutputPart_writePixels;
pub use imf_outputpart::Imf_3_0__OutputPart_currentScanLine as Imf_OutputPart_currentScanLine;
pub use imf_outputpart::Imf_3_0__OutputPart_copyPixels_from_file as Imf_OutputPart_copyPixels_from_file;
pub use imf_outputpart::Imf_3_0__OutputPart_copyPixels_from_part as Imf_OutputPart_copyPixels_from_part;
pub use imf_outputpart::Imf_3_0__OutputPart_updatePreviewImage as Imf_OutputPart_updatePreviewImage;
pub use imf_outputpart::Imf_3_0__OutputPart_breakScanLine as Imf_OutputPart_breakScanLine;
pub mod imf_lut;
pub use imf_lut::Imf_3_0__HalfLut_t as Imf_HalfLut_t;
pub use imf_lut::Imf_3_0__RgbaLut_t as Imf_RgbaLut_t;

pub use imf_lut::Imf_3_0__HalfLut_apply as Imf_HalfLut_apply;
pub use imf_lut::Imf_3_0__HalfLut_apply_1 as Imf_HalfLut_apply_1;
pub use imf_lut::Imf_3_0__HalfLut_dtor as Imf_HalfLut_dtor;
pub use imf_lut::Imf_3_0__RgbaLut_apply as Imf_RgbaLut_apply;
pub use imf_lut::Imf_3_0__RgbaLut_apply_1 as Imf_RgbaLut_apply_1;
pub use imf_lut::Imf_3_0__RgbaLut_dtor as Imf_RgbaLut_dtor;
pub mod imf_envmap;

pub use imf_envmap::Imf_3_0__Envmap_e as Imf_Envmap;
pub use imf_envmap::Imf_Envmap_ENVMAP_LATLONG;
pub use imf_envmap::Imf_Envmap_ENVMAP_CUBE;
pub use imf_envmap::Imf_Envmap_NUM_ENVMAPTYPES;
pub use imf_envmap::Envmap;
pub use imf_envmap::Imf_3_0__CubeMapFace_e as Imf_CubeMapFace;
pub use imf_envmap::Imf_CubeMapFace_CUBEFACE_POS_X;
pub use imf_envmap::Imf_CubeMapFace_CUBEFACE_NEG_X;
pub use imf_envmap::Imf_CubeMapFace_CUBEFACE_POS_Y;
pub use imf_envmap::Imf_CubeMapFace_CUBEFACE_NEG_Y;
pub use imf_envmap::Imf_CubeMapFace_CUBEFACE_POS_Z;
pub use imf_envmap::Imf_CubeMapFace_CUBEFACE_NEG_Z;
pub use imf_envmap::CubeMapFace;
pub use imf_envmap::Imf_3_0_LatLongMap_latlong_from_direction as Imf_LatLongMap_latlong_from_direction;
pub use imf_envmap::Imf_3_0_LatLongMap_latlong_from_pixel_position as Imf_LatLongMap_latlong_from_pixel_position;
pub use imf_envmap::Imf_3_0_LatLongMap_pixelPosition_from_latlong as Imf_LatLongMap_pixelPosition_from_latlong;
pub use imf_envmap::Imf_3_0_LatLongMap_pixelPosition_from_direction as Imf_LatLongMap_pixelPosition_from_direction;
pub use imf_envmap::Imf_3_0_LatLongMap_direction_from_pixel_position as Imf_LatLongMap_direction_from_pixel_position;
pub use imf_envmap::Imf_3_0_CubeMap_sizeOfFace as Imf_CubeMap_sizeOfFace;
pub use imf_envmap::Imf_3_0_CubeMap_dataWindowForFace as Imf_CubeMap_dataWindowForFace;
pub use imf_envmap::Imf_3_0_CubeMap_pixelPosition_from_position_in_face as Imf_CubeMap_pixelPosition_from_position_in_face;
pub use imf_envmap::Imf_3_0_CubeMap_faceAndPixelPosition_from_direction as Imf_CubeMap_faceAndPixelPosition_from_direction;
pub use imf_envmap::Imf_3_0_CubeMap_direction_from_position_in_face as Imf_CubeMap_direction_from_position_in_face;
pub mod imath_matrix;
pub use imath_matrix::Imath_3_0__Matrix33_float__t as Imath_M33f_t;
pub use imath_matrix::Imath_3_0__Matrix33_double__t as Imath_M33d_t;
pub use imath_matrix::Imath_3_0__Matrix44_float__t as Imath_M44f_t;
pub use imath_matrix::Imath_3_0__Matrix44_double__t as Imath_M44d_t;

pub use imath_matrix::Imath_3_0__Uninitialized_e as Imath_Uninitialized;
pub use imath_matrix::Imath_Uninitialized_UNINITIALIZED;
pub use imath_matrix::Imath_3_0__Matrix33_float__row as Imath_M33f_row;
pub use imath_matrix::Imath_3_0__Matrix33_float__row_const as Imath_M33f_row_const;
pub use imath_matrix::Imath_3_0__Matrix33_float__uninitialized as Imath_M33f_uninitialized;
pub use imath_matrix::Imath_3_0__Matrix33_float__identity as Imath_M33f_identity;
pub use imath_matrix::Imath_3_0__Matrix33_float__broadcast as Imath_M33f_broadcast;
pub use imath_matrix::Imath_3_0__Matrix33_float__from_array as Imath_M33f_from_array;
pub use imath_matrix::Imath_3_0__Matrix33_float__ctor as Imath_M33f_ctor;
pub use imath_matrix::Imath_3_0__Matrix33_float__ctor_1 as Imath_M33f_ctor_1;
pub use imath_matrix::Imath_3_0__Matrix33_float___assign as Imath_M33f__assign;
pub use imath_matrix::Imath_3_0__Matrix33_float__dtor as Imath_M33f_dtor;
pub use imath_matrix::Imath_3_0__Matrix33_float__getValue as Imath_M33f_getValue;
pub use imath_matrix::Imath_3_0__Matrix33_float__getValue_const as Imath_M33f_getValue_const;
pub use imath_matrix::Imath_3_0__Matrix33_float___eq as Imath_M33f__eq;
pub use imath_matrix::Imath_3_0__Matrix33_float___ne as Imath_M33f__ne;
pub use imath_matrix::Imath_3_0__Matrix33_float__equalWithAbsError as Imath_M33f_equalWithAbsError;
pub use imath_matrix::Imath_3_0__Matrix33_float__equalWithRelError as Imath_M33f_equalWithRelError;
pub use imath_matrix::Imath_3_0__Matrix33_float___op_iadd as Imath_M33f__op_iadd;
pub use imath_matrix::Imath_3_0__Matrix33_float__add_assign_scalar as Imath_M33f_add_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_float___op_add as Imath_M33f__op_add;
pub use imath_matrix::Imath_3_0__Matrix33_float___op_isub as Imath_M33f__op_isub;
pub use imath_matrix::Imath_3_0__Matrix33_float__sub_assign_scalar as Imath_M33f_sub_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_float___op_sub as Imath_M33f__op_sub;
pub use imath_matrix::Imath_3_0__Matrix33_float___op_sub_1 as Imath_M33f__op_sub_1;
pub use imath_matrix::Imath_3_0__Matrix33_float__negate as Imath_M33f_negate;
pub use imath_matrix::Imath_3_0__Matrix33_float__mul_assign_scalar as Imath_M33f_mul_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_float__mul_scalar as Imath_M33f_mul_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_float__div_assign_scalar as Imath_M33f_div_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_float__div_scalar as Imath_M33f_div_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_float___op_imul as Imath_M33f__op_imul;
pub use imath_matrix::Imath_3_0__Matrix33_float___op_mul as Imath_M33f__op_mul;
pub use imath_matrix::Imath_3_0__Matrix33_float__makeIdentity as Imath_M33f_makeIdentity;
pub use imath_matrix::Imath_3_0__Matrix33_float__transpose as Imath_M33f_transpose;
pub use imath_matrix::Imath_3_0__Matrix33_float__transposed as Imath_M33f_transposed;
pub use imath_matrix::Imath_3_0__Matrix33_float__invert as Imath_M33f_invert;
pub use imath_matrix::Imath_3_0__Matrix33_float__inverse as Imath_M33f_inverse;
pub use imath_matrix::Imath_3_0__Matrix33_float__gjInvert as Imath_M33f_gjInvert;
pub use imath_matrix::Imath_3_0__Matrix33_float__gjInverse as Imath_M33f_gjInverse;
pub use imath_matrix::Imath_3_0__Matrix33_float__minorOf as Imath_M33f_minorOf;
pub use imath_matrix::Imath_3_0__Matrix33_float__fastMinor as Imath_M33f_fastMinor;
pub use imath_matrix::Imath_3_0__Matrix33_float__determinant as Imath_M33f_determinant;
pub use imath_matrix::Imath_3_0__Matrix33_float__setScale as Imath_M33f_setScale;
pub use imath_matrix::Imath_3_0__Matrix33_float__translation as Imath_M33f_translation;
pub use imath_matrix::Imath_3_0__Matrix33_float__baseTypeLowest_1 as Imath_M33f_baseTypeLowest;
pub use imath_matrix::Imath_3_0__Matrix33_float__baseTypeMax_1 as Imath_M33f_baseTypeMax;
pub use imath_matrix::Imath_3_0__Matrix33_float__baseTypeSmallest_1 as Imath_M33f_baseTypeSmallest;
pub use imath_matrix::Imath_3_0__Matrix33_float__baseTypeEpsilon_1 as Imath_M33f_baseTypeEpsilon;
pub use imath_matrix::Imath_3_0__Matrix33_float__dimensions_1 as Imath_M33f_dimensions;
pub use imath_matrix::Imath_3_0__Matrix33_double__row as Imath_M33d_row;
pub use imath_matrix::Imath_3_0__Matrix33_double__row_const as Imath_M33d_row_const;
pub use imath_matrix::Imath_3_0__Matrix33_double__uninitialized as Imath_M33d_uninitialized;
pub use imath_matrix::Imath_3_0__Matrix33_double__identity as Imath_M33d_identity;
pub use imath_matrix::Imath_3_0__Matrix33_double__broadcast as Imath_M33d_broadcast;
pub use imath_matrix::Imath_3_0__Matrix33_double__from_array as Imath_M33d_from_array;
pub use imath_matrix::Imath_3_0__Matrix33_double__ctor as Imath_M33d_ctor;
pub use imath_matrix::Imath_3_0__Matrix33_double__ctor_1 as Imath_M33d_ctor_1;
pub use imath_matrix::Imath_3_0__Matrix33_double___assign as Imath_M33d__assign;
pub use imath_matrix::Imath_3_0__Matrix33_double__dtor as Imath_M33d_dtor;
pub use imath_matrix::Imath_3_0__Matrix33_double__getValue as Imath_M33d_getValue;
pub use imath_matrix::Imath_3_0__Matrix33_double__getValue_const as Imath_M33d_getValue_const;
pub use imath_matrix::Imath_3_0__Matrix33_double___eq as Imath_M33d__eq;
pub use imath_matrix::Imath_3_0__Matrix33_double___ne as Imath_M33d__ne;
pub use imath_matrix::Imath_3_0__Matrix33_double__equalWithAbsError as Imath_M33d_equalWithAbsError;
pub use imath_matrix::Imath_3_0__Matrix33_double__equalWithRelError as Imath_M33d_equalWithRelError;
pub use imath_matrix::Imath_3_0__Matrix33_double___op_iadd as Imath_M33d__op_iadd;
pub use imath_matrix::Imath_3_0__Matrix33_double__add_assign_scalar as Imath_M33d_add_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_double___op_add as Imath_M33d__op_add;
pub use imath_matrix::Imath_3_0__Matrix33_double___op_isub as Imath_M33d__op_isub;
pub use imath_matrix::Imath_3_0__Matrix33_double__sub_assign_scalar as Imath_M33d_sub_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_double___op_sub as Imath_M33d__op_sub;
pub use imath_matrix::Imath_3_0__Matrix33_double___op_sub_1 as Imath_M33d__op_sub_1;
pub use imath_matrix::Imath_3_0__Matrix33_double__negate as Imath_M33d_negate;
pub use imath_matrix::Imath_3_0__Matrix33_double__mul_assign_scalar as Imath_M33d_mul_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_double__mul_scalar as Imath_M33d_mul_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_double__div_assign_scalar as Imath_M33d_div_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_double__div_scalar as Imath_M33d_div_scalar;
pub use imath_matrix::Imath_3_0__Matrix33_double___op_imul as Imath_M33d__op_imul;
pub use imath_matrix::Imath_3_0__Matrix33_double___op_mul as Imath_M33d__op_mul;
pub use imath_matrix::Imath_3_0__Matrix33_double__makeIdentity as Imath_M33d_makeIdentity;
pub use imath_matrix::Imath_3_0__Matrix33_double__transpose as Imath_M33d_transpose;
pub use imath_matrix::Imath_3_0__Matrix33_double__transposed as Imath_M33d_transposed;
pub use imath_matrix::Imath_3_0__Matrix33_double__invert as Imath_M33d_invert;
pub use imath_matrix::Imath_3_0__Matrix33_double__inverse as Imath_M33d_inverse;
pub use imath_matrix::Imath_3_0__Matrix33_double__gjInvert as Imath_M33d_gjInvert;
pub use imath_matrix::Imath_3_0__Matrix33_double__gjInverse as Imath_M33d_gjInverse;
pub use imath_matrix::Imath_3_0__Matrix33_double__minorOf as Imath_M33d_minorOf;
pub use imath_matrix::Imath_3_0__Matrix33_double__fastMinor as Imath_M33d_fastMinor;
pub use imath_matrix::Imath_3_0__Matrix33_double__determinant as Imath_M33d_determinant;
pub use imath_matrix::Imath_3_0__Matrix33_double__setScale as Imath_M33d_setScale;
pub use imath_matrix::Imath_3_0__Matrix33_double__translation as Imath_M33d_translation;
pub use imath_matrix::Imath_3_0__Matrix33_double__baseTypeLowest_1 as Imath_M33d_baseTypeLowest;
pub use imath_matrix::Imath_3_0__Matrix33_double__baseTypeMax_1 as Imath_M33d_baseTypeMax;
pub use imath_matrix::Imath_3_0__Matrix33_double__baseTypeSmallest_1 as Imath_M33d_baseTypeSmallest;
pub use imath_matrix::Imath_3_0__Matrix33_double__baseTypeEpsilon_1 as Imath_M33d_baseTypeEpsilon;
pub use imath_matrix::Imath_3_0__Matrix33_double__dimensions_1 as Imath_M33d_dimensions;
pub use imath_matrix::Imath_3_0__Matrix44_float__row as Imath_M44f_row;
pub use imath_matrix::Imath_3_0__Matrix44_float__row_const as Imath_M44f_row_const;
pub use imath_matrix::Imath_3_0__Matrix44_float__uninitialized as Imath_M44f_uninitialized;
pub use imath_matrix::Imath_3_0__Matrix44_float__identity as Imath_M44f_identity;
pub use imath_matrix::Imath_3_0__Matrix44_float__broadcast as Imath_M44f_broadcast;
pub use imath_matrix::Imath_3_0__Matrix44_float__from_array as Imath_M44f_from_array;
pub use imath_matrix::Imath_3_0__Matrix44_float__ctor as Imath_M44f_ctor;
pub use imath_matrix::Imath_3_0__Matrix44_float__from_rotation_and_translation as Imath_M44f_from_rotation_and_translation;
pub use imath_matrix::Imath_3_0__Matrix44_float__ctor_1 as Imath_M44f_ctor_1;
pub use imath_matrix::Imath_3_0__Matrix44_float___assign as Imath_M44f__assign;
pub use imath_matrix::Imath_3_0__Matrix44_float__dtor as Imath_M44f_dtor;
pub use imath_matrix::Imath_3_0__Matrix44_float__getValue as Imath_M44f_getValue;
pub use imath_matrix::Imath_3_0__Matrix44_float__getValue_1 as Imath_M44f_getValue_1;
pub use imath_matrix::Imath_3_0__Matrix44_float___eq as Imath_M44f__eq;
pub use imath_matrix::Imath_3_0__Matrix44_float___ne as Imath_M44f__ne;
pub use imath_matrix::Imath_3_0__Matrix44_float__equalWithAbsError as Imath_M44f_equalWithAbsError;
pub use imath_matrix::Imath_3_0__Matrix44_float__equalWithRelError as Imath_M44f_equalWithRelError;
pub use imath_matrix::Imath_3_0__Matrix44_float___op_iadd as Imath_M44f__op_iadd;
pub use imath_matrix::Imath_3_0__Matrix44_float__add_assign_scalar as Imath_M44f_add_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_float___op_add as Imath_M44f__op_add;
pub use imath_matrix::Imath_3_0__Matrix44_float___op_isub as Imath_M44f__op_isub;
pub use imath_matrix::Imath_3_0__Matrix44_float__sub_assign_scalar as Imath_M44f_sub_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_float___op_sub as Imath_M44f__op_sub;
pub use imath_matrix::Imath_3_0__Matrix44_float___op_sub_1 as Imath_M44f__op_sub_1;
pub use imath_matrix::Imath_3_0__Matrix44_float__negate as Imath_M44f_negate;
pub use imath_matrix::Imath_3_0__Matrix44_float__mul_assign_scalar as Imath_M44f_mul_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_float__mul_scalar as Imath_M44f_mul_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_float__div_assign_scalar as Imath_M44f_div_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_float__div_scalar as Imath_M44f_div_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_float___op_imul as Imath_M44f__op_imul;
pub use imath_matrix::Imath_3_0__Matrix44_float___op_mul as Imath_M44f__op_mul;
pub use imath_matrix::Imath_3_0__Matrix44_float__multiply_1 as Imath_M44f_multiply;
pub use imath_matrix::Imath_3_0__Matrix44_float__makeIdentity as Imath_M44f_makeIdentity;
pub use imath_matrix::Imath_3_0__Matrix44_float__transpose as Imath_M44f_transpose;
pub use imath_matrix::Imath_3_0__Matrix44_float__transposed as Imath_M44f_transposed;
pub use imath_matrix::Imath_3_0__Matrix44_float__invert as Imath_M44f_invert;
pub use imath_matrix::Imath_3_0__Matrix44_float__inverse as Imath_M44f_inverse;
pub use imath_matrix::Imath_3_0__Matrix44_float__gjInvert as Imath_M44f_gjInvert;
pub use imath_matrix::Imath_3_0__Matrix44_float__gjInverse as Imath_M44f_gjInverse;
pub use imath_matrix::Imath_3_0__Matrix44_float__minorOf as Imath_M44f_minorOf;
pub use imath_matrix::Imath_3_0__Matrix44_float__fastMinor as Imath_M44f_fastMinor;
pub use imath_matrix::Imath_3_0__Matrix44_float__determinant as Imath_M44f_determinant;
pub use imath_matrix::Imath_3_0__Matrix44_float__setScale_uniform as Imath_M44f_setScale_uniform;
pub use imath_matrix::Imath_3_0__Matrix44_float__translation as Imath_M44f_translation;
pub use imath_matrix::Imath_3_0__Matrix44_float__baseTypeLowest_1 as Imath_M44f_baseTypeLowest;
pub use imath_matrix::Imath_3_0__Matrix44_float__baseTypeMax_1 as Imath_M44f_baseTypeMax;
pub use imath_matrix::Imath_3_0__Matrix44_float__baseTypeSmallest_1 as Imath_M44f_baseTypeSmallest;
pub use imath_matrix::Imath_3_0__Matrix44_float__baseTypeEpsilon_1 as Imath_M44f_baseTypeEpsilon;
pub use imath_matrix::Imath_3_0__Matrix44_float__dimensions_1 as Imath_M44f_dimensions;
pub use imath_matrix::Imath_3_0__Matrix44_double__row as Imath_M44d_row;
pub use imath_matrix::Imath_3_0__Matrix44_double__row_const as Imath_M44d_row_const;
pub use imath_matrix::Imath_3_0__Matrix44_double__uninitialized as Imath_M44d_uninitialized;
pub use imath_matrix::Imath_3_0__Matrix44_double__identity as Imath_M44d_identity;
pub use imath_matrix::Imath_3_0__Matrix44_double__broadcast as Imath_M44d_broadcast;
pub use imath_matrix::Imath_3_0__Matrix44_double__from_array as Imath_M44d_from_array;
pub use imath_matrix::Imath_3_0__Matrix44_double__ctor as Imath_M44d_ctor;
pub use imath_matrix::Imath_3_0__Matrix44_double__from_rotation_and_translation as Imath_M44d_from_rotation_and_translation;
pub use imath_matrix::Imath_3_0__Matrix44_double__ctor_1 as Imath_M44d_ctor_1;
pub use imath_matrix::Imath_3_0__Matrix44_double___assign as Imath_M44d__assign;
pub use imath_matrix::Imath_3_0__Matrix44_double__dtor as Imath_M44d_dtor;
pub use imath_matrix::Imath_3_0__Matrix44_double__getValue as Imath_M44d_getValue;
pub use imath_matrix::Imath_3_0__Matrix44_double__getValue_1 as Imath_M44d_getValue_1;
pub use imath_matrix::Imath_3_0__Matrix44_double___eq as Imath_M44d__eq;
pub use imath_matrix::Imath_3_0__Matrix44_double___ne as Imath_M44d__ne;
pub use imath_matrix::Imath_3_0__Matrix44_double__equalWithAbsError as Imath_M44d_equalWithAbsError;
pub use imath_matrix::Imath_3_0__Matrix44_double__equalWithRelError as Imath_M44d_equalWithRelError;
pub use imath_matrix::Imath_3_0__Matrix44_double___op_iadd as Imath_M44d__op_iadd;
pub use imath_matrix::Imath_3_0__Matrix44_double__add_assign_scalar as Imath_M44d_add_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_double___op_add as Imath_M44d__op_add;
pub use imath_matrix::Imath_3_0__Matrix44_double___op_isub as Imath_M44d__op_isub;
pub use imath_matrix::Imath_3_0__Matrix44_double__sub_assign_scalar as Imath_M44d_sub_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_double___op_sub as Imath_M44d__op_sub;
pub use imath_matrix::Imath_3_0__Matrix44_double___op_sub_1 as Imath_M44d__op_sub_1;
pub use imath_matrix::Imath_3_0__Matrix44_double__negate as Imath_M44d_negate;
pub use imath_matrix::Imath_3_0__Matrix44_double__mul_assign_scalar as Imath_M44d_mul_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_double__mul_scalar as Imath_M44d_mul_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_double__div_assign_scalar as Imath_M44d_div_assign_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_double__div_scalar as Imath_M44d_div_scalar;
pub use imath_matrix::Imath_3_0__Matrix44_double___op_imul as Imath_M44d__op_imul;
pub use imath_matrix::Imath_3_0__Matrix44_double___op_mul as Imath_M44d__op_mul;
pub use imath_matrix::Imath_3_0__Matrix44_double__multiply_1 as Imath_M44d_multiply;
pub use imath_matrix::Imath_3_0__Matrix44_double__makeIdentity as Imath_M44d_makeIdentity;
pub use imath_matrix::Imath_3_0__Matrix44_double__transpose as Imath_M44d_transpose;
pub use imath_matrix::Imath_3_0__Matrix44_double__transposed as Imath_M44d_transposed;
pub use imath_matrix::Imath_3_0__Matrix44_double__invert as Imath_M44d_invert;
pub use imath_matrix::Imath_3_0__Matrix44_double__inverse as Imath_M44d_inverse;
pub use imath_matrix::Imath_3_0__Matrix44_double__gjInvert as Imath_M44d_gjInvert;
pub use imath_matrix::Imath_3_0__Matrix44_double__gjInverse as Imath_M44d_gjInverse;
pub use imath_matrix::Imath_3_0__Matrix44_double__minorOf as Imath_M44d_minorOf;
pub use imath_matrix::Imath_3_0__Matrix44_double__fastMinor as Imath_M44d_fastMinor;
pub use imath_matrix::Imath_3_0__Matrix44_double__determinant as Imath_M44d_determinant;
pub use imath_matrix::Imath_3_0__Matrix44_double__setScale_uniform as Imath_M44d_setScale_uniform;
pub use imath_matrix::Imath_3_0__Matrix44_double__translation as Imath_M44d_translation;
pub use imath_matrix::Imath_3_0__Matrix44_double__baseTypeLowest_1 as Imath_M44d_baseTypeLowest;
pub use imath_matrix::Imath_3_0__Matrix44_double__baseTypeMax_1 as Imath_M44d_baseTypeMax;
pub use imath_matrix::Imath_3_0__Matrix44_double__baseTypeSmallest_1 as Imath_M44d_baseTypeSmallest;
pub use imath_matrix::Imath_3_0__Matrix44_double__baseTypeEpsilon_1 as Imath_M44d_baseTypeEpsilon;
pub use imath_matrix::Imath_3_0__Matrix44_double__dimensions_1 as Imath_M44d_dimensions;
pub mod imf_tiledinputfile;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_t as Imf_TiledInputFile_t;

pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_ctor as Imf_TiledInputFile_ctor;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_from_stream as Imf_TiledInputFile_from_stream;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_dtor as Imf_TiledInputFile_dtor;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_fileName as Imf_TiledInputFile_fileName;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_header as Imf_TiledInputFile_header;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_version as Imf_TiledInputFile_version;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_setFrameBuffer as Imf_TiledInputFile_setFrameBuffer;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_frameBuffer as Imf_TiledInputFile_frameBuffer;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_isComplete as Imf_TiledInputFile_isComplete;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_tileXSize as Imf_TiledInputFile_tileXSize;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_tileYSize as Imf_TiledInputFile_tileYSize;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_levelMode as Imf_TiledInputFile_levelMode;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_levelRoundingMode as Imf_TiledInputFile_levelRoundingMode;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_numLevels as Imf_TiledInputFile_numLevels;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_numXLevels as Imf_TiledInputFile_numXLevels;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_numYLevels as Imf_TiledInputFile_numYLevels;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_isValidLevel as Imf_TiledInputFile_isValidLevel;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_levelWidth as Imf_TiledInputFile_levelWidth;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_levelHeight as Imf_TiledInputFile_levelHeight;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_numXTiles as Imf_TiledInputFile_numXTiles;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_numYTiles as Imf_TiledInputFile_numYTiles;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_dataWindowForLevel as Imf_TiledInputFile_dataWindowForLevel;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_dataWindowForTile as Imf_TiledInputFile_dataWindowForTile;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_readTile as Imf_TiledInputFile_readTile;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_readTiles as Imf_TiledInputFile_readTiles;
pub use imf_tiledinputfile::Imf_3_0__TiledInputFile_rawTileData as Imf_TiledInputFile_rawTileData;
pub mod imf_array;
pub use imf_array::Imf_3_0__Array_float__t as Imf_ArrayFloat_t;
pub use imf_array::Imf_3_0__Array_char__t as Imf_ArrayChar_t;
pub use imf_array::Imf_3_0__Array2D_float__t as Imf_Array2DFloat_t;

pub use imf_array::Imf_3_0__Array_float__new as Imf_ArrayFloat_new;
pub use imf_array::Imf_3_0__Array_float__with_size as Imf_ArrayFloat_with_size;
pub use imf_array::Imf_3_0__Array_float__delete as Imf_ArrayFloat_delete;
pub use imf_array::Imf_3_0__Array_float__as_ptr as Imf_ArrayFloat_as_ptr;
pub use imf_array::Imf_3_0__Array_float__as_const_ptr as Imf_ArrayFloat_as_const_ptr;
pub use imf_array::Imf_3_0__Array_float__resizeErase as Imf_ArrayFloat_resizeErase;
pub use imf_array::Imf_3_0__Array_float__resizeEraseUnsafe as Imf_ArrayFloat_resizeEraseUnsafe;
pub use imf_array::Imf_3_0__Array_float__size as Imf_ArrayFloat_size;
pub use imf_array::Imf_3_0__Array_char__new as Imf_ArrayChar_new;
pub use imf_array::Imf_3_0__Array_char__with_size as Imf_ArrayChar_with_size;
pub use imf_array::Imf_3_0__Array_char__delete as Imf_ArrayChar_delete;
pub use imf_array::Imf_3_0__Array_char__as_ptr as Imf_ArrayChar_as_ptr;
pub use imf_array::Imf_3_0__Array_char__as_const_ptr as Imf_ArrayChar_as_const_ptr;
pub use imf_array::Imf_3_0__Array_char__resizeErase as Imf_ArrayChar_resizeErase;
pub use imf_array::Imf_3_0__Array_char__resizeEraseUnsafe as Imf_ArrayChar_resizeEraseUnsafe;
pub use imf_array::Imf_3_0__Array_char__size as Imf_ArrayChar_size;
pub use imf_array::Imf_3_0__Array2D_float__new as Imf_Array2DFloat_new;
pub use imf_array::Imf_3_0__Array2D_float__with_size as Imf_Array2DFloat_with_size;
pub use imf_array::Imf_3_0__Array2D_float__delete as Imf_Array2DFloat_delete;
pub use imf_array::Imf_3_0__Array2D_float__row as Imf_Array2DFloat_row;
pub use imf_array::Imf_3_0__Array2D_float__const_row as Imf_Array2DFloat_const_row;
pub use imf_array::Imf_3_0__Array2D_float__resizeErase as Imf_Array2DFloat_resizeErase;
pub use imf_array::Imf_3_0__Array2D_float__resizeEraseUnsafe as Imf_Array2DFloat_resizeEraseUnsafe;
pub use imf_array::Imf_3_0__Array2D_float__height as Imf_Array2DFloat_height;
pub use imf_array::Imf_3_0__Array2D_float__width as Imf_Array2DFloat_width;
pub mod std_set;
pub use std_set::std__set_std__string__t as std_set_string_t;
pub use std_set::std__set_std__string___const_iterator_t as std_set_string_iterator_t;

pub use std_set::std__set_std__string__ctor as std_set_string_ctor;
pub use std_set::std__set_std__string__dtor as std_set_string_dtor;
pub use std_set::std__set_std__string__cbegin as std_set_string_cbegin;
pub use std_set::std__set_std__string__cend as std_set_string_cend;
pub use std_set::std__set_std__string__size as std_set_string_size;
pub use std_set::std__set_std__string___const_iterator_sizeof as std_set_string_iterator_sizeof;
pub use std_set::std__set_std__string___const_iterator_alignof as std_set_string_iterator_alignof;
pub use std_set::std__set_std__string___const_iterator_deref as std_set_string_iterator_deref;
pub use std_set::std__set_std__string___const_iterator_inc as std_set_string_iterator_inc;
pub use std_set::std_set_string_const_iterator_eq as std_set_string_const_iterator_eq;
pub mod imf_compression;

pub use imf_compression::Imf_3_0__Compression_e as Imf_Compression;
pub use imf_compression::Imf_Compression_NO_COMPRESSION;
pub use imf_compression::Imf_Compression_RLE_COMPRESSION;
pub use imf_compression::Imf_Compression_ZIPS_COMPRESSION;
pub use imf_compression::Imf_Compression_ZIP_COMPRESSION;
pub use imf_compression::Imf_Compression_PIZ_COMPRESSION;
pub use imf_compression::Imf_Compression_PXR24_COMPRESSION;
pub use imf_compression::Imf_Compression_B44_COMPRESSION;
pub use imf_compression::Imf_Compression_B44A_COMPRESSION;
pub use imf_compression::Imf_Compression_DWAA_COMPRESSION;
pub use imf_compression::Imf_Compression_DWAB_COMPRESSION;
pub use imf_compression::Imf_Compression_NUM_COMPRESSION_METHODS;
pub use imf_compression::Compression;
pub mod imf_deeptiledoutputfile;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_t as Imf_DeepTiledOutputFile_t;

pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_ctor as Imf_DeepTiledOutputFile_ctor;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_from_stream as Imf_DeepTiledOutputFile_from_stream;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_dtor as Imf_DeepTiledOutputFile_dtor;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_fileName as Imf_DeepTiledOutputFile_fileName;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_header as Imf_DeepTiledOutputFile_header;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_setFrameBuffer as Imf_DeepTiledOutputFile_setFrameBuffer;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_frameBuffer as Imf_DeepTiledOutputFile_frameBuffer;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_tileXSize as Imf_DeepTiledOutputFile_tileXSize;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_tileYSize as Imf_DeepTiledOutputFile_tileYSize;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_levelMode as Imf_DeepTiledOutputFile_levelMode;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_levelRoundingMode as Imf_DeepTiledOutputFile_levelRoundingMode;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_numLevels as Imf_DeepTiledOutputFile_numLevels;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_numXLevels as Imf_DeepTiledOutputFile_numXLevels;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_numYLevels as Imf_DeepTiledOutputFile_numYLevels;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_isValidLevel as Imf_DeepTiledOutputFile_isValidLevel;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_levelWidth as Imf_DeepTiledOutputFile_levelWidth;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_levelHeight as Imf_DeepTiledOutputFile_levelHeight;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_numXTiles as Imf_DeepTiledOutputFile_numXTiles;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_numYTiles as Imf_DeepTiledOutputFile_numYTiles;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_dataWindowForLevel as Imf_DeepTiledOutputFile_dataWindowForLevel;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_dataWindowForTile as Imf_DeepTiledOutputFile_dataWindowForTile;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_writeTile as Imf_DeepTiledOutputFile_writeTile;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_writeTiles as Imf_DeepTiledOutputFile_writeTiles;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_copyPixels_from_file as Imf_DeepTiledOutputFile_copyPixels_from_file;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_copyPixels_from_part as Imf_DeepTiledOutputFile_copyPixels_from_part;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_updatePreviewImage as Imf_DeepTiledOutputFile_updatePreviewImage;
pub use imf_deeptiledoutputfile::Imf_3_0__DeepTiledOutputFile_breakTile as Imf_DeepTiledOutputFile_breakTile;
pub mod imf_inputpart;
pub use imf_inputpart::Imf_3_0__InputPart_t as Imf_InputPart_t;

pub use imf_inputpart::Imf_3_0__InputPart_sizeof as Imf_InputPart_sizeof;
pub use imf_inputpart::Imf_3_0__InputPart_alignof as Imf_InputPart_alignof;
pub use imf_inputpart::Imf_3_0__InputPart_ctor as Imf_InputPart_ctor;
pub use imf_inputpart::Imf_3_0__InputPart_fileName as Imf_InputPart_fileName;
pub use imf_inputpart::Imf_3_0__InputPart_header as Imf_InputPart_header;
pub use imf_inputpart::Imf_3_0__InputPart_version as Imf_InputPart_version;
pub use imf_inputpart::Imf_3_0__InputPart_setFrameBuffer as Imf_InputPart_setFrameBuffer;
pub use imf_inputpart::Imf_3_0__InputPart_frameBuffer as Imf_InputPart_frameBuffer;
pub use imf_inputpart::Imf_3_0__InputPart_isComplete as Imf_InputPart_isComplete;
pub use imf_inputpart::Imf_3_0__InputPart_isOptimizationEnabled as Imf_InputPart_isOptimizationEnabled;
pub use imf_inputpart::Imf_3_0__InputPart_readPixels as Imf_InputPart_readPixels;
pub use imf_inputpart::Imf_3_0__InputPart_readPixels_1 as Imf_InputPart_readPixels_1;
pub use imf_inputpart::Imf_3_0__InputPart_rawPixelData as Imf_InputPart_rawPixelData;
pub use imf_inputpart::Imf_3_0__InputPart_rawPixelDataToBuffer as Imf_InputPart_rawPixelDataToBuffer;
pub use imf_inputpart::Imf_3_0__InputPart_rawTileData as Imf_InputPart_rawTileData;
pub mod c_half;
pub use c_half::Imath_3_0__half_t as Imath_half_t;

pub use c_half::Imath_3_0__half__FromBitsTag_e as Imath_half_FromBitsTag;
pub use c_half::Imath_half_FromBitsTag_FromBits;
pub use c_half::Imath_3_0__half_sizeof as Imath_half_sizeof;
pub use c_half::Imath_3_0__half_alignof as Imath_half_alignof;
pub use c_half::Imath_3_0__half_ctor as Imath_half_ctor;
pub use c_half::Imath_3_0__half_from_float as Imath_half_from_float;
pub use c_half::Imath_3_0__half_ctor_1 as Imath_half_ctor_1;
pub use c_half::Imath_3_0__half_copy as Imath_half_copy;
pub use c_half::Imath_3_0__half_dtor as Imath_half_dtor;
pub use c_half::Imath_3_0__half_operatorfloat as Imath_half_operatorfloat;
pub use c_half::Imath_3_0__half__op_sub as Imath_half__op_sub;
pub use c_half::Imath_3_0__half__assign as Imath_half__assign;
pub use c_half::Imath_3_0__half__assign_1 as Imath_half__assign_1;
pub use c_half::Imath_3_0__half__op_iadd as Imath_half__op_iadd;
pub use c_half::Imath_3_0__half__op_iadd_1 as Imath_half__op_iadd_1;
pub use c_half::Imath_3_0__half__op_isub as Imath_half__op_isub;
pub use c_half::Imath_3_0__half__op_isub_1 as Imath_half__op_isub_1;
pub use c_half::Imath_3_0__half__op_imul as Imath_half__op_imul;
pub use c_half::Imath_3_0__half__op_imul_1 as Imath_half__op_imul_1;
pub use c_half::Imath_3_0__half__op_idiv as Imath_half__op_idiv;
pub use c_half::Imath_3_0__half__op_idiv_1 as Imath_half__op_idiv_1;
pub use c_half::Imath_3_0__half_round as Imath_half_round;
pub use c_half::Imath_3_0__half_isFinite as Imath_half_isFinite;
pub use c_half::Imath_3_0__half_isNormalized as Imath_half_isNormalized;
pub use c_half::Imath_3_0__half_isDenormalized as Imath_half_isDenormalized;
pub use c_half::Imath_3_0__half_isZero as Imath_half_isZero;
pub use c_half::Imath_3_0__half_isNan as Imath_half_isNan;
pub use c_half::Imath_3_0__half_isInfinity as Imath_half_isInfinity;
pub use c_half::Imath_3_0__half_isNegative as Imath_half_isNegative;
pub use c_half::Imath_3_0__half_posInf_1 as Imath_half_posInf;
pub use c_half::Imath_3_0__half_negInf_1 as Imath_half_negInf;
pub use c_half::Imath_3_0__half_qNan_1 as Imath_half_qNan;
pub use c_half::Imath_3_0__half_sNan_1 as Imath_half_sNan;
pub use c_half::Imath_3_0__half_bits as Imath_half_bits;
pub use c_half::Imath_3_0__half_setBits as Imath_half_setBits;
pub mod imf_inputfile;
pub use imf_inputfile::Imf_3_0__InputFile_t as Imf_InputFile_t;
pub use imf_inputfile::Imf_3_0__GenericInputFile_t as Imf_GenericInputFile_t;

pub use imf_inputfile::Imf_3_0__InputFile_ctor as Imf_InputFile_ctor;
pub use imf_inputfile::Imf_3_0__InputFile_from_stream as Imf_InputFile_from_stream;
pub use imf_inputfile::Imf_3_0__InputFile_dtor as Imf_InputFile_dtor;
pub use imf_inputfile::Imf_3_0__InputFile_fileName as Imf_InputFile_fileName;
pub use imf_inputfile::Imf_3_0__InputFile_header as Imf_InputFile_header;
pub use imf_inputfile::Imf_3_0__InputFile_version as Imf_InputFile_version;
pub use imf_inputfile::Imf_3_0__InputFile_setFrameBuffer as Imf_InputFile_setFrameBuffer;
pub use imf_inputfile::Imf_3_0__InputFile_frameBuffer as Imf_InputFile_frameBuffer;
pub use imf_inputfile::Imf_3_0__InputFile_isComplete as Imf_InputFile_isComplete;
pub use imf_inputfile::Imf_3_0__InputFile_isOptimizationEnabled as Imf_InputFile_isOptimizationEnabled;
pub use imf_inputfile::Imf_3_0__InputFile_readPixels as Imf_InputFile_readPixels;
pub use imf_inputfile::Imf_3_0__InputFile_rawPixelData as Imf_InputFile_rawPixelData;
pub use imf_inputfile::Imf_3_0__InputFile_rawPixelDataToBuffer as Imf_InputFile_rawPixelDataToBuffer;
pub use imf_inputfile::Imf_3_0__InputFile_rawTileData as Imf_InputFile_rawTileData;
pub use imf_inputfile::Imf_3_0__GenericInputFile_dtor as Imf_GenericInputFile_dtor;
pub use imf_inputfile::Imf_3_0__GenericInputFile__assign as Imf_GenericInputFile__assign;
pub use imf_inputfile::Imf_3_0__GenericInputFile_copy as Imf_GenericInputFile_copy;
pub mod imf_deepscanlineinputfile;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_t as Imf_DeepScanLineInputFile_t;

pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_ctor as Imf_DeepScanLineInputFile_ctor;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_ctor_1 as Imf_DeepScanLineInputFile_ctor_1;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_ctor_2 as Imf_DeepScanLineInputFile_ctor_2;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_dtor as Imf_DeepScanLineInputFile_dtor;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_fileName as Imf_DeepScanLineInputFile_fileName;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_header as Imf_DeepScanLineInputFile_header;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_version as Imf_DeepScanLineInputFile_version;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_setFrameBuffer as Imf_DeepScanLineInputFile_setFrameBuffer;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_frameBuffer as Imf_DeepScanLineInputFile_frameBuffer;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_isComplete as Imf_DeepScanLineInputFile_isComplete;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_readPixels as Imf_DeepScanLineInputFile_readPixels;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_readPixels_from_frame_buffer as Imf_DeepScanLineInputFile_readPixels_from_frame_buffer;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_rawPixelData as Imf_DeepScanLineInputFile_rawPixelData;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_firstScanLineInChunk as Imf_DeepScanLineInputFile_firstScanLineInChunk;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_lastScanLineInChunk as Imf_DeepScanLineInputFile_lastScanLineInChunk;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_readPixelSampleCounts as Imf_DeepScanLineInputFile_readPixelSampleCounts;
pub use imf_deepscanlineinputfile::Imf_3_0__DeepScanLineInputFile_readPixelSampleCounts_into_frame_buffer as Imf_DeepScanLineInputFile_readPixelSampleCounts_into_frame_buffer;
pub mod imf_attribute;
pub use imf_attribute::Imf_3_0__Attribute_t as Imf_Attribute_t;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_t as Imf_OpaqueAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__t as Imf_IntAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__t as Imf_FloatAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__t as Imf_DoubleAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__t as Imf_Box2iAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__t as Imf_Box2fAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__t as Imf_ChannelListAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__t as Imf_ChromaticitiesAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__t as Imf_CompressionAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__t as Imf_DeepImageStateAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__t as Imf_EnvmapAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__t as Imf_CppVectorFloatAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__t as Imf_CppVectorStringAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__t as Imf_CppStringAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__t as Imf_KeyCodeAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__t as Imf_LineOrderAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__t as Imf_M33fAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__t as Imf_M33dAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__t as Imf_M44fAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__t as Imf_M44dAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__t as Imf_PreviewImageAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__t as Imf_RationalAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__t as Imf_TileDescriptionAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__t as Imf_TimeCodeAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__t as Imf_V2iAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__t as Imf_V2fAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__t as Imf_V2dAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__t as Imf_V3iAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__t as Imf_V3fAttribute_t;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__t as Imf_V3dAttribute_t;

pub use imf_attribute::Imf_3_0__Attribute_dtor as Imf_Attribute_dtor;
pub use imf_attribute::Imf_3_0__Attribute_typeName as Imf_Attribute_typeName;
pub use imf_attribute::Imf_3_0__Attribute_copy as Imf_Attribute_copy;
pub use imf_attribute::Imf_3_0__Attribute_writeValueTo as Imf_Attribute_writeValueTo;
pub use imf_attribute::Imf_3_0__Attribute_readValueFrom as Imf_Attribute_readValueFrom;
pub use imf_attribute::Imf_3_0__Attribute_copyValueFrom as Imf_Attribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__Attribute_newAttribute_1 as Imf_Attribute_newAttribute;
pub use imf_attribute::Imf_3_0__Attribute_knownType_1 as Imf_Attribute_knownType;
pub use imf_attribute::Imf_3_0__Attribute__assign as Imf_Attribute__assign;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_typeName as Imf_OpaqueAttribute_typeName;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_copy as Imf_OpaqueAttribute_copy;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_writeValueTo as Imf_OpaqueAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_readValueFrom as Imf_OpaqueAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_copyValueFrom as Imf_OpaqueAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_newAttribute_1 as Imf_OpaqueAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_knownType_1 as Imf_OpaqueAttribute_knownType;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_from_typeName as Imf_OpaqueAttribute_from_typeName;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_copy_1 as Imf_OpaqueAttribute_copy_1;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_dtor as Imf_OpaqueAttribute_dtor;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_dataSize as Imf_OpaqueAttribute_dataSize;
pub use imf_attribute::Imf_3_0__OpaqueAttribute_data as Imf_OpaqueAttribute_data;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__typeName as Imf_IntAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__copy as Imf_IntAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__writeValueTo as Imf_IntAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__readValueFrom as Imf_IntAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__copyValueFrom as Imf_IntAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__newAttribute_1 as Imf_IntAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__knownType_1 as Imf_IntAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__ctor as Imf_IntAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__from_value as Imf_IntAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__ctor_copy as Imf_IntAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__dtor as Imf_IntAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__assign as Imf_IntAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__value as Imf_IntAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__value_const as Imf_IntAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__staticTypeName_1 as Imf_IntAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__makeNewAttribute_1 as Imf_IntAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__cast_ptr_1 as Imf_IntAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__cast_ptr_const_1 as Imf_IntAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__cast_1 as Imf_IntAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__cast_const_1 as Imf_IntAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__registerAttributeType_1 as Imf_IntAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_int__unRegisterAttributeType_1 as Imf_IntAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__typeName as Imf_FloatAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__copy as Imf_FloatAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__writeValueTo as Imf_FloatAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__readValueFrom as Imf_FloatAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__copyValueFrom as Imf_FloatAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__newAttribute_1 as Imf_FloatAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__knownType_1 as Imf_FloatAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__ctor as Imf_FloatAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__from_value as Imf_FloatAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__ctor_copy as Imf_FloatAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__dtor as Imf_FloatAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__assign as Imf_FloatAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__value as Imf_FloatAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__value_const as Imf_FloatAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__staticTypeName_1 as Imf_FloatAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__makeNewAttribute_1 as Imf_FloatAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__cast_ptr_1 as Imf_FloatAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__cast_ptr_const_1 as Imf_FloatAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__cast_1 as Imf_FloatAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__cast_const_1 as Imf_FloatAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__registerAttributeType_1 as Imf_FloatAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_float__unRegisterAttributeType_1 as Imf_FloatAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__typeName as Imf_DoubleAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__copy as Imf_DoubleAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__writeValueTo as Imf_DoubleAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__readValueFrom as Imf_DoubleAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__copyValueFrom as Imf_DoubleAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__newAttribute_1 as Imf_DoubleAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__knownType_1 as Imf_DoubleAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__ctor as Imf_DoubleAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__from_value as Imf_DoubleAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__ctor_copy as Imf_DoubleAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__dtor as Imf_DoubleAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__assign as Imf_DoubleAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__value as Imf_DoubleAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__value_const as Imf_DoubleAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__staticTypeName_1 as Imf_DoubleAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__makeNewAttribute_1 as Imf_DoubleAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__cast_ptr_1 as Imf_DoubleAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__cast_ptr_const_1 as Imf_DoubleAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__cast_1 as Imf_DoubleAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__cast_const_1 as Imf_DoubleAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__registerAttributeType_1 as Imf_DoubleAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_double__unRegisterAttributeType_1 as Imf_DoubleAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__typeName as Imf_Box2iAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__copy as Imf_Box2iAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__writeValueTo as Imf_Box2iAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__readValueFrom as Imf_Box2iAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__copyValueFrom as Imf_Box2iAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__newAttribute_1 as Imf_Box2iAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__knownType_1 as Imf_Box2iAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__ctor as Imf_Box2iAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__from_value as Imf_Box2iAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__ctor_copy as Imf_Box2iAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__dtor as Imf_Box2iAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__assign as Imf_Box2iAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__value as Imf_Box2iAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__value_const as Imf_Box2iAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__staticTypeName_1 as Imf_Box2iAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__makeNewAttribute_1 as Imf_Box2iAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__cast_ptr_1 as Imf_Box2iAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__cast_ptr_const_1 as Imf_Box2iAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__cast_1 as Imf_Box2iAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__cast_const_1 as Imf_Box2iAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__registerAttributeType_1 as Imf_Box2iAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2i__unRegisterAttributeType_1 as Imf_Box2iAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__typeName as Imf_Box2fAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__copy as Imf_Box2fAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__writeValueTo as Imf_Box2fAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__readValueFrom as Imf_Box2fAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__copyValueFrom as Imf_Box2fAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__newAttribute_1 as Imf_Box2fAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__knownType_1 as Imf_Box2fAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__ctor as Imf_Box2fAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__from_value as Imf_Box2fAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__ctor_copy as Imf_Box2fAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__dtor as Imf_Box2fAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__assign as Imf_Box2fAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__value as Imf_Box2fAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__value_const as Imf_Box2fAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__staticTypeName_1 as Imf_Box2fAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__makeNewAttribute_1 as Imf_Box2fAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__cast_ptr_1 as Imf_Box2fAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__cast_ptr_const_1 as Imf_Box2fAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__cast_1 as Imf_Box2fAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__cast_const_1 as Imf_Box2fAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__registerAttributeType_1 as Imf_Box2fAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__Box2f__unRegisterAttributeType_1 as Imf_Box2fAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__typeName as Imf_ChannelListAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__copy as Imf_ChannelListAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__writeValueTo as Imf_ChannelListAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__readValueFrom as Imf_ChannelListAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__copyValueFrom as Imf_ChannelListAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__newAttribute_1 as Imf_ChannelListAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__knownType_1 as Imf_ChannelListAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__ctor as Imf_ChannelListAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__from_value as Imf_ChannelListAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__ctor_copy as Imf_ChannelListAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__dtor as Imf_ChannelListAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__assign as Imf_ChannelListAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__value as Imf_ChannelListAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__value_const as Imf_ChannelListAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__staticTypeName_1 as Imf_ChannelListAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__makeNewAttribute_1 as Imf_ChannelListAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__cast_ptr_1 as Imf_ChannelListAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__cast_ptr_const_1 as Imf_ChannelListAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__cast_1 as Imf_ChannelListAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__cast_const_1 as Imf_ChannelListAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__registerAttributeType_1 as Imf_ChannelListAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__ChannelList__unRegisterAttributeType_1 as Imf_ChannelListAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__typeName as Imf_ChromaticitiesAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__copy as Imf_ChromaticitiesAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__writeValueTo as Imf_ChromaticitiesAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__readValueFrom as Imf_ChromaticitiesAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__copyValueFrom as Imf_ChromaticitiesAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__newAttribute_1 as Imf_ChromaticitiesAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__knownType_1 as Imf_ChromaticitiesAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__ctor as Imf_ChromaticitiesAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__from_value as Imf_ChromaticitiesAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__ctor_copy as Imf_ChromaticitiesAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__dtor as Imf_ChromaticitiesAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__assign as Imf_ChromaticitiesAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__value as Imf_ChromaticitiesAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__value_const as Imf_ChromaticitiesAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__staticTypeName_1 as Imf_ChromaticitiesAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__makeNewAttribute_1 as Imf_ChromaticitiesAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__cast_ptr_1 as Imf_ChromaticitiesAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__cast_ptr_const_1 as Imf_ChromaticitiesAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__cast_1 as Imf_ChromaticitiesAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__cast_const_1 as Imf_ChromaticitiesAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__registerAttributeType_1 as Imf_ChromaticitiesAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Chromaticities__unRegisterAttributeType_1 as Imf_ChromaticitiesAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__typeName as Imf_CompressionAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__copy as Imf_CompressionAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__writeValueTo as Imf_CompressionAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__readValueFrom as Imf_CompressionAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__copyValueFrom as Imf_CompressionAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__newAttribute_1 as Imf_CompressionAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__knownType_1 as Imf_CompressionAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__ctor as Imf_CompressionAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__from_value as Imf_CompressionAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__ctor_copy as Imf_CompressionAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__dtor as Imf_CompressionAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__assign as Imf_CompressionAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__value as Imf_CompressionAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__value_const as Imf_CompressionAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__staticTypeName_1 as Imf_CompressionAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__makeNewAttribute_1 as Imf_CompressionAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__cast_ptr_1 as Imf_CompressionAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__cast_ptr_const_1 as Imf_CompressionAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__cast_1 as Imf_CompressionAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__cast_const_1 as Imf_CompressionAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__registerAttributeType_1 as Imf_CompressionAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Compression__unRegisterAttributeType_1 as Imf_CompressionAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__typeName as Imf_DeepImageStateAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__copy as Imf_DeepImageStateAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__writeValueTo as Imf_DeepImageStateAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__readValueFrom as Imf_DeepImageStateAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__copyValueFrom as Imf_DeepImageStateAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__newAttribute_1 as Imf_DeepImageStateAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__knownType_1 as Imf_DeepImageStateAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__ctor as Imf_DeepImageStateAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__from_value as Imf_DeepImageStateAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__ctor_copy as Imf_DeepImageStateAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__dtor as Imf_DeepImageStateAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__assign as Imf_DeepImageStateAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__value as Imf_DeepImageStateAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__value_const as Imf_DeepImageStateAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__staticTypeName_1 as Imf_DeepImageStateAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__makeNewAttribute_1 as Imf_DeepImageStateAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__cast_ptr_1 as Imf_DeepImageStateAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__cast_ptr_const_1 as Imf_DeepImageStateAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__cast_1 as Imf_DeepImageStateAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__cast_const_1 as Imf_DeepImageStateAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__registerAttributeType_1 as Imf_DeepImageStateAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__DeepImageState__unRegisterAttributeType_1 as Imf_DeepImageStateAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__typeName as Imf_EnvmapAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__copy as Imf_EnvmapAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__writeValueTo as Imf_EnvmapAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__readValueFrom as Imf_EnvmapAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__copyValueFrom as Imf_EnvmapAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__newAttribute_1 as Imf_EnvmapAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__knownType_1 as Imf_EnvmapAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__ctor as Imf_EnvmapAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__from_value as Imf_EnvmapAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__ctor_copy as Imf_EnvmapAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__dtor as Imf_EnvmapAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__assign as Imf_EnvmapAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__value as Imf_EnvmapAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__value_const as Imf_EnvmapAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__staticTypeName_1 as Imf_EnvmapAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__makeNewAttribute_1 as Imf_EnvmapAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__cast_ptr_1 as Imf_EnvmapAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__cast_ptr_const_1 as Imf_EnvmapAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__cast_1 as Imf_EnvmapAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__cast_const_1 as Imf_EnvmapAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__registerAttributeType_1 as Imf_EnvmapAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Envmap__unRegisterAttributeType_1 as Imf_EnvmapAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__typeName as Imf_CppVectorFloatAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__copy as Imf_CppVectorFloatAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__writeValueTo as Imf_CppVectorFloatAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__readValueFrom as Imf_CppVectorFloatAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__copyValueFrom as Imf_CppVectorFloatAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__newAttribute_1 as Imf_CppVectorFloatAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__knownType_1 as Imf_CppVectorFloatAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__ctor as Imf_CppVectorFloatAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__from_value as Imf_CppVectorFloatAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__ctor_copy as Imf_CppVectorFloatAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__dtor as Imf_CppVectorFloatAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__assign as Imf_CppVectorFloatAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__value as Imf_CppVectorFloatAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__value_const as Imf_CppVectorFloatAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__staticTypeName_1 as Imf_CppVectorFloatAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__makeNewAttribute_1 as Imf_CppVectorFloatAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__cast_ptr_1 as Imf_CppVectorFloatAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__cast_ptr_const_1 as Imf_CppVectorFloatAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__cast_1 as Imf_CppVectorFloatAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__cast_const_1 as Imf_CppVectorFloatAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__registerAttributeType_1 as Imf_CppVectorFloatAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__FloatVector__unRegisterAttributeType_1 as Imf_CppVectorFloatAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__typeName as Imf_CppVectorStringAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__copy as Imf_CppVectorStringAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__writeValueTo as Imf_CppVectorStringAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__readValueFrom as Imf_CppVectorStringAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__copyValueFrom as Imf_CppVectorStringAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__newAttribute_1 as Imf_CppVectorStringAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__knownType_1 as Imf_CppVectorStringAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__ctor as Imf_CppVectorStringAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__from_value as Imf_CppVectorStringAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__ctor_copy as Imf_CppVectorStringAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__dtor as Imf_CppVectorStringAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__assign as Imf_CppVectorStringAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__value as Imf_CppVectorStringAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__value_const as Imf_CppVectorStringAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__staticTypeName_1 as Imf_CppVectorStringAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__makeNewAttribute_1 as Imf_CppVectorStringAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__cast_ptr_1 as Imf_CppVectorStringAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__cast_ptr_const_1 as Imf_CppVectorStringAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__cast_1 as Imf_CppVectorStringAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__cast_const_1 as Imf_CppVectorStringAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__registerAttributeType_1 as Imf_CppVectorStringAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__StringVector__unRegisterAttributeType_1 as Imf_CppVectorStringAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__typeName as Imf_CppStringAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__copy as Imf_CppStringAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__writeValueTo as Imf_CppStringAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__readValueFrom as Imf_CppStringAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__copyValueFrom as Imf_CppStringAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__newAttribute_1 as Imf_CppStringAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__knownType_1 as Imf_CppStringAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__ctor as Imf_CppStringAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__from_value as Imf_CppStringAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__ctor_copy as Imf_CppStringAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__dtor as Imf_CppStringAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__assign as Imf_CppStringAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__value as Imf_CppStringAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__value_const as Imf_CppStringAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__staticTypeName_1 as Imf_CppStringAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__makeNewAttribute_1 as Imf_CppStringAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__cast_ptr_1 as Imf_CppStringAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__cast_ptr_const_1 as Imf_CppStringAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__cast_1 as Imf_CppStringAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__cast_const_1 as Imf_CppStringAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__registerAttributeType_1 as Imf_CppStringAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_std__string__unRegisterAttributeType_1 as Imf_CppStringAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__typeName as Imf_KeyCodeAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__copy as Imf_KeyCodeAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__writeValueTo as Imf_KeyCodeAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__readValueFrom as Imf_KeyCodeAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__copyValueFrom as Imf_KeyCodeAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__newAttribute_1 as Imf_KeyCodeAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__knownType_1 as Imf_KeyCodeAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__ctor as Imf_KeyCodeAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__from_value as Imf_KeyCodeAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__ctor_copy as Imf_KeyCodeAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__dtor as Imf_KeyCodeAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__assign as Imf_KeyCodeAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__value as Imf_KeyCodeAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__value_const as Imf_KeyCodeAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__staticTypeName_1 as Imf_KeyCodeAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__makeNewAttribute_1 as Imf_KeyCodeAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__cast_ptr_1 as Imf_KeyCodeAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__cast_ptr_const_1 as Imf_KeyCodeAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__cast_1 as Imf_KeyCodeAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__cast_const_1 as Imf_KeyCodeAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__registerAttributeType_1 as Imf_KeyCodeAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__KeyCode__unRegisterAttributeType_1 as Imf_KeyCodeAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__typeName as Imf_LineOrderAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__copy as Imf_LineOrderAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__writeValueTo as Imf_LineOrderAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__readValueFrom as Imf_LineOrderAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__copyValueFrom as Imf_LineOrderAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__newAttribute_1 as Imf_LineOrderAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__knownType_1 as Imf_LineOrderAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__ctor as Imf_LineOrderAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__from_value as Imf_LineOrderAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__ctor_copy as Imf_LineOrderAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__dtor as Imf_LineOrderAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__assign as Imf_LineOrderAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__value as Imf_LineOrderAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__value_const as Imf_LineOrderAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__staticTypeName_1 as Imf_LineOrderAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__makeNewAttribute_1 as Imf_LineOrderAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__cast_ptr_1 as Imf_LineOrderAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__cast_ptr_const_1 as Imf_LineOrderAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__cast_1 as Imf_LineOrderAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__cast_const_1 as Imf_LineOrderAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__registerAttributeType_1 as Imf_LineOrderAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__LineOrder__unRegisterAttributeType_1 as Imf_LineOrderAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__typeName as Imf_M33fAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__copy as Imf_M33fAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__writeValueTo as Imf_M33fAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__readValueFrom as Imf_M33fAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__copyValueFrom as Imf_M33fAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__newAttribute_1 as Imf_M33fAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__knownType_1 as Imf_M33fAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__ctor as Imf_M33fAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__from_value as Imf_M33fAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__ctor_copy as Imf_M33fAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__dtor as Imf_M33fAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__assign as Imf_M33fAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__value as Imf_M33fAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__value_const as Imf_M33fAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__staticTypeName_1 as Imf_M33fAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__makeNewAttribute_1 as Imf_M33fAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__cast_ptr_1 as Imf_M33fAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__cast_ptr_const_1 as Imf_M33fAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__cast_1 as Imf_M33fAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__cast_const_1 as Imf_M33fAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__registerAttributeType_1 as Imf_M33fAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33f__unRegisterAttributeType_1 as Imf_M33fAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__typeName as Imf_M33dAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__copy as Imf_M33dAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__writeValueTo as Imf_M33dAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__readValueFrom as Imf_M33dAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__copyValueFrom as Imf_M33dAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__newAttribute_1 as Imf_M33dAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__knownType_1 as Imf_M33dAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__ctor as Imf_M33dAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__from_value as Imf_M33dAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__ctor_copy as Imf_M33dAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__dtor as Imf_M33dAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__assign as Imf_M33dAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__value as Imf_M33dAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__value_const as Imf_M33dAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__staticTypeName_1 as Imf_M33dAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__makeNewAttribute_1 as Imf_M33dAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__cast_ptr_1 as Imf_M33dAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__cast_ptr_const_1 as Imf_M33dAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__cast_1 as Imf_M33dAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__cast_const_1 as Imf_M33dAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__registerAttributeType_1 as Imf_M33dAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M33d__unRegisterAttributeType_1 as Imf_M33dAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__typeName as Imf_M44fAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__copy as Imf_M44fAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__writeValueTo as Imf_M44fAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__readValueFrom as Imf_M44fAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__copyValueFrom as Imf_M44fAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__newAttribute_1 as Imf_M44fAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__knownType_1 as Imf_M44fAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__ctor as Imf_M44fAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__from_value as Imf_M44fAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__ctor_copy as Imf_M44fAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__dtor as Imf_M44fAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__assign as Imf_M44fAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__value as Imf_M44fAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__value_const as Imf_M44fAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__staticTypeName_1 as Imf_M44fAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__makeNewAttribute_1 as Imf_M44fAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__cast_ptr_1 as Imf_M44fAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__cast_ptr_const_1 as Imf_M44fAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__cast_1 as Imf_M44fAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__cast_const_1 as Imf_M44fAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__registerAttributeType_1 as Imf_M44fAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44f__unRegisterAttributeType_1 as Imf_M44fAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__typeName as Imf_M44dAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__copy as Imf_M44dAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__writeValueTo as Imf_M44dAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__readValueFrom as Imf_M44dAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__copyValueFrom as Imf_M44dAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__newAttribute_1 as Imf_M44dAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__knownType_1 as Imf_M44dAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__ctor as Imf_M44dAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__from_value as Imf_M44dAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__ctor_copy as Imf_M44dAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__dtor as Imf_M44dAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__assign as Imf_M44dAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__value as Imf_M44dAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__value_const as Imf_M44dAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__staticTypeName_1 as Imf_M44dAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__makeNewAttribute_1 as Imf_M44dAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__cast_ptr_1 as Imf_M44dAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__cast_ptr_const_1 as Imf_M44dAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__cast_1 as Imf_M44dAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__cast_const_1 as Imf_M44dAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__registerAttributeType_1 as Imf_M44dAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__M44d__unRegisterAttributeType_1 as Imf_M44dAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__typeName as Imf_PreviewImageAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__copy as Imf_PreviewImageAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__writeValueTo as Imf_PreviewImageAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__readValueFrom as Imf_PreviewImageAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__copyValueFrom as Imf_PreviewImageAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__newAttribute_1 as Imf_PreviewImageAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__knownType_1 as Imf_PreviewImageAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__ctor as Imf_PreviewImageAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__from_value as Imf_PreviewImageAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__ctor_copy as Imf_PreviewImageAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__dtor as Imf_PreviewImageAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__assign as Imf_PreviewImageAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__value as Imf_PreviewImageAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__value_const as Imf_PreviewImageAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__staticTypeName_1 as Imf_PreviewImageAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__makeNewAttribute_1 as Imf_PreviewImageAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__cast_ptr_1 as Imf_PreviewImageAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__cast_ptr_const_1 as Imf_PreviewImageAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__cast_1 as Imf_PreviewImageAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__cast_const_1 as Imf_PreviewImageAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__registerAttributeType_1 as Imf_PreviewImageAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__PreviewImage__unRegisterAttributeType_1 as Imf_PreviewImageAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__typeName as Imf_RationalAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__copy as Imf_RationalAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__writeValueTo as Imf_RationalAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__readValueFrom as Imf_RationalAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__copyValueFrom as Imf_RationalAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__newAttribute_1 as Imf_RationalAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__knownType_1 as Imf_RationalAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__ctor as Imf_RationalAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__from_value as Imf_RationalAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__ctor_copy as Imf_RationalAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__dtor as Imf_RationalAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__assign as Imf_RationalAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__value as Imf_RationalAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__value_const as Imf_RationalAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__staticTypeName_1 as Imf_RationalAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__makeNewAttribute_1 as Imf_RationalAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__cast_ptr_1 as Imf_RationalAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__cast_ptr_const_1 as Imf_RationalAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__cast_1 as Imf_RationalAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__cast_const_1 as Imf_RationalAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__registerAttributeType_1 as Imf_RationalAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__Rational__unRegisterAttributeType_1 as Imf_RationalAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__typeName as Imf_TileDescriptionAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__copy as Imf_TileDescriptionAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__writeValueTo as Imf_TileDescriptionAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__readValueFrom as Imf_TileDescriptionAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__copyValueFrom as Imf_TileDescriptionAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__newAttribute_1 as Imf_TileDescriptionAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__knownType_1 as Imf_TileDescriptionAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__ctor as Imf_TileDescriptionAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__from_value as Imf_TileDescriptionAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__ctor_copy as Imf_TileDescriptionAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__dtor as Imf_TileDescriptionAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__assign as Imf_TileDescriptionAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__value as Imf_TileDescriptionAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__value_const as Imf_TileDescriptionAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__staticTypeName_1 as Imf_TileDescriptionAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__makeNewAttribute_1 as Imf_TileDescriptionAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__cast_ptr_1 as Imf_TileDescriptionAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__cast_ptr_const_1 as Imf_TileDescriptionAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__cast_1 as Imf_TileDescriptionAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__cast_const_1 as Imf_TileDescriptionAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__registerAttributeType_1 as Imf_TileDescriptionAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TileDescription__unRegisterAttributeType_1 as Imf_TileDescriptionAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__typeName as Imf_TimeCodeAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__copy as Imf_TimeCodeAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__writeValueTo as Imf_TimeCodeAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__readValueFrom as Imf_TimeCodeAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__copyValueFrom as Imf_TimeCodeAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__newAttribute_1 as Imf_TimeCodeAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__knownType_1 as Imf_TimeCodeAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__ctor as Imf_TimeCodeAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__from_value as Imf_TimeCodeAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__ctor_copy as Imf_TimeCodeAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__dtor as Imf_TimeCodeAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__assign as Imf_TimeCodeAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__value as Imf_TimeCodeAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__value_const as Imf_TimeCodeAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__staticTypeName_1 as Imf_TimeCodeAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__makeNewAttribute_1 as Imf_TimeCodeAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__cast_ptr_1 as Imf_TimeCodeAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__cast_ptr_const_1 as Imf_TimeCodeAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__cast_1 as Imf_TimeCodeAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__cast_const_1 as Imf_TimeCodeAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__registerAttributeType_1 as Imf_TimeCodeAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imf_3_0__TimeCode__unRegisterAttributeType_1 as Imf_TimeCodeAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__typeName as Imf_V2iAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__copy as Imf_V2iAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__writeValueTo as Imf_V2iAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__readValueFrom as Imf_V2iAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__copyValueFrom as Imf_V2iAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__newAttribute_1 as Imf_V2iAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__knownType_1 as Imf_V2iAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__ctor as Imf_V2iAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__from_value as Imf_V2iAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__ctor_copy as Imf_V2iAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__dtor as Imf_V2iAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__assign as Imf_V2iAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__value as Imf_V2iAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__value_const as Imf_V2iAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__staticTypeName_1 as Imf_V2iAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__makeNewAttribute_1 as Imf_V2iAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__cast_ptr_1 as Imf_V2iAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__cast_ptr_const_1 as Imf_V2iAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__cast_1 as Imf_V2iAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__cast_const_1 as Imf_V2iAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__registerAttributeType_1 as Imf_V2iAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2i__unRegisterAttributeType_1 as Imf_V2iAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__typeName as Imf_V2fAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__copy as Imf_V2fAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__writeValueTo as Imf_V2fAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__readValueFrom as Imf_V2fAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__copyValueFrom as Imf_V2fAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__newAttribute_1 as Imf_V2fAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__knownType_1 as Imf_V2fAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__ctor as Imf_V2fAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__from_value as Imf_V2fAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__ctor_copy as Imf_V2fAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__dtor as Imf_V2fAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__assign as Imf_V2fAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__value as Imf_V2fAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__value_const as Imf_V2fAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__staticTypeName_1 as Imf_V2fAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__makeNewAttribute_1 as Imf_V2fAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__cast_ptr_1 as Imf_V2fAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__cast_ptr_const_1 as Imf_V2fAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__cast_1 as Imf_V2fAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__cast_const_1 as Imf_V2fAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__registerAttributeType_1 as Imf_V2fAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2f__unRegisterAttributeType_1 as Imf_V2fAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__typeName as Imf_V2dAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__copy as Imf_V2dAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__writeValueTo as Imf_V2dAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__readValueFrom as Imf_V2dAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__copyValueFrom as Imf_V2dAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__newAttribute_1 as Imf_V2dAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__knownType_1 as Imf_V2dAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__ctor as Imf_V2dAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__from_value as Imf_V2dAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__ctor_copy as Imf_V2dAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__dtor as Imf_V2dAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__assign as Imf_V2dAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__value as Imf_V2dAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__value_const as Imf_V2dAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__staticTypeName_1 as Imf_V2dAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__makeNewAttribute_1 as Imf_V2dAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__cast_ptr_1 as Imf_V2dAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__cast_ptr_const_1 as Imf_V2dAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__cast_1 as Imf_V2dAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__cast_const_1 as Imf_V2dAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__registerAttributeType_1 as Imf_V2dAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V2d__unRegisterAttributeType_1 as Imf_V2dAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__typeName as Imf_V3iAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__copy as Imf_V3iAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__writeValueTo as Imf_V3iAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__readValueFrom as Imf_V3iAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__copyValueFrom as Imf_V3iAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__newAttribute_1 as Imf_V3iAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__knownType_1 as Imf_V3iAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__ctor as Imf_V3iAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__from_value as Imf_V3iAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__ctor_copy as Imf_V3iAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__dtor as Imf_V3iAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__assign as Imf_V3iAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__value as Imf_V3iAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__value_const as Imf_V3iAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__staticTypeName_1 as Imf_V3iAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__makeNewAttribute_1 as Imf_V3iAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__cast_ptr_1 as Imf_V3iAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__cast_ptr_const_1 as Imf_V3iAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__cast_1 as Imf_V3iAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__cast_const_1 as Imf_V3iAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__registerAttributeType_1 as Imf_V3iAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3i__unRegisterAttributeType_1 as Imf_V3iAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__typeName as Imf_V3fAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__copy as Imf_V3fAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__writeValueTo as Imf_V3fAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__readValueFrom as Imf_V3fAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__copyValueFrom as Imf_V3fAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__newAttribute_1 as Imf_V3fAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__knownType_1 as Imf_V3fAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__ctor as Imf_V3fAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__from_value as Imf_V3fAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__ctor_copy as Imf_V3fAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__dtor as Imf_V3fAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__assign as Imf_V3fAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__value as Imf_V3fAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__value_const as Imf_V3fAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__staticTypeName_1 as Imf_V3fAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__makeNewAttribute_1 as Imf_V3fAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__cast_ptr_1 as Imf_V3fAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__cast_ptr_const_1 as Imf_V3fAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__cast_1 as Imf_V3fAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__cast_const_1 as Imf_V3fAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__registerAttributeType_1 as Imf_V3fAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3f__unRegisterAttributeType_1 as Imf_V3fAttribute_unRegisterAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__typeName as Imf_V3dAttribute_typeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__copy as Imf_V3dAttribute_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__writeValueTo as Imf_V3dAttribute_writeValueTo;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__readValueFrom as Imf_V3dAttribute_readValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__copyValueFrom as Imf_V3dAttribute_copyValueFrom;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__newAttribute_1 as Imf_V3dAttribute_newAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__knownType_1 as Imf_V3dAttribute_knownType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__ctor as Imf_V3dAttribute_ctor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__from_value as Imf_V3dAttribute_from_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__ctor_copy as Imf_V3dAttribute_ctor_copy;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__dtor as Imf_V3dAttribute_dtor;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__assign as Imf_V3dAttribute_assign;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__value as Imf_V3dAttribute_value;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__value_const as Imf_V3dAttribute_value_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__staticTypeName_1 as Imf_V3dAttribute_staticTypeName;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__makeNewAttribute_1 as Imf_V3dAttribute_makeNewAttribute;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__cast_ptr_1 as Imf_V3dAttribute_cast_ptr;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__cast_ptr_const_1 as Imf_V3dAttribute_cast_ptr_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__cast_1 as Imf_V3dAttribute_cast;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__cast_const_1 as Imf_V3dAttribute_cast_const;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__registerAttributeType_1 as Imf_V3dAttribute_registerAttributeType;
pub use imf_attribute::Imf_3_0__TypedAttribute_Imath__V3d__unRegisterAttributeType_1 as Imf_V3dAttribute_unRegisterAttributeType;
pub mod imf_deepimage;
pub use imf_deepimage::Imf_3_0__DeepImage_t as Imf_DeepImage_t;

pub use imf_deepimage::Imf_3_0__DeepImage_levelMode as Imf_DeepImage_levelMode;
pub use imf_deepimage::Imf_3_0__DeepImage_levelRoundingMode as Imf_DeepImage_levelRoundingMode;
pub use imf_deepimage::Imf_3_0__DeepImage_numLevels as Imf_DeepImage_numLevels;
pub use imf_deepimage::Imf_3_0__DeepImage_numXLevels as Imf_DeepImage_numXLevels;
pub use imf_deepimage::Imf_3_0__DeepImage_numYLevels as Imf_DeepImage_numYLevels;
pub use imf_deepimage::Imf_3_0__DeepImage_dataWindow as Imf_DeepImage_dataWindow;
pub use imf_deepimage::Imf_3_0__DeepImage_dataWindowForLevel as Imf_DeepImage_dataWindowForLevel;
pub use imf_deepimage::Imf_3_0__DeepImage_levelWidth as Imf_DeepImage_levelWidth;
pub use imf_deepimage::Imf_3_0__DeepImage_levelHeight as Imf_DeepImage_levelHeight;
pub use imf_deepimage::Imf_3_0__DeepImage_resize as Imf_DeepImage_resize;
pub use imf_deepimage::Imf_3_0__DeepImage_shiftPixels as Imf_DeepImage_shiftPixels;
pub use imf_deepimage::Imf_3_0__DeepImage_insertChannel as Imf_DeepImage_insertChannel;
pub use imf_deepimage::Imf_3_0__DeepImage_eraseChannel as Imf_DeepImage_eraseChannel;
pub use imf_deepimage::Imf_3_0__DeepImage_clearChannels as Imf_DeepImage_clearChannels;
pub use imf_deepimage::Imf_3_0__DeepImage_renameChannel as Imf_DeepImage_renameChannel;
pub use imf_deepimage::Imf_3_0__DeepImage_renameChannels as Imf_DeepImage_renameChannels;
pub use imf_deepimage::Imf_3_0__DeepImage_default as Imf_DeepImage_default;
pub use imf_deepimage::Imf_3_0__DeepImage_ctor as Imf_DeepImage_ctor;
pub use imf_deepimage::Imf_3_0__DeepImage_dtor as Imf_DeepImage_dtor;
pub use imf_deepimage::Imf_3_0__DeepImage_level as Imf_DeepImage_level;
pub use imf_deepimage::Imf_3_0__DeepImage_level_const as Imf_DeepImage_level_const;
pub mod imf_tiledrgbafile;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_t as Imf_TiledRgbaOutputFile_t;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_t as Imf_TiledRgbaInputFile_t;

pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_ctor as Imf_TiledRgbaOutputFile_ctor;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_from_stream as Imf_TiledRgbaOutputFile_from_stream;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_with_windows as Imf_TiledRgbaOutputFile_with_windows;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_with_dimensions as Imf_TiledRgbaOutputFile_with_dimensions;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_dtor as Imf_TiledRgbaOutputFile_dtor;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_setFrameBuffer as Imf_TiledRgbaOutputFile_setFrameBuffer;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_header as Imf_TiledRgbaOutputFile_header;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_frameBuffer as Imf_TiledRgbaOutputFile_frameBuffer;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_displayWindow as Imf_TiledRgbaOutputFile_displayWindow;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_dataWindow as Imf_TiledRgbaOutputFile_dataWindow;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_pixelAspectRatio as Imf_TiledRgbaOutputFile_pixelAspectRatio;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_screenWindowCenter as Imf_TiledRgbaOutputFile_screenWindowCenter;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_screenWindowWidth as Imf_TiledRgbaOutputFile_screenWindowWidth;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_lineOrder as Imf_TiledRgbaOutputFile_lineOrder;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_compression as Imf_TiledRgbaOutputFile_compression;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_channels as Imf_TiledRgbaOutputFile_channels;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_tileXSize as Imf_TiledRgbaOutputFile_tileXSize;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_tileYSize as Imf_TiledRgbaOutputFile_tileYSize;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_levelMode as Imf_TiledRgbaOutputFile_levelMode;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_levelRoundingMode as Imf_TiledRgbaOutputFile_levelRoundingMode;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_numLevels as Imf_TiledRgbaOutputFile_numLevels;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_numXLevels as Imf_TiledRgbaOutputFile_numXLevels;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_numYLevels as Imf_TiledRgbaOutputFile_numYLevels;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_isValidLevel as Imf_TiledRgbaOutputFile_isValidLevel;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_levelWidth as Imf_TiledRgbaOutputFile_levelWidth;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_levelHeight as Imf_TiledRgbaOutputFile_levelHeight;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_numXTiles as Imf_TiledRgbaOutputFile_numXTiles;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_numYTiles as Imf_TiledRgbaOutputFile_numYTiles;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_dataWindowForLevel as Imf_TiledRgbaOutputFile_dataWindowForLevel;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_dataWindowForTile as Imf_TiledRgbaOutputFile_dataWindowForTile;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_writeTile as Imf_TiledRgbaOutputFile_writeTile;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_writeTiles as Imf_TiledRgbaOutputFile_writeTiles;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaOutputFile_updatePreviewImage as Imf_TiledRgbaOutputFile_updatePreviewImage;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_ctor as Imf_TiledRgbaInputFile_ctor;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_from_stream as Imf_TiledRgbaInputFile_from_stream;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_with_layer as Imf_TiledRgbaInputFile_with_layer;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_from_stream_with_layer as Imf_TiledRgbaInputFile_from_stream_with_layer;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_dtor as Imf_TiledRgbaInputFile_dtor;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_setFrameBuffer as Imf_TiledRgbaInputFile_setFrameBuffer;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_setLayerName as Imf_TiledRgbaInputFile_setLayerName;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_header as Imf_TiledRgbaInputFile_header;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_frameBuffer as Imf_TiledRgbaInputFile_frameBuffer;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_displayWindow as Imf_TiledRgbaInputFile_displayWindow;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_dataWindow as Imf_TiledRgbaInputFile_dataWindow;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_pixelAspectRatio as Imf_TiledRgbaInputFile_pixelAspectRatio;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_screenWindowCenter as Imf_TiledRgbaInputFile_screenWindowCenter;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_screenWindowWidth as Imf_TiledRgbaInputFile_screenWindowWidth;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_lineOrder as Imf_TiledRgbaInputFile_lineOrder;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_compression as Imf_TiledRgbaInputFile_compression;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_channels as Imf_TiledRgbaInputFile_channels;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_fileName as Imf_TiledRgbaInputFile_fileName;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_isComplete as Imf_TiledRgbaInputFile_isComplete;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_version as Imf_TiledRgbaInputFile_version;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_tileXSize as Imf_TiledRgbaInputFile_tileXSize;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_tileYSize as Imf_TiledRgbaInputFile_tileYSize;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_levelMode as Imf_TiledRgbaInputFile_levelMode;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_levelRoundingMode as Imf_TiledRgbaInputFile_levelRoundingMode;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_numLevels as Imf_TiledRgbaInputFile_numLevels;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_numXLevels as Imf_TiledRgbaInputFile_numXLevels;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_numYLevels as Imf_TiledRgbaInputFile_numYLevels;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_isValidLevel as Imf_TiledRgbaInputFile_isValidLevel;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_levelWidth as Imf_TiledRgbaInputFile_levelWidth;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_levelHeight as Imf_TiledRgbaInputFile_levelHeight;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_numXTiles as Imf_TiledRgbaInputFile_numXTiles;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_numYTiles as Imf_TiledRgbaInputFile_numYTiles;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_dataWindowForLevel as Imf_TiledRgbaInputFile_dataWindowForLevel;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_dataWindowForTile as Imf_TiledRgbaInputFile_dataWindowForTile;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_readTile as Imf_TiledRgbaInputFile_readTile;
pub use imf_tiledrgbafile::Imf_3_0__TiledRgbaInputFile_readTiles as Imf_TiledRgbaInputFile_readTiles;
pub mod imf_deepframebuffer;
pub use imf_deepframebuffer::Imf_3_0__DeepSlice_t as Imf_DeepSlice_t;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_t as Imf_DeepFrameBuffer_t;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__Iterator_t as Imf_DeepFrameBuffer_Iterator_t;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator_t as Imf_DeepFrameBuffer_ConstIterator_t;

pub use imf_deepframebuffer::Imf_3_0__DeepSlice_sizeof as Imf_DeepSlice_sizeof;
pub use imf_deepframebuffer::Imf_3_0__DeepSlice_alignof as Imf_DeepSlice_alignof;
pub use imf_deepframebuffer::Imf_3_0__DeepSlice_ctor as Imf_DeepSlice_ctor;
pub use imf_deepframebuffer::Imf_3_0__DeepSlice_dtor as Imf_DeepSlice_dtor;
pub use imf_deepframebuffer::Imf_3_0__DeepSlice_copy as Imf_DeepSlice_copy;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_insert as Imf_DeepFrameBuffer_insert;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_findSlice as Imf_DeepFrameBuffer_findSlice;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_findSlice_const as Imf_DeepFrameBuffer_findSlice_const;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_begin as Imf_DeepFrameBuffer_begin;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_begin_const as Imf_DeepFrameBuffer_begin_const;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_end as Imf_DeepFrameBuffer_end;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_end_const as Imf_DeepFrameBuffer_end_const;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_insertSampleCountSlice as Imf_DeepFrameBuffer_insertSampleCountSlice;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_getSampleCountSlice as Imf_DeepFrameBuffer_getSampleCountSlice;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_copy as Imf_DeepFrameBuffer_copy;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_dtor as Imf_DeepFrameBuffer_dtor;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer_ctor as Imf_DeepFrameBuffer_ctor;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__Iterator_sizeof as Imf_DeepFrameBuffer_Iterator_sizeof;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__Iterator_alignof as Imf_DeepFrameBuffer_Iterator_alignof;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__Iterator_ctor as Imf_DeepFrameBuffer_Iterator_ctor;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__Iterator__op_inc as Imf_DeepFrameBuffer_Iterator__op_inc;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__Iterator_name as Imf_DeepFrameBuffer_Iterator_name;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__Iterator_slice as Imf_DeepFrameBuffer_Iterator_slice;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__Iterator_copy as Imf_DeepFrameBuffer_Iterator_copy;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator_sizeof as Imf_DeepFrameBuffer_ConstIterator_sizeof;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator_alignof as Imf_DeepFrameBuffer_ConstIterator_alignof;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator_ctor as Imf_DeepFrameBuffer_ConstIterator_ctor;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator_from_mut as Imf_DeepFrameBuffer_ConstIterator_from_mut;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator__op_inc as Imf_DeepFrameBuffer_ConstIterator__op_inc;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator_name as Imf_DeepFrameBuffer_ConstIterator_name;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator_slice as Imf_DeepFrameBuffer_ConstIterator_slice;
pub use imf_deepframebuffer::Imf_3_0__DeepFrameBuffer__ConstIterator_copy as Imf_DeepFrameBuffer_ConstIterator_copy;
pub use imf_deepframebuffer::Imf_3_0_deep_frame_buffer_const_iter_eq as Imf_deep_frame_buffer_const_iter_eq;
pub mod imf_convert;

pub use imf_convert::Imf_3_0_halfToUint as Imf_halfToUint;
pub use imf_convert::Imf_3_0_floatToUint as Imf_floatToUint;
pub use imf_convert::Imf_3_0_uintToHalf as Imf_uintToHalf;
pub use imf_convert::Imf_3_0_floatToHalf as Imf_floatToHalf;
pub mod imf_timecode;
pub use imf_timecode::Imf_3_0__TimeCode_t as Imf_TimeCode_t;

pub use imf_timecode::Imf_3_0__TimeCode__Packing_e as Imf_TimeCode_Packing;
pub use imf_timecode::Imf_TimeCode_Packing_TV60_PACKING;
pub use imf_timecode::Imf_TimeCode_Packing_TV50_PACKING;
pub use imf_timecode::Imf_TimeCode_Packing_FILM24_PACKING;
pub use imf_timecode::Imf_3_0__TimeCode_sizeof as Imf_TimeCode_sizeof;
pub use imf_timecode::Imf_3_0__TimeCode_alignof as Imf_TimeCode_alignof;
pub use imf_timecode::Imf_3_0__TimeCode_default as Imf_TimeCode_default;
pub use imf_timecode::Imf_3_0__TimeCode_ctor as Imf_TimeCode_ctor;
pub use imf_timecode::Imf_3_0__TimeCode_from_time_and_flags as Imf_TimeCode_from_time_and_flags;
pub use imf_timecode::Imf_3_0__TimeCode_copy as Imf_TimeCode_copy;
pub use imf_timecode::Imf_3_0__TimeCode_dtor as Imf_TimeCode_dtor;
pub use imf_timecode::Imf_3_0__TimeCode__assign as Imf_TimeCode__assign;
pub use imf_timecode::Imf_3_0__TimeCode_hours as Imf_TimeCode_hours;
pub use imf_timecode::Imf_3_0__TimeCode_setHours as Imf_TimeCode_setHours;
pub use imf_timecode::Imf_3_0__TimeCode_minutes as Imf_TimeCode_minutes;
pub use imf_timecode::Imf_3_0__TimeCode_setMinutes as Imf_TimeCode_setMinutes;
pub use imf_timecode::Imf_3_0__TimeCode_seconds as Imf_TimeCode_seconds;
pub use imf_timecode::Imf_3_0__TimeCode_setSeconds as Imf_TimeCode_setSeconds;
pub use imf_timecode::Imf_3_0__TimeCode_frame as Imf_TimeCode_frame;
pub use imf_timecode::Imf_3_0__TimeCode_setFrame as Imf_TimeCode_setFrame;
pub use imf_timecode::Imf_3_0__TimeCode_dropFrame as Imf_TimeCode_dropFrame;
pub use imf_timecode::Imf_3_0__TimeCode_setDropFrame as Imf_TimeCode_setDropFrame;
pub use imf_timecode::Imf_3_0__TimeCode_colorFrame as Imf_TimeCode_colorFrame;
pub use imf_timecode::Imf_3_0__TimeCode_setColorFrame as Imf_TimeCode_setColorFrame;
pub use imf_timecode::Imf_3_0__TimeCode_fieldPhase as Imf_TimeCode_fieldPhase;
pub use imf_timecode::Imf_3_0__TimeCode_setFieldPhase as Imf_TimeCode_setFieldPhase;
pub use imf_timecode::Imf_3_0__TimeCode_bgf0 as Imf_TimeCode_bgf0;
pub use imf_timecode::Imf_3_0__TimeCode_setBgf0 as Imf_TimeCode_setBgf0;
pub use imf_timecode::Imf_3_0__TimeCode_bgf1 as Imf_TimeCode_bgf1;
pub use imf_timecode::Imf_3_0__TimeCode_setBgf1 as Imf_TimeCode_setBgf1;
pub use imf_timecode::Imf_3_0__TimeCode_bgf2 as Imf_TimeCode_bgf2;
pub use imf_timecode::Imf_3_0__TimeCode_setBgf2 as Imf_TimeCode_setBgf2;
pub use imf_timecode::Imf_3_0__TimeCode_binaryGroup as Imf_TimeCode_binaryGroup;
pub use imf_timecode::Imf_3_0__TimeCode_setBinaryGroup as Imf_TimeCode_setBinaryGroup;
pub use imf_timecode::Imf_3_0__TimeCode_timeAndFlags as Imf_TimeCode_timeAndFlags;
pub use imf_timecode::Imf_3_0__TimeCode_setTimeAndFlags as Imf_TimeCode_setTimeAndFlags;
pub use imf_timecode::Imf_3_0__TimeCode_userData as Imf_TimeCode_userData;
pub use imf_timecode::Imf_3_0__TimeCode_setUserData as Imf_TimeCode_setUserData;
pub use imf_timecode::Imf_3_0__TimeCode__eq as Imf_TimeCode__eq;
pub use imf_timecode::Imf_3_0__TimeCode__ne as Imf_TimeCode__ne;
pub mod imf_deepscanlineoutputpart;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_t as Imf_DeepScanLineOutputPart_t;

pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_sizeof as Imf_DeepScanLineOutputPart_sizeof;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_alignof as Imf_DeepScanLineOutputPart_alignof;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_ctor as Imf_DeepScanLineOutputPart_ctor;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_fileName as Imf_DeepScanLineOutputPart_fileName;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_header as Imf_DeepScanLineOutputPart_header;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_setFrameBuffer as Imf_DeepScanLineOutputPart_setFrameBuffer;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_frameBuffer as Imf_DeepScanLineOutputPart_frameBuffer;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_writePixels as Imf_DeepScanLineOutputPart_writePixels;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_currentScanLine as Imf_DeepScanLineOutputPart_currentScanLine;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_copyPixels_from_file as Imf_DeepScanLineOutputPart_copyPixels_from_file;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_copyPixels_from_part as Imf_DeepScanLineOutputPart_copyPixels_from_part;
pub use imf_deepscanlineoutputpart::Imf_3_0__DeepScanLineOutputPart_updatePreviewImage as Imf_DeepScanLineOutputPart_updatePreviewImage;
pub mod imf_tiledoutputfile;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_t as Imf_TiledOutputFile_t;

pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_ctor as Imf_TiledOutputFile_ctor;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_from_stream as Imf_TiledOutputFile_from_stream;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_dtor as Imf_TiledOutputFile_dtor;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_fileName as Imf_TiledOutputFile_fileName;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_header as Imf_TiledOutputFile_header;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_setFrameBuffer as Imf_TiledOutputFile_setFrameBuffer;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_frameBuffer as Imf_TiledOutputFile_frameBuffer;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_tileXSize as Imf_TiledOutputFile_tileXSize;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_tileYSize as Imf_TiledOutputFile_tileYSize;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_levelMode as Imf_TiledOutputFile_levelMode;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_levelRoundingMode as Imf_TiledOutputFile_levelRoundingMode;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_numLevels as Imf_TiledOutputFile_numLevels;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_numXLevels as Imf_TiledOutputFile_numXLevels;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_numYLevels as Imf_TiledOutputFile_numYLevels;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_isValidLevel as Imf_TiledOutputFile_isValidLevel;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_levelWidth as Imf_TiledOutputFile_levelWidth;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_levelHeight as Imf_TiledOutputFile_levelHeight;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_numXTiles as Imf_TiledOutputFile_numXTiles;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_numYTiles as Imf_TiledOutputFile_numYTiles;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_dataWindowForLevel as Imf_TiledOutputFile_dataWindowForLevel;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_dataWindowForTile as Imf_TiledOutputFile_dataWindowForTile;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_writeTile as Imf_TiledOutputFile_writeTile;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_writeTiles as Imf_TiledOutputFile_writeTiles;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_copyPixels_from_tiled_file as Imf_TiledOutputFile_copyPixels_from_tiled_file;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_copyPixels_from_tiled_part as Imf_TiledOutputFile_copyPixels_from_tiled_part;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_copyPixels_from_file as Imf_TiledOutputFile_copyPixels_from_file;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_copyPixels_from_part as Imf_TiledOutputFile_copyPixels_from_part;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_updatePreviewImage as Imf_TiledOutputFile_updatePreviewImage;
pub use imf_tiledoutputfile::Imf_3_0__TiledOutputFile_breakTile as Imf_TiledOutputFile_breakTile;
pub mod imf_deeptiledinputpart;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_t as Imf_DeepTiledInputPart_t;

pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_sizeof as Imf_DeepTiledInputPart_sizeof;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_alignof as Imf_DeepTiledInputPart_alignof;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_ctor as Imf_DeepTiledInputPart_ctor;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_fileName as Imf_DeepTiledInputPart_fileName;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_header as Imf_DeepTiledInputPart_header;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_version as Imf_DeepTiledInputPart_version;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_setFrameBuffer as Imf_DeepTiledInputPart_setFrameBuffer;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_frameBuffer as Imf_DeepTiledInputPart_frameBuffer;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_isComplete as Imf_DeepTiledInputPart_isComplete;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_tileXSize as Imf_DeepTiledInputPart_tileXSize;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_tileYSize as Imf_DeepTiledInputPart_tileYSize;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_levelMode as Imf_DeepTiledInputPart_levelMode;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_levelRoundingMode as Imf_DeepTiledInputPart_levelRoundingMode;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_numLevels as Imf_DeepTiledInputPart_numLevels;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_numXLevels as Imf_DeepTiledInputPart_numXLevels;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_numYLevels as Imf_DeepTiledInputPart_numYLevels;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_isValidLevel as Imf_DeepTiledInputPart_isValidLevel;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_levelWidth as Imf_DeepTiledInputPart_levelWidth;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_levelHeight as Imf_DeepTiledInputPart_levelHeight;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_numXTiles as Imf_DeepTiledInputPart_numXTiles;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_numYTiles as Imf_DeepTiledInputPart_numYTiles;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_dataWindowForLevel as Imf_DeepTiledInputPart_dataWindowForLevel;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_dataWindowForTile as Imf_DeepTiledInputPart_dataWindowForTile;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_readTile as Imf_DeepTiledInputPart_readTile;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_readTiles as Imf_DeepTiledInputPart_readTiles;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_rawTileData as Imf_DeepTiledInputPart_rawTileData;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_readPixelSampleCount as Imf_DeepTiledInputPart_readPixelSampleCount;
pub use imf_deeptiledinputpart::Imf_3_0__DeepTiledInputPart_readPixelSampleCounts as Imf_DeepTiledInputPart_readPixelSampleCounts;
pub mod imf_deepimagelevel;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_t as Imf_DeepImageLevel_t;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_t as Imf_DeepImageLevel_Iterator_t;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_t as Imf_DeepImageLevel_ConstIterator_t;

pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_image as Imf_DeepImageLevel_image;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_image_const as Imf_DeepImageLevel_image_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_xLevelNumber as Imf_DeepImageLevel_xLevelNumber;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_yLevelNumber as Imf_DeepImageLevel_yLevelNumber;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_dataWindow as Imf_DeepImageLevel_dataWindow;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_deepImage as Imf_DeepImageLevel_deepImage;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_deepImage_const as Imf_DeepImageLevel_deepImage_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_findChannel as Imf_DeepImageLevel_findChannel;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_findChannel_const as Imf_DeepImageLevel_findChannel_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_channel as Imf_DeepImageLevel_channel;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_channel_const as Imf_DeepImageLevel_channel_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_findTypedChannel_half as Imf_DeepImageLevel_findTypedChannel_half;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_findTypedChannel_float as Imf_DeepImageLevel_findTypedChannel_float;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_findTypedChannel_uint as Imf_DeepImageLevel_findTypedChannel_uint;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_findTypedChannel_half_const as Imf_DeepImageLevel_findTypedChannel_half_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_findTypedChannel_float_const as Imf_DeepImageLevel_findTypedChannel_float_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_findTypedChannel_uint_const as Imf_DeepImageLevel_findTypedChannel_uint_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_begin as Imf_DeepImageLevel_begin;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_begin_const as Imf_DeepImageLevel_begin_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_end as Imf_DeepImageLevel_end;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_end_const as Imf_DeepImageLevel_end_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_sampleCounts as Imf_DeepImageLevel_sampleCounts;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel_sampleCounts_const as Imf_DeepImageLevel_sampleCounts_const;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_sizeof as Imf_DeepImageLevel_Iterator_sizeof;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_alignof as Imf_DeepImageLevel_Iterator_alignof;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_ctor as Imf_DeepImageLevel_Iterator_ctor;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_inc as Imf_DeepImageLevel_Iterator_inc;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_name as Imf_DeepImageLevel_Iterator_name;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_channel as Imf_DeepImageLevel_Iterator_channel;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_copy as Imf_DeepImageLevel_Iterator_copy;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__Iterator_move as Imf_DeepImageLevel_Iterator_move;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_sizeof as Imf_DeepImageLevel_ConstIterator_sizeof;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_alignof as Imf_DeepImageLevel_ConstIterator_alignof;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_ctor as Imf_DeepImageLevel_ConstIterator_ctor;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_from_mut as Imf_DeepImageLevel_ConstIterator_from_mut;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_inc as Imf_DeepImageLevel_ConstIterator_inc;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_name as Imf_DeepImageLevel_ConstIterator_name;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_channel as Imf_DeepImageLevel_ConstIterator_channel;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_copy as Imf_DeepImageLevel_ConstIterator_copy;
pub use imf_deepimagelevel::Imf_3_0__DeepImageLevel__ConstIterator_move as Imf_DeepImageLevel_ConstIterator_move;
pub mod imf_tiledinputpart;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_t as Imf_TiledInputPart_t;

pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_sizeof as Imf_TiledInputPart_sizeof;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_alignof as Imf_TiledInputPart_alignof;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_ctor as Imf_TiledInputPart_ctor;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_fileName as Imf_TiledInputPart_fileName;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_header as Imf_TiledInputPart_header;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_version as Imf_TiledInputPart_version;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_setFrameBuffer as Imf_TiledInputPart_setFrameBuffer;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_frameBuffer as Imf_TiledInputPart_frameBuffer;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_isComplete as Imf_TiledInputPart_isComplete;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_tileXSize as Imf_TiledInputPart_tileXSize;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_tileYSize as Imf_TiledInputPart_tileYSize;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_levelMode as Imf_TiledInputPart_levelMode;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_levelRoundingMode as Imf_TiledInputPart_levelRoundingMode;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_numLevels as Imf_TiledInputPart_numLevels;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_numXLevels as Imf_TiledInputPart_numXLevels;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_numYLevels as Imf_TiledInputPart_numYLevels;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_isValidLevel as Imf_TiledInputPart_isValidLevel;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_levelWidth as Imf_TiledInputPart_levelWidth;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_levelHeight as Imf_TiledInputPart_levelHeight;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_numXTiles as Imf_TiledInputPart_numXTiles;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_numYTiles as Imf_TiledInputPart_numYTiles;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_dataWindowForLevel as Imf_TiledInputPart_dataWindowForLevel;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_dataWindowForTile as Imf_TiledInputPart_dataWindowForTile;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_readTile as Imf_TiledInputPart_readTile;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_readTiles as Imf_TiledInputPart_readTiles;
pub use imf_tiledinputpart::Imf_3_0__TiledInputPart_rawTileData as Imf_TiledInputPart_rawTileData;
pub mod imf_multipartinputfile;
pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_t as Imf_MultiPartInputFile_t;

pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_ctor as Imf_MultiPartInputFile_ctor;
pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_from_stream as Imf_MultiPartInputFile_from_stream;
pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_dtor as Imf_MultiPartInputFile_dtor;
pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_parts as Imf_MultiPartInputFile_parts;
pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_header as Imf_MultiPartInputFile_header;
pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_version as Imf_MultiPartInputFile_version;
pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_partComplete as Imf_MultiPartInputFile_partComplete;
pub use imf_multipartinputfile::Imf_3_0__MultiPartInputFile_flushPartCache as Imf_MultiPartInputFile_flushPartCache;
pub mod imf_testfile;

pub use imf_testfile::Imf_3_0_isOpenExrFile as Imf_isOpenExrFile;
pub use imf_testfile::Imf_3_0_isTiledOpenExrFile as Imf_isTiledOpenExrFile;
pub use imf_testfile::Imf_3_0_isDeepOpenExrFile as Imf_isDeepOpenExrFile;
pub use imf_testfile::Imf_3_0_isMultiPartOpenExrFile as Imf_isMultiPartOpenExrFile;
pub use imf_testfile::Imf_3_0_stream_is_openexr_file as Imf_stream_is_openexr_file;
pub use imf_testfile::Imf_3_0_stream_is_tiled_openexr_file as Imf_stream_is_tiled_openexr_file;
pub use imf_testfile::Imf_3_0_stream_is_deep_openexr_file as Imf_stream_is_deep_openexr_file;
pub use imf_testfile::Imf_3_0_stream_is_multi_part_openexr_file as Imf_stream_is_multi_part_openexr_file;
pub mod imf_header;
pub use imf_header::Imf_3_0__Header_t as Imf_Header_t;
pub use imf_header::Imf_3_0__Header__Iterator_t as Imf_Header_Iterator_t;
pub use imf_header::Imf_3_0__Header__ConstIterator_t as Imf_Header_ConstIterator_t;

pub use imf_header::Imf_3_0__Header_sizeof as Imf_Header_sizeof;
pub use imf_header::Imf_3_0__Header_alignof as Imf_Header_alignof;
pub use imf_header::Imf_3_0__Header_with_dimensions as Imf_Header_with_dimensions;
pub use imf_header::Imf_3_0__Header_ctor as Imf_Header_ctor;
pub use imf_header::Imf_3_0__Header_copy as Imf_Header_copy;
pub use imf_header::Imf_3_0__Header_dtor as Imf_Header_dtor;
pub use imf_header::Imf_3_0__Header__assign as Imf_Header__assign;
pub use imf_header::Imf_3_0__Header_insert as Imf_Header_insert;
pub use imf_header::Imf_3_0__Header_erase as Imf_Header_erase;
pub use imf_header::Imf_3_0__Header_index as Imf_Header_index;
pub use imf_header::Imf_3_0__Header_index_const as Imf_Header_index_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Int as Imf_Header_findTypedAttribute_Int;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Float as Imf_Header_findTypedAttribute_Float;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Double as Imf_Header_findTypedAttribute_Double;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Box2i as Imf_Header_findTypedAttribute_Box2i;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Box2f as Imf_Header_findTypedAttribute_Box2f;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_ChannelList as Imf_Header_findTypedAttribute_ChannelList;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Chromaticities as Imf_Header_findTypedAttribute_Chromaticities;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Compression as Imf_Header_findTypedAttribute_Compression;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_DeepImageState as Imf_Header_findTypedAttribute_DeepImageState;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Envmap as Imf_Header_findTypedAttribute_Envmap;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_CppVectorFloat as Imf_Header_findTypedAttribute_CppVectorFloat;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_CppVectorString as Imf_Header_findTypedAttribute_CppVectorString;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_CppString as Imf_Header_findTypedAttribute_CppString;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_KeyCode as Imf_Header_findTypedAttribute_KeyCode;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_LineOrder as Imf_Header_findTypedAttribute_LineOrder;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_M33f as Imf_Header_findTypedAttribute_M33f;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_M33d as Imf_Header_findTypedAttribute_M33d;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_M44f as Imf_Header_findTypedAttribute_M44f;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_M44d as Imf_Header_findTypedAttribute_M44d;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_PreviewImage as Imf_Header_findTypedAttribute_PreviewImage;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Rational as Imf_Header_findTypedAttribute_Rational;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_TimeCode as Imf_Header_findTypedAttribute_TimeCode;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V2i as Imf_Header_findTypedAttribute_V2i;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V2f as Imf_Header_findTypedAttribute_V2f;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V2d as Imf_Header_findTypedAttribute_V2d;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V3i as Imf_Header_findTypedAttribute_V3i;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V3f as Imf_Header_findTypedAttribute_V3f;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V3d as Imf_Header_findTypedAttribute_V3d;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Int_const as Imf_Header_findTypedAttribute_Int_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Float_const as Imf_Header_findTypedAttribute_Float_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Double_const as Imf_Header_findTypedAttribute_Double_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Box2i_const as Imf_Header_findTypedAttribute_Box2i_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Box2f_const as Imf_Header_findTypedAttribute_Box2f_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_ChannelList_const as Imf_Header_findTypedAttribute_ChannelList_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Chromaticities_const as Imf_Header_findTypedAttribute_Chromaticities_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Compression_const as Imf_Header_findTypedAttribute_Compression_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_DeepImageState_const as Imf_Header_findTypedAttribute_DeepImageState_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Envmap_const as Imf_Header_findTypedAttribute_Envmap_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_CppVectorFloat_const as Imf_Header_findTypedAttribute_CppVectorFloat_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_CppVectorString_const as Imf_Header_findTypedAttribute_CppVectorString_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_CppString_const as Imf_Header_findTypedAttribute_CppString_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_KeyCode_const as Imf_Header_findTypedAttribute_KeyCode_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_LineOrder_const as Imf_Header_findTypedAttribute_LineOrder_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_M33f_const as Imf_Header_findTypedAttribute_M33f_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_M33d_const as Imf_Header_findTypedAttribute_M33d_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_M44f_const as Imf_Header_findTypedAttribute_M44f_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_M44d_const as Imf_Header_findTypedAttribute_M44d_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_PreviewImage_const as Imf_Header_findTypedAttribute_PreviewImage_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_Rational_const as Imf_Header_findTypedAttribute_Rational_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_TimeCode_const as Imf_Header_findTypedAttribute_TimeCode_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V2i_const as Imf_Header_findTypedAttribute_V2i_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V2f_const as Imf_Header_findTypedAttribute_V2f_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V2d_const as Imf_Header_findTypedAttribute_V2d_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V3i_const as Imf_Header_findTypedAttribute_V3i_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V3f_const as Imf_Header_findTypedAttribute_V3f_const;
pub use imf_header::Imf_3_0__Header_findTypedAttribute_V3d_const as Imf_Header_findTypedAttribute_V3d_const;
pub use imf_header::Imf_3_0__Header_begin as Imf_Header_begin;
pub use imf_header::Imf_3_0__Header_begin_const as Imf_Header_begin_const;
pub use imf_header::Imf_3_0__Header_end as Imf_Header_end;
pub use imf_header::Imf_3_0__Header_end_const as Imf_Header_end_const;
pub use imf_header::Imf_3_0__Header_find as Imf_Header_find;
pub use imf_header::Imf_3_0__Header_find_const as Imf_Header_find_const;
pub use imf_header::Imf_3_0__Header_displayWindow as Imf_Header_displayWindow;
pub use imf_header::Imf_3_0__Header_displayWindow_const as Imf_Header_displayWindow_const;
pub use imf_header::Imf_3_0__Header_dataWindow as Imf_Header_dataWindow;
pub use imf_header::Imf_3_0__Header_dataWindow_const as Imf_Header_dataWindow_const;
pub use imf_header::Imf_3_0__Header_pixelAspectRatio as Imf_Header_pixelAspectRatio;
pub use imf_header::Imf_3_0__Header_pixelAspectRatio_const as Imf_Header_pixelAspectRatio_const;
pub use imf_header::Imf_3_0__Header_screenWindowCenter as Imf_Header_screenWindowCenter;
pub use imf_header::Imf_3_0__Header_screenWindowCenter_const as Imf_Header_screenWindowCenter_const;
pub use imf_header::Imf_3_0__Header_screenWindowWidth as Imf_Header_screenWindowWidth;
pub use imf_header::Imf_3_0__Header_screenWindowWidth_const as Imf_Header_screenWindowWidth_const;
pub use imf_header::Imf_3_0__Header_channels as Imf_Header_channels;
pub use imf_header::Imf_3_0__Header_channels_const as Imf_Header_channels_const;
pub use imf_header::Imf_3_0__Header_lineOrder as Imf_Header_lineOrder;
pub use imf_header::Imf_3_0__Header_lineOrder_const as Imf_Header_lineOrder_const;
pub use imf_header::Imf_3_0__Header_compression as Imf_Header_compression;
pub use imf_header::Imf_3_0__Header_compression_const as Imf_Header_compression_const;
pub use imf_header::Imf_3_0__Header_setName as Imf_Header_setName;
pub use imf_header::Imf_3_0__Header_name as Imf_Header_name;
pub use imf_header::Imf_3_0__Header_name_const as Imf_Header_name_const;
pub use imf_header::Imf_3_0__Header_hasName as Imf_Header_hasName;
pub use imf_header::Imf_3_0__Header_setType as Imf_Header_setType;
pub use imf_header::Imf_3_0__Header_type as Imf_Header_type;
pub use imf_header::Imf_3_0__Header_type_const as Imf_Header_type_const;
pub use imf_header::Imf_3_0__Header_hasType as Imf_Header_hasType;
pub use imf_header::Imf_3_0__Header_setVersion as Imf_Header_setVersion;
pub use imf_header::Imf_3_0__Header_version as Imf_Header_version;
pub use imf_header::Imf_3_0__Header_version_const as Imf_Header_version_const;
pub use imf_header::Imf_3_0__Header_hasVersion as Imf_Header_hasVersion;
pub use imf_header::Imf_3_0__Header_setChunkCount as Imf_Header_setChunkCount;
pub use imf_header::Imf_3_0__Header_hasChunkCount as Imf_Header_hasChunkCount;
pub use imf_header::Imf_3_0__Header_chunkCount_const as Imf_Header_chunkCount_const;
pub use imf_header::Imf_3_0__Header_setView as Imf_Header_setView;
pub use imf_header::Imf_3_0__Header_hasView as Imf_Header_hasView;
pub use imf_header::Imf_3_0__Header_view as Imf_Header_view;
pub use imf_header::Imf_3_0__Header_view_const as Imf_Header_view_const;
pub use imf_header::Imf_3_0__Header_setTileDescription as Imf_Header_setTileDescription;
pub use imf_header::Imf_3_0__Header_tileDescription as Imf_Header_tileDescription;
pub use imf_header::Imf_3_0__Header_tileDescription_const as Imf_Header_tileDescription_const;
pub use imf_header::Imf_3_0__Header_hasTileDescription as Imf_Header_hasTileDescription;
pub use imf_header::Imf_3_0__Header_setPreviewImage as Imf_Header_setPreviewImage;
pub use imf_header::Imf_3_0__Header_previewImage as Imf_Header_previewImage;
pub use imf_header::Imf_3_0__Header_previewImage_const as Imf_Header_previewImage_const;
pub use imf_header::Imf_3_0__Header_hasPreviewImage as Imf_Header_hasPreviewImage;
pub use imf_header::Imf_3_0__Header_sanityCheck as Imf_Header_sanityCheck;
pub use imf_header::Imf_3_0__Header_setMaxImageSize_1 as Imf_Header_setMaxImageSize;
pub use imf_header::Imf_3_0__Header_setMaxTileSize_1 as Imf_Header_setMaxTileSize;
pub use imf_header::Imf_3_0__Header_readsNothing as Imf_Header_readsNothing;
pub use imf_header::Imf_3_0__Header_writeTo as Imf_Header_writeTo;
pub use imf_header::Imf_3_0__Header_readFrom as Imf_Header_readFrom;
pub use imf_header::Imf_3_0__Header__Iterator_sizeof as Imf_Header_Iterator_sizeof;
pub use imf_header::Imf_3_0__Header__Iterator_alignof as Imf_Header_Iterator_alignof;
pub use imf_header::Imf_3_0__Header__Iterator_ctor as Imf_Header_Iterator_ctor;
pub use imf_header::Imf_3_0__Header__Iterator_inc as Imf_Header_Iterator_inc;
pub use imf_header::Imf_3_0__Header__Iterator_name as Imf_Header_Iterator_name;
pub use imf_header::Imf_3_0__Header__Iterator_attribute as Imf_Header_Iterator_attribute;
pub use imf_header::Imf_3_0__Header__Iterator_copy as Imf_Header_Iterator_copy;
pub use imf_header::Imf_3_0__Header__Iterator_move as Imf_Header_Iterator_move;
pub use imf_header::Imf_3_0__Header__ConstIterator_sizeof as Imf_Header_ConstIterator_sizeof;
pub use imf_header::Imf_3_0__Header__ConstIterator_alignof as Imf_Header_ConstIterator_alignof;
pub use imf_header::Imf_3_0__Header__ConstIterator_ctor as Imf_Header_ConstIterator_ctor;
pub use imf_header::Imf_3_0__Header__ConstIterator_from_mut as Imf_Header_ConstIterator_from_mut;
pub use imf_header::Imf_3_0__Header__ConstIterator_inc as Imf_Header_ConstIterator_inc;
pub use imf_header::Imf_3_0__Header__ConstIterator_name as Imf_Header_ConstIterator_name;
pub use imf_header::Imf_3_0__Header__ConstIterator_attribute as Imf_Header_ConstIterator_attribute;
pub use imf_header::Imf_3_0__Header__ConstIterator_copy as Imf_Header_ConstIterator_copy;
pub use imf_header::Imf_3_0__Header__ConstIterator_move as Imf_Header_ConstIterator_move;
pub mod imf_compositedeepscanline;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_t as Imf_CompositeDeepScanLine_t;

pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_ctor as Imf_CompositeDeepScanLine_ctor;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_dtor as Imf_CompositeDeepScanLine_dtor;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_addSource_part as Imf_CompositeDeepScanLine_addSource_part;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_addSource_file as Imf_CompositeDeepScanLine_addSource_file;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_setFrameBuffer as Imf_CompositeDeepScanLine_setFrameBuffer;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_frameBuffer as Imf_CompositeDeepScanLine_frameBuffer;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_readPixels as Imf_CompositeDeepScanLine_readPixels;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_sources as Imf_CompositeDeepScanLine_sources;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_dataWindow as Imf_CompositeDeepScanLine_dataWindow;
pub use imf_compositedeepscanline::Imf_3_0__CompositeDeepScanLine_setCompositing as Imf_CompositeDeepScanLine_setCompositing;
pub mod imf_deepimagestate;

pub use imf_deepimagestate::Imf_3_0__DeepImageState_e as Imf_DeepImageState;
pub use imf_deepimagestate::Imf_DeepImageState_DIS_MESSY;
pub use imf_deepimagestate::Imf_DeepImageState_DIS_SORTED;
pub use imf_deepimagestate::Imf_DeepImageState_DIS_NON_OVERLAPPING;
pub use imf_deepimagestate::Imf_DeepImageState_DIS_TIDY;
pub use imf_deepimagestate::Imf_DeepImageState_DIS_NUMSTATES;
pub use imf_deepimagestate::DeepImageState;
pub mod imf_rgbayca;

pub use imf_rgbayca::Imf_3_0_RgbaYca_computeYw as Imf_RgbaYca_computeYw;
pub use imf_rgbayca::Imf_3_0_RgbaYca_RGBAtoYCA as Imf_RgbaYca_RGBAtoYCA;
pub use imf_rgbayca::Imf_3_0_RgbaYca_decimateChromaHoriz as Imf_RgbaYca_decimateChromaHoriz;
pub use imf_rgbayca::Imf_3_0_RgbaYca_roundYCA as Imf_RgbaYca_roundYCA;
pub use imf_rgbayca::Imf_3_0_RgbaYca_reconstructChromaHoriz as Imf_RgbaYca_reconstructChromaHoriz;
pub use imf_rgbayca::Imf_3_0_RgbaYca_YCAtoRGBA as Imf_RgbaYca_YCAtoRGBA;
pub mod imf_threading;

pub use imf_threading::Imf_3_0_globalThreadCount as Imf_globalThreadCount;
pub use imf_threading::Imf_3_0_setGlobalThreadCount as Imf_setGlobalThreadCount;
pub mod imf_deepimageio;

pub use imf_deepimageio::Imf_3_0_saveDeepImage_with_header as Imf_saveDeepImage_with_header;
pub use imf_deepimageio::Imf_3_0_saveDeepImage as Imf_saveDeepImage;
pub use imf_deepimageio::Imf_3_0_loadDeepImage_with_header as Imf_loadDeepImage_with_header;
pub use imf_deepimageio::Imf_3_0_loadDeepImage as Imf_loadDeepImage;
pub use imf_deepimageio::Imf_3_0_saveDeepScanLineImage_with_header as Imf_saveDeepScanLineImage_with_header;
pub use imf_deepimageio::Imf_3_0_saveDeepScanLineImage as Imf_saveDeepScanLineImage;
pub use imf_deepimageio::Imf_3_0_loadDeepScanLineImage_with_header as Imf_loadDeepScanLineImage_with_header;
pub use imf_deepimageio::Imf_3_0_loadDeepScanLineImage as Imf_loadDeepScanLineImage;
pub use imf_deepimageio::Imf_3_0_saveDeepTiledImage_with_header as Imf_saveDeepTiledImage_with_header;
pub use imf_deepimageio::Imf_3_0_saveDeepTiledImage as Imf_saveDeepTiledImage;
pub use imf_deepimageio::Imf_3_0_loadDeepTiledImage_with_header as Imf_loadDeepTiledImage_with_header;
pub use imf_deepimageio::Imf_3_0_loadDeepTiledImage as Imf_loadDeepTiledImage;
pub mod imf_parthelper;
pub use imf_parthelper::Imf_3_0__MultiViewChannelName_t as Imf_MultiViewChannelName_t;

pub use imf_parthelper::Imf_3_0__MultiViewChannelName_copy as Imf_MultiViewChannelName_copy;
pub use imf_parthelper::Imf_3_0__MultiViewChannelName_move as Imf_MultiViewChannelName_move;
pub use imf_parthelper::Imf_3_0__MultiViewChannelName_dtor as Imf_MultiViewChannelName_dtor;
pub use imf_parthelper::Imf_3_0__MultiViewChannelName_ctor as Imf_MultiViewChannelName_ctor;
pub mod imf_imagedatawindow;

pub use imf_imagedatawindow::Imf_3_0__DataWindowSource_e as Imf_DataWindowSource;
pub use imf_imagedatawindow::Imf_DataWindowSource_USE_IMAGE_DATA_WINDOW;
pub use imf_imagedatawindow::Imf_DataWindowSource_USE_HEADER_DATA_WINDOW;
pub use imf_imagedatawindow::DataWindowSource;
pub use imf_imagedatawindow::Imf_3_0_dataWindowForFile as Imf_dataWindowForFile;
pub mod std_map;
pub use std_map::std__map_std__string_std__string__t as std_map_string_string_t;

pub use std_map::std__map_std__string_std__string__ctor as std_map_string_string_ctor;
pub use std_map::std__map_std__string_std__string__dtor as std_map_string_string_dtor;
pub mod imf_lineorder;

pub use imf_lineorder::Imf_3_0__LineOrder_e as Imf_LineOrder;
pub use imf_lineorder::Imf_LineOrder_INCREASING_Y;
pub use imf_lineorder::Imf_LineOrder_DECREASING_Y;
pub use imf_lineorder::Imf_LineOrder_RANDOM_Y;
pub use imf_lineorder::Imf_LineOrder_NUM_LINEORDERS;
pub use imf_lineorder::LineOrder;
pub mod imf_flatimage;
pub use imf_flatimage::Imf_3_0__FlatImage_t as Imf_FlatImage_t;

pub use imf_flatimage::Imf_3_0__FlatImage_levelMode as Imf_FlatImage_levelMode;
pub use imf_flatimage::Imf_3_0__FlatImage_levelRoundingMode as Imf_FlatImage_levelRoundingMode;
pub use imf_flatimage::Imf_3_0__FlatImage_numLevels as Imf_FlatImage_numLevels;
pub use imf_flatimage::Imf_3_0__FlatImage_numXLevels as Imf_FlatImage_numXLevels;
pub use imf_flatimage::Imf_3_0__FlatImage_numYLevels as Imf_FlatImage_numYLevels;
pub use imf_flatimage::Imf_3_0__FlatImage_dataWindow as Imf_FlatImage_dataWindow;
pub use imf_flatimage::Imf_3_0__FlatImage_dataWindowForLevel as Imf_FlatImage_dataWindowForLevel;
pub use imf_flatimage::Imf_3_0__FlatImage_levelWidth as Imf_FlatImage_levelWidth;
pub use imf_flatimage::Imf_3_0__FlatImage_levelHeight as Imf_FlatImage_levelHeight;
pub use imf_flatimage::Imf_3_0__FlatImage_resize as Imf_FlatImage_resize;
pub use imf_flatimage::Imf_3_0__FlatImage_shiftPixels as Imf_FlatImage_shiftPixels;
pub use imf_flatimage::Imf_3_0__FlatImage_insertChannel as Imf_FlatImage_insertChannel;
pub use imf_flatimage::Imf_3_0__FlatImage_eraseChannel as Imf_FlatImage_eraseChannel;
pub use imf_flatimage::Imf_3_0__FlatImage_clearChannels as Imf_FlatImage_clearChannels;
pub use imf_flatimage::Imf_3_0__FlatImage_renameChannel as Imf_FlatImage_renameChannel;
pub use imf_flatimage::Imf_3_0__FlatImage_default as Imf_FlatImage_default;
pub use imf_flatimage::Imf_3_0__FlatImage_ctor as Imf_FlatImage_ctor;
pub use imf_flatimage::Imf_3_0__FlatImage_dtor as Imf_FlatImage_dtor;
pub use imf_flatimage::Imf_3_0__FlatImage_level as Imf_FlatImage_level;
pub use imf_flatimage::Imf_3_0__FlatImage_level_const as Imf_FlatImage_level_const;
pub mod imf_previewimage;
pub use imf_previewimage::Imf_3_0__PreviewRgba_t as Imf_PreviewRgba_t;
pub use imf_previewimage::Imf_3_0__PreviewImage_t as Imf_PreviewImage_t;

pub use imf_previewimage::Imf_3_0__PreviewRgba_ctor as Imf_PreviewRgba_ctor;
pub use imf_previewimage::Imf_3_0__PreviewImage_ctor as Imf_PreviewImage_ctor;
pub use imf_previewimage::Imf_3_0__PreviewImage_copy as Imf_PreviewImage_copy;
pub use imf_previewimage::Imf_3_0__PreviewImage_dtor as Imf_PreviewImage_dtor;
pub use imf_previewimage::Imf_3_0__PreviewImage__assign as Imf_PreviewImage__assign;
pub use imf_previewimage::Imf_3_0__PreviewImage_width as Imf_PreviewImage_width;
pub use imf_previewimage::Imf_3_0__PreviewImage_height as Imf_PreviewImage_height;
pub use imf_previewimage::Imf_3_0__PreviewImage_pixels as Imf_PreviewImage_pixels;
pub use imf_previewimage::Imf_3_0__PreviewImage_pixels_const as Imf_PreviewImage_pixels_const;
pub use imf_previewimage::Imf_3_0__PreviewImage_pixel as Imf_PreviewImage_pixel;
pub use imf_previewimage::Imf_3_0__PreviewImage_pixel_const as Imf_PreviewImage_pixel_const;
pub mod imath_vec;
pub use imath_vec::Imath_3_0__Vec2_short__t as Imath_V2s_t;
pub use imath_vec::Imath_3_0__Vec2_int__t as Imath_V2i_t;
pub use imath_vec::Imath_3_0__Vec2_long__t as Imath_V2i64_t;
pub use imath_vec::Imath_3_0__Vec2_float__t as Imath_V2f_t;
pub use imath_vec::Imath_3_0__Vec2_double__t as Imath_V2d_t;
pub use imath_vec::Imath_3_0__Vec3_short__t as Imath_V3s_t;
pub use imath_vec::Imath_3_0__Vec3_int__t as Imath_V3i_t;
pub use imath_vec::Imath_3_0__Vec3_long__t as Imath_V3i64_t;
pub use imath_vec::Imath_3_0__Vec3_float__t as Imath_V3f_t;
pub use imath_vec::Imath_3_0__Vec3_double__t as Imath_V3d_t;
pub use imath_vec::Imath_3_0__Vec4_short__t as Imath_V4s_t;
pub use imath_vec::Imath_3_0__Vec4_int__t as Imath_Vec4_t;
pub use imath_vec::Imath_3_0__Vec4_long__t as Imath_V4i64_t;
pub use imath_vec::Imath_3_0__Vec4_float__t as Imath_V4f_t;
pub use imath_vec::Imath_3_0__Vec4_double__t as Imath_V4d_t;

pub use imath_vec::Imath_3_0__InfException_e as Imath_InfException;
pub use imath_vec::Imath_InfException_INF_EXCEPTION;
pub use imath_vec::Imath_3_0__Vec2_short__index as Imath_V2s_index;
pub use imath_vec::Imath_3_0__Vec2_short__index_const as Imath_V2s_index_const;
pub use imath_vec::Imath_3_0__Vec2_short__broadcast as Imath_V2s_broadcast;
pub use imath_vec::Imath_3_0__Vec2_short__ctor as Imath_V2s_ctor;
pub use imath_vec::Imath_3_0__Vec2_short__ctor_1 as Imath_V2s_ctor_1;
pub use imath_vec::Imath_3_0__Vec2_short___assign as Imath_V2s__assign;
pub use imath_vec::Imath_3_0__Vec2_short__dtor as Imath_V2s_dtor;
pub use imath_vec::Imath_3_0__Vec2_short__equalWithAbsError as Imath_V2s_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec2_short__equalWithRelError as Imath_V2s_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec2_short__dot as Imath_V2s_dot;
pub use imath_vec::Imath_3_0__Vec2_short__cross as Imath_V2s_cross;
pub use imath_vec::Imath_3_0__Vec2_short___op_iadd as Imath_V2s__op_iadd;
pub use imath_vec::Imath_3_0__Vec2_short___op_add as Imath_V2s__op_add;
pub use imath_vec::Imath_3_0__Vec2_short___op_isub as Imath_V2s__op_isub;
pub use imath_vec::Imath_3_0__Vec2_short___op_sub as Imath_V2s__op_sub;
pub use imath_vec::Imath_3_0__Vec2_short___op_sub_1 as Imath_V2s__op_sub_1;
pub use imath_vec::Imath_3_0__Vec2_short__negate as Imath_V2s_negate;
pub use imath_vec::Imath_3_0__Vec2_short___op_imul as Imath_V2s__op_imul;
pub use imath_vec::Imath_3_0__Vec2_short___op_imul_1 as Imath_V2s__op_imul_1;
pub use imath_vec::Imath_3_0__Vec2_short___op_mul as Imath_V2s__op_mul;
pub use imath_vec::Imath_3_0__Vec2_short___op_mul_1 as Imath_V2s__op_mul_1;
pub use imath_vec::Imath_3_0__Vec2_short___op_idiv as Imath_V2s__op_idiv;
pub use imath_vec::Imath_3_0__Vec2_short___op_idiv_1 as Imath_V2s__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec2_short___op_div as Imath_V2s__op_div;
pub use imath_vec::Imath_3_0__Vec2_short___op_div_1 as Imath_V2s__op_div_1;
pub use imath_vec::Imath_3_0__Vec2_short__length2 as Imath_V2s_length2;
pub use imath_vec::Imath_3_0__Vec2_short__baseTypeLowest_1 as Imath_V2s_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec2_short__baseTypeMax_1 as Imath_V2s_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec2_short__baseTypeSmallest_1 as Imath_V2s_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec2_short__baseTypeEpsilon_1 as Imath_V2s_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec2_short__dimensions_1 as Imath_V2s_dimensions;
pub use imath_vec::Imath_3_0__Vec2_int__index as Imath_V2i_index;
pub use imath_vec::Imath_3_0__Vec2_int__index_const as Imath_V2i_index_const;
pub use imath_vec::Imath_3_0__Vec2_int__broadcast as Imath_V2i_broadcast;
pub use imath_vec::Imath_3_0__Vec2_int__ctor as Imath_V2i_ctor;
pub use imath_vec::Imath_3_0__Vec2_int__ctor_1 as Imath_V2i_ctor_1;
pub use imath_vec::Imath_3_0__Vec2_int___assign as Imath_V2i__assign;
pub use imath_vec::Imath_3_0__Vec2_int__dtor as Imath_V2i_dtor;
pub use imath_vec::Imath_3_0__Vec2_int__equalWithAbsError as Imath_V2i_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec2_int__equalWithRelError as Imath_V2i_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec2_int__dot as Imath_V2i_dot;
pub use imath_vec::Imath_3_0__Vec2_int__cross as Imath_V2i_cross;
pub use imath_vec::Imath_3_0__Vec2_int___op_iadd as Imath_V2i__op_iadd;
pub use imath_vec::Imath_3_0__Vec2_int___op_add as Imath_V2i__op_add;
pub use imath_vec::Imath_3_0__Vec2_int___op_isub as Imath_V2i__op_isub;
pub use imath_vec::Imath_3_0__Vec2_int___op_sub as Imath_V2i__op_sub;
pub use imath_vec::Imath_3_0__Vec2_int___op_sub_1 as Imath_V2i__op_sub_1;
pub use imath_vec::Imath_3_0__Vec2_int__negate as Imath_V2i_negate;
pub use imath_vec::Imath_3_0__Vec2_int___op_imul as Imath_V2i__op_imul;
pub use imath_vec::Imath_3_0__Vec2_int___op_imul_1 as Imath_V2i__op_imul_1;
pub use imath_vec::Imath_3_0__Vec2_int___op_mul as Imath_V2i__op_mul;
pub use imath_vec::Imath_3_0__Vec2_int___op_mul_1 as Imath_V2i__op_mul_1;
pub use imath_vec::Imath_3_0__Vec2_int___op_idiv as Imath_V2i__op_idiv;
pub use imath_vec::Imath_3_0__Vec2_int___op_idiv_1 as Imath_V2i__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec2_int___op_div as Imath_V2i__op_div;
pub use imath_vec::Imath_3_0__Vec2_int___op_div_1 as Imath_V2i__op_div_1;
pub use imath_vec::Imath_3_0__Vec2_int__length2 as Imath_V2i_length2;
pub use imath_vec::Imath_3_0__Vec2_int__baseTypeLowest_1 as Imath_V2i_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec2_int__baseTypeMax_1 as Imath_V2i_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec2_int__baseTypeSmallest_1 as Imath_V2i_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec2_int__baseTypeEpsilon_1 as Imath_V2i_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec2_int__dimensions_1 as Imath_V2i_dimensions;
pub use imath_vec::Imath_3_0__Vec2_long__index as Imath_V2i64_index;
pub use imath_vec::Imath_3_0__Vec2_long__index_const as Imath_V2i64_index_const;
pub use imath_vec::Imath_3_0__Vec2_long__broadcast as Imath_V2i64_broadcast;
pub use imath_vec::Imath_3_0__Vec2_long__ctor as Imath_V2i64_ctor;
pub use imath_vec::Imath_3_0__Vec2_long__copy as Imath_V2i64_copy;
pub use imath_vec::Imath_3_0__Vec2_long___assign as Imath_V2i64__assign;
pub use imath_vec::Imath_3_0__Vec2_long__dtor as Imath_V2i64_dtor;
pub use imath_vec::Imath_3_0__Vec2_long__equalWithAbsError as Imath_V2i64_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec2_long__equalWithRelError as Imath_V2i64_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec2_long__dot as Imath_V2i64_dot;
pub use imath_vec::Imath_3_0__Vec2_long__cross as Imath_V2i64_cross;
pub use imath_vec::Imath_3_0__Vec2_long___op_iadd as Imath_V2i64__op_iadd;
pub use imath_vec::Imath_3_0__Vec2_long___op_add as Imath_V2i64__op_add;
pub use imath_vec::Imath_3_0__Vec2_long___op_isub as Imath_V2i64__op_isub;
pub use imath_vec::Imath_3_0__Vec2_long___op_sub as Imath_V2i64__op_sub;
pub use imath_vec::Imath_3_0__Vec2_long___op_sub_1 as Imath_V2i64__op_sub_1;
pub use imath_vec::Imath_3_0__Vec2_long__negate as Imath_V2i64_negate;
pub use imath_vec::Imath_3_0__Vec2_long___op_imul as Imath_V2i64__op_imul;
pub use imath_vec::Imath_3_0__Vec2_long___op_imul_1 as Imath_V2i64__op_imul_1;
pub use imath_vec::Imath_3_0__Vec2_long___op_mul as Imath_V2i64__op_mul;
pub use imath_vec::Imath_3_0__Vec2_long___op_mul_1 as Imath_V2i64__op_mul_1;
pub use imath_vec::Imath_3_0__Vec2_long___op_idiv as Imath_V2i64__op_idiv;
pub use imath_vec::Imath_3_0__Vec2_long___op_idiv_1 as Imath_V2i64__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec2_long___op_div as Imath_V2i64__op_div;
pub use imath_vec::Imath_3_0__Vec2_long___op_div_1 as Imath_V2i64__op_div_1;
pub use imath_vec::Imath_3_0__Vec2_long__length2 as Imath_V2i64_length2;
pub use imath_vec::Imath_3_0__Vec2_long__baseTypeLowest_1 as Imath_V2i64_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec2_long__baseTypeMax_1 as Imath_V2i64_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec2_long__baseTypeSmallest_1 as Imath_V2i64_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec2_long__baseTypeEpsilon_1 as Imath_V2i64_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec2_long__dimensions_1 as Imath_V2i64_dimensions;
pub use imath_vec::Imath_3_0__Vec2_float__index as Imath_V2f_index;
pub use imath_vec::Imath_3_0__Vec2_float__index_const as Imath_V2f_index_const;
pub use imath_vec::Imath_3_0__Vec2_float__broadcast as Imath_V2f_broadcast;
pub use imath_vec::Imath_3_0__Vec2_float__ctor as Imath_V2f_ctor;
pub use imath_vec::Imath_3_0__Vec2_float__ctor_1 as Imath_V2f_ctor_1;
pub use imath_vec::Imath_3_0__Vec2_float___assign as Imath_V2f__assign;
pub use imath_vec::Imath_3_0__Vec2_float__dtor as Imath_V2f_dtor;
pub use imath_vec::Imath_3_0__Vec2_float__equalWithAbsError as Imath_V2f_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec2_float__equalWithRelError as Imath_V2f_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec2_float__dot as Imath_V2f_dot;
pub use imath_vec::Imath_3_0__Vec2_float__cross as Imath_V2f_cross;
pub use imath_vec::Imath_3_0__Vec2_float___op_iadd as Imath_V2f__op_iadd;
pub use imath_vec::Imath_3_0__Vec2_float___op_add as Imath_V2f__op_add;
pub use imath_vec::Imath_3_0__Vec2_float___op_isub as Imath_V2f__op_isub;
pub use imath_vec::Imath_3_0__Vec2_float___op_sub as Imath_V2f__op_sub;
pub use imath_vec::Imath_3_0__Vec2_float___op_sub_1 as Imath_V2f__op_sub_1;
pub use imath_vec::Imath_3_0__Vec2_float__negate as Imath_V2f_negate;
pub use imath_vec::Imath_3_0__Vec2_float___op_imul as Imath_V2f__op_imul;
pub use imath_vec::Imath_3_0__Vec2_float___op_imul_1 as Imath_V2f__op_imul_1;
pub use imath_vec::Imath_3_0__Vec2_float___op_mul as Imath_V2f__op_mul;
pub use imath_vec::Imath_3_0__Vec2_float___op_mul_1 as Imath_V2f__op_mul_1;
pub use imath_vec::Imath_3_0__Vec2_float___op_idiv as Imath_V2f__op_idiv;
pub use imath_vec::Imath_3_0__Vec2_float___op_idiv_1 as Imath_V2f__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec2_float___op_div as Imath_V2f__op_div;
pub use imath_vec::Imath_3_0__Vec2_float___op_div_1 as Imath_V2f__op_div_1;
pub use imath_vec::Imath_3_0__Vec2_float__length as Imath_V2f_length;
pub use imath_vec::Imath_3_0__Vec2_float__length2 as Imath_V2f_length2;
pub use imath_vec::Imath_3_0__Vec2_float__normalize as Imath_V2f_normalize;
pub use imath_vec::Imath_3_0__Vec2_float__normalizeExc as Imath_V2f_normalizeExc;
pub use imath_vec::Imath_3_0__Vec2_float__normalizeNonNull as Imath_V2f_normalizeNonNull;
pub use imath_vec::Imath_3_0__Vec2_float__normalized as Imath_V2f_normalized;
pub use imath_vec::Imath_3_0__Vec2_float__normalizedExc as Imath_V2f_normalizedExc;
pub use imath_vec::Imath_3_0__Vec2_float__normalizedNonNull as Imath_V2f_normalizedNonNull;
pub use imath_vec::Imath_3_0__Vec2_float__baseTypeLowest_1 as Imath_V2f_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec2_float__baseTypeMax_1 as Imath_V2f_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec2_float__baseTypeSmallest_1 as Imath_V2f_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec2_float__baseTypeEpsilon_1 as Imath_V2f_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec2_float__dimensions_1 as Imath_V2f_dimensions;
pub use imath_vec::Imath_3_0__Vec2_double__index as Imath_V2d_index;
pub use imath_vec::Imath_3_0__Vec2_double__index_const as Imath_V2d_index_const;
pub use imath_vec::Imath_3_0__Vec2_double__broadcast as Imath_V2d_broadcast;
pub use imath_vec::Imath_3_0__Vec2_double__ctor as Imath_V2d_ctor;
pub use imath_vec::Imath_3_0__Vec2_double__ctor_1 as Imath_V2d_ctor_1;
pub use imath_vec::Imath_3_0__Vec2_double___assign as Imath_V2d__assign;
pub use imath_vec::Imath_3_0__Vec2_double__dtor as Imath_V2d_dtor;
pub use imath_vec::Imath_3_0__Vec2_double__equalWithAbsError as Imath_V2d_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec2_double__equalWithRelError as Imath_V2d_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec2_double__dot as Imath_V2d_dot;
pub use imath_vec::Imath_3_0__Vec2_double__cross as Imath_V2d_cross;
pub use imath_vec::Imath_3_0__Vec2_double___op_iadd as Imath_V2d__op_iadd;
pub use imath_vec::Imath_3_0__Vec2_double___op_add as Imath_V2d__op_add;
pub use imath_vec::Imath_3_0__Vec2_double___op_isub as Imath_V2d__op_isub;
pub use imath_vec::Imath_3_0__Vec2_double___op_sub as Imath_V2d__op_sub;
pub use imath_vec::Imath_3_0__Vec2_double___op_sub_1 as Imath_V2d__op_sub_1;
pub use imath_vec::Imath_3_0__Vec2_double__negate as Imath_V2d_negate;
pub use imath_vec::Imath_3_0__Vec2_double___op_imul as Imath_V2d__op_imul;
pub use imath_vec::Imath_3_0__Vec2_double___op_imul_1 as Imath_V2d__op_imul_1;
pub use imath_vec::Imath_3_0__Vec2_double___op_mul as Imath_V2d__op_mul;
pub use imath_vec::Imath_3_0__Vec2_double___op_mul_1 as Imath_V2d__op_mul_1;
pub use imath_vec::Imath_3_0__Vec2_double___op_idiv as Imath_V2d__op_idiv;
pub use imath_vec::Imath_3_0__Vec2_double___op_idiv_1 as Imath_V2d__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec2_double___op_div as Imath_V2d__op_div;
pub use imath_vec::Imath_3_0__Vec2_double___op_div_1 as Imath_V2d__op_div_1;
pub use imath_vec::Imath_3_0__Vec2_double__length as Imath_V2d_length;
pub use imath_vec::Imath_3_0__Vec2_double__length2 as Imath_V2d_length2;
pub use imath_vec::Imath_3_0__Vec2_double__normalize as Imath_V2d_normalize;
pub use imath_vec::Imath_3_0__Vec2_double__normalizeExc as Imath_V2d_normalizeExc;
pub use imath_vec::Imath_3_0__Vec2_double__normalizeNonNull as Imath_V2d_normalizeNonNull;
pub use imath_vec::Imath_3_0__Vec2_double__normalized as Imath_V2d_normalized;
pub use imath_vec::Imath_3_0__Vec2_double__normalizedExc as Imath_V2d_normalizedExc;
pub use imath_vec::Imath_3_0__Vec2_double__normalizedNonNull as Imath_V2d_normalizedNonNull;
pub use imath_vec::Imath_3_0__Vec2_double__baseTypeLowest_1 as Imath_V2d_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec2_double__baseTypeMax_1 as Imath_V2d_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec2_double__baseTypeSmallest_1 as Imath_V2d_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec2_double__baseTypeEpsilon_1 as Imath_V2d_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec2_double__dimensions_1 as Imath_V2d_dimensions;
pub use imath_vec::Imath_3_0__Vec3_short__index as Imath_V3s_index;
pub use imath_vec::Imath_3_0__Vec3_short__index_const as Imath_V3s_index_const;
pub use imath_vec::Imath_3_0__Vec3_short__ctor as Imath_V3s_ctor;
pub use imath_vec::Imath_3_0__Vec3_short__ctor_1 as Imath_V3s_ctor_1;
pub use imath_vec::Imath_3_0__Vec3_short__ctor_2 as Imath_V3s_ctor_2;
pub use imath_vec::Imath_3_0__Vec3_short__ctor_3 as Imath_V3s_ctor_3;
pub use imath_vec::Imath_3_0__Vec3_short___assign as Imath_V3s__assign;
pub use imath_vec::Imath_3_0__Vec3_short__dtor as Imath_V3s_dtor;
pub use imath_vec::Imath_3_0__Vec3_short__getValue as Imath_V3s_getValue;
pub use imath_vec::Imath_3_0__Vec3_short__getValue_1 as Imath_V3s_getValue_1;
pub use imath_vec::Imath_3_0__Vec3_short__equalWithAbsError as Imath_V3s_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec3_short__equalWithRelError as Imath_V3s_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec3_short__dot as Imath_V3s_dot;
pub use imath_vec::Imath_3_0__Vec3_short__cross as Imath_V3s_cross;
pub use imath_vec::Imath_3_0__Vec3_short___op_iadd as Imath_V3s__op_iadd;
pub use imath_vec::Imath_3_0__Vec3_short___op_add as Imath_V3s__op_add;
pub use imath_vec::Imath_3_0__Vec3_short___op_isub as Imath_V3s__op_isub;
pub use imath_vec::Imath_3_0__Vec3_short___op_sub as Imath_V3s__op_sub;
pub use imath_vec::Imath_3_0__Vec3_short___op_sub_1 as Imath_V3s__op_sub_1;
pub use imath_vec::Imath_3_0__Vec3_short__negate as Imath_V3s_negate;
pub use imath_vec::Imath_3_0__Vec3_short___op_imul as Imath_V3s__op_imul;
pub use imath_vec::Imath_3_0__Vec3_short___op_imul_1 as Imath_V3s__op_imul_1;
pub use imath_vec::Imath_3_0__Vec3_short___op_mul as Imath_V3s__op_mul;
pub use imath_vec::Imath_3_0__Vec3_short___op_mul_1 as Imath_V3s__op_mul_1;
pub use imath_vec::Imath_3_0__Vec3_short___op_idiv as Imath_V3s__op_idiv;
pub use imath_vec::Imath_3_0__Vec3_short___op_idiv_1 as Imath_V3s__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec3_short___op_div as Imath_V3s__op_div;
pub use imath_vec::Imath_3_0__Vec3_short___op_div_1 as Imath_V3s__op_div_1;
pub use imath_vec::Imath_3_0__Vec3_short__length2 as Imath_V3s_length2;
pub use imath_vec::Imath_3_0__Vec3_short__baseTypeLowest_1 as Imath_V3s_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec3_short__baseTypeMax_1 as Imath_V3s_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec3_short__baseTypeSmallest_1 as Imath_V3s_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec3_short__baseTypeEpsilon_1 as Imath_V3s_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec3_short__dimensions_1 as Imath_V3s_dimensions;
pub use imath_vec::Imath_3_0__Vec3_int__index as Imath_V3i_index;
pub use imath_vec::Imath_3_0__Vec3_int__index_const as Imath_V3i_index_const;
pub use imath_vec::Imath_3_0__Vec3_int__ctor as Imath_V3i_ctor;
pub use imath_vec::Imath_3_0__Vec3_int__ctor_1 as Imath_V3i_ctor_1;
pub use imath_vec::Imath_3_0__Vec3_int__ctor_2 as Imath_V3i_ctor_2;
pub use imath_vec::Imath_3_0__Vec3_int__ctor_3 as Imath_V3i_ctor_3;
pub use imath_vec::Imath_3_0__Vec3_int___assign as Imath_V3i__assign;
pub use imath_vec::Imath_3_0__Vec3_int__dtor as Imath_V3i_dtor;
pub use imath_vec::Imath_3_0__Vec3_int__getValue as Imath_V3i_getValue;
pub use imath_vec::Imath_3_0__Vec3_int__getValue_1 as Imath_V3i_getValue_1;
pub use imath_vec::Imath_3_0__Vec3_int__equalWithAbsError as Imath_V3i_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec3_int__equalWithRelError as Imath_V3i_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec3_int__dot as Imath_V3i_dot;
pub use imath_vec::Imath_3_0__Vec3_int__cross as Imath_V3i_cross;
pub use imath_vec::Imath_3_0__Vec3_int___op_iadd as Imath_V3i__op_iadd;
pub use imath_vec::Imath_3_0__Vec3_int___op_add as Imath_V3i__op_add;
pub use imath_vec::Imath_3_0__Vec3_int___op_isub as Imath_V3i__op_isub;
pub use imath_vec::Imath_3_0__Vec3_int___op_sub as Imath_V3i__op_sub;
pub use imath_vec::Imath_3_0__Vec3_int___op_sub_1 as Imath_V3i__op_sub_1;
pub use imath_vec::Imath_3_0__Vec3_int__negate as Imath_V3i_negate;
pub use imath_vec::Imath_3_0__Vec3_int___op_imul as Imath_V3i__op_imul;
pub use imath_vec::Imath_3_0__Vec3_int___op_imul_1 as Imath_V3i__op_imul_1;
pub use imath_vec::Imath_3_0__Vec3_int___op_mul as Imath_V3i__op_mul;
pub use imath_vec::Imath_3_0__Vec3_int___op_mul_1 as Imath_V3i__op_mul_1;
pub use imath_vec::Imath_3_0__Vec3_int___op_idiv as Imath_V3i__op_idiv;
pub use imath_vec::Imath_3_0__Vec3_int___op_idiv_1 as Imath_V3i__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec3_int___op_div as Imath_V3i__op_div;
pub use imath_vec::Imath_3_0__Vec3_int___op_div_1 as Imath_V3i__op_div_1;
pub use imath_vec::Imath_3_0__Vec3_int__length2 as Imath_V3i_length2;
pub use imath_vec::Imath_3_0__Vec3_int__baseTypeLowest_1 as Imath_V3i_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec3_int__baseTypeMax_1 as Imath_V3i_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec3_int__baseTypeSmallest_1 as Imath_V3i_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec3_int__baseTypeEpsilon_1 as Imath_V3i_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec3_int__dimensions_1 as Imath_V3i_dimensions;
pub use imath_vec::Imath_3_0__Vec3_long__index as Imath_V3i64_index;
pub use imath_vec::Imath_3_0__Vec3_long__index_const as Imath_V3i64_index_const;
pub use imath_vec::Imath_3_0__Vec3_long__ctor as Imath_V3i64_ctor;
pub use imath_vec::Imath_3_0__Vec3_long__ctor_1 as Imath_V3i64_ctor_1;
pub use imath_vec::Imath_3_0__Vec3_long__ctor_2 as Imath_V3i64_ctor_2;
pub use imath_vec::Imath_3_0__Vec3_long__copy as Imath_V3i64_copy;
pub use imath_vec::Imath_3_0__Vec3_long___assign as Imath_V3i64__assign;
pub use imath_vec::Imath_3_0__Vec3_long__dtor as Imath_V3i64_dtor;
pub use imath_vec::Imath_3_0__Vec3_long__getValue as Imath_V3i64_getValue;
pub use imath_vec::Imath_3_0__Vec3_long__getValue_1 as Imath_V3i64_getValue_1;
pub use imath_vec::Imath_3_0__Vec3_long__equalWithAbsError as Imath_V3i64_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec3_long__equalWithRelError as Imath_V3i64_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec3_long__dot as Imath_V3i64_dot;
pub use imath_vec::Imath_3_0__Vec3_long__cross as Imath_V3i64_cross;
pub use imath_vec::Imath_3_0__Vec3_long___op_iadd as Imath_V3i64__op_iadd;
pub use imath_vec::Imath_3_0__Vec3_long___op_add as Imath_V3i64__op_add;
pub use imath_vec::Imath_3_0__Vec3_long___op_isub as Imath_V3i64__op_isub;
pub use imath_vec::Imath_3_0__Vec3_long___op_sub as Imath_V3i64__op_sub;
pub use imath_vec::Imath_3_0__Vec3_long___op_sub_1 as Imath_V3i64__op_sub_1;
pub use imath_vec::Imath_3_0__Vec3_long__negate as Imath_V3i64_negate;
pub use imath_vec::Imath_3_0__Vec3_long___op_imul as Imath_V3i64__op_imul;
pub use imath_vec::Imath_3_0__Vec3_long___op_imul_1 as Imath_V3i64__op_imul_1;
pub use imath_vec::Imath_3_0__Vec3_long___op_mul as Imath_V3i64__op_mul;
pub use imath_vec::Imath_3_0__Vec3_long___op_mul_1 as Imath_V3i64__op_mul_1;
pub use imath_vec::Imath_3_0__Vec3_long___op_idiv as Imath_V3i64__op_idiv;
pub use imath_vec::Imath_3_0__Vec3_long___op_idiv_1 as Imath_V3i64__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec3_long___op_div as Imath_V3i64__op_div;
pub use imath_vec::Imath_3_0__Vec3_long___op_div_1 as Imath_V3i64__op_div_1;
pub use imath_vec::Imath_3_0__Vec3_long__length2 as Imath_V3i64_length2;
pub use imath_vec::Imath_3_0__Vec3_long__baseTypeLowest_1 as Imath_V3i64_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec3_long__baseTypeMax_1 as Imath_V3i64_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec3_long__baseTypeSmallest_1 as Imath_V3i64_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec3_long__baseTypeEpsilon_1 as Imath_V3i64_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec3_long__dimensions_1 as Imath_V3i64_dimensions;
pub use imath_vec::Imath_3_0__Vec3_float__index as Imath_V3f_index;
pub use imath_vec::Imath_3_0__Vec3_float__index_const as Imath_V3f_index_const;
pub use imath_vec::Imath_3_0__Vec3_float__ctor as Imath_V3f_ctor;
pub use imath_vec::Imath_3_0__Vec3_float__ctor_1 as Imath_V3f_ctor_1;
pub use imath_vec::Imath_3_0__Vec3_float__ctor_2 as Imath_V3f_ctor_2;
pub use imath_vec::Imath_3_0__Vec3_float__ctor_3 as Imath_V3f_ctor_3;
pub use imath_vec::Imath_3_0__Vec3_float___assign as Imath_V3f__assign;
pub use imath_vec::Imath_3_0__Vec3_float__dtor as Imath_V3f_dtor;
pub use imath_vec::Imath_3_0__Vec3_float__getValue as Imath_V3f_getValue;
pub use imath_vec::Imath_3_0__Vec3_float__getValue_1 as Imath_V3f_getValue_1;
pub use imath_vec::Imath_3_0__Vec3_float__equalWithAbsError as Imath_V3f_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec3_float__equalWithRelError as Imath_V3f_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec3_float__dot as Imath_V3f_dot;
pub use imath_vec::Imath_3_0__Vec3_float__cross as Imath_V3f_cross;
pub use imath_vec::Imath_3_0__Vec3_float___op_iadd as Imath_V3f__op_iadd;
pub use imath_vec::Imath_3_0__Vec3_float___op_add as Imath_V3f__op_add;
pub use imath_vec::Imath_3_0__Vec3_float___op_isub as Imath_V3f__op_isub;
pub use imath_vec::Imath_3_0__Vec3_float___op_sub as Imath_V3f__op_sub;
pub use imath_vec::Imath_3_0__Vec3_float___op_sub_1 as Imath_V3f__op_sub_1;
pub use imath_vec::Imath_3_0__Vec3_float__negate as Imath_V3f_negate;
pub use imath_vec::Imath_3_0__Vec3_float___op_imul as Imath_V3f__op_imul;
pub use imath_vec::Imath_3_0__Vec3_float___op_imul_1 as Imath_V3f__op_imul_1;
pub use imath_vec::Imath_3_0__Vec3_float___op_mul as Imath_V3f__op_mul;
pub use imath_vec::Imath_3_0__Vec3_float___op_mul_1 as Imath_V3f__op_mul_1;
pub use imath_vec::Imath_3_0__Vec3_float___op_idiv as Imath_V3f__op_idiv;
pub use imath_vec::Imath_3_0__Vec3_float___op_idiv_1 as Imath_V3f__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec3_float___op_div as Imath_V3f__op_div;
pub use imath_vec::Imath_3_0__Vec3_float___op_div_1 as Imath_V3f__op_div_1;
pub use imath_vec::Imath_3_0__Vec3_float__length as Imath_V3f_length;
pub use imath_vec::Imath_3_0__Vec3_float__length2 as Imath_V3f_length2;
pub use imath_vec::Imath_3_0__Vec3_float__normalize as Imath_V3f_normalize;
pub use imath_vec::Imath_3_0__Vec3_float__normalizeNonNull as Imath_V3f_normalizeNonNull;
pub use imath_vec::Imath_3_0__Vec3_float__normalized as Imath_V3f_normalized;
pub use imath_vec::Imath_3_0__Vec3_float__normalizedNonNull as Imath_V3f_normalizedNonNull;
pub use imath_vec::Imath_3_0__Vec3_float__baseTypeLowest_1 as Imath_V3f_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec3_float__baseTypeMax_1 as Imath_V3f_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec3_float__baseTypeSmallest_1 as Imath_V3f_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec3_float__baseTypeEpsilon_1 as Imath_V3f_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec3_float__dimensions_1 as Imath_V3f_dimensions;
pub use imath_vec::Imath_3_0__Vec3_double__index as Imath_V3d_index;
pub use imath_vec::Imath_3_0__Vec3_double__index_const as Imath_V3d_index_const;
pub use imath_vec::Imath_3_0__Vec3_double__ctor as Imath_V3d_ctor;
pub use imath_vec::Imath_3_0__Vec3_double__ctor_1 as Imath_V3d_ctor_1;
pub use imath_vec::Imath_3_0__Vec3_double__ctor_2 as Imath_V3d_ctor_2;
pub use imath_vec::Imath_3_0__Vec3_double__ctor_3 as Imath_V3d_ctor_3;
pub use imath_vec::Imath_3_0__Vec3_double___assign as Imath_V3d__assign;
pub use imath_vec::Imath_3_0__Vec3_double__dtor as Imath_V3d_dtor;
pub use imath_vec::Imath_3_0__Vec3_double__getValue as Imath_V3d_getValue;
pub use imath_vec::Imath_3_0__Vec3_double__getValue_1 as Imath_V3d_getValue_1;
pub use imath_vec::Imath_3_0__Vec3_double__equalWithAbsError as Imath_V3d_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec3_double__equalWithRelError as Imath_V3d_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec3_double__dot as Imath_V3d_dot;
pub use imath_vec::Imath_3_0__Vec3_double__cross as Imath_V3d_cross;
pub use imath_vec::Imath_3_0__Vec3_double___op_iadd as Imath_V3d__op_iadd;
pub use imath_vec::Imath_3_0__Vec3_double___op_add as Imath_V3d__op_add;
pub use imath_vec::Imath_3_0__Vec3_double___op_isub as Imath_V3d__op_isub;
pub use imath_vec::Imath_3_0__Vec3_double___op_sub as Imath_V3d__op_sub;
pub use imath_vec::Imath_3_0__Vec3_double___op_sub_1 as Imath_V3d__op_sub_1;
pub use imath_vec::Imath_3_0__Vec3_double__negate as Imath_V3d_negate;
pub use imath_vec::Imath_3_0__Vec3_double___op_imul as Imath_V3d__op_imul;
pub use imath_vec::Imath_3_0__Vec3_double___op_imul_1 as Imath_V3d__op_imul_1;
pub use imath_vec::Imath_3_0__Vec3_double___op_mul as Imath_V3d__op_mul;
pub use imath_vec::Imath_3_0__Vec3_double___op_mul_1 as Imath_V3d__op_mul_1;
pub use imath_vec::Imath_3_0__Vec3_double___op_idiv as Imath_V3d__op_idiv;
pub use imath_vec::Imath_3_0__Vec3_double___op_idiv_1 as Imath_V3d__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec3_double___op_div as Imath_V3d__op_div;
pub use imath_vec::Imath_3_0__Vec3_double___op_div_1 as Imath_V3d__op_div_1;
pub use imath_vec::Imath_3_0__Vec3_double__length as Imath_V3d_length;
pub use imath_vec::Imath_3_0__Vec3_double__length2 as Imath_V3d_length2;
pub use imath_vec::Imath_3_0__Vec3_double__normalize as Imath_V3d_normalize;
pub use imath_vec::Imath_3_0__Vec3_double__normalizeNonNull as Imath_V3d_normalizeNonNull;
pub use imath_vec::Imath_3_0__Vec3_double__normalized as Imath_V3d_normalized;
pub use imath_vec::Imath_3_0__Vec3_double__normalizedNonNull as Imath_V3d_normalizedNonNull;
pub use imath_vec::Imath_3_0__Vec3_double__baseTypeLowest_1 as Imath_V3d_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec3_double__baseTypeMax_1 as Imath_V3d_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec3_double__baseTypeSmallest_1 as Imath_V3d_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec3_double__baseTypeEpsilon_1 as Imath_V3d_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec3_double__dimensions_1 as Imath_V3d_dimensions;
pub use imath_vec::Imath_3_0__Vec4_short__index as Imath_V4s_index;
pub use imath_vec::Imath_3_0__Vec4_short__index_const as Imath_V4s_index_const;
pub use imath_vec::Imath_3_0__Vec4_short__ctor as Imath_V4s_ctor;
pub use imath_vec::Imath_3_0__Vec4_short__ctor_1 as Imath_V4s_ctor_1;
pub use imath_vec::Imath_3_0__Vec4_short__ctor_2 as Imath_V4s_ctor_2;
pub use imath_vec::Imath_3_0__Vec4_short__ctor_3 as Imath_V4s_ctor_3;
pub use imath_vec::Imath_3_0__Vec4_short___assign as Imath_V4s__assign;
pub use imath_vec::Imath_3_0__Vec4_short__dtor as Imath_V4s_dtor;
pub use imath_vec::Imath_3_0__Vec4_short__equalWithAbsError as Imath_V4s_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec4_short__equalWithRelError as Imath_V4s_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec4_short__dot as Imath_V4s_dot;
pub use imath_vec::Imath_3_0__Vec4_short___op_add as Imath_V4s__op_add;
pub use imath_vec::Imath_3_0__Vec4_short___op_isub as Imath_V4s__op_isub;
pub use imath_vec::Imath_3_0__Vec4_short___op_sub as Imath_V4s__op_sub;
pub use imath_vec::Imath_3_0__Vec4_short___op_sub_1 as Imath_V4s__op_sub_1;
pub use imath_vec::Imath_3_0__Vec4_short__negate as Imath_V4s_negate;
pub use imath_vec::Imath_3_0__Vec4_short___op_imul as Imath_V4s__op_imul;
pub use imath_vec::Imath_3_0__Vec4_short___op_imul_1 as Imath_V4s__op_imul_1;
pub use imath_vec::Imath_3_0__Vec4_short___op_mul as Imath_V4s__op_mul;
pub use imath_vec::Imath_3_0__Vec4_short___op_mul_1 as Imath_V4s__op_mul_1;
pub use imath_vec::Imath_3_0__Vec4_short___op_idiv as Imath_V4s__op_idiv;
pub use imath_vec::Imath_3_0__Vec4_short___op_idiv_1 as Imath_V4s__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec4_short___op_div as Imath_V4s__op_div;
pub use imath_vec::Imath_3_0__Vec4_short___op_div_1 as Imath_V4s__op_div_1;
pub use imath_vec::Imath_3_0__Vec4_short__length2 as Imath_V4s_length2;
pub use imath_vec::Imath_3_0__Vec4_short__baseTypeLowest_1 as Imath_V4s_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec4_short__baseTypeMax_1 as Imath_V4s_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec4_short__baseTypeSmallest_1 as Imath_V4s_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec4_short__baseTypeEpsilon_1 as Imath_V4s_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec4_short__dimensions_1 as Imath_V4s_dimensions;
pub use imath_vec::Imath_3_0__Vec4_int__index as Imath_Vec4_index;
pub use imath_vec::Imath_3_0__Vec4_int__index_const as Imath_Vec4_index_const;
pub use imath_vec::Imath_3_0__Vec4_int__ctor as Imath_Vec4_ctor;
pub use imath_vec::Imath_3_0__Vec4_int__ctor_1 as Imath_Vec4_ctor_1;
pub use imath_vec::Imath_3_0__Vec4_int__ctor_2 as Imath_Vec4_ctor_2;
pub use imath_vec::Imath_3_0__Vec4_int__ctor_3 as Imath_Vec4_ctor_3;
pub use imath_vec::Imath_3_0__Vec4_int___assign as Imath_Vec4__assign;
pub use imath_vec::Imath_3_0__Vec4_int__dtor as Imath_Vec4_dtor;
pub use imath_vec::Imath_3_0__Vec4_int__equalWithAbsError as Imath_Vec4_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec4_int__equalWithRelError as Imath_Vec4_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec4_int__dot as Imath_Vec4_dot;
pub use imath_vec::Imath_3_0__Vec4_int___op_add as Imath_Vec4__op_add;
pub use imath_vec::Imath_3_0__Vec4_int___op_isub as Imath_Vec4__op_isub;
pub use imath_vec::Imath_3_0__Vec4_int___op_sub as Imath_Vec4__op_sub;
pub use imath_vec::Imath_3_0__Vec4_int___op_sub_1 as Imath_Vec4__op_sub_1;
pub use imath_vec::Imath_3_0__Vec4_int__negate as Imath_Vec4_negate;
pub use imath_vec::Imath_3_0__Vec4_int___op_imul as Imath_Vec4__op_imul;
pub use imath_vec::Imath_3_0__Vec4_int___op_imul_1 as Imath_Vec4__op_imul_1;
pub use imath_vec::Imath_3_0__Vec4_int___op_mul as Imath_Vec4__op_mul;
pub use imath_vec::Imath_3_0__Vec4_int___op_mul_1 as Imath_Vec4__op_mul_1;
pub use imath_vec::Imath_3_0__Vec4_int___op_idiv as Imath_Vec4__op_idiv;
pub use imath_vec::Imath_3_0__Vec4_int___op_idiv_1 as Imath_Vec4__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec4_int___op_div as Imath_Vec4__op_div;
pub use imath_vec::Imath_3_0__Vec4_int___op_div_1 as Imath_Vec4__op_div_1;
pub use imath_vec::Imath_3_0__Vec4_int__length2 as Imath_Vec4_length2;
pub use imath_vec::Imath_3_0__Vec4_int__baseTypeLowest_1 as Imath_Vec4_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec4_int__baseTypeMax_1 as Imath_Vec4_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec4_int__baseTypeSmallest_1 as Imath_Vec4_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec4_int__baseTypeEpsilon_1 as Imath_Vec4_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec4_int__dimensions_1 as Imath_Vec4_dimensions;
pub use imath_vec::Imath_3_0__Vec4_long__index as Imath_V4i64_index;
pub use imath_vec::Imath_3_0__Vec4_long__index_const as Imath_V4i64_index_const;
pub use imath_vec::Imath_3_0__Vec4_long__ctor as Imath_V4i64_ctor;
pub use imath_vec::Imath_3_0__Vec4_long__ctor_1 as Imath_V4i64_ctor_1;
pub use imath_vec::Imath_3_0__Vec4_long__ctor_2 as Imath_V4i64_ctor_2;
pub use imath_vec::Imath_3_0__Vec4_long__copy as Imath_V4i64_copy;
pub use imath_vec::Imath_3_0__Vec4_long___assign as Imath_V4i64__assign;
pub use imath_vec::Imath_3_0__Vec4_long__dtor as Imath_V4i64_dtor;
pub use imath_vec::Imath_3_0__Vec4_long__equalWithAbsError as Imath_V4i64_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec4_long__equalWithRelError as Imath_V4i64_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec4_long__dot as Imath_V4i64_dot;
pub use imath_vec::Imath_3_0__Vec4_long___op_add as Imath_V4i64__op_add;
pub use imath_vec::Imath_3_0__Vec4_long___op_isub as Imath_V4i64__op_isub;
pub use imath_vec::Imath_3_0__Vec4_long___op_sub as Imath_V4i64__op_sub;
pub use imath_vec::Imath_3_0__Vec4_long___op_sub_1 as Imath_V4i64__op_sub_1;
pub use imath_vec::Imath_3_0__Vec4_long__negate as Imath_V4i64_negate;
pub use imath_vec::Imath_3_0__Vec4_long___op_imul as Imath_V4i64__op_imul;
pub use imath_vec::Imath_3_0__Vec4_long___op_imul_1 as Imath_V4i64__op_imul_1;
pub use imath_vec::Imath_3_0__Vec4_long___op_mul as Imath_V4i64__op_mul;
pub use imath_vec::Imath_3_0__Vec4_long___op_mul_1 as Imath_V4i64__op_mul_1;
pub use imath_vec::Imath_3_0__Vec4_long___op_idiv as Imath_V4i64__op_idiv;
pub use imath_vec::Imath_3_0__Vec4_long___op_idiv_1 as Imath_V4i64__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec4_long___op_div as Imath_V4i64__op_div;
pub use imath_vec::Imath_3_0__Vec4_long___op_div_1 as Imath_V4i64__op_div_1;
pub use imath_vec::Imath_3_0__Vec4_long__length2 as Imath_V4i64_length2;
pub use imath_vec::Imath_3_0__Vec4_long__baseTypeLowest_1 as Imath_V4i64_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec4_long__baseTypeMax_1 as Imath_V4i64_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec4_long__baseTypeSmallest_1 as Imath_V4i64_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec4_long__baseTypeEpsilon_1 as Imath_V4i64_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec4_long__dimensions_1 as Imath_V4i64_dimensions;
pub use imath_vec::Imath_3_0__Vec4_float__index as Imath_V4f_index;
pub use imath_vec::Imath_3_0__Vec4_float__index_const as Imath_V4f_index_const;
pub use imath_vec::Imath_3_0__Vec4_float__ctor as Imath_V4f_ctor;
pub use imath_vec::Imath_3_0__Vec4_float__ctor_1 as Imath_V4f_ctor_1;
pub use imath_vec::Imath_3_0__Vec4_float__ctor_2 as Imath_V4f_ctor_2;
pub use imath_vec::Imath_3_0__Vec4_float__ctor_3 as Imath_V4f_ctor_3;
pub use imath_vec::Imath_3_0__Vec4_float___assign as Imath_V4f__assign;
pub use imath_vec::Imath_3_0__Vec4_float__dtor as Imath_V4f_dtor;
pub use imath_vec::Imath_3_0__Vec4_float__equalWithAbsError as Imath_V4f_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec4_float__equalWithRelError as Imath_V4f_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec4_float__dot as Imath_V4f_dot;
pub use imath_vec::Imath_3_0__Vec4_float___op_add as Imath_V4f__op_add;
pub use imath_vec::Imath_3_0__Vec4_float___op_isub as Imath_V4f__op_isub;
pub use imath_vec::Imath_3_0__Vec4_float___op_sub as Imath_V4f__op_sub;
pub use imath_vec::Imath_3_0__Vec4_float___op_sub_1 as Imath_V4f__op_sub_1;
pub use imath_vec::Imath_3_0__Vec4_float__negate as Imath_V4f_negate;
pub use imath_vec::Imath_3_0__Vec4_float___op_imul as Imath_V4f__op_imul;
pub use imath_vec::Imath_3_0__Vec4_float___op_imul_1 as Imath_V4f__op_imul_1;
pub use imath_vec::Imath_3_0__Vec4_float___op_mul as Imath_V4f__op_mul;
pub use imath_vec::Imath_3_0__Vec4_float___op_mul_1 as Imath_V4f__op_mul_1;
pub use imath_vec::Imath_3_0__Vec4_float___op_idiv as Imath_V4f__op_idiv;
pub use imath_vec::Imath_3_0__Vec4_float___op_idiv_1 as Imath_V4f__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec4_float___op_div as Imath_V4f__op_div;
pub use imath_vec::Imath_3_0__Vec4_float___op_div_1 as Imath_V4f__op_div_1;
pub use imath_vec::Imath_3_0__Vec4_float__length as Imath_V4f_length;
pub use imath_vec::Imath_3_0__Vec4_float__length2 as Imath_V4f_length2;
pub use imath_vec::Imath_3_0__Vec4_float__normalize as Imath_V4f_normalize;
pub use imath_vec::Imath_3_0__Vec4_float__normalizeNonNull as Imath_V4f_normalizeNonNull;
pub use imath_vec::Imath_3_0__Vec4_float__normalized as Imath_V4f_normalized;
pub use imath_vec::Imath_3_0__Vec4_float__normalizedNonNull as Imath_V4f_normalizedNonNull;
pub use imath_vec::Imath_3_0__Vec4_float__baseTypeLowest_1 as Imath_V4f_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec4_float__baseTypeMax_1 as Imath_V4f_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec4_float__baseTypeSmallest_1 as Imath_V4f_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec4_float__baseTypeEpsilon_1 as Imath_V4f_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec4_float__dimensions_1 as Imath_V4f_dimensions;
pub use imath_vec::Imath_3_0__Vec4_double__index as Imath_V4d_index;
pub use imath_vec::Imath_3_0__Vec4_double__index_const as Imath_V4d_index_const;
pub use imath_vec::Imath_3_0__Vec4_double__ctor as Imath_V4d_ctor;
pub use imath_vec::Imath_3_0__Vec4_double__ctor_1 as Imath_V4d_ctor_1;
pub use imath_vec::Imath_3_0__Vec4_double__ctor_2 as Imath_V4d_ctor_2;
pub use imath_vec::Imath_3_0__Vec4_double__ctor_3 as Imath_V4d_ctor_3;
pub use imath_vec::Imath_3_0__Vec4_double___assign as Imath_V4d__assign;
pub use imath_vec::Imath_3_0__Vec4_double__dtor as Imath_V4d_dtor;
pub use imath_vec::Imath_3_0__Vec4_double__equalWithAbsError as Imath_V4d_equalWithAbsError;
pub use imath_vec::Imath_3_0__Vec4_double__equalWithRelError as Imath_V4d_equalWithRelError;
pub use imath_vec::Imath_3_0__Vec4_double__dot as Imath_V4d_dot;
pub use imath_vec::Imath_3_0__Vec4_double___op_add as Imath_V4d__op_add;
pub use imath_vec::Imath_3_0__Vec4_double___op_isub as Imath_V4d__op_isub;
pub use imath_vec::Imath_3_0__Vec4_double___op_sub as Imath_V4d__op_sub;
pub use imath_vec::Imath_3_0__Vec4_double___op_sub_1 as Imath_V4d__op_sub_1;
pub use imath_vec::Imath_3_0__Vec4_double__negate as Imath_V4d_negate;
pub use imath_vec::Imath_3_0__Vec4_double___op_imul as Imath_V4d__op_imul;
pub use imath_vec::Imath_3_0__Vec4_double___op_imul_1 as Imath_V4d__op_imul_1;
pub use imath_vec::Imath_3_0__Vec4_double___op_mul as Imath_V4d__op_mul;
pub use imath_vec::Imath_3_0__Vec4_double___op_mul_1 as Imath_V4d__op_mul_1;
pub use imath_vec::Imath_3_0__Vec4_double___op_idiv as Imath_V4d__op_idiv;
pub use imath_vec::Imath_3_0__Vec4_double___op_idiv_1 as Imath_V4d__op_idiv_1;
pub use imath_vec::Imath_3_0__Vec4_double___op_div as Imath_V4d__op_div;
pub use imath_vec::Imath_3_0__Vec4_double___op_div_1 as Imath_V4d__op_div_1;
pub use imath_vec::Imath_3_0__Vec4_double__length as Imath_V4d_length;
pub use imath_vec::Imath_3_0__Vec4_double__length2 as Imath_V4d_length2;
pub use imath_vec::Imath_3_0__Vec4_double__normalize as Imath_V4d_normalize;
pub use imath_vec::Imath_3_0__Vec4_double__normalizeNonNull as Imath_V4d_normalizeNonNull;
pub use imath_vec::Imath_3_0__Vec4_double__normalized as Imath_V4d_normalized;
pub use imath_vec::Imath_3_0__Vec4_double__normalizedNonNull as Imath_V4d_normalizedNonNull;
pub use imath_vec::Imath_3_0__Vec4_double__baseTypeLowest_1 as Imath_V4d_baseTypeLowest;
pub use imath_vec::Imath_3_0__Vec4_double__baseTypeMax_1 as Imath_V4d_baseTypeMax;
pub use imath_vec::Imath_3_0__Vec4_double__baseTypeSmallest_1 as Imath_V4d_baseTypeSmallest;
pub use imath_vec::Imath_3_0__Vec4_double__baseTypeEpsilon_1 as Imath_V4d_baseTypeEpsilon;
pub use imath_vec::Imath_3_0__Vec4_double__dimensions_1 as Imath_V4d_dimensions;
pub mod imf_deepimagechannel;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_t as Imf_DeepImageChannel_t;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__t as Imf_DeepHalfChannel_t;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__t as Imf_DeepFloatChannel_t;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__t as Imf_DeepUIntChannel_t;

pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_pixelType as Imf_DeepImageChannel_pixelType;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_channel as Imf_DeepImageChannel_channel;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_xSampling as Imf_DeepImageChannel_xSampling;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_ySampling as Imf_DeepImageChannel_ySampling;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_pLinear as Imf_DeepImageChannel_pLinear;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_pixelsPerRow as Imf_DeepImageChannel_pixelsPerRow;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_pixelsPerColumn as Imf_DeepImageChannel_pixelsPerColumn;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_numPixels as Imf_DeepImageChannel_numPixels;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_level as Imf_DeepImageChannel_level;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_level_const as Imf_DeepImageChannel_level_const;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_slice as Imf_DeepImageChannel_slice;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_deepLevel as Imf_DeepImageChannel_deepLevel;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_deepLevel_const as Imf_DeepImageChannel_deepLevel_const;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_sampleCounts as Imf_DeepImageChannel_sampleCounts;
pub use imf_deepimagechannel::Imf_3_0__DeepImageChannel_sampleCounts_1 as Imf_DeepImageChannel_sampleCounts_1;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__pixelType as Imf_DeepHalfChannel_pixelType;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__channel as Imf_DeepHalfChannel_channel;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__xSampling as Imf_DeepHalfChannel_xSampling;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__ySampling as Imf_DeepHalfChannel_ySampling;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__pLinear as Imf_DeepHalfChannel_pLinear;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__pixelsPerRow as Imf_DeepHalfChannel_pixelsPerRow;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__pixelsPerColumn as Imf_DeepHalfChannel_pixelsPerColumn;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__numPixels as Imf_DeepHalfChannel_numPixels;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__level as Imf_DeepHalfChannel_level;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__level_const as Imf_DeepHalfChannel_level_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__slice as Imf_DeepHalfChannel_slice;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__deepLevel as Imf_DeepHalfChannel_deepLevel;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__deepLevel_const as Imf_DeepHalfChannel_deepLevel_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__sampleCounts as Imf_DeepHalfChannel_sampleCounts;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__sampleCounts_1 as Imf_DeepHalfChannel_sampleCounts_1;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__index as Imf_DeepHalfChannel_index;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__index_const as Imf_DeepHalfChannel_index_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__at as Imf_DeepHalfChannel_at;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_half__at_const as Imf_DeepHalfChannel_at_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__pixelType as Imf_DeepFloatChannel_pixelType;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__channel as Imf_DeepFloatChannel_channel;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__xSampling as Imf_DeepFloatChannel_xSampling;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__ySampling as Imf_DeepFloatChannel_ySampling;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__pLinear as Imf_DeepFloatChannel_pLinear;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__pixelsPerRow as Imf_DeepFloatChannel_pixelsPerRow;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__pixelsPerColumn as Imf_DeepFloatChannel_pixelsPerColumn;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__numPixels as Imf_DeepFloatChannel_numPixels;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__level as Imf_DeepFloatChannel_level;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__level_const as Imf_DeepFloatChannel_level_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__slice as Imf_DeepFloatChannel_slice;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__deepLevel as Imf_DeepFloatChannel_deepLevel;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__deepLevel_const as Imf_DeepFloatChannel_deepLevel_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__sampleCounts as Imf_DeepFloatChannel_sampleCounts;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__sampleCounts_1 as Imf_DeepFloatChannel_sampleCounts_1;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__index as Imf_DeepFloatChannel_index;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__index_const as Imf_DeepFloatChannel_index_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__at as Imf_DeepFloatChannel_at;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_float__at_const as Imf_DeepFloatChannel_at_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__pixelType as Imf_DeepUIntChannel_pixelType;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__channel as Imf_DeepUIntChannel_channel;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__xSampling as Imf_DeepUIntChannel_xSampling;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__ySampling as Imf_DeepUIntChannel_ySampling;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__pLinear as Imf_DeepUIntChannel_pLinear;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__pixelsPerRow as Imf_DeepUIntChannel_pixelsPerRow;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__pixelsPerColumn as Imf_DeepUIntChannel_pixelsPerColumn;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__numPixels as Imf_DeepUIntChannel_numPixels;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__level as Imf_DeepUIntChannel_level;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__level_const as Imf_DeepUIntChannel_level_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__slice as Imf_DeepUIntChannel_slice;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__deepLevel as Imf_DeepUIntChannel_deepLevel;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__deepLevel_const as Imf_DeepUIntChannel_deepLevel_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__sampleCounts as Imf_DeepUIntChannel_sampleCounts;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__sampleCounts_1 as Imf_DeepUIntChannel_sampleCounts_1;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__index as Imf_DeepUIntChannel_index;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__index_const as Imf_DeepUIntChannel_index_const;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__at as Imf_DeepUIntChannel_at;
pub use imf_deepimagechannel::Imf_3_0__TypedDeepImageChannel_unsignedint__at_const as Imf_DeepUIntChannel_at_const;
pub mod imf_channellist;
pub use imf_channellist::Imf_3_0__Channel_t as Imf_Channel_t;
pub use imf_channellist::Imf_3_0__ChannelList_t as Imf_ChannelList_t;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator_t as Imf_ChannelList_Iterator_t;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_t as Imf_ChannelList_ConstIterator_t;

pub use imf_channellist::Imf_3_0__Channel_ctor as Imf_Channel_ctor;
pub use imf_channellist::Imf_3_0__Channel__eq as Imf_Channel__eq;
pub use imf_channellist::Imf_3_0__Channel_dtor as Imf_Channel_dtor;
pub use imf_channellist::Imf_3_0__Channel_copy as Imf_Channel_copy;
pub use imf_channellist::Imf_3_0__Channel_move as Imf_Channel_move;
pub use imf_channellist::Imf_3_0__ChannelList_insert as Imf_ChannelList_insert;
pub use imf_channellist::Imf_3_0__ChannelList_findChannel as Imf_ChannelList_findChannel;
pub use imf_channellist::Imf_3_0__ChannelList_findChannel_const as Imf_ChannelList_findChannel_const;
pub use imf_channellist::Imf_3_0__ChannelList_begin as Imf_ChannelList_begin;
pub use imf_channellist::Imf_3_0__ChannelList_begin_const as Imf_ChannelList_begin_const;
pub use imf_channellist::Imf_3_0__ChannelList_end as Imf_ChannelList_end;
pub use imf_channellist::Imf_3_0__ChannelList_end_const as Imf_ChannelList_end_const;
pub use imf_channellist::Imf_3_0__ChannelList_find as Imf_ChannelList_find;
pub use imf_channellist::Imf_3_0__ChannelList_find_const as Imf_ChannelList_find_const;
pub use imf_channellist::Imf_3_0__ChannelList_layers as Imf_ChannelList_layers;
pub use imf_channellist::Imf_3_0__ChannelList_channelsInLayer as Imf_ChannelList_channelsInLayer;
pub use imf_channellist::Imf_3_0__ChannelList_channelsInLayer_const as Imf_ChannelList_channelsInLayer_const;
pub use imf_channellist::Imf_3_0__ChannelList_channelsWithPrefix as Imf_ChannelList_channelsWithPrefix;
pub use imf_channellist::Imf_3_0__ChannelList_channelsWithPrefix_const as Imf_ChannelList_channelsWithPrefix_const;
pub use imf_channellist::Imf_3_0__ChannelList__eq as Imf_ChannelList__eq;
pub use imf_channellist::Imf_3_0__ChannelList_copy as Imf_ChannelList_copy;
pub use imf_channellist::Imf_3_0__ChannelList_dtor as Imf_ChannelList_dtor;
pub use imf_channellist::Imf_3_0__ChannelList_ctor as Imf_ChannelList_ctor;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator_sizeof as Imf_ChannelList_Iterator_sizeof;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator_alignof as Imf_ChannelList_Iterator_alignof;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator_ctor as Imf_ChannelList_Iterator_ctor;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator__op_inc as Imf_ChannelList_Iterator__op_inc;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator_name as Imf_ChannelList_Iterator_name;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator_channel as Imf_ChannelList_Iterator_channel;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator_copy as Imf_ChannelList_Iterator_copy;
pub use imf_channellist::Imf_3_0__ChannelList__Iterator_move as Imf_ChannelList_Iterator_move;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_sizeof as Imf_ChannelList_ConstIterator_sizeof;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_alignof as Imf_ChannelList_ConstIterator_alignof;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_ctor as Imf_ChannelList_ConstIterator_ctor;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_from_mut as Imf_ChannelList_ConstIterator_from_mut;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator__op_inc as Imf_ChannelList_ConstIterator__op_inc;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_name as Imf_ChannelList_ConstIterator_name;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_channel as Imf_ChannelList_ConstIterator_channel;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_copy as Imf_ChannelList_ConstIterator_copy;
pub use imf_channellist::Imf_3_0__ChannelList__ConstIterator_move as Imf_ChannelList_ConstIterator_move;
pub use imf_channellist::Imf_3_0_channel_list_const_iter_eq as Imf_channel_list_const_iter_eq;
pub mod imf_deeptiledoutputpart;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_t as Imf_DeepTiledOutputPart_t;

pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_sizeof as Imf_DeepTiledOutputPart_sizeof;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_alignof as Imf_DeepTiledOutputPart_alignof;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_ctor as Imf_DeepTiledOutputPart_ctor;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_fileName as Imf_DeepTiledOutputPart_fileName;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_header as Imf_DeepTiledOutputPart_header;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_setFrameBuffer as Imf_DeepTiledOutputPart_setFrameBuffer;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_frameBuffer as Imf_DeepTiledOutputPart_frameBuffer;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_tileXSize as Imf_DeepTiledOutputPart_tileXSize;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_tileYSize as Imf_DeepTiledOutputPart_tileYSize;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_levelMode as Imf_DeepTiledOutputPart_levelMode;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_levelRoundingMode as Imf_DeepTiledOutputPart_levelRoundingMode;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_numLevels as Imf_DeepTiledOutputPart_numLevels;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_numXLevels as Imf_DeepTiledOutputPart_numXLevels;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_numYLevels as Imf_DeepTiledOutputPart_numYLevels;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_isValidLevel as Imf_DeepTiledOutputPart_isValidLevel;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_levelWidth as Imf_DeepTiledOutputPart_levelWidth;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_levelHeight as Imf_DeepTiledOutputPart_levelHeight;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_numXTiles as Imf_DeepTiledOutputPart_numXTiles;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_numYTiles as Imf_DeepTiledOutputPart_numYTiles;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_dataWindowForLevel as Imf_DeepTiledOutputPart_dataWindowForLevel;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_dataWindowForTile as Imf_DeepTiledOutputPart_dataWindowForTile;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_writeTile as Imf_DeepTiledOutputPart_writeTile;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_writeTiles as Imf_DeepTiledOutputPart_writeTiles;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_copyPixels_from_file as Imf_DeepTiledOutputPart_copyPixels_from_file;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_copyPixels_from_part as Imf_DeepTiledOutputPart_copyPixels_from_part;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_updatePreviewImage as Imf_DeepTiledOutputPart_updatePreviewImage;
pub use imf_deeptiledoutputpart::Imf_3_0__DeepTiledOutputPart_breakTile as Imf_DeepTiledOutputPart_breakTile;
pub mod imf_flatimagechannel;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_t as Imf_FlatImageChannel_t;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__t as Imf_FlatHalfChannel_t;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__t as Imf_FlatFloatChannel_t;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__t as Imf_FlatUIntChannel_t;

pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_pixelType as Imf_FlatImageChannel_pixelType;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_channel as Imf_FlatImageChannel_channel;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_xSampling as Imf_FlatImageChannel_xSampling;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_ySampling as Imf_FlatImageChannel_ySampling;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_pLinear as Imf_FlatImageChannel_pLinear;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_pixelsPerRow as Imf_FlatImageChannel_pixelsPerRow;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_pixelsPerColumn as Imf_FlatImageChannel_pixelsPerColumn;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_numPixels as Imf_FlatImageChannel_numPixels;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_level as Imf_FlatImageChannel_level;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_level_1 as Imf_FlatImageChannel_level_1;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_slice as Imf_FlatImageChannel_slice;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_flatLevel as Imf_FlatImageChannel_flatLevel;
pub use imf_flatimagechannel::Imf_3_0__FlatImageChannel_flatLevel_1 as Imf_FlatImageChannel_flatLevel_1;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__pixelType as Imf_FlatHalfChannel_pixelType;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__channel as Imf_FlatHalfChannel_channel;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__xSampling as Imf_FlatHalfChannel_xSampling;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__ySampling as Imf_FlatHalfChannel_ySampling;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__pLinear as Imf_FlatHalfChannel_pLinear;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__pixelsPerRow as Imf_FlatHalfChannel_pixelsPerRow;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__pixelsPerColumn as Imf_FlatHalfChannel_pixelsPerColumn;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__numPixels as Imf_FlatHalfChannel_numPixels;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__slice as Imf_FlatHalfChannel_slice;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__flatLevel as Imf_FlatHalfChannel_flatLevel;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__flatLevel_const as Imf_FlatHalfChannel_flatLevel_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__index as Imf_FlatHalfChannel_index;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__index_const as Imf_FlatHalfChannel_index_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__at as Imf_FlatHalfChannel_at;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__at_const as Imf_FlatHalfChannel_at_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__row as Imf_FlatHalfChannel_row;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_half__row_const as Imf_FlatHalfChannel_row_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__pixelType as Imf_FlatFloatChannel_pixelType;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__channel as Imf_FlatFloatChannel_channel;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__xSampling as Imf_FlatFloatChannel_xSampling;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__ySampling as Imf_FlatFloatChannel_ySampling;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__pLinear as Imf_FlatFloatChannel_pLinear;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__pixelsPerRow as Imf_FlatFloatChannel_pixelsPerRow;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__pixelsPerColumn as Imf_FlatFloatChannel_pixelsPerColumn;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__numPixels as Imf_FlatFloatChannel_numPixels;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__slice as Imf_FlatFloatChannel_slice;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__flatLevel as Imf_FlatFloatChannel_flatLevel;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__flatLevel_const as Imf_FlatFloatChannel_flatLevel_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__index as Imf_FlatFloatChannel_index;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__index_const as Imf_FlatFloatChannel_index_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__at as Imf_FlatFloatChannel_at;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__at_const as Imf_FlatFloatChannel_at_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__row as Imf_FlatFloatChannel_row;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_float__row_const as Imf_FlatFloatChannel_row_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__pixelType as Imf_FlatUIntChannel_pixelType;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__channel as Imf_FlatUIntChannel_channel;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__xSampling as Imf_FlatUIntChannel_xSampling;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__ySampling as Imf_FlatUIntChannel_ySampling;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__pLinear as Imf_FlatUIntChannel_pLinear;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__pixelsPerRow as Imf_FlatUIntChannel_pixelsPerRow;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__pixelsPerColumn as Imf_FlatUIntChannel_pixelsPerColumn;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__numPixels as Imf_FlatUIntChannel_numPixels;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__slice as Imf_FlatUIntChannel_slice;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__flatLevel as Imf_FlatUIntChannel_flatLevel;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__flatLevel_const as Imf_FlatUIntChannel_flatLevel_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__index as Imf_FlatUIntChannel_index;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__index_const as Imf_FlatUIntChannel_index_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__at as Imf_FlatUIntChannel_at;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__at_const as Imf_FlatUIntChannel_at_const;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__row as Imf_FlatUIntChannel_row;
pub use imf_flatimagechannel::Imf_3_0__TypedFlatImageChannel_unsignedint__row_const as Imf_FlatUIntChannel_row_const;
pub mod imf_imagechannel;
pub use imf_imagechannel::Imf_3_0__ImageChannel_t as Imf_ImageChannel_t;

pub use imf_imagechannel::Imf_3_0__ImageChannel_pixelType as Imf_ImageChannel_pixelType;
pub use imf_imagechannel::Imf_3_0__ImageChannel_channel as Imf_ImageChannel_channel;
pub use imf_imagechannel::Imf_3_0__ImageChannel_xSampling as Imf_ImageChannel_xSampling;
pub use imf_imagechannel::Imf_3_0__ImageChannel_ySampling as Imf_ImageChannel_ySampling;
pub use imf_imagechannel::Imf_3_0__ImageChannel_pLinear as Imf_ImageChannel_pLinear;
pub use imf_imagechannel::Imf_3_0__ImageChannel_pixelsPerRow as Imf_ImageChannel_pixelsPerRow;
pub use imf_imagechannel::Imf_3_0__ImageChannel_pixelsPerColumn as Imf_ImageChannel_pixelsPerColumn;
pub use imf_imagechannel::Imf_3_0__ImageChannel_numPixels as Imf_ImageChannel_numPixels;
pub use imf_imagechannel::Imf_3_0__ImageChannel_level as Imf_ImageChannel_level;
pub use imf_imagechannel::Imf_3_0__ImageChannel_level_const as Imf_ImageChannel_level_const;
pub mod imf_version;

pub use imf_version::Imf_3_0_isTiled as Imf_isTiled;
pub use imf_version::Imf_3_0_isMultiPart as Imf_isMultiPart;
pub use imf_version::Imf_3_0_isNonImage as Imf_isNonImage;
pub use imf_version::Imf_3_0_makeTiled as Imf_makeTiled;
pub use imf_version::Imf_3_0_makeNotTiled as Imf_makeNotTiled;
pub use imf_version::Imf_3_0_getVersion as Imf_getVersion;
pub use imf_version::Imf_3_0_getFlags as Imf_getFlags;
pub use imf_version::Imf_3_0_supportsFlags as Imf_supportsFlags;
pub use imf_version::Imf_3_0_isImfMagic as Imf_isImfMagic;
pub mod imf_parttype;

pub use imf_parttype::Imf_3_0_part_isImage as Imf_part_isImage;
pub use imf_parttype::Imf_3_0_part_isTiled as Imf_part_isTiled;
pub use imf_parttype::Imf_3_0_part_isDeepData as Imf_part_isDeepData;
pub use imf_parttype::Imf_3_0_part_isSupportedType as Imf_part_isSupportedType;
pub mod imath_box;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___t as Imath_Box2s_t;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___t as Imath_Box2i_t;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___t as Imath_Box2f_t;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___t as Imath_Box2d_t;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___t as Imath_Box3s_t;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___t as Imath_Box3i_t;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___t as Imath_Box3f_t;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___t as Imath_Box3d_t;

pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___ctor as Imath_Box2s_ctor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___ctor_1 as Imath_Box2s_ctor_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___ctor_2 as Imath_Box2s_ctor_2;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short____eq as Imath_Box2s__eq;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short____ne as Imath_Box2s__ne;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___makeEmpty as Imath_Box2s_makeEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___extendBy as Imath_Box2s_extendBy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___extendBy_1 as Imath_Box2s_extendBy_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___makeInfinite as Imath_Box2s_makeInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___size as Imath_Box2s_size;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___center as Imath_Box2s_center;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___intersects as Imath_Box2s_intersects;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___intersects_1 as Imath_Box2s_intersects_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___majorAxis as Imath_Box2s_majorAxis;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___isEmpty as Imath_Box2s_isEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___hasVolume as Imath_Box2s_hasVolume;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___isInfinite as Imath_Box2s_isInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___copy as Imath_Box2s_copy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___move as Imath_Box2s_move;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_short___dtor as Imath_Box2s_dtor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___ctor as Imath_Box2i_ctor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___ctor_1 as Imath_Box2i_ctor_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___ctor_2 as Imath_Box2i_ctor_2;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int____eq as Imath_Box2i__eq;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int____ne as Imath_Box2i__ne;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___makeEmpty as Imath_Box2i_makeEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___extendBy as Imath_Box2i_extendBy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___extendBy_1 as Imath_Box2i_extendBy_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___makeInfinite as Imath_Box2i_makeInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___size as Imath_Box2i_size;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___center as Imath_Box2i_center;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___intersects as Imath_Box2i_intersects;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___intersects_1 as Imath_Box2i_intersects_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___majorAxis as Imath_Box2i_majorAxis;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___isEmpty as Imath_Box2i_isEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___hasVolume as Imath_Box2i_hasVolume;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___isInfinite as Imath_Box2i_isInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___copy as Imath_Box2i_copy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___move as Imath_Box2i_move;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_int___dtor as Imath_Box2i_dtor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___ctor as Imath_Box2f_ctor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___ctor_1 as Imath_Box2f_ctor_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___ctor_2 as Imath_Box2f_ctor_2;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float____eq as Imath_Box2f__eq;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float____ne as Imath_Box2f__ne;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___makeEmpty as Imath_Box2f_makeEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___extendBy as Imath_Box2f_extendBy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___extendBy_1 as Imath_Box2f_extendBy_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___makeInfinite as Imath_Box2f_makeInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___size as Imath_Box2f_size;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___center as Imath_Box2f_center;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___intersects as Imath_Box2f_intersects;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___intersects_1 as Imath_Box2f_intersects_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___majorAxis as Imath_Box2f_majorAxis;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___isEmpty as Imath_Box2f_isEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___hasVolume as Imath_Box2f_hasVolume;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___isInfinite as Imath_Box2f_isInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___copy as Imath_Box2f_copy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___move as Imath_Box2f_move;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_float___dtor as Imath_Box2f_dtor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___ctor as Imath_Box2d_ctor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___ctor_1 as Imath_Box2d_ctor_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___ctor_2 as Imath_Box2d_ctor_2;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double____eq as Imath_Box2d__eq;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double____ne as Imath_Box2d__ne;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___makeEmpty as Imath_Box2d_makeEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___extendBy as Imath_Box2d_extendBy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___extendBy_1 as Imath_Box2d_extendBy_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___makeInfinite as Imath_Box2d_makeInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___size as Imath_Box2d_size;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___center as Imath_Box2d_center;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___intersects as Imath_Box2d_intersects;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___intersects_1 as Imath_Box2d_intersects_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___majorAxis as Imath_Box2d_majorAxis;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___isEmpty as Imath_Box2d_isEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___hasVolume as Imath_Box2d_hasVolume;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___isInfinite as Imath_Box2d_isInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___copy as Imath_Box2d_copy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___move as Imath_Box2d_move;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec2_double___dtor as Imath_Box2d_dtor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___ctor as Imath_Box3s_ctor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___ctor_1 as Imath_Box3s_ctor_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___ctor_2 as Imath_Box3s_ctor_2;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short____eq as Imath_Box3s__eq;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short____ne as Imath_Box3s__ne;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___makeEmpty as Imath_Box3s_makeEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___extendBy as Imath_Box3s_extendBy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___extendBy_1 as Imath_Box3s_extendBy_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___makeInfinite as Imath_Box3s_makeInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___size as Imath_Box3s_size;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___center as Imath_Box3s_center;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___intersects as Imath_Box3s_intersects;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___intersects_1 as Imath_Box3s_intersects_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___majorAxis as Imath_Box3s_majorAxis;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___isEmpty as Imath_Box3s_isEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___hasVolume as Imath_Box3s_hasVolume;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___isInfinite as Imath_Box3s_isInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___copy as Imath_Box3s_copy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___move as Imath_Box3s_move;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_short___dtor as Imath_Box3s_dtor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___ctor as Imath_Box3i_ctor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___ctor_1 as Imath_Box3i_ctor_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___ctor_2 as Imath_Box3i_ctor_2;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int____eq as Imath_Box3i__eq;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int____ne as Imath_Box3i__ne;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___makeEmpty as Imath_Box3i_makeEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___extendBy as Imath_Box3i_extendBy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___extendBy_1 as Imath_Box3i_extendBy_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___makeInfinite as Imath_Box3i_makeInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___size as Imath_Box3i_size;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___center as Imath_Box3i_center;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___intersects as Imath_Box3i_intersects;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___intersects_1 as Imath_Box3i_intersects_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___majorAxis as Imath_Box3i_majorAxis;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___isEmpty as Imath_Box3i_isEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___hasVolume as Imath_Box3i_hasVolume;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___isInfinite as Imath_Box3i_isInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___copy as Imath_Box3i_copy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___move as Imath_Box3i_move;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_int___dtor as Imath_Box3i_dtor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___ctor as Imath_Box3f_ctor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___ctor_1 as Imath_Box3f_ctor_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___ctor_2 as Imath_Box3f_ctor_2;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float____eq as Imath_Box3f__eq;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float____ne as Imath_Box3f__ne;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___makeEmpty as Imath_Box3f_makeEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___extendBy as Imath_Box3f_extendBy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___extendBy_1 as Imath_Box3f_extendBy_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___makeInfinite as Imath_Box3f_makeInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___size as Imath_Box3f_size;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___center as Imath_Box3f_center;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___intersects as Imath_Box3f_intersects;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___intersects_1 as Imath_Box3f_intersects_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___majorAxis as Imath_Box3f_majorAxis;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___isEmpty as Imath_Box3f_isEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___hasVolume as Imath_Box3f_hasVolume;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___isInfinite as Imath_Box3f_isInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___copy as Imath_Box3f_copy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___move as Imath_Box3f_move;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_float___dtor as Imath_Box3f_dtor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___ctor as Imath_Box3d_ctor;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___ctor_1 as Imath_Box3d_ctor_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___ctor_2 as Imath_Box3d_ctor_2;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double____eq as Imath_Box3d__eq;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double____ne as Imath_Box3d__ne;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___makeEmpty as Imath_Box3d_makeEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___extendBy as Imath_Box3d_extendBy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___extendBy_1 as Imath_Box3d_extendBy_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___makeInfinite as Imath_Box3d_makeInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___size as Imath_Box3d_size;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___center as Imath_Box3d_center;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___intersects as Imath_Box3d_intersects;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___intersects_1 as Imath_Box3d_intersects_1;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___majorAxis as Imath_Box3d_majorAxis;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___isEmpty as Imath_Box3d_isEmpty;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___hasVolume as Imath_Box3d_hasVolume;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___isInfinite as Imath_Box3d_isInfinite;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___copy as Imath_Box3d_copy;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___move as Imath_Box3d_move;
pub use imath_box::Imath_3_0__Box_Imath_3_0__Vec3_double___dtor as Imath_Box3d_dtor;
pub mod imf_imageio;

pub use imf_imageio::Imf_3_0_saveImage as Imf_saveImage;
pub use imf_imageio::Imf_3_0_saveImage_1 as Imf_saveImage_1;
pub use imf_imageio::Imf_3_0_loadImage as Imf_loadImage;
pub use imf_imageio::Imf_3_0_loadImage_1 as Imf_loadImage_1;
pub mod imf_deepcompositing;
pub use imf_deepcompositing::Imf_3_0__DeepCompositing_t as Imf_DeepCompositing_t;

pub use imf_deepcompositing::Imf_3_0__DeepCompositing_ctor as Imf_DeepCompositing_ctor;
pub use imf_deepcompositing::Imf_3_0__DeepCompositing_dtor as Imf_DeepCompositing_dtor;
pub use imf_deepcompositing::Imf_3_0__DeepCompositing_composite_pixel as Imf_DeepCompositing_composite_pixel;
pub use imf_deepcompositing::Imf_3_0__DeepCompositing_sort as Imf_DeepCompositing_sort;
pub use imf_deepcompositing::Imf_3_0__DeepCompositing__assign as Imf_DeepCompositing__assign;
pub mod imf_rgbafile;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_t as Imf_RgbaOutputFile_t;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_t as Imf_RgbaInputFile_t;

pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_ctor as Imf_RgbaOutputFile_ctor;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_from_stream as Imf_RgbaOutputFile_from_stream;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_with_windows as Imf_RgbaOutputFile_with_windows;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_with_dimensions as Imf_RgbaOutputFile_with_dimensions;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_dtor as Imf_RgbaOutputFile_dtor;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_setFrameBuffer as Imf_RgbaOutputFile_setFrameBuffer;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_writePixels as Imf_RgbaOutputFile_writePixels;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_currentScanLine as Imf_RgbaOutputFile_currentScanLine;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_header as Imf_RgbaOutputFile_header;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_frameBuffer as Imf_RgbaOutputFile_frameBuffer;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_displayWindow as Imf_RgbaOutputFile_displayWindow;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_dataWindow as Imf_RgbaOutputFile_dataWindow;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_pixelAspectRatio as Imf_RgbaOutputFile_pixelAspectRatio;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_screenWindowCenter as Imf_RgbaOutputFile_screenWindowCenter;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_screenWindowWidth as Imf_RgbaOutputFile_screenWindowWidth;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_lineOrder as Imf_RgbaOutputFile_lineOrder;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_compression as Imf_RgbaOutputFile_compression;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_channels as Imf_RgbaOutputFile_channels;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_updatePreviewImage as Imf_RgbaOutputFile_updatePreviewImage;
pub use imf_rgbafile::Imf_3_0__RgbaOutputFile_setYCRounding as Imf_RgbaOutputFile_setYCRounding;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_ctor as Imf_RgbaInputFile_ctor;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_from_stream as Imf_RgbaInputFile_from_stream;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_with_layer as Imf_RgbaInputFile_with_layer;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_from_stream_with_layer as Imf_RgbaInputFile_from_stream_with_layer;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_dtor as Imf_RgbaInputFile_dtor;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_setFrameBuffer as Imf_RgbaInputFile_setFrameBuffer;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_setLayerName as Imf_RgbaInputFile_setLayerName;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_readPixels as Imf_RgbaInputFile_readPixels;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_header as Imf_RgbaInputFile_header;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_frameBuffer as Imf_RgbaInputFile_frameBuffer;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_displayWindow as Imf_RgbaInputFile_displayWindow;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_dataWindow as Imf_RgbaInputFile_dataWindow;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_pixelAspectRatio as Imf_RgbaInputFile_pixelAspectRatio;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_screenWindowCenter as Imf_RgbaInputFile_screenWindowCenter;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_screenWindowWidth as Imf_RgbaInputFile_screenWindowWidth;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_lineOrder as Imf_RgbaInputFile_lineOrder;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_compression as Imf_RgbaInputFile_compression;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_channels as Imf_RgbaInputFile_channels;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_fileName as Imf_RgbaInputFile_fileName;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_isComplete as Imf_RgbaInputFile_isComplete;
pub use imf_rgbafile::Imf_3_0__RgbaInputFile_version as Imf_RgbaInputFile_version;
pub use imf_rgbafile::Imf_3_0_ComputeBasePointer as Imf_ComputeBasePointer;
pub mod imf_aces_file;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_t as Imf_AcesOutputFile_t;
pub use imf_aces_file::Imf_3_0__AcesInputFile_t as Imf_AcesInputFile_t;

pub use imf_aces_file::Imf_3_0__AcesOutputFile_new as Imf_AcesOutputFile_new;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_new_with_stream as Imf_AcesOutputFile_new_with_stream;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_new_with_header as Imf_AcesOutputFile_new_with_header;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_dtor as Imf_AcesOutputFile_dtor;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_setFrameBuffer as Imf_AcesOutputFile_setFrameBuffer;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_writePixels as Imf_AcesOutputFile_writePixels;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_currentScanLine as Imf_AcesOutputFile_currentScanLine;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_header as Imf_AcesOutputFile_header;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_displayWindow as Imf_AcesOutputFile_displayWindow;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_dataWindow as Imf_AcesOutputFile_dataWindow;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_pixelAspectRatio as Imf_AcesOutputFile_pixelAspectRatio;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_screenWindowCenter as Imf_AcesOutputFile_screenWindowCenter;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_screenWindowWidth as Imf_AcesOutputFile_screenWindowWidth;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_lineOrder as Imf_AcesOutputFile_lineOrder;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_compression as Imf_AcesOutputFile_compression;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_channels as Imf_AcesOutputFile_channels;
pub use imf_aces_file::Imf_3_0__AcesOutputFile_updatePreviewImage as Imf_AcesOutputFile_updatePreviewImage;
pub use imf_aces_file::Imf_3_0__AcesInputFile_new as Imf_AcesInputFile_new;
pub use imf_aces_file::Imf_3_0__AcesInputFile_new_with_stream as Imf_AcesInputFile_new_with_stream;
pub use imf_aces_file::Imf_3_0__AcesInputFile_dtor as Imf_AcesInputFile_dtor;
pub use imf_aces_file::Imf_3_0__AcesInputFile_setFrameBuffer as Imf_AcesInputFile_setFrameBuffer;
pub use imf_aces_file::Imf_3_0__AcesInputFile_readPixels as Imf_AcesInputFile_readPixels;
pub use imf_aces_file::Imf_3_0__AcesInputFile_header as Imf_AcesInputFile_header;
pub use imf_aces_file::Imf_3_0__AcesInputFile_displayWindow as Imf_AcesInputFile_displayWindow;
pub use imf_aces_file::Imf_3_0__AcesInputFile_dataWindow as Imf_AcesInputFile_dataWindow;
pub use imf_aces_file::Imf_3_0__AcesInputFile_pixelAspectRatio as Imf_AcesInputFile_pixelAspectRatio;
pub use imf_aces_file::Imf_3_0__AcesInputFile_screenWindowCenter as Imf_AcesInputFile_screenWindowCenter;
pub use imf_aces_file::Imf_3_0__AcesInputFile_screenWindowWidth as Imf_AcesInputFile_screenWindowWidth;
pub use imf_aces_file::Imf_3_0__AcesInputFile_lineOrder as Imf_AcesInputFile_lineOrder;
pub use imf_aces_file::Imf_3_0__AcesInputFile_compression as Imf_AcesInputFile_compression;
pub use imf_aces_file::Imf_3_0__AcesInputFile_channels as Imf_AcesInputFile_channels;
pub use imf_aces_file::Imf_3_0__AcesInputFile_fileName as Imf_AcesInputFile_fileName;
pub use imf_aces_file::Imf_3_0__AcesInputFile_isComplete as Imf_AcesInputFile_isComplete;
pub use imf_aces_file::Imf_3_0__AcesInputFile_version as Imf_AcesInputFile_version;
pub mod imf_tiledoutputpart;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_t as Imf_TiledOutputPart_t;

pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_sizeof as Imf_TiledOutputPart_sizeof;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_alignof as Imf_TiledOutputPart_alignof;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_ctor as Imf_TiledOutputPart_ctor;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_fileName as Imf_TiledOutputPart_fileName;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_header as Imf_TiledOutputPart_header;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_setFrameBuffer as Imf_TiledOutputPart_setFrameBuffer;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_frameBuffer as Imf_TiledOutputPart_frameBuffer;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_tileXSize as Imf_TiledOutputPart_tileXSize;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_tileYSize as Imf_TiledOutputPart_tileYSize;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_levelMode as Imf_TiledOutputPart_levelMode;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_levelRoundingMode as Imf_TiledOutputPart_levelRoundingMode;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_numLevels as Imf_TiledOutputPart_numLevels;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_numXLevels as Imf_TiledOutputPart_numXLevels;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_numYLevels as Imf_TiledOutputPart_numYLevels;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_isValidLevel as Imf_TiledOutputPart_isValidLevel;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_levelWidth as Imf_TiledOutputPart_levelWidth;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_levelHeight as Imf_TiledOutputPart_levelHeight;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_numXTiles as Imf_TiledOutputPart_numXTiles;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_numYTiles as Imf_TiledOutputPart_numYTiles;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_dataWindowForLevel as Imf_TiledOutputPart_dataWindowForLevel;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_dataWindowForTile as Imf_TiledOutputPart_dataWindowForTile;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_writeTile as Imf_TiledOutputPart_writeTile;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_writeTiles as Imf_TiledOutputPart_writeTiles;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_copyPixels_from_tiled_file as Imf_TiledOutputPart_copyPixels_from_tiled_file;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_copyPixels_from_file as Imf_TiledOutputPart_copyPixels_from_file;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_copyPixels_from_tiled_part as Imf_TiledOutputPart_copyPixels_from_tiled_part;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_copyPixels_from_part as Imf_TiledOutputPart_copyPixels_from_part;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_updatePreviewImage as Imf_TiledOutputPart_updatePreviewImage;
pub use imf_tiledoutputpart::Imf_3_0__TiledOutputPart_breakTile as Imf_TiledOutputPart_breakTile;
pub mod imf_samplecountchannel;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_t as Imf_SampleCountChannel_t;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel__Edit_t as Imf_SampleCountChannel_Edit_t;

pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_pixelType as Imf_SampleCountChannel_pixelType;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_channel as Imf_SampleCountChannel_channel;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_xSampling as Imf_SampleCountChannel_xSampling;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_ySampling as Imf_SampleCountChannel_ySampling;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_pLinear as Imf_SampleCountChannel_pLinear;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_pixelsPerRow as Imf_SampleCountChannel_pixelsPerRow;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_pixelsPerColumn as Imf_SampleCountChannel_pixelsPerColumn;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_numPixels as Imf_SampleCountChannel_numPixels;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_level as Imf_SampleCountChannel_level;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_level_1 as Imf_SampleCountChannel_level_1;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_slice as Imf_SampleCountChannel_slice;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_deepLevel as Imf_SampleCountChannel_deepLevel;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_deepLevel_const as Imf_SampleCountChannel_deepLevel_const;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_index as Imf_SampleCountChannel_index;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_at as Imf_SampleCountChannel_at;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_row as Imf_SampleCountChannel_row;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_set as Imf_SampleCountChannel_set;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_set_row as Imf_SampleCountChannel_set_row;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_clear as Imf_SampleCountChannel_clear;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_beginEdit as Imf_SampleCountChannel_beginEdit;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_endEdit as Imf_SampleCountChannel_endEdit;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_numSamples as Imf_SampleCountChannel_numSamples;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_sampleListSizes as Imf_SampleCountChannel_sampleListSizes;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_sampleListPositions as Imf_SampleCountChannel_sampleListPositions;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel_sampleBufferSize as Imf_SampleCountChannel_sampleBufferSize;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel__Edit_ctor as Imf_SampleCountChannel_Edit_ctor;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel__Edit_dtor as Imf_SampleCountChannel_Edit_dtor;
pub use imf_samplecountchannel::Imf_3_0__SampleCountChannel__Edit_sampleCounts as Imf_SampleCountChannel_Edit_sampleCounts;
pub mod std_string;
pub use std_string::std__string_t as std_string_t;

pub use std_string::std__string_ctor as std_string_ctor;
pub use std_string::std__string_copy as std_string_copy;
pub use std_string::std__string_dtor as std_string_dtor;
pub use std_string::std__string_assign as std_string_assign;
pub use std_string::std__string_c_str as std_string_c_str;
pub mod imf_outputfile;
pub use imf_outputfile::Imf_3_0__OutputFile_t as Imf_OutputFile_t;

pub use imf_outputfile::Imf_3_0__OutputFile_ctor as Imf_OutputFile_ctor;
pub use imf_outputfile::Imf_3_0__OutputFile_from_stream as Imf_OutputFile_from_stream;
pub use imf_outputfile::Imf_3_0__OutputFile_dtor as Imf_OutputFile_dtor;
pub use imf_outputfile::Imf_3_0__OutputFile_fileName as Imf_OutputFile_fileName;
pub use imf_outputfile::Imf_3_0__OutputFile_header as Imf_OutputFile_header;
pub use imf_outputfile::Imf_3_0__OutputFile_setFrameBuffer as Imf_OutputFile_setFrameBuffer;
pub use imf_outputfile::Imf_3_0__OutputFile_frameBuffer as Imf_OutputFile_frameBuffer;
pub use imf_outputfile::Imf_3_0__OutputFile_writePixels as Imf_OutputFile_writePixels;
pub use imf_outputfile::Imf_3_0__OutputFile_currentScanLine as Imf_OutputFile_currentScanLine;
pub use imf_outputfile::Imf_3_0__OutputFile_copyPixels_from_file as Imf_OutputFile_copyPixels_from_file;
pub use imf_outputfile::Imf_3_0__OutputFile_copyPixels_from_part as Imf_OutputFile_copyPixels_from_part;
pub use imf_outputfile::Imf_3_0__OutputFile_updatePreviewImage as Imf_OutputFile_updatePreviewImage;
pub use imf_outputfile::Imf_3_0__OutputFile_breakScanLine as Imf_OutputFile_breakScanLine;
pub mod imf_multiview;

pub mod imf_pixeltype;

pub use imf_pixeltype::Imf_3_0__PixelType_e as Imf_PixelType;
pub use imf_pixeltype::Imf_PixelType_UINT;
pub use imf_pixeltype::Imf_PixelType_HALF;
pub use imf_pixeltype::Imf_PixelType_FLOAT;
pub use imf_pixeltype::Imf_PixelType_NUM_PIXELTYPES;
pub use imf_pixeltype::PixelType;
pub mod imf_image;
pub use imf_image::Imf_3_0__Image_t as Imf_Image_t;

pub use imf_image::Imf_3_0__Image_dtor as Imf_Image_dtor;
pub use imf_image::Imf_3_0__Image_levelMode as Imf_Image_levelMode;
pub use imf_image::Imf_3_0__Image_levelRoundingMode as Imf_Image_levelRoundingMode;
pub use imf_image::Imf_3_0__Image_numLevels as Imf_Image_numLevels;
pub use imf_image::Imf_3_0__Image_numXLevels as Imf_Image_numXLevels;
pub use imf_image::Imf_3_0__Image_numYLevels as Imf_Image_numYLevels;
pub use imf_image::Imf_3_0__Image_dataWindow as Imf_Image_dataWindow;
pub use imf_image::Imf_3_0__Image_dataWindowForLevel as Imf_Image_dataWindowForLevel;
pub use imf_image::Imf_3_0__Image_levelWidth as Imf_Image_levelWidth;
pub use imf_image::Imf_3_0__Image_levelHeight as Imf_Image_levelHeight;
pub use imf_image::Imf_3_0__Image_resize as Imf_Image_resize;
pub use imf_image::Imf_3_0__Image_resize_1 as Imf_Image_resize_1;
pub use imf_image::Imf_3_0__Image_shiftPixels as Imf_Image_shiftPixels;
pub use imf_image::Imf_3_0__Image_insertChannel as Imf_Image_insertChannel;
pub use imf_image::Imf_3_0__Image_insertChannel_1 as Imf_Image_insertChannel_1;
pub use imf_image::Imf_3_0__Image_eraseChannel as Imf_Image_eraseChannel;
pub use imf_image::Imf_3_0__Image_clearChannels as Imf_Image_clearChannels;
pub use imf_image::Imf_3_0__Image_renameChannel as Imf_Image_renameChannel;
pub use imf_image::Imf_3_0__Image_renameChannels as Imf_Image_renameChannels;
pub use imf_image::Imf_3_0__Image_level as Imf_Image_level;
pub use imf_image::Imf_3_0__Image_level_const as Imf_Image_level_const;
pub mod imf_name;
pub use imf_name::Imf_3_0__Name_t as Imf_Name_t;

pub use imf_name::Imf_3_0__Name_sizeof as Imf_Name_sizeof;
pub use imf_name::Imf_3_0__Name_alignof as Imf_Name_alignof;
pub use imf_name::Imf_3_0__Name_default as Imf_Name_default;
pub use imf_name::Imf_3_0__Name_ctor as Imf_Name_ctor;
pub use imf_name::Imf_3_0__Name_copy as Imf_Name_copy;
pub use imf_name::Imf_3_0__Name_move as Imf_Name_move;
pub use imf_name::Imf_3_0__Name_dtor as Imf_Name_dtor;
pub use imf_name::Imf_3_0__Name__assign as Imf_Name__assign;
pub use imf_name::Imf_3_0__Name__assign_1 as Imf_Name__assign_1;
pub use imf_name::Imf_3_0__Name_text as Imf_Name_text;
pub mod imf_multipartoutputfile;
pub use imf_multipartoutputfile::Imf_3_0__MultiPartOutputFile_t as Imf_MultiPartOutputFile_t;

pub use imf_multipartoutputfile::Imf_3_0__MultiPartOutputFile_ctor as Imf_MultiPartOutputFile_ctor;
pub use imf_multipartoutputfile::Imf_3_0__MultiPartOutputFile_from_stream as Imf_MultiPartOutputFile_from_stream;
pub use imf_multipartoutputfile::Imf_3_0__MultiPartOutputFile_parts as Imf_MultiPartOutputFile_parts;
pub use imf_multipartoutputfile::Imf_3_0__MultiPartOutputFile_header as Imf_MultiPartOutputFile_header;
pub use imf_multipartoutputfile::Imf_3_0__MultiPartOutputFile_dtor as Imf_MultiPartOutputFile_dtor;
pub mod imf_chromaticities;
pub use imf_chromaticities::Imf_3_0__Chromaticities_t as Imf_Chromaticities_t;

pub use imf_chromaticities::Imf_3_0__Chromaticities_ctor as Imf_Chromaticities_ctor;
pub use imf_chromaticities::Imf_3_0__Chromaticities__eq as Imf_Chromaticities__eq;
pub use imf_chromaticities::Imf_3_0__Chromaticities__ne as Imf_Chromaticities__ne;
pub use imf_chromaticities::Imf_3_0__Chromaticities_copy as Imf_Chromaticities_copy;
pub use imf_chromaticities::Imf_3_0__Chromaticities_move as Imf_Chromaticities_move;
pub use imf_chromaticities::Imf_3_0__Chromaticities_dtor as Imf_Chromaticities_dtor;
pub mod imf_flatimagelevel;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_t as Imf_FlatImageLevel_t;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__Iterator_t as Imf_FlatImageLevel_Iterator_t;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_t as Imf_FlatImageLevel_ConstIterator_t;

pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_xLevelNumber as Imf_FlatImageLevel_xLevelNumber;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_yLevelNumber as Imf_FlatImageLevel_yLevelNumber;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_dataWindow as Imf_FlatImageLevel_dataWindow;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_flatImage as Imf_FlatImageLevel_flatImage;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_flatImage_const as Imf_FlatImageLevel_flatImage_const;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_findChannel as Imf_FlatImageLevel_findChannel;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_findChannel_const as Imf_FlatImageLevel_findChannel_const;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_channel as Imf_FlatImageLevel_channel;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_channel_const as Imf_FlatImageLevel_channel_const;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_findTypedChannel_half as Imf_FlatImageLevel_findTypedChannel_half;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_findTypedChannel_float as Imf_FlatImageLevel_findTypedChannel_float;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_findTypedChannel_uint as Imf_FlatImageLevel_findTypedChannel_uint;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_findTypedChannel_half_const as Imf_FlatImageLevel_findTypedChannel_half_const;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_findTypedChannel_float_const as Imf_FlatImageLevel_findTypedChannel_float_const;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_findTypedChannel_uint_const as Imf_FlatImageLevel_findTypedChannel_uint_const;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_begin as Imf_FlatImageLevel_begin;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_begin_const as Imf_FlatImageLevel_begin_const;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_end as Imf_FlatImageLevel_end;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel_end_const as Imf_FlatImageLevel_end_const;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__Iterator_sizeof as Imf_FlatImageLevel_Iterator_sizeof;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__Iterator_alignof as Imf_FlatImageLevel_Iterator_alignof;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__Iterator_ctor as Imf_FlatImageLevel_Iterator_ctor;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__Iterator_inc as Imf_FlatImageLevel_Iterator_inc;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__Iterator_name as Imf_FlatImageLevel_Iterator_name;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__Iterator_channel as Imf_FlatImageLevel_Iterator_channel;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__Iterator_copy as Imf_FlatImageLevel_Iterator_copy;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_sizeof as Imf_FlatImageLevel_ConstIterator_sizeof;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_alignof as Imf_FlatImageLevel_ConstIterator_alignof;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_ctor as Imf_FlatImageLevel_ConstIterator_ctor;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_from_mut as Imf_FlatImageLevel_ConstIterator_from_mut;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_inc as Imf_FlatImageLevel_ConstIterator_inc;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_name as Imf_FlatImageLevel_ConstIterator_name;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_channel as Imf_FlatImageLevel_ConstIterator_channel;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_copy as Imf_FlatImageLevel_ConstIterator_copy;
pub use imf_flatimagelevel::Imf_3_0__FlatImageLevel__ConstIterator_move as Imf_FlatImageLevel_ConstIterator_move;


#[cfg(test)]
mod test;
