#[macro_export]
/// Creates an asynchronous state machine with the given visibility, name and
/// state definitions.
macro_rules! state_machine {
    {
        $(#[$attr:meta])*
        $vis:vis $name:ident $(($($iname:ident: $itype:ty),+ $(,)?))? $({
            $(
                $(#[$vattr:meta])*
                $vname:ident: $vtype:ty = $vinit:expr
            ),+ $(,)?
        })? = $init:ident($($arg:expr),*);

        $(
            $(#[$fattr:meta])*
            $state:ident ($ctx:ident $(, $pname:ident: $ptype:ty)* $(,)?) $([$($vref:ident),*])? $(-> $fret:ty)? $body:block
        )*
    } => {
        #[derive(Clone, Debug, PartialEq, Eq, PartialOrd, Ord)]
        /// State type used internally by the state machine. Auto-generated by the `state_machine!` macro.
        $vis enum State {
            $(
                #[allow(non_camel_case_types)]
                #[allow(missing_docs)]
                $state($($ptype),*),
            )*
        }

        #[derive(Clone)]
        struct Vars {
            $(
                $(
                    $(#[$vattr])*
                    $vname: $vtype,
                )+
            )?
        }

        impl Vars {
            $(
                fn $state(&mut self, $ctx: $crate::rtos::Context, $($pname: $ptype),*) $(-> $fret)? {
                    $(
                        $(
                            let $vref: &mut _ = &mut self.$vref;
                        )*
                    )?
                    $body
                }
            )*
        }

        struct Data {
            state: State,
            #[allow(dead_code)]
            promise: $crate::rtos::Promise<Vars>,
            ctxw: $crate::rtos::ContextWrapper,
        }

        $(#[$attr])*
        $vis struct $name($crate::rtos::Mutex<Data>);

        impl $name {
            pub fn new($($($iname: $itype),+)?) -> Self {
                let (promise, resolve) = $crate::rtos::Promise::new();
                $(
                    $(
                        let $vname = $vinit;
                    )+
                )?
                resolve(Vars {
                    $(
                        $(
                            $vname,
                        )+
                    )?
                });
                let state = State::$init($($arg),*);
                let r = Self($crate::rtos::Mutex::new(Data {
                    state: ::core::clone::Clone::clone(&state),
                    promise,
                    ctxw: $crate::rtos::ContextWrapper::new(),
                }));
                $crate::machine::StateMachine::transition(&r, state);
                r
            }

            $(
                $(#[$fattr])*
                pub fn $state(&self, $($pname: $ptype),*) -> $crate::rtos::Promise $(<$fret>)? {
                    let mut lock = self.0.lock();
                    let ctx = lock.ctxw.replace();
                    lock.state = State::$state($(::core::clone::Clone::clone($pname)),*);
                    let promise = lock.promise.then(move |vars: &Vars| {
                        let mut vars = ::core::clone::Clone::clone(vars);
                        let r = vars.$state(ctx, $($pname),*);
                        (vars, r)
                    });
                    lock.promise = promise.then(|(vars, _)| ::core::clone::Clone::clone(vars));
                    promise.then(|(_, r)| ::core::clone::Clone::clone(r))
                }
            )*
        }

        impl $crate::machine::StateMachine for $name {
            type State = State;

            #[inline]
            fn state(&self) -> State {
                self.0.lock().state.clone()
            }

            #[inline]
            fn transition(&self, state: State) {
                match state {
                    $(
                        State::$state($($pname),*) => self.$state($($pname),*),
                    )*
                };
            }
        }
    };
}
