/*
 * \file pros/colors.h
 *
 * Contains macro definitions of colors (as `uint32_t`)
 *
 * This file should not be modified by users, since it gets replaced whenever
 * a kernel upgrade occurs.
 *
 * Copyright (c) 2017-2020 Purdue University ACM SIGBots.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License v. 2.0. If a copy of the MPL was not distributed with this
 * file You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef _PROS_COLORS_H_
#define _PROS_COLORS_H_

#define RGB2COLOR(R, G, B) ((R & 0xff) << 16 | (G & 0xff) << 8 | (B & 0xff))
#define COLOR2R(COLOR) ((COLOR >> 16) & 0xff)
#define COLOR2G(COLOR) ((COLOR >> 8) && 0xff)
#define COLOR2B(COLOR) (COLOR & 0xff)

#define COLOR_ALICE_BLUE 0x00F0F8FF
#define COLOR_ANTIQUE_WHITE 0x00FAEBD7
#define COLOR_AQUA 0x0000FFFF
#define COLOR_AQUAMARINE 0x007FFFD4
#define COLOR_AZURE 0x00F0FFFF
#define COLOR_BEIGE 0x00F5F5DC
#define COLOR_BISQUE 0x00FFE4C4
#define COLOR_BLACK 0x00000000
#define COLOR_BLANCHED_ALMOND 0x00FFEBCD
#define COLOR_BLUE 0x000000FF
#define COLOR_BLUE_VIOLET 0x008A2BE2
#define COLOR_BROWN 0x00A52A2A
#define COLOR_BURLY_WOOD 0x00DEB887
#define COLOR_CADET_BLUE 0x005F9EA0
#define COLOR_CHARTREUSE 0x007FFF00
#define COLOR_CHOCOLATE 0x00D2691E
#define COLOR_CORAL 0x00FF7F50
#define COLOR_CORNFLOWER_BLUE 0x006495ED
#define COLOR_CORNSILK 0x00FFF8DC
#define COLOR_CRIMSON 0x00DC143C
#define COLOR_CYAN 0x0000FFFF
#define COLOR_DARK_BLUE 0x0000008B
#define COLOR_DARK_CYAN 0x00008B8B
#define COLOR_DARK_GOLDENROD 0x00B8860B
#define COLOR_DARK_GRAY 0x00A9A9A9
#define COLOR_DARK_GREEN 0x00006400
#define COLOR_DARK_KHAKI 0x00BDB76B
#define COLOR_DARK_MAGENTA 0x008B008B
#define COLOR_DARK_OLIVE_GREEN 0x00556B2F
#define COLOR_DARK_ORANGE 0x00FF8C00
#define COLOR_DARK_ORCHID 0x009932CC
#define COLOR_DARK_RED 0x008B0000
#define COLOR_DARK_SALMON 0x00E9967A
#define COLOR_DARK_SEA_GREEN 0x008FBC8F
#define COLOR_DARK_SLATE_GRAY 0x002F4F4F
#define COLOR_DARK_TURQUOISE 0x0000CED1
#define COLOR_DARK_VIOLET 0x009400D3
#define COLOR_DEEP_PINK 0x00FF1493
#define COLOR_DEEP_SKY_BLUE 0x0000BFFF
#define COLOR_DIM_GRAY 0x00696969
#define COLOR_DODGER_BLUE 0x001E90FF
#define COLOR_FIRE_BRICK 0x00B22222
#define COLOR_FLORAL_WHITE 0x00FFFAF0
#define COLOR_FOREST_GREEN 0x00228B22
#define COLOR_FUCHSIA 0x00FF00FF
#define COLOR_GAINSBORO 0x00DCDCDC
#define COLOR_GHOST_WHITE 0x00F8F8FF
#define COLOR_GOLD 0x00FFD700
#define COLOR_GOLDENROD 0x00DAA520
#define COLOR_GRAY 0x00808080
#define COLOR_GREEN 0x00008000
#define COLOR_GREEN_YELLOW 0x00ADFF2F
#define COLOR_HONEYDEW 0x00F0FFF0
#define COLOR_HOT_PINK 0x00FF69B4
#define COLOR_INDIAN_RED 0x00CD5C5C
#define COLOR_INDIGO 0x004B0082
#define COLOR_IVORY 0x00FFFFF0
#define COLOR_KHAKI 0x00F0E68C
#define COLOR_LAVENDER 0x00E6E6FA
#define COLOR_LAVENDER_BLUSH 0x00FFF0F5
#define COLOR_LAWN_GREEN 0x007CFC00
#define COLOR_LEMON_CHIFFON 0x00FFFACD
#define COLOR_LIGHT_BLUE 0x00ADD8E6
#define COLOR_LIGHT_CORAL 0x00F08080
#define COLOR_LIGHT_CYAN 0x00E0FFFF
#define COLOR_LIGHT_GOLDENROD_YELLOW 0x00FAFAD2
#define COLOR_LIGHT_GREEN 0x0090EE90
#define COLOR_LIGHT_GRAY 0x00D3D3D3
#define COLOR_LIGHT_PINK 0x00FFB6C1
#define COLOR_LIGHT_SALMON 0x00FFA07A
#define COLOR_LIGHT_SEA_GREEN 0x0020B2AA
#define COLOR_LIGHT_SKY_BLUE 0x0087CEFA
#define COLOR_LIGHT_SLATE_GRAY 0x00778899
#define COLOR_LIGHT_STEEL_BLUE 0x00B0C4DE
#define COLOR_LIGHT_YELLOW 0x00FFFFE0
#define COLOR_LIME 0x0000FF00
#define COLOR_LIME_GREEN 0x0032CD32
#define COLOR_LINEN 0x00FAF0E6
#define COLOR_MAGENTA 0x00FF00FF
#define COLOR_MAROON 0x00800000
#define COLOR_MEDIUM_AQUAMARINE 0x0066CDAA
#define COLOR_MEDIUM_BLUE 0x000000CD
#define COLOR_MEDIUM_ORCHID 0x00BA55D3
#define COLOR_MEDIUM_PURPLE 0x009370DB
#define COLOR_MEDIUM_SEA_GREEN 0x003CB371
#define COLOR_MEDIUM_SLATE_BLUE 0x007B68EE
#define COLOR_MEDIUM_SPRING_GREEN 0x0000FA9A
#define COLOR_MEDIUM_TURQUOISE 0x0048D1CC
#define COLOR_MEDIUM_VIOLET_RED 0x00C71585
#define COLOR_MIDNIGHT_BLUE 0x00191970
#define COLOR_MINT_CREAM 0x00F5FFFA
#define COLOR_MISTY_ROSE 0x00FFE4E1
#define COLOR_MOCCASIN 0x00FFE4B5
#define COLOR_NAVAJO_WHITE 0x00FFDEAD
#define COLOR_NAVY 0x00000080
#define COLOR_OLD_LACE 0x00FDF5E6
#define COLOR_OLIVE 0x00808000
#define COLOR_OLIVE_DRAB 0x006B8E23
#define COLOR_ORANGE 0x00FFA500
#define COLOR_ORANGE_RED 0x00FF4500
#define COLOR_ORCHID 0x00DA70D6
#define COLOR_PALE_GOLDENROD 0x00EEE8AA
#define COLOR_PALE_GREEN 0x0098FB98
#define COLOR_PALE_TURQUOISE 0x00AFEEEE
#define COLOR_PALE_VIOLET_RED 0x00DB7093
#define COLOR_PAPAY_WHIP 0x00FFEFD5
#define COLOR_PEACH_PUFF 0x00FFDAB9
#define COLOR_PERU 0x00CD853F
#define COLOR_PINK 0x00FFC0CB
#define COLOR_PLUM 0x00DDA0DD
#define COLOR_POWDER_BLUE 0x00B0E0E6
#define COLOR_PURPLE 0x00800080
#define COLOR_RED 0x00FF0000
#define COLOR_ROSY_BROWN 0x00BC8F8F
#define COLOR_ROYAL_BLUE 0x004169E1
#define COLOR_SADDLE_BROWN 0x008B4513
#define COLOR_SALMON 0x00FA8072
#define COLOR_SANDY_BROWN 0x00F4A460
#define COLOR_SEA_GREEN 0x002E8B57
#define COLOR_SEASHELL 0x00FFF5EE
#define COLOR_SIENNA 0x00A0522D
#define COLOR_SILVER 0x00C0C0C0
#define COLOR_SKY_BLUE 0x0087CEEB
#define COLOR_SLATE_BLUE 0x006A5ACD
#define COLOR_SLATE_GRAY 0x00708090
#define COLOR_SNOW 0x00FFFAFA
#define COLOR_SPRING_GREEN 0x0000FF7F
#define COLOR_STEEL_BLUE 0x004682B4
#define COLOR_TAN 0x00D2B48C
#define COLOR_TEAL 0x00008080
#define COLOR_THISTLE 0x00D8BFD8
#define COLOR_TOMATO 0x00FF6347
#define COLOR_TURQUOISE 0x0040E0D0
#define COLOR_VIOLET 0x00EE82EE
#define COLOR_WHEAT 0x00F5DEB3
#define COLOR_WHITE 0x00FFFFFF
#define COLOR_WHITE_SMOKE 0x00F5F5F5
#define COLOR_YELLOW 0x00FFFF00
#define COLOR_YELLOW_GREEN 0x009ACD32
#define COLOR_DARK_GREY COLOR_DARK_GRAY
#define COLOR_DARK_SLATE_GREY COLOR_DARK_SLATE_GRAY
#define COLOR_DIM_GREY COLOR_DIM_GRAY
#define COLOR_GREY COLOR_GRAY
#define COLOR_LIGHT_GREY COLOR_LIGHT_GRAY
#define COLOR_LIGHT_SLATE_GREY COLOR_LIGHT_SLATE_GRAY
#define COLOR_SLATE_GREY COLOR_SLATE_GRAY

#endif  // _PROS_COLORS_H_
