use std::io;
use thiserror::Error;

/// Various error types returned by verto functions.
#[derive(Debug, Error)]
pub enum VertoError {
    #[error("Error parsing semver: {0}")]
    Semver(#[from] semver::Error),

    #[error("Error parsing semver: {0}")]
    Version(String),

    #[error("I/O error: {0}")]
    Io(#[from] io::Error),

    #[error("Git error: {0}")]
    Git(#[from] git2::Error),

    #[error("Error traversing directories: {0}")]
    Directory(#[from] walkdir::Error),

    #[error("{0}")]
    Error(String),
}
