# Vermilion
Vermilion is a virtual machine, code generator and object file format intended for use in JIT compiled programming languages (written entirely in Rust).  It allows efficient compilation (at the expense of no code verification) compared to code generators such as LLVM and Cranelift.

> Vermilion is still in an alpha state and doesn't generate the most efficient code.  If you find any bugs, please create an issue describing how to reproduce it.  Thank you :)

## Example
Provided the following pseudo code:

```
function main {
block0:
    %0 = int 1
    %1 = int 1

    add_int %0, %1

    return
}
```

We can implement this with Vermilion via the `vermilion-codegen` crate:

```rust
use vermilion_jit::codegen::binemit::Binemit;
use vermilion_jit::codegen::ir::{Function, Module};

let module = Module::new();

let main = Function::new();
let block0 = main.create_block();

main.switch_to_block(block0);
{
    let tmp0 = main.iconst_integer(1);
    let tmp1 = main.iconst_integer(1);
    main.integer_add(tmp0, tmp1);
}
main.return_();

// Define main function
module.define_function("main", main);

// Compile
let mut compiler = Binemit::new(module);
let mut artifact = compiler.emit();

// Run
let mut vm = artifact.new_vm();
vm.run_function("main");
```