//! A module that provides support for the types defined in Vermilion 2021 R2.

/// The objects natively supported by the Vermilion virtual machine.
#[derive(Clone, Copy)]
pub enum VermilionObject {

    /// A single bit encoded as 1 byte, used for logical comparisons.
    Boolean(bool),

    /// An unsigned 8-bit integer.
    Byte(u8),

    /// A 64-bit integer.
    Integer(i64),

    /// A 64-bit floating point number.
    Float(f64),

}