//! Exposes the instructions that are available to the virtual machine.

/// The opcodes for the instructions defined in the Vermilion 2021
/// specification.
pub enum Opcode {

    /// An illegal instruction.  Not defined in the Vermilion specification,
    /// but it is used for internal use only.
    Illegal,

    Boolean,
    Byte,
    Integer,
    Float,
    Pop,
    Clone,
    Clear,
    Trap,
    BooleanAdd,
    BooleanSubtract,
    ByteAdd,
    ByteSubtract,
    ByteMultiply,
    ByteDivide,
    ByteRemainder,
    IntegerAdd,
    IntegerSubtract,
    IntegerMultiply,
    IntegerDivide,
    IntegerRemainder,
    FloatAdd,
    FloatSubtract,
    FloatMultiply,
    FloatDivide,
    FloatRemainder,
    CastBoolean,
    CastByte,
    CastInteger,
    CastFloat,
    NegateBoolean,
    NegateByte,
    NegateInteger,
    NegateFloat,
    Load,
    Store,
    Realloc,
    HeapSize,
    Alloc,
    ReallocSection,
    SectionAddr,
    SectionShiftLeft,
    SectionShiftRight,
    Free,
    FreeAndShift,
    Branch,
    BranchIfZero,
    BranchIfNotZero,
    Equal,
    GreaterThan,
    LessThan,
    GreaterThanOrEqual,
    LessThanOrEqual,
    Call,
    Return,

}