extern crate vermilion_codegen;
extern crate vermilion_vm;

use std::fs::write;
use vermilion_codegen::ir::{Function, Module};
use vermilion_codegen::binemit::Binemit;
use vermilion_vm::VermilionObject;

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn textemit() {
        let start = std::time::Instant::now();
        let mut module = Module::new();
        let mut func = Function::new();
        
        let block0 = func.create_block();

        func.switch_to_block(block0);
        {
            let tmp0 = func.iconst_integer(1);
            let tmp1 = func.iconst_integer(1);
            
            func.int_add(tmp0, tmp1);

            //func.branch(block0);
            func.return_(&[]);
        }

        module.define_function("main".to_string(), func);

        let mut compiler = Binemit::new(module);
        let mut artifact = compiler.emit();

        let end = start.elapsed().as_nanos();

        println!("Compile time: {}ms", end as f64 / 1e+6f64);

        let bytes = artifact.into_bytes();

        write("test.o", bytes).unwrap();

        // test vm

        /*
        let mut vm = artifact.new_vm();

        let start = std::time::Instant::now();
        vm.call_function("main".to_string());
        let end = start.elapsed().as_nanos();
        println!("Run time: {}ms", end as f64 / 1e+6f64);

        //println!("{}", vm.stack.len());

        for item in vm.stack {
            match item {
                VermilionObject::Boolean(v) => {
                    println!("Boolean({})", v);
                },
                VermilionObject::Byte(v) => {
                    println!("Byte({})", v);
                },
                VermilionObject::Integer(v) => {
                    println!("Integer({})", v);
                },
                VermilionObject::Float(v) => {
                    println!("Float({})", v);
                },
            }
        }

        //for byte in bytes {
        //    println!("BYTE {}", byte);
        //}*/
    }
}