//! A module for Vermilion IR instructions.

use crate::entities::Value;

/// An instruction opcode, used when emitting binary.
#[derive(Clone)]
pub enum Opcode {
    Pop,
    Clone,
    Clear,
    Trap,
    BooleanAdd,
    BooleanSubtract,
    ByteAdd,
    ByteSubtract,
    ByteMultiply,
    ByteDivide,
    ByteRemainder,
    IntegerAdd,
    IntegerSubtract,
    IntegerMultiply,
    IntegerDivide,
    IntegerRemainder,
    FloatAdd,
    FloatSubtract,
    FloatMultiply,
    FloatDivide,
    FloatRemainder,
    CastBoolean,
    CastByte,
    CastInteger,
    CastFloat,
    NegateBoolean,
    NegateByte,
    NegateInteger,
    NegateFloat,
    Load,
    Store,
    Realloc,
    HeapSize,
    Alloc,
    ReallocSection,
    SectionAddr,
    SectionShiftLeft,
    SectionShiftRight,
    Free,
    FreeAndShift,
    Branch,
    BranchIfZero,
    BranchIfNotZero,
    Equal,
    GreaterThan,
    LessThan,
    GreaterThanOrEqual,
    LessThanOrEqual,
    Call,
    Return,
}

/// A struct that stores information about an instruction.
#[derive(Clone)]
pub struct InstructionData {

    /// The opcode of the instruction, which is translated
    /// directly to bytecode.
    pub opcode: Opcode,

    /// A list of instruction arguments.
    pub args: Vec<Value>,

}