//! Entities used by the Vermilion code generator.

use crate::ir::Function;

/// An opaque reference to an SSA value.
#[derive(Clone)]
pub struct Value(pub u32);

/// An opaque reference to a global SSA value.
#[derive(Clone)]
pub struct GlobalValue(String);

/// An opaque reference to a block.
#[derive(Clone, Copy)]
pub struct Block(pub u32);

/// A symbol in Vermilion IR
#[derive(Clone)]
pub enum Symbol {

    /// An externally defined symbol, undeclared here.
    External,

    /// A locally defined symbol.
    Local(Function)

}

/// Used for constant global variables.
pub enum GlobalData {
    
    /// A basic null-terminated string.
    String(String),

}