use bevy::prelude::*;


pub const TEXT_ACTOR_DEFAULT_LAYER: f32 = 900.0;
pub const TEXT_ACTOR_DEFAULT_FONT_SIZE: f32 = 30.0;

#[derive(Clone, Debug)]
pub struct TextActor {

    pub label: String,

    pub text: String,

    pub font_size: f32,

    pub translation: Vec2,

    pub layer: f32,

    pub rotation: f32,

    pub scale: f32,
}

//There Are 2 Available Simple Fonts Yet In The VeeBee GameEngine
impl Default for TextActor {
    fn default() -> Self {
        Self {
            label: String::default(),
            text: String::default(),
            font_size: TEXT_ACTOR_DEFAULT_FONT_SIZE,
            translation: Vec2::default(),
            layer: TEXT_ACTOR_DEFAULT_LAYER,
            rotation: f32::default(),
            scale: 1.0,
        }
    }
}

impl TextActor {
    pub(crate) fn bevy_transform(&self) -> Transform {
        let mut transform = Transform::from_translation(self.translation.extend(self.layer));
        transform.rotation = Quat::from_axis_angle(Vec3::Z, self.rotation);
        transform.scale = Vec3::splat(self.scale);
        transform
    }
}