use veebee::prelude::*;

fn main() {
    let mut game = Game::new();
    game.window_settings(WindowDescriptor {
        width: 700.0,
        height: 100.0,
        resize_constraints: WindowResizeConstraints {
            min_width: 700.0,
            min_height: 150.0,
            max_width: 900.0,
            max_height: 300.0,
        },
        title: "Veebee Window".into(),
        vsync: false,
        resizable: true,
        decorations: false,
        cursor_visible: false,
        ..Default::default()
    });
    let _ = game.add_text_actor(
        "message",
        "This Is A Simple VeeBee Window\nPress Esc To Exit.",
    );
    game.run(|_| {});
}