use veebee::prelude::*;

fn main() {
    let mut game = Game::new();
    game.game_state_mut()
        .timer_map
        .insert("music change timer".into(), Timer::from_seconds(30.0, true));
    let _ = game.add_text_actor(
        "msg",
        "If It Takes Too Long To Play The Music, Try To Run It With \"--release\", It May Take A Few Seconds To Play.",
    );

    game.run(logic);
}

fn logic(game_state: &mut GameState) {

    if game_state.bool_map.get("Music Begin!").is_none() {
        let note1 =
            game_state.add_text_actor("note1", "Playing MysteriousMagic For About 30 Seconds.");
        note1.translation.y = -100.0;
        game_state.bool_map.insert("Music Begin!".into(), true);
        game_state
            .audio_manager
            .play_music(MusicPreset::MysteriousMagic, 1.0);
    }
    if game_state
        .timer_map
        .get_mut("music change timer")
        .unwrap()
        .tick(game_state.delta)
        .just_finished()
    {
        if game_state.bool_map.get("Music Changed!").is_none() {
            println!("Switching To Classy8Bit...Forever. Press ESC If You Want To Quit.");
            game_state.bool_map.insert("Music Changed!".into(), true);
            game_state
                .audio_manager
                .play_music(MusicPreset::Classy8Bit, 1.0);
        }
    }
}