use veebee::prelude::*;

const ORIGIN_LOCATION: (f32, f32) = (0.0, -200.0);

fn main() {
    let mut game = Game::new();

    let race_car = game.add_actor("Car", ActorPreset::Car);
    race_car.translation = Vec2::new(0.0, 0.0);
    race_car.rotation = UP;
    race_car.scale = 1.0;
    race_car.layer = 2.0;

    let mover = game.add_actor("move indicator", ActorPreset::Cone);
    mover.translation = ORIGIN_LOCATION.into();
    mover.layer = 1.0;

    let anchor = game.add_actor("move indicator origin", ActorPreset::Cone);
    anchor.translation = ORIGIN_LOCATION.into();
    anchor.layer = 0.0;

    let msg = game.add_text_actor("relative message", "Relative Mouse Motion Indicator");
    msg.translation.y = -300.0;
    msg.font_size = 20.0;

    let msg2 = game.add_text_actor(
        "instructions",
        "You Can Move The Car With Your Mouse.\nYou Can Rotate It By Clicking On Left/Right Buttons On The Mouse.\nAnd You Can Scale It With Your Mouse Wheel!.",
    );
    msg2.font_size = 30.0;
    msg2.translation.y = 300.0;

    game.run(logic);
}

fn logic(game_state: &mut GameState) {
    if let Some(actor) = game_state.actors.get_mut("Car") {

        for mouse_button_input in &game_state.mouse_button_events {
            if mouse_button_input.state != ElementState::Pressed {
                break;
            }
            match mouse_button_input.button {
                MouseButton::Left => actor.rotation += std::f32::consts::FRAC_PI_4,
                MouseButton::Right => actor.rotation -= std::f32::consts::FRAC_PI_4,
                _ => {}
            }
        }

        for cursor_moved in &game_state.mouse_location_events {
            actor.translation = cursor_moved.position;
        }

        for mouse_wheel in &game_state.mouse_wheel_events {
            actor.scale *= 1.0 + (0.05 * mouse_wheel.y);
            actor.scale = actor.scale.clamp(0.1, 4.0);
        }
    }

    if let Some(actor) = game_state.actors.get_mut("move indicator") {


        let mut cumulative_motion = Vec2::ZERO;
        for mouse_motion in &game_state.mouse_motion_events {
            cumulative_motion += mouse_motion.delta
        }

        if cumulative_motion != Vec2::ZERO {
            actor.translation = cumulative_motion + ORIGIN_LOCATION.into();
        }
    }
}