use veebee::prelude::*;

fn main() {
    let mut game = Game::new();

    //Btw, The Car Texture Is An Built In Texture For The VeeBee Game engine
    //I Know It's A Really Bad Image, By Me Btw...
    let mut race_car = game.add_actor("Car", ActorPreset::Car);
    race_car.translation = Vec2::new(0.0, 0.0);
    race_car.rotation = UP;
    race_car.scale = 1.0;

    let instructions = "Simple Keyboard Event With VeeBee\n==============================\nMove With: w a s d / arrows\nRotation: z c\n Scale: + -";
    let text = game.add_text_actor("instructions", instructions);
    text.translation.y = 250.0;

    game.run(logic);
}

fn logic(game_state: &mut GameState) {

    let race_car = game_state.actors.get_mut("Car").unwrap();


    for keyboard_event in &game_state.keyboard_events {
        if let KeyboardInput {
            scan_code: _,
            key_code: Some(key_code),
            state: ElementState::Pressed,
        } = keyboard_event
        {

            match key_code {
                KeyCode::A | KeyCode::Left => race_car.translation.x -= 10.0,
                KeyCode::D | KeyCode::Right | KeyCode::E => race_car.translation.x += 10.0,
                KeyCode::O | KeyCode::Down | KeyCode::S => race_car.translation.y -= 10.0,
                KeyCode::W | KeyCode::Up | KeyCode::Comma => race_car.translation.y += 10.0,
                KeyCode::Z | KeyCode::Semicolon => race_car.rotation += std::f32::consts::FRAC_PI_4,
                KeyCode::C | KeyCode::J => race_car.rotation -= std::f32::consts::FRAC_PI_4,
                KeyCode::Plus | KeyCode::Equals => race_car.scale *= 1.1,
                KeyCode::Minus | KeyCode::Underline => race_car.scale *= 0.9,
                _ => {}
            }


            race_car.scale = race_car.scale.clamp(0.1, 3.0);


            race_car.translation = race_car.translation.clamp(
                -game_state.screen_dimensions * 0.5,
                game_state.screen_dimensions * 0.5,
            );
        }
    }
}