#[allow(unused_imports)]
use criterion::{black_box, criterion_group, criterion_main, Criterion};

use vectora::types::vector::Vector;

fn access(v1: &Vector<f64, 10>, v2: &Vector<f64, 10>) {
    let _ = v1.midpoint(&v2);
}

fn criterion_benchmark(c: &mut Criterion) {
    let v1: Vector<f64, 10> = Vector::from([1.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0]);
    let v2: Vector<f64, 10> = Vector::from([2.0, 4.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0]);
    // let x = [2; 1000].to_vec();
    c.bench_function("access", |b| b.iter(|| access(&v1, &v2)));
}

criterion_group!(benches, criterion_benchmark);
criterion_main!(benches);
