use num_traits::{real::Real, Zero};
use std::{
    cmp::PartialOrd,
    ops::{Add, AddAssign, Div, DivAssign, Mul, MulAssign, Neg, Sub, SubAssign},
};

/// This trait specifies some type to be a vector type.
/// It specifies the scalar type and is required for other vector types.
pub trait VectorSpace: Copy + Zero + PartialEq
where
    Self: Add<Output = Self>,
    Self: Sub<Output = Self>,
    Self: Mul<<Self as VectorSpace>::Scalar, Output = Self>,
    Self: Div<<Self as VectorSpace>::Scalar, Output = Self>,
    Self: Neg<Output = Self>,
{
    /// The scalar type of the vector space.
    type Scalar: Real + PartialOrd;
}

impl VectorSpace for f32 {
    type Scalar = f32;
}
impl VectorSpace for f64 {
    type Scalar = f64;
}

/// This trait is automatically implemented for vector spaces, which also implement assignment operations.
pub trait VectorSpaceAssign:
    VectorSpace + AddAssign + SubAssign + MulAssign<Self::Scalar> + DivAssign<Self::Scalar>
{
}
impl<T> VectorSpaceAssign for T where
    T: VectorSpace + AddAssign + SubAssign + MulAssign<Self::Scalar> + DivAssign<Self::Scalar>
{
}
