#![deny(missing_docs)]
/*!
This crate contains new traits useful for working with vector spaces.
They have default implementations, so you can just implement them to get a lot of useful methods for free for your vector type.
But you can also just implement the methods yourself.

You can also define some library in terms of these traits instead of using a specific vector math implementation, so the user can choose, which one to use, or simply add multiple vector math libraries which implement these traits yourself by using this library.
**/

mod dot;
mod inner;
mod vector;

pub use dot::DotProduct;
pub use inner::InnerSpace;
pub use vector::VectorSpace;
