use crate::VectorSpace;

/// This trait defines the dot product.
pub trait DotProduct<T = Self>: VectorSpace {
    /// The output type of the dot product.
    type Output;

    /// Computes the dot product.
    fn dot(self, other: T) -> <Self as DotProduct<T>>::Output;
}

impl DotProduct for f32 {
    type Output = f32;
    fn dot(self, other: Self) -> f32 {
        self * other
    }
}

impl DotProduct for f64 {
    type Output = f64;
    fn dot(self, other: Self) -> f64 {
        self * other
    }
}
