use std::env::current_dir;
use std::fs::create_dir_all;

use cosmwasm_schema::{export_schema, remove_schemas, schema_for};

use valkyrie_qualifier::*;
use valkyrie_qualifier::execute_msgs::*;
use valkyrie_qualifier::query_msgs::*;

fn main() {
    let mut out_dir = current_dir().unwrap();
    out_dir.push("schema");
    create_dir_all(&out_dir).unwrap();
    remove_schemas(&out_dir).unwrap();

    export_schema(&schema_for!(QualifiedContinueOption), &out_dir);

    export_schema(&schema_for!(ExecuteMsg), &out_dir);

    export_schema(&schema_for!(QualificationMsg), &out_dir);
    export_schema(&schema_for!(QualificationResult), &out_dir);

    export_schema(&schema_for!(QueryMsg), &out_dir);
}