#![doc = "Peripheral access API for VA416XX microcontrollers (generated using svd2rust v0.20.0 (b9857c5 2021-12-10))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.20.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 4;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn U0();
    fn U1();
    fn U2();
    fn U3();
    fn U4();
    fn U5();
    fn U6();
    fn U7();
    fn U8();
    fn U9();
    fn U10();
    fn U11();
    fn U12();
    fn U13();
    fn U14();
    fn U15();
    fn SPI0_TX();
    fn SPI0_RX();
    fn SPI1_TX();
    fn SPI1_RX();
    fn SPI2_TX();
    fn SPI2_RX();
    fn SPI3_TX();
    fn SPI3_RX();
    fn UART0_TX();
    fn UART0_RX();
    fn UART1_TX();
    fn UART1_RX();
    fn UART2_TX();
    fn UART2_RX();
    fn I2C0_MS();
    fn I2C0_SL();
    fn I2C1_MS();
    fn I2C1_SL();
    fn I2C2_MS();
    fn I2C2_SL();
    fn ETHERNET();
    fn U37();
    fn SPW();
    fn U39();
    fn DAC0();
    fn DAC1();
    fn TRNG();
    fn DMA_ERROR();
    fn ADC();
    fn LOCLK();
    fn LVD();
    fn WATCHDOG();
    fn TIM0();
    fn TIM1();
    fn TIM2();
    fn TIM3();
    fn TIM4();
    fn TIM5();
    fn TIM6();
    fn TIM7();
    fn TIM8();
    fn TIM9();
    fn TIM10();
    fn TIM11();
    fn TIM12();
    fn TIM13();
    fn TIM14();
    fn TIM15();
    fn TIM16();
    fn TIM17();
    fn TIM18();
    fn TIM19();
    fn TIM20();
    fn TIM21();
    fn TIM22();
    fn TIM23();
    fn CAN0();
    fn U73();
    fn CAN1();
    fn U75();
    fn EDAC_MBE();
    fn EDAC_SBE();
    fn PORTA0();
    fn PORTA1();
    fn PORTA2();
    fn PORTA3();
    fn PORTA4();
    fn PORTA5();
    fn PORTA6();
    fn PORTA7();
    fn PORTA8();
    fn PORTA9();
    fn PORTA10();
    fn PORTA11();
    fn PORTA12();
    fn PORTA13();
    fn PORTA14();
    fn PORTA15();
    fn PORTB0();
    fn PORTB1();
    fn PORTB2();
    fn PORTB3();
    fn PORTB4();
    fn PORTB5();
    fn PORTB6();
    fn PORTB7();
    fn PORTB8();
    fn PORTB9();
    fn PORTB10();
    fn PORTB11();
    fn PORTB12();
    fn PORTB13();
    fn PORTB14();
    fn PORTB15();
    fn PORTC0();
    fn PORTC1();
    fn PORTC2();
    fn PORTC3();
    fn PORTC4();
    fn PORTC5();
    fn PORTC6();
    fn PORTC7();
    fn PORTC8();
    fn PORTC9();
    fn PORTC10();
    fn PORTC11();
    fn PORTC12();
    fn PORTC13();
    fn PORTC14();
    fn PORTC15();
    fn PORTD0();
    fn PORTD1();
    fn PORTD2();
    fn PORTD3();
    fn PORTD4();
    fn PORTD5();
    fn PORTD6();
    fn PORTD7();
    fn PORTD8();
    fn PORTD9();
    fn PORTD10();
    fn PORTD11();
    fn PORTD12();
    fn PORTD13();
    fn PORTD14();
    fn PORTD15();
    fn PORTE0();
    fn PORTE1();
    fn PORTE2();
    fn PORTE3();
    fn PORTE4();
    fn PORTE5();
    fn PORTE6();
    fn PORTE7();
    fn PORTE8();
    fn PORTE9();
    fn PORTE10();
    fn PORTE11();
    fn PORTE12();
    fn PORTE13();
    fn PORTE14();
    fn PORTE15();
    fn PORTF0();
    fn PORTF1();
    fn PORTF2();
    fn PORTF3();
    fn PORTF4();
    fn PORTF5();
    fn PORTF6();
    fn PORTF7();
    fn PORTF8();
    fn PORTF9();
    fn PORTF10();
    fn PORTF11();
    fn PORTF12();
    fn PORTF13();
    fn PORTF14();
    fn PORTF15();
    fn DMA_ACTIVE0();
    fn DMA_ACTIVE1();
    fn DMA_ACTIVE2();
    fn DMA_ACTIVE3();
    fn DMA_DONE0();
    fn DMA_DONE1();
    fn DMA_DONE2();
    fn DMA_DONE3();
    fn I2C0_MS_RX();
    fn I2C0_MS_TX();
    fn I2C0_SL_RX();
    fn I2C0_SL_TX();
    fn I2C1_MS_RX();
    fn I2C1_MS_TX();
    fn I2C1_SL_RX();
    fn I2C1_SL_TX();
    fn I2C2_MS_RX();
    fn I2C2_MS_TX();
    fn I2C2_SL_RX();
    fn I2C2_SL_TX();
    fn FPU();
    fn TXEV();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 196] = [
    Vector { _handler: U0 },
    Vector { _handler: U1 },
    Vector { _handler: U2 },
    Vector { _handler: U3 },
    Vector { _handler: U4 },
    Vector { _handler: U5 },
    Vector { _handler: U6 },
    Vector { _handler: U7 },
    Vector { _handler: U8 },
    Vector { _handler: U9 },
    Vector { _handler: U10 },
    Vector { _handler: U11 },
    Vector { _handler: U12 },
    Vector { _handler: U13 },
    Vector { _handler: U14 },
    Vector { _handler: U15 },
    Vector { _handler: SPI0_TX },
    Vector { _handler: SPI0_RX },
    Vector { _handler: SPI1_TX },
    Vector { _handler: SPI1_RX },
    Vector { _handler: SPI2_TX },
    Vector { _handler: SPI2_RX },
    Vector { _handler: SPI3_TX },
    Vector { _handler: SPI3_RX },
    Vector { _handler: UART0_TX },
    Vector { _handler: UART0_RX },
    Vector { _handler: UART1_TX },
    Vector { _handler: UART1_RX },
    Vector { _handler: UART2_TX },
    Vector { _handler: UART2_RX },
    Vector { _handler: I2C0_MS },
    Vector { _handler: I2C0_SL },
    Vector { _handler: I2C1_MS },
    Vector { _handler: I2C1_SL },
    Vector { _handler: I2C2_MS },
    Vector { _handler: I2C2_SL },
    Vector { _handler: ETHERNET },
    Vector { _handler: U37 },
    Vector { _handler: SPW },
    Vector { _handler: U39 },
    Vector { _handler: DAC0 },
    Vector { _handler: DAC1 },
    Vector { _handler: TRNG },
    Vector {
        _handler: DMA_ERROR,
    },
    Vector { _handler: ADC },
    Vector { _handler: LOCLK },
    Vector { _handler: LVD },
    Vector { _handler: WATCHDOG },
    Vector { _handler: TIM0 },
    Vector { _handler: TIM1 },
    Vector { _handler: TIM2 },
    Vector { _handler: TIM3 },
    Vector { _handler: TIM4 },
    Vector { _handler: TIM5 },
    Vector { _handler: TIM6 },
    Vector { _handler: TIM7 },
    Vector { _handler: TIM8 },
    Vector { _handler: TIM9 },
    Vector { _handler: TIM10 },
    Vector { _handler: TIM11 },
    Vector { _handler: TIM12 },
    Vector { _handler: TIM13 },
    Vector { _handler: TIM14 },
    Vector { _handler: TIM15 },
    Vector { _handler: TIM16 },
    Vector { _handler: TIM17 },
    Vector { _handler: TIM18 },
    Vector { _handler: TIM19 },
    Vector { _handler: TIM20 },
    Vector { _handler: TIM21 },
    Vector { _handler: TIM22 },
    Vector { _handler: TIM23 },
    Vector { _handler: CAN0 },
    Vector { _handler: U73 },
    Vector { _handler: CAN1 },
    Vector { _handler: U75 },
    Vector { _handler: EDAC_MBE },
    Vector { _handler: EDAC_SBE },
    Vector { _handler: PORTA0 },
    Vector { _handler: PORTA1 },
    Vector { _handler: PORTA2 },
    Vector { _handler: PORTA3 },
    Vector { _handler: PORTA4 },
    Vector { _handler: PORTA5 },
    Vector { _handler: PORTA6 },
    Vector { _handler: PORTA7 },
    Vector { _handler: PORTA8 },
    Vector { _handler: PORTA9 },
    Vector { _handler: PORTA10 },
    Vector { _handler: PORTA11 },
    Vector { _handler: PORTA12 },
    Vector { _handler: PORTA13 },
    Vector { _handler: PORTA14 },
    Vector { _handler: PORTA15 },
    Vector { _handler: PORTB0 },
    Vector { _handler: PORTB1 },
    Vector { _handler: PORTB2 },
    Vector { _handler: PORTB3 },
    Vector { _handler: PORTB4 },
    Vector { _handler: PORTB5 },
    Vector { _handler: PORTB6 },
    Vector { _handler: PORTB7 },
    Vector { _handler: PORTB8 },
    Vector { _handler: PORTB9 },
    Vector { _handler: PORTB10 },
    Vector { _handler: PORTB11 },
    Vector { _handler: PORTB12 },
    Vector { _handler: PORTB13 },
    Vector { _handler: PORTB14 },
    Vector { _handler: PORTB15 },
    Vector { _handler: PORTC0 },
    Vector { _handler: PORTC1 },
    Vector { _handler: PORTC2 },
    Vector { _handler: PORTC3 },
    Vector { _handler: PORTC4 },
    Vector { _handler: PORTC5 },
    Vector { _handler: PORTC6 },
    Vector { _handler: PORTC7 },
    Vector { _handler: PORTC8 },
    Vector { _handler: PORTC9 },
    Vector { _handler: PORTC10 },
    Vector { _handler: PORTC11 },
    Vector { _handler: PORTC12 },
    Vector { _handler: PORTC13 },
    Vector { _handler: PORTC14 },
    Vector { _handler: PORTC15 },
    Vector { _handler: PORTD0 },
    Vector { _handler: PORTD1 },
    Vector { _handler: PORTD2 },
    Vector { _handler: PORTD3 },
    Vector { _handler: PORTD4 },
    Vector { _handler: PORTD5 },
    Vector { _handler: PORTD6 },
    Vector { _handler: PORTD7 },
    Vector { _handler: PORTD8 },
    Vector { _handler: PORTD9 },
    Vector { _handler: PORTD10 },
    Vector { _handler: PORTD11 },
    Vector { _handler: PORTD12 },
    Vector { _handler: PORTD13 },
    Vector { _handler: PORTD14 },
    Vector { _handler: PORTD15 },
    Vector { _handler: PORTE0 },
    Vector { _handler: PORTE1 },
    Vector { _handler: PORTE2 },
    Vector { _handler: PORTE3 },
    Vector { _handler: PORTE4 },
    Vector { _handler: PORTE5 },
    Vector { _handler: PORTE6 },
    Vector { _handler: PORTE7 },
    Vector { _handler: PORTE8 },
    Vector { _handler: PORTE9 },
    Vector { _handler: PORTE10 },
    Vector { _handler: PORTE11 },
    Vector { _handler: PORTE12 },
    Vector { _handler: PORTE13 },
    Vector { _handler: PORTE14 },
    Vector { _handler: PORTE15 },
    Vector { _handler: PORTF0 },
    Vector { _handler: PORTF1 },
    Vector { _handler: PORTF2 },
    Vector { _handler: PORTF3 },
    Vector { _handler: PORTF4 },
    Vector { _handler: PORTF5 },
    Vector { _handler: PORTF6 },
    Vector { _handler: PORTF7 },
    Vector { _handler: PORTF8 },
    Vector { _handler: PORTF9 },
    Vector { _handler: PORTF10 },
    Vector { _handler: PORTF11 },
    Vector { _handler: PORTF12 },
    Vector { _handler: PORTF13 },
    Vector { _handler: PORTF14 },
    Vector { _handler: PORTF15 },
    Vector {
        _handler: DMA_ACTIVE0,
    },
    Vector {
        _handler: DMA_ACTIVE1,
    },
    Vector {
        _handler: DMA_ACTIVE2,
    },
    Vector {
        _handler: DMA_ACTIVE3,
    },
    Vector {
        _handler: DMA_DONE0,
    },
    Vector {
        _handler: DMA_DONE1,
    },
    Vector {
        _handler: DMA_DONE2,
    },
    Vector {
        _handler: DMA_DONE3,
    },
    Vector {
        _handler: I2C0_MS_RX,
    },
    Vector {
        _handler: I2C0_MS_TX,
    },
    Vector {
        _handler: I2C0_SL_RX,
    },
    Vector {
        _handler: I2C0_SL_TX,
    },
    Vector {
        _handler: I2C1_MS_RX,
    },
    Vector {
        _handler: I2C1_MS_TX,
    },
    Vector {
        _handler: I2C1_SL_RX,
    },
    Vector {
        _handler: I2C1_SL_TX,
    },
    Vector {
        _handler: I2C2_MS_RX,
    },
    Vector {
        _handler: I2C2_MS_TX,
    },
    Vector {
        _handler: I2C2_SL_RX,
    },
    Vector {
        _handler: I2C2_SL_TX,
    },
    Vector { _handler: FPU },
    Vector { _handler: TXEV },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - U0"]
    U0 = 0,
    #[doc = "1 - U1"]
    U1 = 1,
    #[doc = "2 - U2"]
    U2 = 2,
    #[doc = "3 - U3"]
    U3 = 3,
    #[doc = "4 - U4"]
    U4 = 4,
    #[doc = "5 - U5"]
    U5 = 5,
    #[doc = "6 - U6"]
    U6 = 6,
    #[doc = "7 - U7"]
    U7 = 7,
    #[doc = "8 - U8"]
    U8 = 8,
    #[doc = "9 - U9"]
    U9 = 9,
    #[doc = "10 - U10"]
    U10 = 10,
    #[doc = "11 - U11"]
    U11 = 11,
    #[doc = "12 - U12"]
    U12 = 12,
    #[doc = "13 - U13"]
    U13 = 13,
    #[doc = "14 - U14"]
    U14 = 14,
    #[doc = "15 - U15"]
    U15 = 15,
    #[doc = "16 - SPI0_TX"]
    SPI0_TX = 16,
    #[doc = "17 - SPI0_RX"]
    SPI0_RX = 17,
    #[doc = "18 - SPI1_TX"]
    SPI1_TX = 18,
    #[doc = "19 - SPI1_RX"]
    SPI1_RX = 19,
    #[doc = "20 - SPI2_TX"]
    SPI2_TX = 20,
    #[doc = "21 - SPI2_RX"]
    SPI2_RX = 21,
    #[doc = "22 - SPI3_TX"]
    SPI3_TX = 22,
    #[doc = "23 - SPI3_RX"]
    SPI3_RX = 23,
    #[doc = "24 - UART0_TX"]
    UART0_TX = 24,
    #[doc = "25 - UART0_RX"]
    UART0_RX = 25,
    #[doc = "26 - UART1_TX"]
    UART1_TX = 26,
    #[doc = "27 - UART1_RX"]
    UART1_RX = 27,
    #[doc = "28 - UART2_TX"]
    UART2_TX = 28,
    #[doc = "29 - UART2_RX"]
    UART2_RX = 29,
    #[doc = "30 - I2C0_MS"]
    I2C0_MS = 30,
    #[doc = "31 - I2C0_SL"]
    I2C0_SL = 31,
    #[doc = "32 - I2C1_MS"]
    I2C1_MS = 32,
    #[doc = "33 - I2C1_SL"]
    I2C1_SL = 33,
    #[doc = "34 - I2C2_MS"]
    I2C2_MS = 34,
    #[doc = "35 - I2C2_SL"]
    I2C2_SL = 35,
    #[doc = "36 - Ethernet"]
    ETHERNET = 36,
    #[doc = "37 - U37"]
    U37 = 37,
    #[doc = "38 - SpW"]
    SPW = 38,
    #[doc = "39 - U39"]
    U39 = 39,
    #[doc = "40 - DAC0"]
    DAC0 = 40,
    #[doc = "41 - DAC1"]
    DAC1 = 41,
    #[doc = "42 - TRNG"]
    TRNG = 42,
    #[doc = "43 - DMA_ERROR"]
    DMA_ERROR = 43,
    #[doc = "44 - ADC"]
    ADC = 44,
    #[doc = "45 - LoCLK"]
    LOCLK = 45,
    #[doc = "46 - LVD"]
    LVD = 46,
    #[doc = "47 - WATCHDOG"]
    WATCHDOG = 47,
    #[doc = "48 - TIM0"]
    TIM0 = 48,
    #[doc = "49 - TIM1"]
    TIM1 = 49,
    #[doc = "50 - TIM2"]
    TIM2 = 50,
    #[doc = "51 - TIM3"]
    TIM3 = 51,
    #[doc = "52 - TIM4"]
    TIM4 = 52,
    #[doc = "53 - TIM5"]
    TIM5 = 53,
    #[doc = "54 - TIM6"]
    TIM6 = 54,
    #[doc = "55 - TIM7"]
    TIM7 = 55,
    #[doc = "56 - TIM8"]
    TIM8 = 56,
    #[doc = "57 - TIM9"]
    TIM9 = 57,
    #[doc = "58 - TIM10"]
    TIM10 = 58,
    #[doc = "59 - TIM11"]
    TIM11 = 59,
    #[doc = "60 - TIM12"]
    TIM12 = 60,
    #[doc = "61 - TIM13"]
    TIM13 = 61,
    #[doc = "62 - TIM14"]
    TIM14 = 62,
    #[doc = "63 - TIM15"]
    TIM15 = 63,
    #[doc = "64 - TIM16"]
    TIM16 = 64,
    #[doc = "65 - TIM17"]
    TIM17 = 65,
    #[doc = "66 - TIM18"]
    TIM18 = 66,
    #[doc = "67 - TIM19"]
    TIM19 = 67,
    #[doc = "68 - TIM20"]
    TIM20 = 68,
    #[doc = "69 - TIM21"]
    TIM21 = 69,
    #[doc = "70 - TIM22"]
    TIM22 = 70,
    #[doc = "71 - TIM23"]
    TIM23 = 71,
    #[doc = "72 - CAN0"]
    CAN0 = 72,
    #[doc = "73 - U73"]
    U73 = 73,
    #[doc = "74 - CAN1"]
    CAN1 = 74,
    #[doc = "75 - U75"]
    U75 = 75,
    #[doc = "76 - EDAC_MBE"]
    EDAC_MBE = 76,
    #[doc = "77 - EDAC_SBE"]
    EDAC_SBE = 77,
    #[doc = "78 - PORTA0"]
    PORTA0 = 78,
    #[doc = "79 - PORTA1"]
    PORTA1 = 79,
    #[doc = "80 - PORTA2"]
    PORTA2 = 80,
    #[doc = "81 - PORTA3"]
    PORTA3 = 81,
    #[doc = "82 - PORTA4"]
    PORTA4 = 82,
    #[doc = "83 - PORTA5"]
    PORTA5 = 83,
    #[doc = "84 - PORTA6"]
    PORTA6 = 84,
    #[doc = "85 - PORTA7"]
    PORTA7 = 85,
    #[doc = "86 - PORTA8"]
    PORTA8 = 86,
    #[doc = "87 - PORTA9"]
    PORTA9 = 87,
    #[doc = "88 - PORTA10"]
    PORTA10 = 88,
    #[doc = "89 - PORTA11"]
    PORTA11 = 89,
    #[doc = "90 - PORTA12"]
    PORTA12 = 90,
    #[doc = "91 - PORTA13"]
    PORTA13 = 91,
    #[doc = "92 - PORTA14"]
    PORTA14 = 92,
    #[doc = "93 - PORTA15"]
    PORTA15 = 93,
    #[doc = "94 - PORTB0"]
    PORTB0 = 94,
    #[doc = "95 - PORTB1"]
    PORTB1 = 95,
    #[doc = "96 - PORTB2"]
    PORTB2 = 96,
    #[doc = "97 - PORTB3"]
    PORTB3 = 97,
    #[doc = "98 - PORTB4"]
    PORTB4 = 98,
    #[doc = "99 - PORTB5"]
    PORTB5 = 99,
    #[doc = "100 - PORTB6"]
    PORTB6 = 100,
    #[doc = "101 - PORTB7"]
    PORTB7 = 101,
    #[doc = "102 - PORTB8"]
    PORTB8 = 102,
    #[doc = "103 - PORTB9"]
    PORTB9 = 103,
    #[doc = "104 - PORTB10"]
    PORTB10 = 104,
    #[doc = "105 - PORTB11"]
    PORTB11 = 105,
    #[doc = "106 - PORTB12"]
    PORTB12 = 106,
    #[doc = "107 - PORTB13"]
    PORTB13 = 107,
    #[doc = "108 - PORTB14"]
    PORTB14 = 108,
    #[doc = "109 - PORTB15"]
    PORTB15 = 109,
    #[doc = "110 - PORTC0"]
    PORTC0 = 110,
    #[doc = "111 - PORTC1"]
    PORTC1 = 111,
    #[doc = "112 - PORTC2"]
    PORTC2 = 112,
    #[doc = "113 - PORTC3"]
    PORTC3 = 113,
    #[doc = "114 - PORTC4"]
    PORTC4 = 114,
    #[doc = "115 - PORTC5"]
    PORTC5 = 115,
    #[doc = "116 - PORTC6"]
    PORTC6 = 116,
    #[doc = "117 - PORTC7"]
    PORTC7 = 117,
    #[doc = "118 - PORTC8"]
    PORTC8 = 118,
    #[doc = "119 - PORTC9"]
    PORTC9 = 119,
    #[doc = "120 - PORTC10"]
    PORTC10 = 120,
    #[doc = "121 - PORTC11"]
    PORTC11 = 121,
    #[doc = "122 - PORTC12"]
    PORTC12 = 122,
    #[doc = "123 - PORTC13"]
    PORTC13 = 123,
    #[doc = "124 - PORTC14"]
    PORTC14 = 124,
    #[doc = "125 - PORTC15"]
    PORTC15 = 125,
    #[doc = "126 - PORTD0"]
    PORTD0 = 126,
    #[doc = "127 - PORTD1"]
    PORTD1 = 127,
    #[doc = "128 - PORTD2"]
    PORTD2 = 128,
    #[doc = "129 - PORTD3"]
    PORTD3 = 129,
    #[doc = "130 - PORTD4"]
    PORTD4 = 130,
    #[doc = "131 - PORTD5"]
    PORTD5 = 131,
    #[doc = "132 - PORTD6"]
    PORTD6 = 132,
    #[doc = "133 - PORTD7"]
    PORTD7 = 133,
    #[doc = "134 - PORTD8"]
    PORTD8 = 134,
    #[doc = "135 - PORTD9"]
    PORTD9 = 135,
    #[doc = "136 - PORTD10"]
    PORTD10 = 136,
    #[doc = "137 - PORTD11"]
    PORTD11 = 137,
    #[doc = "138 - PORTD12"]
    PORTD12 = 138,
    #[doc = "139 - PORTD13"]
    PORTD13 = 139,
    #[doc = "140 - PORTD14"]
    PORTD14 = 140,
    #[doc = "141 - PORTD15"]
    PORTD15 = 141,
    #[doc = "142 - PORTE0"]
    PORTE0 = 142,
    #[doc = "143 - PORTE1"]
    PORTE1 = 143,
    #[doc = "144 - PORTE2"]
    PORTE2 = 144,
    #[doc = "145 - PORTE3"]
    PORTE3 = 145,
    #[doc = "146 - PORTE4"]
    PORTE4 = 146,
    #[doc = "147 - PORTE5"]
    PORTE5 = 147,
    #[doc = "148 - PORTE6"]
    PORTE6 = 148,
    #[doc = "149 - PORTE7"]
    PORTE7 = 149,
    #[doc = "150 - PORTE8"]
    PORTE8 = 150,
    #[doc = "151 - PORTE9"]
    PORTE9 = 151,
    #[doc = "152 - PORTE10"]
    PORTE10 = 152,
    #[doc = "153 - PORTE11"]
    PORTE11 = 153,
    #[doc = "154 - PORTE12"]
    PORTE12 = 154,
    #[doc = "155 - PORTE13"]
    PORTE13 = 155,
    #[doc = "156 - PORTE14"]
    PORTE14 = 156,
    #[doc = "157 - PORTE15"]
    PORTE15 = 157,
    #[doc = "158 - PORTF0"]
    PORTF0 = 158,
    #[doc = "159 - PORTF1"]
    PORTF1 = 159,
    #[doc = "160 - PORTF2"]
    PORTF2 = 160,
    #[doc = "161 - PORTF3"]
    PORTF3 = 161,
    #[doc = "162 - PORTF4"]
    PORTF4 = 162,
    #[doc = "163 - PORTF5"]
    PORTF5 = 163,
    #[doc = "164 - PORTF6"]
    PORTF6 = 164,
    #[doc = "165 - PORTF7"]
    PORTF7 = 165,
    #[doc = "166 - PORTF8"]
    PORTF8 = 166,
    #[doc = "167 - PORTF9"]
    PORTF9 = 167,
    #[doc = "168 - PORTF10"]
    PORTF10 = 168,
    #[doc = "169 - PORTF11"]
    PORTF11 = 169,
    #[doc = "170 - PORTF12"]
    PORTF12 = 170,
    #[doc = "171 - PORTF13"]
    PORTF13 = 171,
    #[doc = "172 - PORTF14"]
    PORTF14 = 172,
    #[doc = "173 - PORTF15"]
    PORTF15 = 173,
    #[doc = "174 - DMA_ACTIVE0"]
    DMA_ACTIVE0 = 174,
    #[doc = "175 - DMA_ACTIVE1"]
    DMA_ACTIVE1 = 175,
    #[doc = "176 - DMA_ACTIVE2"]
    DMA_ACTIVE2 = 176,
    #[doc = "177 - DMA_ACTIVE3"]
    DMA_ACTIVE3 = 177,
    #[doc = "178 - DMA_DONE0"]
    DMA_DONE0 = 178,
    #[doc = "179 - DMA_DONE1"]
    DMA_DONE1 = 179,
    #[doc = "180 - DMA_DONE2"]
    DMA_DONE2 = 180,
    #[doc = "181 - DMA_DONE3"]
    DMA_DONE3 = 181,
    #[doc = "182 - I2C0_MS_RX"]
    I2C0_MS_RX = 182,
    #[doc = "183 - I2C0_MS_TX"]
    I2C0_MS_TX = 183,
    #[doc = "184 - I2C0_SL_RX"]
    I2C0_SL_RX = 184,
    #[doc = "185 - I2C0_SL_TX"]
    I2C0_SL_TX = 185,
    #[doc = "186 - I2C1_MS_RX"]
    I2C1_MS_RX = 186,
    #[doc = "187 - I2C1_MS_TX"]
    I2C1_MS_TX = 187,
    #[doc = "188 - I2C1_SL_RX"]
    I2C1_SL_RX = 188,
    #[doc = "189 - I2C1_SL_TX"]
    I2C1_SL_TX = 189,
    #[doc = "190 - I2C2_MS_RX"]
    I2C2_MS_RX = 190,
    #[doc = "191 - I2C2_MS_TX"]
    I2C2_MS_TX = 191,
    #[doc = "192 - I2C2_SL_RX"]
    I2C2_SL_RX = 192,
    #[doc = "193 - I2C2_SL_TX"]
    I2C2_SL_TX = 193,
    #[doc = "194 - FPU"]
    FPU = 194,
    #[doc = "195 - TXEV"]
    TXEV = 195,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = "Clock Generation Peripheral"]
pub struct CLKGEN {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CLKGEN {}
impl CLKGEN {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const clkgen::RegisterBlock = 0x4000_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const clkgen::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CLKGEN {
    type Target = clkgen::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CLKGEN {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CLKGEN").finish()
    }
}
#[doc = "Clock Generation Peripheral"]
pub mod clkgen;
#[doc = "System Configuration Peripheral"]
pub struct SYSCONFIG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSCONFIG {}
impl SYSCONFIG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sysconfig::RegisterBlock = 0x4001_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sysconfig::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSCONFIG {
    type Target = sysconfig::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSCONFIG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSCONFIG").finish()
    }
}
#[doc = "System Configuration Peripheral"]
pub mod sysconfig;
#[doc = "DMA Controller Block"]
pub struct DMA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA {}
impl DMA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dma::RegisterBlock = 0x4000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dma::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMA {
    type Target = dma::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMA").finish()
    }
}
#[doc = "DMA Controller Block"]
pub mod dma;
#[doc = "IO Pin Configuration Peripheral"]
pub struct IOCONFIG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IOCONFIG {}
impl IOCONFIG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ioconfig::RegisterBlock = 0x4001_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ioconfig::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IOCONFIG {
    type Target = ioconfig::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IOCONFIG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IOCONFIG").finish()
    }
}
#[doc = "IO Pin Configuration Peripheral"]
pub mod ioconfig;
#[doc = "Utility Peripheral"]
pub struct UTILITY {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UTILITY {}
impl UTILITY {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const utility::RegisterBlock = 0x4002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const utility::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UTILITY {
    type Target = utility::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UTILITY {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UTILITY").finish()
    }
}
#[doc = "Utility Peripheral"]
pub mod utility;
#[doc = "GPIO Peripheral"]
pub struct PORTA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTA {}
impl PORTA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x4001_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTA {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTA").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub mod porta;
#[doc = "GPIO Peripheral"]
pub struct PORTB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTB {}
impl PORTB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x4001_2400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTB {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTB").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub use porta as portb;
#[doc = "GPIO Peripheral"]
pub struct PORTC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTC {}
impl PORTC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x4001_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTC {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTC").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub use porta as portc;
#[doc = "GPIO Peripheral"]
pub struct PORTD {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTD {}
impl PORTD {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x4001_2c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTD {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTD {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTD").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub use porta as portd;
#[doc = "GPIO Peripheral"]
pub struct PORTE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTE {}
impl PORTE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x4001_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTE {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTE").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub use porta as porte;
#[doc = "GPIO Peripheral"]
pub struct PORTF {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTF {}
impl PORTF {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x4001_3400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTF {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTF {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTF").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub use porta as portf;
#[doc = "GPIO Peripheral"]
pub struct PORTG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTG {}
impl PORTG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x4001_3800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTG {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTG").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub use porta as portg;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM0 {}
impl TIM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM0 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM0").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub mod tim0;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM1 {}
impl TIM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_8400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM1 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM1").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim1;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM2 {}
impl TIM2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_8800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM2 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM2").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim2;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM3 {}
impl TIM3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_8c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM3 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM3").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim3;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM4 {}
impl TIM4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM4 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM4").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim4;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM5 {}
impl TIM5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_9400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM5 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM5").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim5;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM6 {}
impl TIM6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_9800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM6 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM6").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim6;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM7 {}
impl TIM7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_9c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM7 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM7").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim7;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM8 {}
impl TIM8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM8 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM8").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim8;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM9 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM9 {}
impl TIM9 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_a400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM9 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM9 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM9").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim9;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM10 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM10 {}
impl TIM10 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_a800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM10 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM10 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM10").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim10;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM11 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM11 {}
impl TIM11 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_ac00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM11 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM11 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM11").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim11;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM12 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM12 {}
impl TIM12 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM12 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM12 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM12").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim12;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM13 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM13 {}
impl TIM13 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_b400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM13 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM13 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM13").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim13;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM14 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM14 {}
impl TIM14 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_b800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM14 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM14 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM14").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim14;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM15 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM15 {}
impl TIM15 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4001_bc00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM15 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM15 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM15").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim15;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM16 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM16 {}
impl TIM16 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM16 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM16 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM16").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim16;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM17 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM17 {}
impl TIM17 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_8400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM17 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM17 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM17").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim17;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM18 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM18 {}
impl TIM18 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_8800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM18 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM18 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM18").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim18;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM19 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM19 {}
impl TIM19 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_8c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM19 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM19 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM19").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim19;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM20 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM20 {}
impl TIM20 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM20 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM20 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM20").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim20;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM21 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM21 {}
impl TIM21 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_9400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM21 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM21 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM21").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim21;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM22 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM22 {}
impl TIM22 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_9800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM22 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM22 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM22").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim22;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM23 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM23 {}
impl TIM23 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_9c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM23 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM23 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM23").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim23;
#[doc = "UART Peripheral"]
pub struct UART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART0 {}
impl UART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4002_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART0 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART0").finish()
    }
}
#[doc = "UART Peripheral"]
pub mod uart0;
#[doc = "UART Peripheral"]
pub struct UART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART1 {}
impl UART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4002_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART1 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART1").finish()
    }
}
#[doc = "UART Peripheral"]
pub use uart0 as uart1;
#[doc = "UART Peripheral"]
pub struct UART2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART2 {}
impl UART2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x4001_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART2 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART2").finish()
    }
}
#[doc = "UART Peripheral"]
pub use uart0 as uart2;
#[doc = "SPI Peripheral"]
pub struct SPI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI0 {}
impl SPI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4001_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI0 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI0").finish()
    }
}
#[doc = "SPI Peripheral"]
pub mod spi0;
#[doc = "SPI Peripheral"]
pub struct SPI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI1 {}
impl SPI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4001_5400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI1 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI1").finish()
    }
}
#[doc = "SPI Peripheral"]
pub use spi0 as spi1;
#[doc = "SPI Peripheral"]
pub struct SPI2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI2 {}
impl SPI2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4001_5800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI2 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI2").finish()
    }
}
#[doc = "SPI Peripheral"]
pub use spi0 as spi2;
#[doc = "SPI Peripheral"]
pub struct SPI3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI3 {}
impl SPI3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x4001_5c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI3 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI3").finish()
    }
}
#[doc = "SPI Peripheral"]
pub use spi0 as spi3;
#[doc = "I2C Peripheral"]
pub struct I2C0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C0 {}
impl I2C0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4001_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C0 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C0").finish()
    }
}
#[doc = "I2C Peripheral"]
pub mod i2c0;
#[doc = "I2C Peripheral"]
pub struct I2C1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C1 {}
impl I2C1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4001_6400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C1 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C1").finish()
    }
}
#[doc = "I2C Peripheral"]
pub use i2c0 as i2c1;
#[doc = "I2C Peripheral"]
pub struct I2C2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C2 {}
impl I2C2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x4001_6800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C2 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C2").finish()
    }
}
#[doc = "I2C Peripheral"]
pub use i2c0 as i2c2;
#[doc = "CAN Peripheral"]
pub struct CAN0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CAN0 {}
impl CAN0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const can0::RegisterBlock = 0x4001_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const can0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CAN0 {
    type Target = can0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CAN0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CAN0").finish()
    }
}
#[doc = "CAN Peripheral"]
pub mod can0;
#[doc = "CAN Peripheral"]
pub struct CAN1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CAN1 {}
impl CAN1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const can0::RegisterBlock = 0x4001_4400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const can0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CAN1 {
    type Target = can0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CAN1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CAN1").finish()
    }
}
#[doc = "CAN Peripheral"]
pub use can0 as can1;
#[doc = "Analog to Digital Converter Peripheral"]
pub struct ADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADC {}
impl ADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adc::RegisterBlock = 0x4002_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADC {
    type Target = adc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADC").finish()
    }
}
#[doc = "Analog to Digital Converter Peripheral"]
pub mod adc;
#[doc = "Digital to Analog Converter Peripheral"]
pub struct DAC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DAC0 {}
impl DAC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dac0::RegisterBlock = 0x4002_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dac0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DAC0 {
    type Target = dac0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DAC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DAC0").finish()
    }
}
#[doc = "Digital to Analog Converter Peripheral"]
pub mod dac0;
#[doc = "Digital to Analog Converter Peripheral"]
pub struct DAC1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DAC1 {}
impl DAC1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dac0::RegisterBlock = 0x4002_3800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dac0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DAC1 {
    type Target = dac0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DAC1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DAC1").finish()
    }
}
#[doc = "Digital to Analog Converter Peripheral"]
pub use dac0 as dac1;
#[doc = "SpaceWire Peripheral"]
pub struct SPW {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPW {}
impl SPW {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spw::RegisterBlock = 0x4000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spw::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPW {
    type Target = spw::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPW {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPW").finish()
    }
}
#[doc = "SpaceWire Peripheral"]
pub mod spw;
#[doc = "Interrupt Router Peripheral"]
pub struct IRQ_ROUTER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IRQ_ROUTER {}
impl IRQ_ROUTER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const irq_router::RegisterBlock = 0x4000_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const irq_router::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IRQ_ROUTER {
    type Target = irq_router::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IRQ_ROUTER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IRQ_ROUTER").finish()
    }
}
#[doc = "Interrupt Router Peripheral"]
pub mod irq_router;
#[doc = "Watchdog Block Peripheral"]
pub struct WATCH_DOG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WATCH_DOG {}
impl WATCH_DOG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const watch_dog::RegisterBlock = 0x4002_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const watch_dog::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WATCH_DOG {
    type Target = watch_dog::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WATCH_DOG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WATCH_DOG").finish()
    }
}
#[doc = "Watchdog Block Peripheral"]
pub mod watch_dog;
#[doc = "True Random Number Generator"]
pub struct TRNG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TRNG {}
impl TRNG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const trng::RegisterBlock = 0x4002_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const trng::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TRNG {
    type Target = trng::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TRNG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TRNG").finish()
    }
}
#[doc = "True Random Number Generator"]
pub mod trng;
#[doc = "Ethernet Block"]
pub struct ETH {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ETH {}
impl ETH {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const eth::RegisterBlock = 0x4000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const eth::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ETH {
    type Target = eth::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ETH {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ETH").finish()
    }
}
#[doc = "Ethernet Block"]
pub mod eth;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "CLKGEN"]
    pub CLKGEN: CLKGEN,
    #[doc = "SYSCONFIG"]
    pub SYSCONFIG: SYSCONFIG,
    #[doc = "DMA"]
    pub DMA: DMA,
    #[doc = "IOCONFIG"]
    pub IOCONFIG: IOCONFIG,
    #[doc = "UTILITY"]
    pub UTILITY: UTILITY,
    #[doc = "PORTA"]
    pub PORTA: PORTA,
    #[doc = "PORTB"]
    pub PORTB: PORTB,
    #[doc = "PORTC"]
    pub PORTC: PORTC,
    #[doc = "PORTD"]
    pub PORTD: PORTD,
    #[doc = "PORTE"]
    pub PORTE: PORTE,
    #[doc = "PORTF"]
    pub PORTF: PORTF,
    #[doc = "PORTG"]
    pub PORTG: PORTG,
    #[doc = "TIM0"]
    pub TIM0: TIM0,
    #[doc = "TIM1"]
    pub TIM1: TIM1,
    #[doc = "TIM2"]
    pub TIM2: TIM2,
    #[doc = "TIM3"]
    pub TIM3: TIM3,
    #[doc = "TIM4"]
    pub TIM4: TIM4,
    #[doc = "TIM5"]
    pub TIM5: TIM5,
    #[doc = "TIM6"]
    pub TIM6: TIM6,
    #[doc = "TIM7"]
    pub TIM7: TIM7,
    #[doc = "TIM8"]
    pub TIM8: TIM8,
    #[doc = "TIM9"]
    pub TIM9: TIM9,
    #[doc = "TIM10"]
    pub TIM10: TIM10,
    #[doc = "TIM11"]
    pub TIM11: TIM11,
    #[doc = "TIM12"]
    pub TIM12: TIM12,
    #[doc = "TIM13"]
    pub TIM13: TIM13,
    #[doc = "TIM14"]
    pub TIM14: TIM14,
    #[doc = "TIM15"]
    pub TIM15: TIM15,
    #[doc = "TIM16"]
    pub TIM16: TIM16,
    #[doc = "TIM17"]
    pub TIM17: TIM17,
    #[doc = "TIM18"]
    pub TIM18: TIM18,
    #[doc = "TIM19"]
    pub TIM19: TIM19,
    #[doc = "TIM20"]
    pub TIM20: TIM20,
    #[doc = "TIM21"]
    pub TIM21: TIM21,
    #[doc = "TIM22"]
    pub TIM22: TIM22,
    #[doc = "TIM23"]
    pub TIM23: TIM23,
    #[doc = "UART0"]
    pub UART0: UART0,
    #[doc = "UART1"]
    pub UART1: UART1,
    #[doc = "UART2"]
    pub UART2: UART2,
    #[doc = "SPI0"]
    pub SPI0: SPI0,
    #[doc = "SPI1"]
    pub SPI1: SPI1,
    #[doc = "SPI2"]
    pub SPI2: SPI2,
    #[doc = "SPI3"]
    pub SPI3: SPI3,
    #[doc = "I2C0"]
    pub I2C0: I2C0,
    #[doc = "I2C1"]
    pub I2C1: I2C1,
    #[doc = "I2C2"]
    pub I2C2: I2C2,
    #[doc = "CAN0"]
    pub CAN0: CAN0,
    #[doc = "CAN1"]
    pub CAN1: CAN1,
    #[doc = "ADC"]
    pub ADC: ADC,
    #[doc = "DAC0"]
    pub DAC0: DAC0,
    #[doc = "DAC1"]
    pub DAC1: DAC1,
    #[doc = "SPW"]
    pub SPW: SPW,
    #[doc = "IRQ_ROUTER"]
    pub IRQ_ROUTER: IRQ_ROUTER,
    #[doc = "WATCH_DOG"]
    pub WATCH_DOG: WATCH_DOG,
    #[doc = "TRNG"]
    pub TRNG: TRNG,
    #[doc = "ETH"]
    pub ETH: ETH,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            CLKGEN: CLKGEN {
                _marker: PhantomData,
            },
            SYSCONFIG: SYSCONFIG {
                _marker: PhantomData,
            },
            DMA: DMA {
                _marker: PhantomData,
            },
            IOCONFIG: IOCONFIG {
                _marker: PhantomData,
            },
            UTILITY: UTILITY {
                _marker: PhantomData,
            },
            PORTA: PORTA {
                _marker: PhantomData,
            },
            PORTB: PORTB {
                _marker: PhantomData,
            },
            PORTC: PORTC {
                _marker: PhantomData,
            },
            PORTD: PORTD {
                _marker: PhantomData,
            },
            PORTE: PORTE {
                _marker: PhantomData,
            },
            PORTF: PORTF {
                _marker: PhantomData,
            },
            PORTG: PORTG {
                _marker: PhantomData,
            },
            TIM0: TIM0 {
                _marker: PhantomData,
            },
            TIM1: TIM1 {
                _marker: PhantomData,
            },
            TIM2: TIM2 {
                _marker: PhantomData,
            },
            TIM3: TIM3 {
                _marker: PhantomData,
            },
            TIM4: TIM4 {
                _marker: PhantomData,
            },
            TIM5: TIM5 {
                _marker: PhantomData,
            },
            TIM6: TIM6 {
                _marker: PhantomData,
            },
            TIM7: TIM7 {
                _marker: PhantomData,
            },
            TIM8: TIM8 {
                _marker: PhantomData,
            },
            TIM9: TIM9 {
                _marker: PhantomData,
            },
            TIM10: TIM10 {
                _marker: PhantomData,
            },
            TIM11: TIM11 {
                _marker: PhantomData,
            },
            TIM12: TIM12 {
                _marker: PhantomData,
            },
            TIM13: TIM13 {
                _marker: PhantomData,
            },
            TIM14: TIM14 {
                _marker: PhantomData,
            },
            TIM15: TIM15 {
                _marker: PhantomData,
            },
            TIM16: TIM16 {
                _marker: PhantomData,
            },
            TIM17: TIM17 {
                _marker: PhantomData,
            },
            TIM18: TIM18 {
                _marker: PhantomData,
            },
            TIM19: TIM19 {
                _marker: PhantomData,
            },
            TIM20: TIM20 {
                _marker: PhantomData,
            },
            TIM21: TIM21 {
                _marker: PhantomData,
            },
            TIM22: TIM22 {
                _marker: PhantomData,
            },
            TIM23: TIM23 {
                _marker: PhantomData,
            },
            UART0: UART0 {
                _marker: PhantomData,
            },
            UART1: UART1 {
                _marker: PhantomData,
            },
            UART2: UART2 {
                _marker: PhantomData,
            },
            SPI0: SPI0 {
                _marker: PhantomData,
            },
            SPI1: SPI1 {
                _marker: PhantomData,
            },
            SPI2: SPI2 {
                _marker: PhantomData,
            },
            SPI3: SPI3 {
                _marker: PhantomData,
            },
            I2C0: I2C0 {
                _marker: PhantomData,
            },
            I2C1: I2C1 {
                _marker: PhantomData,
            },
            I2C2: I2C2 {
                _marker: PhantomData,
            },
            CAN0: CAN0 {
                _marker: PhantomData,
            },
            CAN1: CAN1 {
                _marker: PhantomData,
            },
            ADC: ADC {
                _marker: PhantomData,
            },
            DAC0: DAC0 {
                _marker: PhantomData,
            },
            DAC1: DAC1 {
                _marker: PhantomData,
            },
            SPW: SPW {
                _marker: PhantomData,
            },
            IRQ_ROUTER: IRQ_ROUTER {
                _marker: PhantomData,
            },
            WATCH_DOG: WATCH_DOG {
                _marker: PhantomData,
            },
            TRNG: TRNG {
                _marker: PhantomData,
            },
            ETH: ETH {
                _marker: PhantomData,
            },
        }
    }
}
