#![doc = "Peripheral access API for VA108XX microcontrollers (generated using svd2rust v0.19.0 (b45bdce 2021-12-04))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 2;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn OC0();
    fn OC1();
    fn OC2();
    fn OC3();
    fn OC4();
    fn OC5();
    fn OC6();
    fn OC7();
    fn OC8();
    fn OC9();
    fn OC10();
    fn OC11();
    fn OC12();
    fn OC13();
    fn OC14();
    fn OC15();
    fn OC16();
    fn OC17();
    fn OC18();
    fn OC19();
    fn OC20();
    fn OC21();
    fn OC22();
    fn OC23();
    fn OC24();
    fn OC25();
    fn OC26();
    fn OC27();
    fn OC28();
    fn OC29();
    fn OC30();
    fn OC31();
}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 32] = [
    Vector { _handler: OC0 },
    Vector { _handler: OC1 },
    Vector { _handler: OC2 },
    Vector { _handler: OC3 },
    Vector { _handler: OC4 },
    Vector { _handler: OC5 },
    Vector { _handler: OC6 },
    Vector { _handler: OC7 },
    Vector { _handler: OC8 },
    Vector { _handler: OC9 },
    Vector { _handler: OC10 },
    Vector { _handler: OC11 },
    Vector { _handler: OC12 },
    Vector { _handler: OC13 },
    Vector { _handler: OC14 },
    Vector { _handler: OC15 },
    Vector { _handler: OC16 },
    Vector { _handler: OC17 },
    Vector { _handler: OC18 },
    Vector { _handler: OC19 },
    Vector { _handler: OC20 },
    Vector { _handler: OC21 },
    Vector { _handler: OC22 },
    Vector { _handler: OC23 },
    Vector { _handler: OC24 },
    Vector { _handler: OC25 },
    Vector { _handler: OC26 },
    Vector { _handler: OC27 },
    Vector { _handler: OC28 },
    Vector { _handler: OC29 },
    Vector { _handler: OC30 },
    Vector { _handler: OC31 },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "0 - OC0"]
    OC0 = 0,
    #[doc = "1 - OC1"]
    OC1 = 1,
    #[doc = "2 - OC2"]
    OC2 = 2,
    #[doc = "3 - OC3"]
    OC3 = 3,
    #[doc = "4 - OC4"]
    OC4 = 4,
    #[doc = "5 - OC5"]
    OC5 = 5,
    #[doc = "6 - OC6"]
    OC6 = 6,
    #[doc = "7 - OC7"]
    OC7 = 7,
    #[doc = "8 - OC8"]
    OC8 = 8,
    #[doc = "9 - OC9"]
    OC9 = 9,
    #[doc = "10 - OC10"]
    OC10 = 10,
    #[doc = "11 - OC11"]
    OC11 = 11,
    #[doc = "12 - OC12"]
    OC12 = 12,
    #[doc = "13 - OC13"]
    OC13 = 13,
    #[doc = "14 - OC14"]
    OC14 = 14,
    #[doc = "15 - OC15"]
    OC15 = 15,
    #[doc = "16 - OC16"]
    OC16 = 16,
    #[doc = "17 - OC17"]
    OC17 = 17,
    #[doc = "18 - OC18"]
    OC18 = 18,
    #[doc = "19 - OC19"]
    OC19 = 19,
    #[doc = "20 - OC20"]
    OC20 = 20,
    #[doc = "21 - OC21"]
    OC21 = 21,
    #[doc = "22 - OC22"]
    OC22 = 22,
    #[doc = "23 - OC23"]
    OC23 = 23,
    #[doc = "24 - OC24"]
    OC24 = 24,
    #[doc = "25 - OC25"]
    OC25 = 25,
    #[doc = "26 - OC26"]
    OC26 = 26,
    #[doc = "27 - OC27"]
    OC27 = 27,
    #[doc = "28 - OC28"]
    OC28 = 28,
    #[doc = "29 - OC29"]
    OC29 = 29,
    #[doc = "30 - OC30"]
    OC30 = 30,
    #[doc = "31 - OC31"]
    OC31 = 31,
}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = "System Configuration Peripheral"]
pub struct SYSCONFIG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSCONFIG {}
impl SYSCONFIG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sysconfig::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sysconfig::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSCONFIG {
    type Target = sysconfig::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSCONFIG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSCONFIG").finish()
    }
}
#[doc = "System Configuration Peripheral"]
pub mod sysconfig;
#[doc = "Interrupt Selector Peripheral"]
pub struct IRQSEL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IRQSEL {}
impl IRQSEL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const irqsel::RegisterBlock = 0x4000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const irqsel::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IRQSEL {
    type Target = irqsel::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IRQSEL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IRQSEL").finish()
    }
}
#[doc = "Interrupt Selector Peripheral"]
pub mod irqsel;
#[doc = "IO Pin Configuration Peripheral"]
pub struct IOCONFIG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IOCONFIG {}
impl IOCONFIG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ioconfig::RegisterBlock = 0x4000_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ioconfig::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IOCONFIG {
    type Target = ioconfig::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IOCONFIG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IOCONFIG").finish()
    }
}
#[doc = "IO Pin Configuration Peripheral"]
pub mod ioconfig;
#[doc = "Utility Peripheral"]
pub struct UTILITY {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UTILITY {}
impl UTILITY {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const utility::RegisterBlock = 0x4000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const utility::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UTILITY {
    type Target = utility::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UTILITY {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UTILITY").finish()
    }
}
#[doc = "Utility Peripheral"]
pub mod utility;
#[doc = "GPIO Peripheral"]
pub struct PORTA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTA {}
impl PORTA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x5000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTA {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTA").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub mod porta;
#[doc = "GPIO Peripheral"]
pub struct PORTB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PORTB {}
impl PORTB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const porta::RegisterBlock = 0x5000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const porta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PORTB {
    type Target = porta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PORTB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PORTB").finish()
    }
}
#[doc = "GPIO Peripheral"]
pub use porta as portb;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM0 {}
impl TIM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM0 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM0").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub mod tim0;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM1 {}
impl TIM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM1 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM1").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim1;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM2 {}
impl TIM2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM2 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM2").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim2;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM3 {}
impl TIM3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM3 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM3").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim3;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM4 {}
impl TIM4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM4 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM4").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim4;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM5 {}
impl TIM5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM5 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM5").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim5;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM6 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM6 {}
impl TIM6 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM6 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM6 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM6").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim6;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM7 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM7 {}
impl TIM7 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM7 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM7 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM7").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim7;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM8 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM8 {}
impl TIM8 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM8 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM8 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM8").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim8;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM9 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM9 {}
impl TIM9 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM9 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM9 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM9").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim9;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM10 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM10 {}
impl TIM10 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM10 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM10 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM10").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim10;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM11 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM11 {}
impl TIM11 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM11 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM11 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM11").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim11;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM12 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM12 {}
impl TIM12 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM12 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM12 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM12").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim12;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM13 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM13 {}
impl TIM13 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM13 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM13 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM13").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim13;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM14 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM14 {}
impl TIM14 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM14 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM14 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM14").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim14;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM15 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM15 {}
impl TIM15 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4002_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM15 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM15 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM15").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim15;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM16 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM16 {}
impl TIM16 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4003_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM16 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM16 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM16").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim16;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM17 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM17 {}
impl TIM17 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4003_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM17 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM17 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM17").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim17;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM18 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM18 {}
impl TIM18 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4003_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM18 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM18 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM18").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim18;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM19 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM19 {}
impl TIM19 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4003_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM19 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM19 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM19").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim19;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM20 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM20 {}
impl TIM20 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4003_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM20 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM20 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM20").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim20;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM21 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM21 {}
impl TIM21 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4003_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM21 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM21 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM21").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim21;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM22 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM22 {}
impl TIM22 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4003_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM22 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM22 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM22").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim22;
#[doc = "Timer/Counter Peripheral"]
pub struct TIM23 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIM23 {}
impl TIM23 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tim0::RegisterBlock = 0x4003_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tim0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIM23 {
    type Target = tim0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIM23 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIM23").finish()
    }
}
#[doc = "Timer/Counter Peripheral"]
pub use tim0 as tim23;
#[doc = "UART Peripheral"]
pub struct UARTA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTA {}
impl UARTA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarta::RegisterBlock = 0x4004_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTA {
    type Target = uarta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTA").finish()
    }
}
#[doc = "UART Peripheral"]
pub mod uarta;
#[doc = "UART Peripheral"]
pub struct UARTB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UARTB {}
impl UARTB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uarta::RegisterBlock = 0x4004_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uarta::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UARTB {
    type Target = uarta::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UARTB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UARTB").finish()
    }
}
#[doc = "UART Peripheral"]
pub use uarta as uartb;
#[doc = "SPI Peripheral"]
pub struct SPIA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIA {}
impl SPIA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spia::RegisterBlock = 0x4005_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spia::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIA {
    type Target = spia::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIA").finish()
    }
}
#[doc = "SPI Peripheral"]
pub mod spia;
#[doc = "SPI Peripheral"]
pub struct SPIB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIB {}
impl SPIB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spia::RegisterBlock = 0x4005_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spia::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIB {
    type Target = spia::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIB").finish()
    }
}
#[doc = "SPI Peripheral"]
pub use spia as spib;
#[doc = "SPI Peripheral"]
pub struct SPIC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPIC {}
impl SPIC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spia::RegisterBlock = 0x4005_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spia::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPIC {
    type Target = spia::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPIC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPIC").finish()
    }
}
#[doc = "SPI Peripheral"]
pub use spia as spic;
#[doc = "I2C Peripheral"]
pub struct I2CA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2CA {}
impl I2CA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2ca::RegisterBlock = 0x4006_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2ca::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2CA {
    type Target = i2ca::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2CA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2CA").finish()
    }
}
#[doc = "I2C Peripheral"]
pub mod i2ca;
#[doc = "I2C Peripheral"]
pub struct I2CB {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2CB {}
impl I2CB {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2ca::RegisterBlock = 0x4006_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2ca::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2CB {
    type Target = i2ca::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2CB {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2CB").finish()
    }
}
#[doc = "I2C Peripheral"]
pub use i2ca as i2cb;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "SYSCONFIG"]
    pub SYSCONFIG: SYSCONFIG,
    #[doc = "IRQSEL"]
    pub IRQSEL: IRQSEL,
    #[doc = "IOCONFIG"]
    pub IOCONFIG: IOCONFIG,
    #[doc = "UTILITY"]
    pub UTILITY: UTILITY,
    #[doc = "PORTA"]
    pub PORTA: PORTA,
    #[doc = "PORTB"]
    pub PORTB: PORTB,
    #[doc = "TIM0"]
    pub TIM0: TIM0,
    #[doc = "TIM1"]
    pub TIM1: TIM1,
    #[doc = "TIM2"]
    pub TIM2: TIM2,
    #[doc = "TIM3"]
    pub TIM3: TIM3,
    #[doc = "TIM4"]
    pub TIM4: TIM4,
    #[doc = "TIM5"]
    pub TIM5: TIM5,
    #[doc = "TIM6"]
    pub TIM6: TIM6,
    #[doc = "TIM7"]
    pub TIM7: TIM7,
    #[doc = "TIM8"]
    pub TIM8: TIM8,
    #[doc = "TIM9"]
    pub TIM9: TIM9,
    #[doc = "TIM10"]
    pub TIM10: TIM10,
    #[doc = "TIM11"]
    pub TIM11: TIM11,
    #[doc = "TIM12"]
    pub TIM12: TIM12,
    #[doc = "TIM13"]
    pub TIM13: TIM13,
    #[doc = "TIM14"]
    pub TIM14: TIM14,
    #[doc = "TIM15"]
    pub TIM15: TIM15,
    #[doc = "TIM16"]
    pub TIM16: TIM16,
    #[doc = "TIM17"]
    pub TIM17: TIM17,
    #[doc = "TIM18"]
    pub TIM18: TIM18,
    #[doc = "TIM19"]
    pub TIM19: TIM19,
    #[doc = "TIM20"]
    pub TIM20: TIM20,
    #[doc = "TIM21"]
    pub TIM21: TIM21,
    #[doc = "TIM22"]
    pub TIM22: TIM22,
    #[doc = "TIM23"]
    pub TIM23: TIM23,
    #[doc = "UARTA"]
    pub UARTA: UARTA,
    #[doc = "UARTB"]
    pub UARTB: UARTB,
    #[doc = "SPIA"]
    pub SPIA: SPIA,
    #[doc = "SPIB"]
    pub SPIB: SPIB,
    #[doc = "SPIC"]
    pub SPIC: SPIC,
    #[doc = "I2CA"]
    pub I2CA: I2CA,
    #[doc = "I2CB"]
    pub I2CB: I2CB,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            SYSCONFIG: SYSCONFIG {
                _marker: PhantomData,
            },
            IRQSEL: IRQSEL {
                _marker: PhantomData,
            },
            IOCONFIG: IOCONFIG {
                _marker: PhantomData,
            },
            UTILITY: UTILITY {
                _marker: PhantomData,
            },
            PORTA: PORTA {
                _marker: PhantomData,
            },
            PORTB: PORTB {
                _marker: PhantomData,
            },
            TIM0: TIM0 {
                _marker: PhantomData,
            },
            TIM1: TIM1 {
                _marker: PhantomData,
            },
            TIM2: TIM2 {
                _marker: PhantomData,
            },
            TIM3: TIM3 {
                _marker: PhantomData,
            },
            TIM4: TIM4 {
                _marker: PhantomData,
            },
            TIM5: TIM5 {
                _marker: PhantomData,
            },
            TIM6: TIM6 {
                _marker: PhantomData,
            },
            TIM7: TIM7 {
                _marker: PhantomData,
            },
            TIM8: TIM8 {
                _marker: PhantomData,
            },
            TIM9: TIM9 {
                _marker: PhantomData,
            },
            TIM10: TIM10 {
                _marker: PhantomData,
            },
            TIM11: TIM11 {
                _marker: PhantomData,
            },
            TIM12: TIM12 {
                _marker: PhantomData,
            },
            TIM13: TIM13 {
                _marker: PhantomData,
            },
            TIM14: TIM14 {
                _marker: PhantomData,
            },
            TIM15: TIM15 {
                _marker: PhantomData,
            },
            TIM16: TIM16 {
                _marker: PhantomData,
            },
            TIM17: TIM17 {
                _marker: PhantomData,
            },
            TIM18: TIM18 {
                _marker: PhantomData,
            },
            TIM19: TIM19 {
                _marker: PhantomData,
            },
            TIM20: TIM20 {
                _marker: PhantomData,
            },
            TIM21: TIM21 {
                _marker: PhantomData,
            },
            TIM22: TIM22 {
                _marker: PhantomData,
            },
            TIM23: TIM23 {
                _marker: PhantomData,
            },
            UARTA: UARTA {
                _marker: PhantomData,
            },
            UARTB: UARTB {
                _marker: PhantomData,
            },
            SPIA: SPIA {
                _marker: PhantomData,
            },
            SPIB: SPIB {
                _marker: PhantomData,
            },
            SPIC: SPIC {
                _marker: PhantomData,
            },
            I2CA: I2CA {
                _marker: PhantomData,
            },
            I2CB: I2CB {
                _marker: PhantomData,
            },
        }
    }
}
