##### 3.4.2.4. Создание схемы авторизации

Задается схема авторизации с помощью сущностей следующих классов: **v-s:Group, v-s:Membership, v-s:PermissionStatement**.

С помощью сущностей **v-s:Group** можно задать группы как для пользователя, так и для защищаемого ресурса. Затем созданные ранее группы следует связать в дерево с помощью сущностей класса **v-s:Membership**. Должно получиться два не связанных между собой дерева - одно для пользователя, другое для защищаемого ресурса. Последним этапом будет связывание этих деревьев между собой с помощью сущностей **v-s:PermissionStatement**.

В базовой поставке уже есть ряд скриптов, которые занимаются созданием групп, помещением в них пользователей и ресурсов в зависимости от их содержимого и текущей ситуации. Пример: [Генерация схемы для поля v-s:author](#скрипты-отвечающие-за-назначение-прав-автору-новой-сущности)

##### 3.4.2.5. Алгоритмы авторизации

*Базовые алгоритмы авторизации*

При выполнении проверки прав доступа (на сервере):

- По тикету вычисляется пользователь.
- Производится извлечение всех групп, в которых состоит пользователь, с учетом вложенности групп друг в друга.
- Производится извлечение всех групп, в которых состоит запрашиваемый ресурс, с учетом вложенности групп друг в друга.
- Производится извлечение подходящих записей авторизации, в которых есть группа пользователя и группа ресурса с необходимым уровнем прав, и вычисление прав с учетом ограничений, установленных в группах.

*Дополнительные алгоритмы, накладывающие ограничение на полученные права*

Такие ограничения позволяет наложить запрет на права, полученные пользователем косвенным образом.

**Ограниченные права на основе признака**

Данный вид прав позволяет установить ограничение на отдельный ресурс. Может применяться для временного выключения прав на ресурс для большинства пользователей и взамен включения точечных прав для небольшой группы пользователей. Алгоритм ограничения действует в две фазы.

В первой фазе для всех пользователей включается ограничение прав на ресурс.
Для этого следует описать сущность типа **v-s:PermissionFilter**, у которой в поле **v-s:permissionObject** устанавливаем uri ресурса, на который накладываются ограничения. В поле **v-s:resource** задаем общий для обеих фаз маркер. Также необходимо задать мощность ограничительных прав.  Сразу после создания вышеописанной сущности, вычисляемые права на ресурс будут возвращаться как "не выше заданных".

**Пример сущности для первой фазы.**
Здесь мы ограничиваем всем пользователям их права до Read:

```
mnd-s:test_permissionFilter_1
  rdf:type v-s:PermissionFilter ;
  v-s:permissionObject d:a1kemm4f21polivjc6aqo6gp1kg ;
  v-s:resource v-s:StatusStarted ;
  v-s:canRead "true"^^xsd:boolean.
```

Во второй фазе выдаем разрешающие права для некоторых пользователей.
Для этого следует описать сущность типа **v-s:PermissionStatement**. В поле **v-s:useFilter** следует задать общий для обеих фаз маркер. Поля **v-s:permissionObject** и **v-s:permissionSubject** задают связку выдаваемого права с ресурсом и пользователем.

**Пример сущности для второй фазы.**
Здесь мы выдаем пользователю d:employee_00051114 право на Update на защищаемый ресурс:

```
mnd-s:test_permissionFilter_permission_1
  rdf:type v-s:PermissionStatement ;
  v-s:useFilter v-s:StatusStarted ;
  v-s:permissionObject d:a1kemm4f21polivjc6aqo6gp1kg ;
  v-s:permissionSubject d:employee_00051114;
  v-s:canUpdate "true"^^xsd:boolean.
```

При пометке сущности из первой фазы как "удаленной", вызовет отключение ограничения и отзыв выданного права из второй фазы.



**Ограниченные права на основе групп**

Данный вид прав позволяет ограничить доступ для отдельных групп пользователей. Может потребоваться при условии, что в системе есть пользователи из разных организаций.

Для этого следует создать включение в группу со специальным признаком **v-s:isExclusive = true**:

```
mnd-s:InternalDocumentToCompany1_membership
  rdf:type v-s:Membership ;
  v-s:memberOf mnd-s:InternalDocument_group ;
  v-s:resource d:org_Company1 ;
  rdfs:label "Внутренние документы доступные для Компании 1" ;
  v-s:isExclusive "true"^^xsd:boolean .
```

После внесения такой записи, для пользователей, входящих по иерархии в группу **d:org_Company1**, на обычную для них авторизацию будет налагаться ограничение:
   - теперь авторизуемый обьект должен входить по иерархии **CLASS_GROUP_HIERARCHY** в группу **mnd-s:InternalDocument_group**, иначе он не будет доступен.

Структура **CLASS_GROUP_HIERARCHY**:
   - группы, содержащие **v-s:isExclusive = true** в иерархию не входят;
   - в 0 уровень могут входить любые группы;
   - для уровня > 0 предыдущий уровень должен содержать строку **'_group'** или **сfg:TTLResourcesGroup_**;
   - сущности, не имеющие на первом уровне иерархии групп с **'_group'** или **сfg:TTLResourcesGroup**, считаются системными и на них не действуют ограничения.

*ВНИМАНИЕ!
При наличии хотя бы одной записи о включения в группу с признаком **v-s:isExclusive**, для ограничивающей группы пользователей произойдет потеря всех прав, кроме прав на онтологию и прав, разрешаемых с помощью этой записи.*

