/// Representing the keys on a Keyboard for use in the `InputKeyboard` virtual controller.
/// 
/// Can be extended with Custom by using concrete project values.
///

#[allow(non_camel_case_types)]
pub enum Key {
    NUM_LOCK,
    CLEAR,
    HELP,
    ALT,
    BACKSPACE,
    CAPS_LOCK,
    CONTROL,
    DELETE,
    DOWN,
    END,
    ENTER,
    ESCAPE,
    F1,
    F10,
    F11,
    F12,
    F13,
    F14,
    F15,
    F2,
    F3,
    F4,
    F5,
    F6,
    F7,
    F8,
    F9,
    HOME,
    INSERT,
    LEFT,
    NUMPAD_0,
    NUMPAD_1,
    NUMPAD_2,
    NUMPAD_3,
    NUMPAD_4,
    NUMPAD_5,
    NUMPAD_6,
    NUMPAD_7,
    NUMPAD_8,
    NUMPAD_9,
    NUMPAD_ADD,
    NUMPAD_DECIMAL,
    NUMPAD_DIVIDE,
    NUMPAD_ENTER,
    NUMPAD_MULTIPLY,
    NUMPAD_SUBTRACT,
    PAGE_DOWN,
    PAGE_UP,
    RIGHT,
    SHIFT,
    SPACE,
    TAB,
    UP,
    A,
    B,
    C,
    D,
    E,
    F,
    G,
    H,
    I,
    J,
    K,
    L,
    M,
    N,
    O,
    P,
    Q,
    R,
    S,
    T,
    U,
    V,
    W,
    X,
    Y,
    Z,
    NUMBER_0,
    NUMBER_1,
    NUMBER_2,
    NUMBER_3,
    NUMBER_4,
    NUMBER_5,
    NUMBER_6,
    NUMBER_7,
    NUMBER_8,
    NUMBER_9,
    COLON,
    EQUALS,
    HYPHEN,
    SLASH,
    TILDE,
    SQUARELEFT,
    SQUARERIGHT,
    BACKSLASH,
    APOSTROPHE,
    TOPLEFT,
    /// Allows EKey to be extended (e.g. for using non US / English keyboards).
    CUSTOM {
        value: u32,
    },
}
