/* automatically generated by rust-bindgen 0.59.2 */

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_allocator {
    pub _address: u8,
}
pub type std_allocator_value_type = u8;
pub type std_allocator_size_type = u64;
pub type std_allocator_difference_type = u64;
pub type std_allocator_pointer = u8;
pub type std_allocator_const_pointer = u8;
pub type std_allocator_reference = u8;
pub type std_allocator_const_reference = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_allocator_rebind {
    pub _address: u8,
}
pub type std_allocator_rebind_other = u8;
pub type std_allocator_propagate_on_container_move_assignment = u8;
pub type std_allocator_is_always_equal = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_vector {
    pub _address: u8,
}
pub type std_vector__Base = u8;
pub type std_vector__Tp_alloc_type = u8;
pub type std_vector__Alloc_traits = u8;
pub type std_vector_value_type = u8;
pub type std_vector_pointer = u8;
pub type std_vector_const_pointer = u8;
pub type std_vector_reference = u8;
pub type std_vector_const_reference = u8;
pub type std_vector_iterator = u8;
pub type std_vector_const_iterator = u8;
pub type std_vector_const_reverse_iterator = u8;
pub type std_vector_reverse_iterator = u8;
pub type std_vector_size_type = u64;
pub type std_vector_difference_type = u64;
pub type std_vector_allocator_type = u8;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct std_vector__Temporary_value {
    pub _address: u8,
}
pub type size_t = ::std::os::raw::c_ulong;
pub type uchar = ::std::os::raw::c_uchar;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cv_cuda_GpuMat {
    _unused: [u8; 0],
}
#[doc = " @brief Template class for 2D points specified by its coordinates `x` and `y`."]
#[doc = ""]
#[doc = "An instance of the class is interchangeable with C structures, CvPoint and CvPoint2D32f . There is"]
#[doc = "also a cast operator to convert point coordinates to the specified type. The conversion from"]
#[doc = "floating-point coordinates to integer coordinates is done by rounding. Commonly, the conversion"]
#[doc = "uses this operation for each of the coordinates. Besides the class members listed in the"]
#[doc = "declaration above, the following operations on points are implemented:"]
#[doc = "@code"]
#[doc = "pt1 = pt2 + pt3;"]
#[doc = "pt1 = pt2 - pt3;"]
#[doc = "pt1 = pt2 * a;"]
#[doc = "pt1 = a * pt2;"]
#[doc = "pt1 = pt2 / a;"]
#[doc = "pt1 += pt2;"]
#[doc = "pt1 -= pt2;"]
#[doc = "pt1 *= a;"]
#[doc = "pt1 /= a;"]
#[doc = "double value = norm(pt); // L2 norm"]
#[doc = "pt1 == pt2;"]
#[doc = "pt1 != pt2;"]
#[doc = "@endcode"]
#[doc = "For your convenience, the following type aliases are defined:"]
#[doc = "@code"]
#[doc = "typedef Point_<int> Point2i;"]
#[doc = "typedef Point2i Point;"]
#[doc = "typedef Point_<float> Point2f;"]
#[doc = "typedef Point_<double> Point2d;"]
#[doc = "@endcode"]
#[doc = "Example:"]
#[doc = "@code"]
#[doc = "Point2f a(0.3f, 0.f), b(0.f, 0.4f);"]
#[doc = "Point pt = (a + b)*10.f;"]
#[doc = "cout << pt.x << \", \" << pt.y << endl;"]
#[doc = "@endcode"]
pub type cv_Point = [u32; 2usize];
#[doc = " @brief Template class for specifying the size of an image or rectangle."]
#[doc = ""]
#[doc = "The class includes two members called width and height. The structure can be converted to and from"]
#[doc = "the old OpenCV structures CvSize and CvSize2D32f . The same set of arithmetic and comparison"]
#[doc = "operations as for Point_ is available."]
#[doc = ""]
#[doc = "OpenCV defines the following Size_\\<\\> aliases:"]
#[doc = "@code"]
#[doc = "typedef Size_<int> Size2i;"]
#[doc = "typedef Size2i Size;"]
#[doc = "typedef Size_<float> Size2f;"]
#[doc = "@endcode"]
pub type cv_Size = [u32; 2usize];
#[doc = " @brief Template class for 2D rectangles"]
#[doc = ""]
#[doc = "described by the following parameters:"]
#[doc = "-   Coordinates of the top-left corner. This is a default interpretation of Rect_::x and Rect_::y"]
#[doc = "in OpenCV. Though, in your algorithms you may count x and y from the bottom-left corner."]
#[doc = "-   Rectangle width and height."]
#[doc = ""]
#[doc = "OpenCV typically assumes that the top and left boundary of the rectangle are inclusive, while the"]
#[doc = "right and bottom boundaries are not. For example, the method Rect_::contains returns true if"]
#[doc = ""]
#[doc = "\\f[x  \\leq pt.x < x+width,"]
#[doc = "y  \\leq pt.y < y+height\\f]"]
#[doc = ""]
#[doc = "Virtually every loop over an image ROI in OpenCV (where ROI is specified by Rect_\\<int\\> ) is"]
#[doc = "implemented as:"]
#[doc = "@code"]
#[doc = "for(int y = roi.y; y < roi.y + roi.height; y++)"]
#[doc = "for(int x = roi.x; x < roi.x + roi.width; x++)"]
#[doc = "{"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = "In addition to the class members, the following operations on rectangles are implemented:"]
#[doc = "-   \\f$\\texttt{rect} = \\texttt{rect} \\pm \\texttt{point}\\f$ (shifting a rectangle by a certain offset)"]
#[doc = "-   \\f$\\texttt{rect} = \\texttt{rect} \\pm \\texttt{size}\\f$ (expanding or shrinking a rectangle by a"]
#[doc = "certain amount)"]
#[doc = "-   rect += point, rect -= point, rect += size, rect -= size (augmenting operations)"]
#[doc = "-   rect = rect1 & rect2 (rectangle intersection)"]
#[doc = "-   rect = rect1 | rect2 (minimum area rectangle containing rect1 and rect2 )"]
#[doc = "-   rect &= rect1, rect |= rect1 (and the corresponding augmenting operations)"]
#[doc = "-   rect == rect1, rect != rect1 (rectangle comparison)"]
#[doc = ""]
#[doc = "This is an example how the partial ordering on rectangles can be established (rect1 \\f$\\subseteq\\f$"]
#[doc = "rect2):"]
#[doc = "@code"]
#[doc = "template<typename _Tp> inline bool"]
#[doc = "operator <= (const Rect_<_Tp>& r1, const Rect_<_Tp>& r2)"]
#[doc = "{"]
#[doc = "return (r1 & r2) == r1;"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = "For your convenience, the Rect_\\<\\> alias is available: cv::Rect"]
pub type cv_Rect = [u32; 4usize];
#[doc = " @brief Template class specifying a continuous subsequence (slice) of a sequence."]
#[doc = ""]
#[doc = "The class is used to specify a row or a column span in a matrix ( Mat ) and for many other purposes."]
#[doc = "Range(a,b) is basically the same as a:b in Matlab or a..b in Python. As in Python, start is an"]
#[doc = "inclusive left boundary of the range and end is an exclusive right boundary of the range. Such a"]
#[doc = "half-opened interval is usually denoted as \\f$[start,end)\\f$ ."]
#[doc = ""]
#[doc = "The static method Range::all() returns a special variable that means \"the whole sequence\" or \"the"]
#[doc = "whole range\", just like \" : \" in Matlab or \" ... \" in Python. All the methods and functions in"]
#[doc = "OpenCV that take Range support this special Range::all() value. But, of course, in case of your own"]
#[doc = "custom processing, you will probably have to check and handle it explicitly:"]
#[doc = "@code"]
#[doc = "void my_function(..., const Range& r, ....)"]
#[doc = "{"]
#[doc = "if(r == Range::all()) {"]
#[doc = "}"]
#[doc = "else {"]
#[doc = "}"]
#[doc = "}"]
#[doc = "@endcode"]
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct cv_Range {
    pub _bindgen_opaque_blob: [u32; 2usize],
}
#[test]
fn bindgen_test_layout_cv_Range() {
    assert_eq!(
        ::std::mem::size_of::<cv_Range>(),
        8usize,
        concat!("Size of: ", stringify!(cv_Range))
    );
    assert_eq!(
        ::std::mem::align_of::<cv_Range>(),
        4usize,
        concat!("Alignment of ", stringify!(cv_Range))
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5Range4sizeEv"]
    pub fn cv_Range_size(this: *const cv_Range) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5Range5emptyEv"]
    pub fn cv_Range_empty(this: *const cv_Range) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv5Range3allEv"]
    pub fn cv_Range_all() -> cv_Range;
}
extern "C" {
    #[doc = " Range /////////////////////////////////"]
    #[link_name = "\u{1}_ZN2cv5RangeC1Ev"]
    pub fn cv_Range_Range(this: *mut cv_Range);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv5RangeC1Eii"]
    pub fn cv_Range_Range1(
        this: *mut cv_Range,
        _start: ::std::os::raw::c_int,
        _end: ::std::os::raw::c_int,
    );
}
impl cv_Range {
    #[inline]
    pub unsafe fn size(&self) -> ::std::os::raw::c_int {
        cv_Range_size(self)
    }
    #[inline]
    pub unsafe fn empty(&self) -> bool {
        cv_Range_empty(self)
    }
    #[inline]
    pub unsafe fn all() -> cv_Range {
        cv_Range_all()
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Range_Range(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(_start: ::std::os::raw::c_int, _end: ::std::os::raw::c_int) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Range_Range1(__bindgen_tmp.as_mut_ptr(), _start, _end);
        __bindgen_tmp.assume_init()
    }
}
#[doc = " @brief Template class for a 4-element vector derived from Vec."]
#[doc = ""]
#[doc = "Being derived from Vec\\<_Tp, 4\\> , Scalar\\_ and Scalar can be used just as typical 4-element"]
#[doc = "vectors. In addition, they can be converted to/from CvScalar . The type Scalar is widely used in"]
#[doc = "OpenCV to pass pixel values."]
pub type cv_Scalar = [u64; 4usize];
#[doc = "! @addtogroup core"]
#[doc = "! @{"]
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct cv_BufferPoolController {
    pub _bindgen_opaque_blob: u64,
}
#[test]
fn bindgen_test_layout_cv_BufferPoolController() {
    assert_eq!(
        ::std::mem::size_of::<cv_BufferPoolController>(),
        8usize,
        concat!("Size of: ", stringify!(cv_BufferPoolController))
    );
    assert_eq!(
        ::std::mem::align_of::<cv_BufferPoolController>(),
        8usize,
        concat!("Alignment of ", stringify!(cv_BufferPoolController))
    );
}
pub const cv_AccessFlag_ACCESS_READ: cv_AccessFlag = 16777216;
pub const cv_AccessFlag_ACCESS_WRITE: cv_AccessFlag = 33554432;
pub const cv_AccessFlag_ACCESS_RW: cv_AccessFlag = 50331648;
pub const cv_AccessFlag_ACCESS_MASK: cv_AccessFlag = 50331648;
pub const cv_AccessFlag_ACCESS_FAST: cv_AccessFlag = 67108864;
#[doc = "! @addtogroup core_basic"]
#[doc = "! @{"]
pub type cv_AccessFlag = ::std::os::raw::c_uint;
pub type cv_InputArray = [u64; 3usize];
pub type cv_OutputArray = [u64; 3usize];
pub const cv_UMatUsageFlags_USAGE_DEFAULT: cv_UMatUsageFlags = 0;
pub const cv_UMatUsageFlags_USAGE_ALLOCATE_HOST_MEMORY: cv_UMatUsageFlags = 1;
pub const cv_UMatUsageFlags_USAGE_ALLOCATE_DEVICE_MEMORY: cv_UMatUsageFlags = 2;
pub const cv_UMatUsageFlags_USAGE_ALLOCATE_SHARED_MEMORY: cv_UMatUsageFlags = 4;
pub const cv_UMatUsageFlags___UMAT_USAGE_FLAGS_32BIT: cv_UMatUsageFlags = 2147483647;
#[doc = "! Usage flags for allocator"]
pub type cv_UMatUsageFlags = ::std::os::raw::c_uint;
#[doc = " @brief  Custom array allocator"]
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct cv_MatAllocator {
    pub _bindgen_opaque_blob: u64,
}
#[test]
fn bindgen_test_layout_cv_MatAllocator() {
    assert_eq!(
        ::std::mem::size_of::<cv_MatAllocator>(),
        8usize,
        concat!("Size of: ", stringify!(cv_MatAllocator))
    );
    assert_eq!(
        ::std::mem::align_of::<cv_MatAllocator>(),
        8usize,
        concat!("Alignment of ", stringify!(cv_MatAllocator))
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv12MatAllocator3mapEPNS_8UMatDataENS_10AccessFlagE"]
    pub fn cv_MatAllocator_map(
        this: *mut ::std::os::raw::c_void,
        data: *mut cv_UMatData,
        accessflags: cv_AccessFlag,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv12MatAllocator5unmapEPNS_8UMatDataE"]
    pub fn cv_MatAllocator_unmap(this: *mut ::std::os::raw::c_void, data: *mut cv_UMatData);
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv12MatAllocator8downloadEPNS_8UMatDataEPviPKmS5_S5_S5_"]
    pub fn cv_MatAllocator_download(
        this: *mut ::std::os::raw::c_void,
        data: *mut cv_UMatData,
        dst: *mut ::std::os::raw::c_void,
        dims: ::std::os::raw::c_int,
        sz: *const size_t,
        srcofs: *const size_t,
        srcstep: *const size_t,
        dststep: *const size_t,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv12MatAllocator6uploadEPNS_8UMatDataEPKviPKmS6_S6_S6_"]
    pub fn cv_MatAllocator_upload(
        this: *mut ::std::os::raw::c_void,
        data: *mut cv_UMatData,
        src: *const ::std::os::raw::c_void,
        dims: ::std::os::raw::c_int,
        sz: *const size_t,
        dstofs: *const size_t,
        dststep: *const size_t,
        srcstep: *const size_t,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv12MatAllocator4copyEPNS_8UMatDataES2_iPKmS4_S4_S4_S4_b"]
    pub fn cv_MatAllocator_copy(
        this: *mut ::std::os::raw::c_void,
        srcdata: *mut cv_UMatData,
        dstdata: *mut cv_UMatData,
        dims: ::std::os::raw::c_int,
        sz: *const size_t,
        srcofs: *const size_t,
        srcstep: *const size_t,
        dstofs: *const size_t,
        dststep: *const size_t,
        sync: bool,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv12MatAllocator23getBufferPoolControllerEPKc"]
    pub fn cv_MatAllocator_getBufferPoolController(
        this: *mut ::std::os::raw::c_void,
        id: *const ::std::os::raw::c_char,
    ) -> *mut cv_BufferPoolController;
}
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct cv_UMatData {
    pub _bindgen_opaque_blob: [u64; 13usize],
}
pub const cv_UMatData_MemoryFlag_COPY_ON_MAP: cv_UMatData_MemoryFlag = 1;
pub const cv_UMatData_MemoryFlag_HOST_COPY_OBSOLETE: cv_UMatData_MemoryFlag = 2;
pub const cv_UMatData_MemoryFlag_DEVICE_COPY_OBSOLETE: cv_UMatData_MemoryFlag = 4;
pub const cv_UMatData_MemoryFlag_TEMP_UMAT: cv_UMatData_MemoryFlag = 8;
pub const cv_UMatData_MemoryFlag_TEMP_COPIED_UMAT: cv_UMatData_MemoryFlag = 24;
pub const cv_UMatData_MemoryFlag_USER_ALLOCATED: cv_UMatData_MemoryFlag = 32;
pub const cv_UMatData_MemoryFlag_DEVICE_MEM_MAPPED: cv_UMatData_MemoryFlag = 64;
pub const cv_UMatData_MemoryFlag_ASYNC_CLEANUP: cv_UMatData_MemoryFlag = 128;
pub type cv_UMatData_MemoryFlag = ::std::os::raw::c_uint;
#[test]
fn bindgen_test_layout_cv_UMatData() {
    assert_eq!(
        ::std::mem::size_of::<cv_UMatData>(),
        104usize,
        concat!("Size of: ", stringify!(cv_UMatData))
    );
    assert_eq!(
        ::std::mem::align_of::<cv_UMatData>(),
        8usize,
        concat!("Alignment of ", stringify!(cv_UMatData))
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv8UMatData4lockEv"]
    pub fn cv_UMatData_lock(this: *mut cv_UMatData);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv8UMatData6unlockEv"]
    pub fn cv_UMatData_unlock(this: *mut cv_UMatData);
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv8UMatData16hostCopyObsoleteEv"]
    pub fn cv_UMatData_hostCopyObsolete(this: *const cv_UMatData) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv8UMatData18deviceCopyObsoleteEv"]
    pub fn cv_UMatData_deviceCopyObsolete(this: *const cv_UMatData) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv8UMatData15deviceMemMappedEv"]
    pub fn cv_UMatData_deviceMemMapped(this: *const cv_UMatData) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv8UMatData9copyOnMapEv"]
    pub fn cv_UMatData_copyOnMap(this: *const cv_UMatData) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv8UMatData8tempUMatEv"]
    pub fn cv_UMatData_tempUMat(this: *const cv_UMatData) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv8UMatData14tempCopiedUMatEv"]
    pub fn cv_UMatData_tempCopiedUMat(this: *const cv_UMatData) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv8UMatData20markHostCopyObsoleteEb"]
    pub fn cv_UMatData_markHostCopyObsolete(this: *mut cv_UMatData, flag: bool);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv8UMatData22markDeviceCopyObsoleteEb"]
    pub fn cv_UMatData_markDeviceCopyObsolete(this: *mut cv_UMatData, flag: bool);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv8UMatData19markDeviceMemMappedEb"]
    pub fn cv_UMatData_markDeviceMemMapped(this: *mut cv_UMatData, flag: bool);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv8UMatDataC1EPKNS_12MatAllocatorE"]
    pub fn cv_UMatData_UMatData(this: *mut cv_UMatData, allocator: *const cv_MatAllocator);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv8UMatDataD1Ev"]
    pub fn cv_UMatData_UMatData_destructor(this: *mut cv_UMatData);
}
impl cv_UMatData {
    #[inline]
    pub unsafe fn lock(&mut self) {
        cv_UMatData_lock(self)
    }
    #[inline]
    pub unsafe fn unlock(&mut self) {
        cv_UMatData_unlock(self)
    }
    #[inline]
    pub unsafe fn hostCopyObsolete(&self) -> bool {
        cv_UMatData_hostCopyObsolete(self)
    }
    #[inline]
    pub unsafe fn deviceCopyObsolete(&self) -> bool {
        cv_UMatData_deviceCopyObsolete(self)
    }
    #[inline]
    pub unsafe fn deviceMemMapped(&self) -> bool {
        cv_UMatData_deviceMemMapped(self)
    }
    #[inline]
    pub unsafe fn copyOnMap(&self) -> bool {
        cv_UMatData_copyOnMap(self)
    }
    #[inline]
    pub unsafe fn tempUMat(&self) -> bool {
        cv_UMatData_tempUMat(self)
    }
    #[inline]
    pub unsafe fn tempCopiedUMat(&self) -> bool {
        cv_UMatData_tempCopiedUMat(self)
    }
    #[inline]
    pub unsafe fn markHostCopyObsolete(&mut self, flag: bool) {
        cv_UMatData_markHostCopyObsolete(self, flag)
    }
    #[inline]
    pub unsafe fn markDeviceCopyObsolete(&mut self, flag: bool) {
        cv_UMatData_markDeviceCopyObsolete(self, flag)
    }
    #[inline]
    pub unsafe fn markDeviceMemMapped(&mut self, flag: bool) {
        cv_UMatData_markDeviceMemMapped(self, flag)
    }
    #[inline]
    pub unsafe fn new(allocator: *const cv_MatAllocator) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMatData_UMatData(__bindgen_tmp.as_mut_ptr(), allocator);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        cv_UMatData_UMatData_destructor(self)
    }
}
#[doc = " @brief n-dimensional dense array class \\anchor CVMat_Details"]
#[doc = ""]
#[doc = "The class Mat represents an n-dimensional dense numerical single-channel or multi-channel array. It"]
#[doc = "can be used to store real or complex-valued vectors and matrices, grayscale or color images, voxel"]
#[doc = "volumes, vector fields, point clouds, tensors, histograms (though, very high-dimensional histograms"]
#[doc = "may be better stored in a SparseMat ). The data layout of the array `M` is defined by the array"]
#[doc = "`M.step[]`, so that the address of element \\f$(i_0,...,i_{M.dims-1})\\f$, where \\f$0\\leq i_k<M.size[k]\\f$, is"]
#[doc = "computed as:"]
#[doc = "\\f[addr(M_{i_0,...,i_{M.dims-1}}) = M.data + M.step[0]*i_0 + M.step[1]*i_1 + ... + M.step[M.dims-1]*i_{M.dims-1}\\f]"]
#[doc = "In case of a 2-dimensional array, the above formula is reduced to:"]
#[doc = "\\f[addr(M_{i,j}) = M.data + M.step[0]*i + M.step[1]*j\\f]"]
#[doc = "Note that `M.step[i] >= M.step[i+1]` (in fact, `M.step[i] >= M.step[i+1]*M.size[i+1]` ). This means"]
#[doc = "that 2-dimensional matrices are stored row-by-row, 3-dimensional matrices are stored plane-by-plane,"]
#[doc = "and so on. M.step[M.dims-1] is minimal and always equal to the element size M.elemSize() ."]
#[doc = ""]
#[doc = "So, the data layout in Mat is compatible with the majority of dense array types from the standard"]
#[doc = "toolkits and SDKs, such as Numpy (ndarray), Win32 (independent device bitmaps), and others,"]
#[doc = "that is, with any array that uses *steps* (or *strides*) to compute the position of a pixel."]
#[doc = "Due to this compatibility, it is possible to make a Mat header for user-allocated data and process"]
#[doc = "it in-place using OpenCV functions."]
#[doc = ""]
#[doc = "There are many different ways to create a Mat object. The most popular options are listed below:"]
#[doc = ""]
#[doc = "- Use the create(nrows, ncols, type) method or the similar Mat(nrows, ncols, type[, fillValue])"]
#[doc = "constructor. A new array of the specified size and type is allocated. type has the same meaning as"]
#[doc = "in the cvCreateMat method. For example, CV_8UC1 means a 8-bit single-channel array, CV_32FC2"]
#[doc = "means a 2-channel (complex) floating-point array, and so on."]
#[doc = "@code"]
#[doc = "Mat M(7,7,CV_32FC2,Scalar(1,3));"]
#[doc = "M.create(100,60,CV_8UC(15));"]
#[doc = "@endcode"]
#[doc = "As noted in the introduction to this chapter, create() allocates only a new array when the shape"]
#[doc = "or type of the current array are different from the specified ones."]
#[doc = ""]
#[doc = "- Create a multi-dimensional array:"]
#[doc = "@code"]
#[doc = "int sz[] = {100, 100, 100};"]
#[doc = "Mat bigCube(3, sz, CV_8U, Scalar::all(0));"]
#[doc = "@endcode"]
#[doc = "It passes the number of dimensions =1 to the Mat constructor but the created array will be"]
#[doc = "2-dimensional with the number of columns set to 1. So, Mat::dims is always \\>= 2 (can also be 0"]
#[doc = "when the array is empty)."]
#[doc = ""]
#[doc = "- Use a copy constructor or assignment operator where there can be an array or expression on the"]
#[doc = "right side (see below). As noted in the introduction, the array assignment is an O(1) operation"]
#[doc = "because it only copies the header and increases the reference counter. The Mat::clone() method can"]
#[doc = "be used to get a full (deep) copy of the array when you need it."]
#[doc = ""]
#[doc = "- Construct a header for a part of another array. It can be a single row, single column, several"]
#[doc = "rows, several columns, rectangular region in the array (called a *minor* in algebra) or a"]
#[doc = "diagonal. Such operations are also O(1) because the new header references the same data. You can"]
#[doc = "actually modify a part of the array using this feature, for example:"]
#[doc = "@code"]
#[doc = "M.row(3) = M.row(3) + M.row(5)*3;"]
#[doc = "Mat M1 = M.col(1);"]
#[doc = "M.col(7).copyTo(M1);"]
#[doc = "Mat img(Size(320,240),CV_8UC3);"]
#[doc = "Mat roi(img, Rect(10,10,100,100));"]
#[doc = "roi = Scalar(0,255,0);"]
#[doc = "@endcode"]
#[doc = "Due to the additional datastart and dataend members, it is possible to compute a relative"]
#[doc = "sub-array position in the main *container* array using locateROI():"]
#[doc = "@code"]
#[doc = "Mat A = Mat::eye(10, 10, CV_32S);"]
#[doc = "Mat B = A(Range::all(), Range(1, 3));"]
#[doc = "Mat C = B(Range(5, 9), Range::all());"]
#[doc = "Size size; Point ofs;"]
#[doc = "C.locateROI(size, ofs);"]
#[doc = "@endcode"]
#[doc = "As in case of whole matrices, if you need a deep copy, use the `clone()` method of the extracted"]
#[doc = "sub-matrices."]
#[doc = ""]
#[doc = "- Make a header for user-allocated data. It can be useful to do the following:"]
#[doc = "-# Process \"foreign\" data using OpenCV (for example, when you implement a DirectShow\\* filter or"]
#[doc = "a processing module for gstreamer, and so on). For example:"]
#[doc = "@code"]
#[doc = "Mat process_video_frame(const unsigned char* pixels,"]
#[doc = "int width, int height, int step)"]
#[doc = "{"]
#[doc = "Mat img(height, width, CV_8UC3, (unsigned char*)pixels, step);"]
#[doc = ""]
#[doc = "Mat result;"]
#[doc = "GaussianBlur(img, result, Size(7, 7), 1.5, 1.5);"]
#[doc = ""]
#[doc = "return result;"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = "-# Quickly initialize small matrices and/or get a super-fast element access."]
#[doc = "@code"]
#[doc = "double m[3][3] = {{a, b, c}, {d, e, f}, {g, h, i}};"]
#[doc = "Mat M = Mat(3, 3, CV_64F, m).inv();"]
#[doc = "@endcode"]
#[doc = "."]
#[doc = ""]
#[doc = "- Use MATLAB-style array initializers, zeros(), ones(), eye(), for example:"]
#[doc = "@code"]
#[doc = "M += Mat::eye(M.rows, M.cols, CV_64F);"]
#[doc = "@endcode"]
#[doc = ""]
#[doc = "- Use a comma-separated initializer:"]
#[doc = "@code"]
#[doc = "Mat M = (Mat_<double>(3,3) << 1, 0, 0, 0, 1, 0, 0, 0, 1);"]
#[doc = "@endcode"]
#[doc = "With this approach, you first call a constructor of the Mat class with the proper parameters, and"]
#[doc = "then you just put `<< operator` followed by comma-separated values that can be constants,"]
#[doc = "variables, expressions, and so on. Also, note the extra parentheses required to avoid compilation"]
#[doc = "errors."]
#[doc = ""]
#[doc = "Once the array is created, it is automatically managed via a reference-counting mechanism. If the"]
#[doc = "array header is built on top of user-allocated data, you should handle the data by yourself. The"]
#[doc = "array data is deallocated when no one points to it. If you want to release the data pointed by a"]
#[doc = "array header before the array destructor is called, use Mat::release()."]
#[doc = ""]
#[doc = "The next important thing to learn about the array class is element access. This manual already"]
#[doc = "described how to compute an address of each array element. Normally, you are not required to use the"]
#[doc = "formula directly in the code. If you know the array element type (which can be retrieved using the"]
#[doc = "method Mat::type() ), you can access the element \\f$M_{ij}\\f$ of a 2-dimensional array as:"]
#[doc = "@code"]
#[doc = "M.at<double>(i,j) += 1.f;"]
#[doc = "@endcode"]
#[doc = "assuming that `M` is a double-precision floating-point array. There are several variants of the method"]
#[doc = "at for a different number of dimensions."]
#[doc = ""]
#[doc = "If you need to process a whole row of a 2D array, the most efficient way is to get the pointer to"]
#[doc = "the row first, and then just use the plain C operator [] :"]
#[doc = "@code"]
#[doc = "double sum=0;"]
#[doc = "for(int i = 0; i < M.rows; i++)"]
#[doc = "{"]
#[doc = "const double* Mi = M.ptr<double>(i);"]
#[doc = "for(int j = 0; j < M.cols; j++)"]
#[doc = "sum += std::max(Mi[j], 0.);"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = "Some operations, like the one above, do not actually depend on the array shape. They just process"]
#[doc = "elements of an array one by one (or elements from multiple arrays that have the same coordinates,"]
#[doc = "for example, array addition). Such operations are called *element-wise*. It makes sense to check"]
#[doc = "whether all the input/output arrays are continuous, namely, have no gaps at the end of each row. If"]
#[doc = "yes, process them as a long single row:"]
#[doc = "@code"]
#[doc = "double sum=0;"]
#[doc = "int cols = M.cols, rows = M.rows;"]
#[doc = "if(M.isContinuous())"]
#[doc = "{"]
#[doc = "cols *= rows;"]
#[doc = "rows = 1;"]
#[doc = "}"]
#[doc = "for(int i = 0; i < rows; i++)"]
#[doc = "{"]
#[doc = "const double* Mi = M.ptr<double>(i);"]
#[doc = "for(int j = 0; j < cols; j++)"]
#[doc = "sum += std::max(Mi[j], 0.);"]
#[doc = "}"]
#[doc = "@endcode"]
#[doc = "In case of the continuous matrix, the outer loop body is executed just once. So, the overhead is"]
#[doc = "smaller, which is especially noticeable in case of small matrices."]
#[doc = ""]
#[doc = "Finally, there are STL-style iterators that are smart enough to skip gaps between successive rows:"]
#[doc = "@code"]
#[doc = "double sum=0;"]
#[doc = "MatConstIterator_<double> it = M.begin<double>(), it_end = M.end<double>();"]
#[doc = "for(; it != it_end; ++it)"]
#[doc = "sum += std::max(*it, 0.);"]
#[doc = "@endcode"]
#[doc = "The matrix iterators are random-access iterators, so they can be passed to any STL algorithm,"]
#[doc = "including std::sort()."]
#[doc = ""]
#[doc = "@note Matrix Expressions and arithmetic see MatExpr"]
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct cv_Mat {
    pub _bindgen_opaque_blob: [u64; 12usize],
}
pub const cv_Mat_MAGIC_VAL: ::std::os::raw::c_uint = 1124007936;
pub const cv_Mat_AUTO_STEP: ::std::os::raw::c_uint = 0;
pub const cv_Mat_CONTINUOUS_FLAG: ::std::os::raw::c_uint = 16384;
pub const cv_Mat_SUBMATRIX_FLAG: ::std::os::raw::c_uint = 32768;
pub type cv_Mat__bindgen_ty_1 = ::std::os::raw::c_uint;
pub const cv_Mat_MAGIC_MASK: ::std::os::raw::c_uint = 4294901760;
pub const cv_Mat_TYPE_MASK: ::std::os::raw::c_uint = 4095;
pub const cv_Mat_DEPTH_MASK: ::std::os::raw::c_uint = 7;
pub type cv_Mat__bindgen_ty_2 = ::std::os::raw::c_uint;
#[test]
fn bindgen_test_layout_cv_Mat() {
    assert_eq!(
        ::std::mem::size_of::<cv_Mat>(),
        96usize,
        concat!("Size of: ", stringify!(cv_Mat))
    );
    assert_eq!(
        ::std::mem::align_of::<cv_Mat>(),
        8usize,
        concat!("Alignment of ", stringify!(cv_Mat))
    );
}
extern "C" {
    #[doc = "! retrieve UMat from Mat"]
    #[link_name = "\u{1}_ZNK2cv3Mat7getUMatENS_10AccessFlagENS_14UMatUsageFlagsE"]
    pub fn cv_Mat_getUMat(
        this: *const cv_Mat,
        accessFlags: cv_AccessFlag,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[doc = " @brief Creates a matrix header for the specified matrix row."]
    #[doc = ""]
    #[doc = "The method makes a new header for the specified matrix row and returns it. This is an O(1)"]
    #[doc = "operation, regardless of the matrix size. The underlying data of the new matrix is shared with the"]
    #[doc = "original matrix. Here is the example of one of the classical basic matrix processing operations,"]
    #[doc = "axpy, used by LU and many other algorithms:"]
    #[doc = "@code"]
    #[doc = "inline void matrix_axpy(Mat& A, int i, int j, double alpha)"]
    #[doc = "{"]
    #[doc = "A.row(i) += A.row(j)*alpha;"]
    #[doc = "}"]
    #[doc = "@endcode"]
    #[doc = "@note In the current implementation, the following code does not work as expected:"]
    #[doc = "@code"]
    #[doc = "Mat A;"]
    #[doc = "..."]
    #[doc = "A.row(i) = A.row(j); // will not work"]
    #[doc = "@endcode"]
    #[doc = "This happens because A.row(i) forms a temporary header that is further assigned to another header."]
    #[doc = "Remember that each of these operations is O(1), that is, no data is copied. Thus, the above"]
    #[doc = "assignment is not true if you may have expected the j-th row to be copied to the i-th row. To"]
    #[doc = "achieve that, you should either turn this simple assignment into an expression or use the"]
    #[doc = "Mat::copyTo method:"]
    #[doc = "@code"]
    #[doc = "Mat A;"]
    #[doc = "..."]
    #[doc = "A.row(i) = A.row(j) + 0;"]
    #[doc = "A.row(j).copyTo(A.row(i));"]
    #[doc = "@endcode"]
    #[doc = "@param y A 0-based row index."]
    #[link_name = "\u{1}_ZNK2cv3Mat3rowEi"]
    pub fn cv_Mat_row(this: *const cv_Mat, y: ::std::os::raw::c_int) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief Creates a matrix header for the specified matrix column."]
    #[doc = ""]
    #[doc = "The method makes a new header for the specified matrix column and returns it. This is an O(1)"]
    #[doc = "operation, regardless of the matrix size. The underlying data of the new matrix is shared with the"]
    #[doc = "original matrix. See also the Mat::row description."]
    #[doc = "@param x A 0-based column index."]
    #[link_name = "\u{1}_ZNK2cv3Mat3colEi"]
    pub fn cv_Mat_col(this: *const cv_Mat, x: ::std::os::raw::c_int) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief Creates a matrix header for the specified row span."]
    #[doc = ""]
    #[doc = "The method makes a new header for the specified row span of the matrix. Similarly to Mat::row and"]
    #[doc = "Mat::col , this is an O(1) operation."]
    #[doc = "@param startrow An inclusive 0-based start index of the row span."]
    #[doc = "@param endrow An exclusive 0-based ending index of the row span."]
    #[link_name = "\u{1}_ZNK2cv3Mat8rowRangeEii"]
    pub fn cv_Mat_rowRange(
        this: *const cv_Mat,
        startrow: ::std::os::raw::c_int,
        endrow: ::std::os::raw::c_int,
    ) -> cv_Mat;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param r Range structure containing both the start and the end indices."]
    #[link_name = "\u{1}_ZNK2cv3Mat8rowRangeERKNS_5RangeE"]
    pub fn cv_Mat_rowRange1(this: *const cv_Mat, r: *const cv_Range) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief Creates a matrix header for the specified column span."]
    #[doc = ""]
    #[doc = "The method makes a new header for the specified column span of the matrix. Similarly to Mat::row and"]
    #[doc = "Mat::col , this is an O(1) operation."]
    #[doc = "@param startcol An inclusive 0-based start index of the column span."]
    #[doc = "@param endcol An exclusive 0-based ending index of the column span."]
    #[link_name = "\u{1}_ZNK2cv3Mat8colRangeEii"]
    pub fn cv_Mat_colRange(
        this: *const cv_Mat,
        startcol: ::std::os::raw::c_int,
        endcol: ::std::os::raw::c_int,
    ) -> cv_Mat;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param r Range structure containing both the start and the end indices."]
    #[link_name = "\u{1}_ZNK2cv3Mat8colRangeERKNS_5RangeE"]
    pub fn cv_Mat_colRange1(this: *const cv_Mat, r: *const cv_Range) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief Extracts a diagonal from a matrix"]
    #[doc = ""]
    #[doc = "The method makes a new header for the specified matrix diagonal. The new matrix is represented as a"]
    #[doc = "single-column matrix. Similarly to Mat::row and Mat::col, this is an O(1) operation."]
    #[doc = "@param d index of the diagonal, with the following values:"]
    #[doc = "- `d=0` is the main diagonal."]
    #[doc = "- `d<0` is a diagonal from the lower half. For example, d=-1 means the diagonal is set"]
    #[doc = "immediately below the main one."]
    #[doc = "- `d>0` is a diagonal from the upper half. For example, d=1 means the diagonal is set"]
    #[doc = "immediately above the main one."]
    #[doc = "For example:"]
    #[doc = "@code"]
    #[doc = "Mat m = (Mat_<int>(3,3) <<"]
    #[doc = "1,2,3,"]
    #[doc = "4,5,6,"]
    #[doc = "7,8,9);"]
    #[doc = "Mat d0 = m.diag(0);"]
    #[doc = "Mat d1 = m.diag(1);"]
    #[doc = "Mat d_1 = m.diag(-1);"]
    #[doc = "@endcode"]
    #[doc = "The resulting matrices are"]
    #[doc = "@code"]
    #[doc = "d0 ="]
    #[doc = "[1;"]
    #[doc = "5;"]
    #[doc = "9]"]
    #[doc = "d1 ="]
    #[doc = "[2;"]
    #[doc = "6]"]
    #[doc = "d_1 ="]
    #[doc = "[4;"]
    #[doc = "8]"]
    #[doc = "@endcode"]
    #[link_name = "\u{1}_ZNK2cv3Mat4diagEi"]
    pub fn cv_Mat_diag(this: *const cv_Mat, d: ::std::os::raw::c_int) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief creates a diagonal matrix"]
    #[doc = ""]
    #[doc = "The method creates a square diagonal matrix from specified main diagonal."]
    #[doc = "@param d One-dimensional matrix that represents the main diagonal."]
    #[link_name = "\u{1}_ZN2cv3Mat4diagERKS0_"]
    pub fn cv_Mat_diag1(d: *const cv_Mat) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief Creates a full copy of the array and the underlying data."]
    #[doc = ""]
    #[doc = "The method creates a full copy of the array. The original step[] is not taken into account. So, the"]
    #[doc = "array copy is a continuous array occupying total()*elemSize() bytes."]
    #[link_name = "\u{1}_ZNK2cv3Mat5cloneEv"]
    pub fn cv_Mat_clone(this: *const cv_Mat) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief Copies the matrix to another one."]
    #[doc = ""]
    #[doc = "The method copies the matrix data to another matrix. Before copying the data, the method invokes :"]
    #[doc = "@code"]
    #[doc = "m.create(this->size(), this->type());"]
    #[doc = "@endcode"]
    #[doc = "so that the destination matrix is reallocated if needed. While m.copyTo(m); works flawlessly, the"]
    #[doc = "function does not handle the case of a partial overlap between the source and the destination"]
    #[doc = "matrices."]
    #[doc = ""]
    #[doc = "When the operation mask is specified, if the Mat::create call shown above reallocates the matrix,"]
    #[doc = "the newly allocated matrix is initialized with all zeros before copying the data."]
    #[doc = "@param m Destination matrix. If it does not have a proper size or type before the operation, it is"]
    #[doc = "reallocated."]
    #[link_name = "\u{1}_ZNK2cv3Mat6copyToERKNS_12_OutputArrayE"]
    pub fn cv_Mat_copyTo(this: *const cv_Mat, m: cv_OutputArray);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param m Destination matrix. If it does not have a proper size or type before the operation, it is"]
    #[doc = "reallocated."]
    #[doc = "@param mask Operation mask of the same size as \\*this. Its non-zero elements indicate which matrix"]
    #[doc = "elements need to be copied. The mask has to be of type CV_8U and can have 1 or multiple channels."]
    #[link_name = "\u{1}_ZNK2cv3Mat6copyToERKNS_12_OutputArrayERKNS_11_InputArrayE"]
    pub fn cv_Mat_copyTo1(this: *const cv_Mat, m: cv_OutputArray, mask: cv_InputArray);
}
extern "C" {
    #[doc = " @brief Converts an array to another data type with optional scaling."]
    #[doc = ""]
    #[doc = "The method converts source pixel values to the target data type. saturate_cast\\<\\> is applied at"]
    #[doc = "the end to avoid possible overflows:"]
    #[doc = ""]
    #[doc = "\\f[m(x,y) = saturate \\_ cast<rType>( \\alpha (*this)(x,y) +  \\beta )\\f]"]
    #[doc = "@param m output matrix; if it does not have a proper size or type before the operation, it is"]
    #[doc = "reallocated."]
    #[doc = "@param rtype desired output matrix type or, rather, the depth since the number of channels are the"]
    #[doc = "same as the input has; if rtype is negative, the output matrix will have the same type as the input."]
    #[doc = "@param alpha optional scale factor."]
    #[doc = "@param beta optional delta added to the scaled values."]
    #[link_name = "\u{1}_ZNK2cv3Mat9convertToERKNS_12_OutputArrayEidd"]
    pub fn cv_Mat_convertTo(
        this: *const cv_Mat,
        m: cv_OutputArray,
        rtype: ::std::os::raw::c_int,
        alpha: f64,
        beta: f64,
    );
}
extern "C" {
    #[doc = " @brief Provides a functional form of convertTo."]
    #[doc = ""]
    #[doc = "This is an internally used method called by the @ref MatrixExpressions engine."]
    #[doc = "@param m Destination array."]
    #[doc = "@param type Desired destination array depth (or -1 if it should be the same as the source type)."]
    #[link_name = "\u{1}_ZNK2cv3Mat8assignToERS0_i"]
    pub fn cv_Mat_assignTo(this: *const cv_Mat, m: *mut cv_Mat, type_: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " @brief Sets all or some of the array elements to the specified value."]
    #[doc = ""]
    #[doc = "This is an advanced variant of the Mat::operator=(const Scalar& s) operator."]
    #[doc = "@param value Assigned scalar converted to the actual array type."]
    #[doc = "@param mask Operation mask of the same size as \\*this. Its non-zero elements indicate which matrix"]
    #[doc = "elements need to be copied. The mask has to be of type CV_8U and can have 1 or multiple channels"]
    #[link_name = "\u{1}_ZN2cv3Mat5setToERKNS_11_InputArrayES3_"]
    pub fn cv_Mat_setTo(
        this: *mut cv_Mat,
        value: cv_InputArray,
        mask: cv_InputArray,
    ) -> *mut cv_Mat;
}
extern "C" {
    #[doc = " @brief Changes the shape and/or the number of channels of a 2D matrix without copying the data."]
    #[doc = ""]
    #[doc = "The method makes a new matrix header for \\*this elements. The new matrix may have a different size"]
    #[doc = "and/or different number of channels. Any combination is possible if:"]
    #[doc = "-   No extra elements are included into the new matrix and no elements are excluded. Consequently,"]
    #[doc = "the product rows\\*cols\\*channels() must stay the same after the transformation."]
    #[doc = "-   No data is copied. That is, this is an O(1) operation. Consequently, if you change the number of"]
    #[doc = "rows, or the operation changes the indices of elements row in some other way, the matrix must be"]
    #[doc = "continuous. See Mat::isContinuous ."]
    #[doc = ""]
    #[doc = "For example, if there is a set of 3D points stored as an STL vector, and you want to represent the"]
    #[doc = "points as a 3xN matrix, do the following:"]
    #[doc = "@code"]
    #[doc = "std::vector<Point3f> vec;"]
    #[doc = "..."]
    #[doc = "Mat pointMat = Mat(vec). // convert vector to Mat, O(1) operation"]
    #[doc = "reshape(1). // make Nx3 1-channel matrix out of Nx1 3-channel."]
    #[doc = "t(); // finally, transpose the Nx3 matrix."]
    #[doc = "@endcode"]
    #[doc = "@param cn New number of channels. If the parameter is 0, the number of channels remains the same."]
    #[doc = "@param rows New number of rows. If the parameter is 0, the number of rows remains the same."]
    #[link_name = "\u{1}_ZNK2cv3Mat7reshapeEii"]
    pub fn cv_Mat_reshape(
        this: *const cv_Mat,
        cn: ::std::os::raw::c_int,
        rows: ::std::os::raw::c_int,
    ) -> cv_Mat;
}
extern "C" {
    #[doc = " @overload"]
    #[link_name = "\u{1}_ZNK2cv3Mat7reshapeEiiPKi"]
    pub fn cv_Mat_reshape1(
        this: *const cv_Mat,
        cn: ::std::os::raw::c_int,
        newndims: ::std::os::raw::c_int,
        newsz: *const ::std::os::raw::c_int,
    ) -> cv_Mat;
}
extern "C" {
    #[doc = " @overload"]
    #[link_name = "\u{1}_ZNK2cv3Mat7reshapeEiRKSt6vectorIiSaIiEE"]
    pub fn cv_Mat_reshape2(
        this: *const cv_Mat,
        cn: ::std::os::raw::c_int,
        newshape: *const [u64; 3usize],
    ) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief Transposes a matrix."]
    #[doc = ""]
    #[doc = "The method performs matrix transposition by means of matrix expressions. It does not perform the"]
    #[doc = "actual transposition but returns a temporary matrix transposition object that can be further used as"]
    #[doc = "a part of more complex matrix expressions or can be assigned to a matrix:"]
    #[doc = "@code"]
    #[doc = "Mat A1 = A + Mat::eye(A.size(), A.type())*lambda;"]
    #[doc = "Mat C = A1.t()*A1; // compute (A + lambda*I)^t * (A + lamda*I)"]
    #[doc = "@endcode"]
    #[link_name = "\u{1}_ZNK2cv3Mat1tEv"]
    pub fn cv_Mat_t(this: *const cv_Mat) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @brief Inverses a matrix."]
    #[doc = ""]
    #[doc = "The method performs a matrix inversion by means of matrix expressions. This means that a temporary"]
    #[doc = "matrix inversion object is returned by the method and can be used further as a part of more complex"]
    #[doc = "matrix expressions or can be assigned to a matrix."]
    #[doc = "@param method Matrix inversion method. One of cv::DecompTypes"]
    #[link_name = "\u{1}_ZNK2cv3Mat3invEi"]
    pub fn cv_Mat_inv(this: *const cv_Mat, method: ::std::os::raw::c_int) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @brief Performs an element-wise multiplication or division of the two matrices."]
    #[doc = ""]
    #[doc = "The method returns a temporary object encoding per-element array multiplication, with optional"]
    #[doc = "scale. Note that this is not a matrix multiplication that corresponds to a simpler \"\\*\" operator."]
    #[doc = ""]
    #[doc = "Example:"]
    #[doc = "@code"]
    #[doc = "Mat C = A.mul(5/B); // equivalent to divide(A, B, C, 5)"]
    #[doc = "@endcode"]
    #[doc = "@param m Another array of the same type and the same size as \\*this, or a matrix expression."]
    #[doc = "@param scale Optional scale factor."]
    #[link_name = "\u{1}_ZNK2cv3Mat3mulERKNS_11_InputArrayEd"]
    pub fn cv_Mat_mul(this: *const cv_Mat, m: cv_InputArray, scale: f64) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @brief Computes a cross-product of two 3-element vectors."]
    #[doc = ""]
    #[doc = "The method computes a cross-product of two 3-element vectors. The vectors must be 3-element"]
    #[doc = "floating-point vectors of the same shape and size. The result is another 3-element vector of the"]
    #[doc = "same shape and type as operands."]
    #[doc = "@param m Another cross-product operand."]
    #[link_name = "\u{1}_ZNK2cv3Mat5crossERKNS_11_InputArrayE"]
    pub fn cv_Mat_cross(this: *const cv_Mat, m: cv_InputArray) -> cv_Mat;
}
extern "C" {
    #[doc = " @brief Computes a dot-product of two vectors."]
    #[doc = ""]
    #[doc = "The method computes a dot-product of two matrices. If the matrices are not single-column or"]
    #[doc = "single-row vectors, the top-to-bottom left-to-right scan ordering is used to treat them as 1D"]
    #[doc = "vectors. The vectors must have the same size and type. If the matrices have more than one channel,"]
    #[doc = "the dot products from all the channels are summed together."]
    #[doc = "@param m another dot-product operand."]
    #[link_name = "\u{1}_ZNK2cv3Mat3dotERKNS_11_InputArrayE"]
    pub fn cv_Mat_dot(this: *const cv_Mat, m: cv_InputArray) -> f64;
}
extern "C" {
    #[doc = " @brief Returns a zero array of the specified size and type."]
    #[doc = ""]
    #[doc = "The method returns a Matlab-style zero array initializer. It can be used to quickly form a constant"]
    #[doc = "array as a function parameter, part of a matrix expression, or as a matrix initializer:"]
    #[doc = "@code"]
    #[doc = "Mat A;"]
    #[doc = "A = Mat::zeros(3, 3, CV_32F);"]
    #[doc = "@endcode"]
    #[doc = "In the example above, a new matrix is allocated only if A is not a 3x3 floating-point matrix."]
    #[doc = "Otherwise, the existing matrix A is filled with zeros."]
    #[doc = "@param rows Number of rows."]
    #[doc = "@param cols Number of columns."]
    #[doc = "@param type Created matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat5zerosEiii"]
    pub fn cv_Mat_zeros(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param size Alternative to the matrix size specification Size(cols, rows) ."]
    #[doc = "@param type Created matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat5zerosENS_5Size_IiEEi"]
    pub fn cv_Mat_zeros1(size: cv_Size, type_: ::std::os::raw::c_int) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param ndims Array dimensionality."]
    #[doc = "@param sz Array of integers specifying the array shape."]
    #[doc = "@param type Created matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat5zerosEiPKii"]
    pub fn cv_Mat_zeros2(
        ndims: ::std::os::raw::c_int,
        sz: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @brief Returns an array of all 1's of the specified size and type."]
    #[doc = ""]
    #[doc = "The method returns a Matlab-style 1's array initializer, similarly to Mat::zeros. Note that using"]
    #[doc = "this method you can initialize an array with an arbitrary value, using the following Matlab idiom:"]
    #[doc = "@code"]
    #[doc = "Mat A = Mat::ones(100, 100, CV_8U)*3; // make 100x100 matrix filled with 3."]
    #[doc = "@endcode"]
    #[doc = "The above operation does not form a 100x100 matrix of 1's and then multiply it by 3. Instead, it"]
    #[doc = "just remembers the scale factor (3 in this case) and use it when actually invoking the matrix"]
    #[doc = "initializer."]
    #[doc = "@note In case of multi-channels type, only the first channel will be initialized with 1's, the"]
    #[doc = "others will be set to 0's."]
    #[doc = "@param rows Number of rows."]
    #[doc = "@param cols Number of columns."]
    #[doc = "@param type Created matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat4onesEiii"]
    pub fn cv_Mat_ones(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param size Alternative to the matrix size specification Size(cols, rows) ."]
    #[doc = "@param type Created matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat4onesENS_5Size_IiEEi"]
    pub fn cv_Mat_ones1(size: cv_Size, type_: ::std::os::raw::c_int) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param ndims Array dimensionality."]
    #[doc = "@param sz Array of integers specifying the array shape."]
    #[doc = "@param type Created matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat4onesEiPKii"]
    pub fn cv_Mat_ones2(
        ndims: ::std::os::raw::c_int,
        sz: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @brief Returns an identity matrix of the specified size and type."]
    #[doc = ""]
    #[doc = "The method returns a Matlab-style identity matrix initializer, similarly to Mat::zeros. Similarly to"]
    #[doc = "Mat::ones, you can use a scale operation to create a scaled identity matrix efficiently:"]
    #[doc = "@code"]
    #[doc = "Mat A = Mat::eye(4, 4, CV_32F)*0.1;"]
    #[doc = "@endcode"]
    #[doc = "@note In case of multi-channels type, identity matrix will be initialized only for the first channel,"]
    #[doc = "the others will be set to 0's"]
    #[doc = "@param rows Number of rows."]
    #[doc = "@param cols Number of columns."]
    #[doc = "@param type Created matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat3eyeEiii"]
    pub fn cv_Mat_eye(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param size Alternative matrix size specification as Size(cols, rows) ."]
    #[doc = "@param type Created matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat3eyeENS_5Size_IiEEi"]
    pub fn cv_Mat_eye1(size: cv_Size, type_: ::std::os::raw::c_int) -> cv_MatExpr;
}
extern "C" {
    #[doc = " @brief Allocates new array data if needed."]
    #[doc = ""]
    #[doc = "This is one of the key Mat methods. Most new-style OpenCV functions and methods that produce arrays"]
    #[doc = "call this method for each output array. The method uses the following algorithm:"]
    #[doc = ""]
    #[doc = "-# If the current array shape and the type match the new ones, return immediately. Otherwise,"]
    #[doc = "de-reference the previous data by calling Mat::release."]
    #[doc = "-# Initialize the new header."]
    #[doc = "-# Allocate the new data of total()\\*elemSize() bytes."]
    #[doc = "-# Allocate the new, associated with the data, reference counter and set it to 1."]
    #[doc = ""]
    #[doc = "Such a scheme makes the memory management robust and efficient at the same time and helps avoid"]
    #[doc = "extra typing for you. This means that usually there is no need to explicitly allocate output arrays."]
    #[doc = "That is, instead of writing:"]
    #[doc = "@code"]
    #[doc = "Mat color;"]
    #[doc = "..."]
    #[doc = "Mat gray(color.rows, color.cols, color.depth());"]
    #[doc = "cvtColor(color, gray, COLOR_BGR2GRAY);"]
    #[doc = "@endcode"]
    #[doc = "you can simply write:"]
    #[doc = "@code"]
    #[doc = "Mat color;"]
    #[doc = "..."]
    #[doc = "Mat gray;"]
    #[doc = "cvtColor(color, gray, COLOR_BGR2GRAY);"]
    #[doc = "@endcode"]
    #[doc = "because cvtColor, as well as the most of OpenCV functions, calls Mat::create() for the output array"]
    #[doc = "internally."]
    #[doc = "@param rows New number of rows."]
    #[doc = "@param cols New number of columns."]
    #[doc = "@param type New matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat6createEiii"]
    pub fn cv_Mat_create(
        this: *mut cv_Mat,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param size Alternative new matrix size specification: Size(cols, rows)"]
    #[doc = "@param type New matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat6createENS_5Size_IiEEi"]
    pub fn cv_Mat_create1(this: *mut cv_Mat, size: cv_Size, type_: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param ndims New array dimensionality."]
    #[doc = "@param sizes Array of integers specifying a new array shape."]
    #[doc = "@param type New matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat6createEiPKii"]
    pub fn cv_Mat_create2(
        this: *mut cv_Mat,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param sizes Array of integers specifying a new array shape."]
    #[doc = "@param type New matrix type."]
    #[link_name = "\u{1}_ZN2cv3Mat6createERKSt6vectorIiSaIiEEi"]
    pub fn cv_Mat_create3(
        this: *mut cv_Mat,
        sizes: *const [u64; 3usize],
        type_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " @brief Increments the reference counter."]
    #[doc = ""]
    #[doc = "The method increments the reference counter associated with the matrix data. If the matrix header"]
    #[doc = "points to an external data set (see Mat::Mat ), the reference counter is NULL, and the method has no"]
    #[doc = "effect in this case. Normally, to avoid memory leaks, the method should not be called explicitly. It"]
    #[doc = "is called implicitly by the matrix assignment operator. The reference counter increment is an atomic"]
    #[doc = "operation on the platforms that support it. Thus, it is safe to operate on the same matrices"]
    #[doc = "asynchronously in different threads."]
    #[link_name = "\u{1}_ZN2cv3Mat6addrefEv"]
    pub fn cv_Mat_addref(this: *mut cv_Mat);
}
extern "C" {
    #[doc = " @brief Decrements the reference counter and deallocates the matrix if needed."]
    #[doc = ""]
    #[doc = "The method decrements the reference counter associated with the matrix data. When the reference"]
    #[doc = "counter reaches 0, the matrix data is deallocated and the data and the reference counter pointers"]
    #[doc = "are set to NULL's. If the matrix header points to an external data set (see Mat::Mat ), the"]
    #[doc = "reference counter is NULL, and the method has no effect in this case."]
    #[doc = ""]
    #[doc = "This method can be called manually to force the matrix data deallocation. But since this method is"]
    #[doc = "automatically called in the destructor, or by any other method that changes the data pointer, it is"]
    #[doc = "usually not needed. The reference counter decrement and check for 0 is an atomic operation on the"]
    #[doc = "platforms that support it. Thus, it is safe to operate on the same matrices asynchronously in"]
    #[doc = "different threads."]
    #[link_name = "\u{1}_ZN2cv3Mat7releaseEv"]
    pub fn cv_Mat_release(this: *mut cv_Mat);
}
extern "C" {
    #[doc = "! internal use function, consider to use 'release' method instead; deallocates the matrix data"]
    #[link_name = "\u{1}_ZN2cv3Mat10deallocateEv"]
    pub fn cv_Mat_deallocate(this: *mut cv_Mat);
}
extern "C" {
    #[doc = "! internal use function; properly re-allocates _size, _step arrays"]
    #[link_name = "\u{1}_ZN2cv3Mat8copySizeERKS0_"]
    pub fn cv_Mat_copySize(this: *mut cv_Mat, m: *const cv_Mat);
}
extern "C" {
    #[doc = " @brief Reserves space for the certain number of rows."]
    #[doc = ""]
    #[doc = "The method reserves space for sz rows. If the matrix already has enough space to store sz rows,"]
    #[doc = "nothing happens. If the matrix is reallocated, the first Mat::rows rows are preserved. The method"]
    #[doc = "emulates the corresponding method of the STL vector class."]
    #[doc = "@param sz Number of rows."]
    #[link_name = "\u{1}_ZN2cv3Mat7reserveEm"]
    pub fn cv_Mat_reserve(this: *mut cv_Mat, sz: size_t);
}
extern "C" {
    #[doc = " @brief Reserves space for the certain number of bytes."]
    #[doc = ""]
    #[doc = "The method reserves space for sz bytes. If the matrix already has enough space to store sz bytes,"]
    #[doc = "nothing happens. If matrix has to be reallocated its previous content could be lost."]
    #[doc = "@param sz Number of bytes."]
    #[link_name = "\u{1}_ZN2cv3Mat13reserveBufferEm"]
    pub fn cv_Mat_reserveBuffer(this: *mut cv_Mat, sz: size_t);
}
extern "C" {
    #[doc = " @brief Changes the number of matrix rows."]
    #[doc = ""]
    #[doc = "The methods change the number of matrix rows. If the matrix is reallocated, the first"]
    #[doc = "min(Mat::rows, sz) rows are preserved. The methods emulate the corresponding methods of the STL"]
    #[doc = "vector class."]
    #[doc = "@param sz New number of rows."]
    #[link_name = "\u{1}_ZN2cv3Mat6resizeEm"]
    pub fn cv_Mat_resize(this: *mut cv_Mat, sz: size_t);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param sz New number of rows."]
    #[doc = "@param s Value assigned to the newly added elements."]
    #[link_name = "\u{1}_ZN2cv3Mat6resizeEmRKNS_7Scalar_IdEE"]
    pub fn cv_Mat_resize1(this: *mut cv_Mat, sz: size_t, s: *const cv_Scalar);
}
extern "C" {
    #[doc = "! internal function"]
    #[link_name = "\u{1}_ZN2cv3Mat10push_back_EPKv"]
    pub fn cv_Mat_push_back_(this: *mut cv_Mat, elem: *const ::std::os::raw::c_void);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param m Added line(s)."]
    #[link_name = "\u{1}_ZN2cv3Mat9push_backERKS0_"]
    pub fn cv_Mat_push_back(this: *mut cv_Mat, m: *const cv_Mat);
}
extern "C" {
    #[doc = " @brief Removes elements from the bottom of the matrix."]
    #[doc = ""]
    #[doc = "The method removes one or more rows from the bottom of the matrix."]
    #[doc = "@param nelems Number of removed rows. If it is greater than the total number of rows, an exception"]
    #[doc = "is thrown."]
    #[link_name = "\u{1}_ZN2cv3Mat8pop_backEm"]
    pub fn cv_Mat_pop_back(this: *mut cv_Mat, nelems: size_t);
}
extern "C" {
    #[doc = " @brief Locates the matrix header within a parent matrix."]
    #[doc = ""]
    #[doc = "After you extracted a submatrix from a matrix using Mat::row, Mat::col, Mat::rowRange,"]
    #[doc = "Mat::colRange, and others, the resultant submatrix points just to the part of the original big"]
    #[doc = "matrix. However, each submatrix contains information (represented by datastart and dataend"]
    #[doc = "fields) that helps reconstruct the original matrix size and the position of the extracted"]
    #[doc = "submatrix within the original matrix. The method locateROI does exactly that."]
    #[doc = "@param wholeSize Output parameter that contains the size of the whole matrix containing *this*"]
    #[doc = "as a part."]
    #[doc = "@param ofs Output parameter that contains an offset of *this* inside the whole matrix."]
    #[link_name = "\u{1}_ZNK2cv3Mat9locateROIERNS_5Size_IiEERNS_6Point_IiEE"]
    pub fn cv_Mat_locateROI(this: *const cv_Mat, wholeSize: *mut cv_Size, ofs: *mut cv_Point);
}
extern "C" {
    #[doc = " @brief Adjusts a submatrix size and position within the parent matrix."]
    #[doc = ""]
    #[doc = "The method is complimentary to Mat::locateROI . The typical use of these functions is to determine"]
    #[doc = "the submatrix position within the parent matrix and then shift the position somehow. Typically, it"]
    #[doc = "can be required for filtering operations when pixels outside of the ROI should be taken into"]
    #[doc = "account. When all the method parameters are positive, the ROI needs to grow in all directions by the"]
    #[doc = "specified amount, for example:"]
    #[doc = "@code"]
    #[doc = "A.adjustROI(2, 2, 2, 2);"]
    #[doc = "@endcode"]
    #[doc = "In this example, the matrix size is increased by 4 elements in each direction. The matrix is shifted"]
    #[doc = "by 2 elements to the left and 2 elements up, which brings in all the necessary pixels for the"]
    #[doc = "filtering with the 5x5 kernel."]
    #[doc = ""]
    #[doc = "adjustROI forces the adjusted ROI to be inside of the parent matrix that is boundaries of the"]
    #[doc = "adjusted ROI are constrained by boundaries of the parent matrix. For example, if the submatrix A is"]
    #[doc = "located in the first row of a parent matrix and you called A.adjustROI(2, 2, 2, 2) then A will not"]
    #[doc = "be increased in the upward direction."]
    #[doc = ""]
    #[doc = "The function is used internally by the OpenCV filtering functions, like filter2D , morphological"]
    #[doc = "operations, and so on."]
    #[doc = "@param dtop Shift of the top submatrix boundary upwards."]
    #[doc = "@param dbottom Shift of the bottom submatrix boundary downwards."]
    #[doc = "@param dleft Shift of the left submatrix boundary to the left."]
    #[doc = "@param dright Shift of the right submatrix boundary to the right."]
    #[doc = "@sa copyMakeBorder"]
    #[link_name = "\u{1}_ZN2cv3Mat9adjustROIEiiii"]
    pub fn cv_Mat_adjustROI(
        this: *mut cv_Mat,
        dtop: ::std::os::raw::c_int,
        dbottom: ::std::os::raw::c_int,
        dleft: ::std::os::raw::c_int,
        dright: ::std::os::raw::c_int,
    ) -> *mut cv_Mat;
}
extern "C" {
    #[doc = " @brief Reports whether the matrix is continuous or not."]
    #[doc = ""]
    #[doc = "The method returns true if the matrix elements are stored continuously without gaps at the end of"]
    #[doc = "each row. Otherwise, it returns false. Obviously, 1x1 or 1xN matrices are always continuous."]
    #[doc = "Matrices created with Mat::create are always continuous. But if you extract a part of the matrix"]
    #[doc = "using Mat::col, Mat::diag, and so on, or constructed a matrix header for externally allocated data,"]
    #[doc = "such matrices may no longer have this property."]
    #[doc = ""]
    #[doc = "The continuity flag is stored as a bit in the Mat::flags field and is computed automatically when"]
    #[doc = "you construct a matrix header. Thus, the continuity check is a very fast operation, though"]
    #[doc = "theoretically it could be done as follows:"]
    #[doc = "@code"]
    #[doc = "bool myCheckMatContinuity(const Mat& m)"]
    #[doc = "{"]
    #[doc = "return m.rows == 1 || m.step == m.cols*m.elemSize();"]
    #[doc = "}"]
    #[doc = "@endcode"]
    #[doc = "The method is used in quite a few of OpenCV functions. The point is that element-wise operations"]
    #[doc = "(such as arithmetic and logical operations, math functions, alpha blending, color space"]
    #[doc = "transformations, and others) do not depend on the image geometry. Thus, if all the input and output"]
    #[doc = "arrays are continuous, the functions can process them as very long single-row vectors. The example"]
    #[doc = "below illustrates how an alpha-blending function can be implemented:"]
    #[doc = "@code"]
    #[doc = "template<typename T>"]
    #[doc = "void alphaBlendRGBA(const Mat& src1, const Mat& src2, Mat& dst)"]
    #[doc = "{"]
    #[doc = "const float alpha_scale = (float)std::numeric_limits<T>::max(),"]
    #[doc = "inv_scale = 1.f/alpha_scale;"]
    #[doc = ""]
    #[doc = "CV_Assert( src1.type() == src2.type() &&"]
    #[doc = "src1.type() == CV_MAKETYPE(traits::Depth<T>::value, 4) &&"]
    #[doc = "src1.size() == src2.size());"]
    #[doc = "Size size = src1.size();"]
    #[doc = "dst.create(size, src1.type());"]
    #[doc = ""]
    #[doc = "if( src1.isContinuous() && src2.isContinuous() && dst.isContinuous() )"]
    #[doc = "{"]
    #[doc = "size.width *= size.height;"]
    #[doc = "size.height = 1;"]
    #[doc = "}"]
    #[doc = "size.width *= 4;"]
    #[doc = ""]
    #[doc = "for( int i = 0; i < size.height; i++ )"]
    #[doc = "{"]
    #[doc = "const T* ptr1 = src1.ptr<T>(i);"]
    #[doc = "const T* ptr2 = src2.ptr<T>(i);"]
    #[doc = "T* dptr = dst.ptr<T>(i);"]
    #[doc = ""]
    #[doc = "for( int j = 0; j < size.width; j += 4 )"]
    #[doc = "{"]
    #[doc = "float alpha = ptr1[j+3]*inv_scale, beta = ptr2[j+3]*inv_scale;"]
    #[doc = "dptr[j] = saturate_cast<T>(ptr1[j]*alpha + ptr2[j]*beta);"]
    #[doc = "dptr[j+1] = saturate_cast<T>(ptr1[j+1]*alpha + ptr2[j+1]*beta);"]
    #[doc = "dptr[j+2] = saturate_cast<T>(ptr1[j+2]*alpha + ptr2[j+2]*beta);"]
    #[doc = "dptr[j+3] = saturate_cast<T>((1 - (1-alpha)*(1-beta))*alpha_scale);"]
    #[doc = "}"]
    #[doc = "}"]
    #[doc = "}"]
    #[doc = "@endcode"]
    #[doc = "This approach, while being very simple, can boost the performance of a simple element-operation by"]
    #[doc = "10-20 percents, especially if the image is rather small and the operation is quite simple."]
    #[doc = ""]
    #[doc = "Another OpenCV idiom in this function, a call of Mat::create for the destination array, that"]
    #[doc = "allocates the destination array unless it already has the proper size and type. And while the newly"]
    #[doc = "allocated arrays are always continuous, you still need to check the destination array because"]
    #[doc = "Mat::create does not always allocate a new matrix."]
    #[link_name = "\u{1}_ZNK2cv3Mat12isContinuousEv"]
    pub fn cv_Mat_isContinuous(this: *const cv_Mat) -> bool;
}
extern "C" {
    #[doc = "! returns true if the matrix is a submatrix of another matrix"]
    #[link_name = "\u{1}_ZNK2cv3Mat11isSubmatrixEv"]
    pub fn cv_Mat_isSubmatrix(this: *const cv_Mat) -> bool;
}
extern "C" {
    #[doc = " @brief Returns the matrix element size in bytes."]
    #[doc = ""]
    #[doc = "The method returns the matrix element size in bytes. For example, if the matrix type is CV_16SC3 ,"]
    #[doc = "the method returns 3\\*sizeof(short) or 6."]
    #[link_name = "\u{1}_ZNK2cv3Mat8elemSizeEv"]
    pub fn cv_Mat_elemSize(this: *const cv_Mat) -> size_t;
}
extern "C" {
    #[doc = " @brief Returns the size of each matrix element channel in bytes."]
    #[doc = ""]
    #[doc = "The method returns the matrix element channel size in bytes, that is, it ignores the number of"]
    #[doc = "channels. For example, if the matrix type is CV_16SC3 , the method returns sizeof(short) or 2."]
    #[link_name = "\u{1}_ZNK2cv3Mat9elemSize1Ev"]
    pub fn cv_Mat_elemSize1(this: *const cv_Mat) -> size_t;
}
extern "C" {
    #[doc = " @brief Returns the type of a matrix element."]
    #[doc = ""]
    #[doc = "The method returns a matrix element type. This is an identifier compatible with the CvMat type"]
    #[doc = "system, like CV_16SC3 or 16-bit signed 3-channel array, and so on."]
    #[link_name = "\u{1}_ZNK2cv3Mat4typeEv"]
    pub fn cv_Mat_type(this: *const cv_Mat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Returns the depth of a matrix element."]
    #[doc = ""]
    #[doc = "The method returns the identifier of the matrix element depth (the type of each individual channel)."]
    #[doc = "For example, for a 16-bit signed element array, the method returns CV_16S . A complete list of"]
    #[doc = "matrix types contains the following values:"]
    #[doc = "-   CV_8U - 8-bit unsigned integers ( 0..255 )"]
    #[doc = "-   CV_8S - 8-bit signed integers ( -128..127 )"]
    #[doc = "-   CV_16U - 16-bit unsigned integers ( 0..65535 )"]
    #[doc = "-   CV_16S - 16-bit signed integers ( -32768..32767 )"]
    #[doc = "-   CV_32S - 32-bit signed integers ( -2147483648..2147483647 )"]
    #[doc = "-   CV_32F - 32-bit floating-point numbers ( -FLT_MAX..FLT_MAX, INF, NAN )"]
    #[doc = "-   CV_64F - 64-bit floating-point numbers ( -DBL_MAX..DBL_MAX, INF, NAN )"]
    #[link_name = "\u{1}_ZNK2cv3Mat5depthEv"]
    pub fn cv_Mat_depth(this: *const cv_Mat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Returns the number of matrix channels."]
    #[doc = ""]
    #[doc = "The method returns the number of matrix channels."]
    #[link_name = "\u{1}_ZNK2cv3Mat8channelsEv"]
    pub fn cv_Mat_channels(this: *const cv_Mat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Returns a normalized step."]
    #[doc = ""]
    #[doc = "The method returns a matrix step divided by Mat::elemSize1() . It can be useful to quickly access an"]
    #[doc = "arbitrary matrix element."]
    #[link_name = "\u{1}_ZNK2cv3Mat5step1Ei"]
    pub fn cv_Mat_step1(this: *const cv_Mat, i: ::std::os::raw::c_int) -> size_t;
}
extern "C" {
    #[doc = " @brief Returns true if the array has no elements."]
    #[doc = ""]
    #[doc = "The method returns true if Mat::total() is 0 or if Mat::data is NULL. Because of pop_back() and"]
    #[doc = "resize() methods `M.total() == 0` does not imply that `M.data == NULL`."]
    #[link_name = "\u{1}_ZNK2cv3Mat5emptyEv"]
    pub fn cv_Mat_empty(this: *const cv_Mat) -> bool;
}
extern "C" {
    #[doc = " @brief Returns the total number of array elements."]
    #[doc = ""]
    #[doc = "The method returns the number of array elements (a number of pixels if the array represents an"]
    #[doc = "image)."]
    #[link_name = "\u{1}_ZNK2cv3Mat5totalEv"]
    pub fn cv_Mat_total(this: *const cv_Mat) -> size_t;
}
extern "C" {
    #[doc = " @brief Returns the total number of array elements."]
    #[doc = ""]
    #[doc = "The method returns the number of elements within a certain sub-array slice with startDim <= dim < endDim"]
    #[link_name = "\u{1}_ZNK2cv3Mat5totalEii"]
    pub fn cv_Mat_total1(
        this: *const cv_Mat,
        startDim: ::std::os::raw::c_int,
        endDim: ::std::os::raw::c_int,
    ) -> size_t;
}
extern "C" {
    #[doc = " @param elemChannels Number of channels or number of columns the matrix should have."]
    #[doc = "                     For a 2-D matrix, when the matrix has only 1 column, then it should have"]
    #[doc = "                     elemChannels channels; When the matrix has only 1 channel,"]
    #[doc = "                     then it should have elemChannels columns."]
    #[doc = "                     For a 3-D matrix, it should have only one channel. Furthermore,"]
    #[doc = "                     if the number of planes is not one, then the number of rows"]
    #[doc = "                     within every plane has to be 1; if the number of rows within"]
    #[doc = "                     every plane is not 1, then the number of planes has to be 1."]
    #[doc = " @param depth The depth the matrix should have. Set it to -1 when any depth is fine."]
    #[doc = " @param requireContinuous Set it to true to require the matrix to be continuous"]
    #[doc = " @return -1 if the requirement is not satisfied."]
    #[doc = "         Otherwise, it returns the number of elements in the matrix. Note"]
    #[doc = "         that an element may have multiple channels."]
    #[doc = ""]
    #[doc = " The following code demonstrates its usage for a 2-d matrix:"]
    #[doc = " @snippet snippets/core_mat_checkVector.cpp example-2d"]
    #[doc = ""]
    #[doc = " The following code demonstrates its usage for a 3-d matrix:"]
    #[doc = " @snippet snippets/core_mat_checkVector.cpp example-3d"]
    #[link_name = "\u{1}_ZNK2cv3Mat11checkVectorEiib"]
    pub fn cv_Mat_checkVector(
        this: *const cv_Mat,
        elemChannels: ::std::os::raw::c_int,
        depth: ::std::os::raw::c_int,
        requireContinuous: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @brief Returns a pointer to the specified matrix row."]
    #[doc = ""]
    #[doc = "The methods return `uchar*` or typed pointer to the specified matrix row. See the sample in"]
    #[doc = "Mat::isContinuous to know how to use these methods."]
    #[doc = "@param i0 A 0-based row index."]
    #[link_name = "\u{1}_ZN2cv3Mat3ptrEi"]
    pub fn cv_Mat_ptr(this: *mut cv_Mat, i0: ::std::os::raw::c_int) -> *mut uchar;
}
extern "C" {
    #[doc = " @overload"]
    #[link_name = "\u{1}_ZNK2cv3Mat3ptrEi"]
    pub fn cv_Mat_ptr1(this: *const cv_Mat, i0: ::std::os::raw::c_int) -> *const uchar;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param row Index along the dimension 0"]
    #[doc = "@param col Index along the dimension 1"]
    #[link_name = "\u{1}_ZN2cv3Mat3ptrEii"]
    pub fn cv_Mat_ptr2(
        this: *mut cv_Mat,
        row: ::std::os::raw::c_int,
        col: ::std::os::raw::c_int,
    ) -> *mut uchar;
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param row Index along the dimension 0"]
    #[doc = "@param col Index along the dimension 1"]
    #[link_name = "\u{1}_ZNK2cv3Mat3ptrEii"]
    pub fn cv_Mat_ptr3(
        this: *const cv_Mat,
        row: ::std::os::raw::c_int,
        col: ::std::os::raw::c_int,
    ) -> *const uchar;
}
extern "C" {
    #[doc = " @overload"]
    #[link_name = "\u{1}_ZN2cv3Mat3ptrEiii"]
    pub fn cv_Mat_ptr4(
        this: *mut cv_Mat,
        i0: ::std::os::raw::c_int,
        i1: ::std::os::raw::c_int,
        i2: ::std::os::raw::c_int,
    ) -> *mut uchar;
}
extern "C" {
    #[doc = " @overload"]
    #[link_name = "\u{1}_ZNK2cv3Mat3ptrEiii"]
    pub fn cv_Mat_ptr5(
        this: *const cv_Mat,
        i0: ::std::os::raw::c_int,
        i1: ::std::os::raw::c_int,
        i2: ::std::os::raw::c_int,
    ) -> *const uchar;
}
extern "C" {
    #[doc = " @overload"]
    #[link_name = "\u{1}_ZN2cv3Mat3ptrEPKi"]
    pub fn cv_Mat_ptr6(this: *mut cv_Mat, idx: *const ::std::os::raw::c_int) -> *mut uchar;
}
extern "C" {
    #[doc = " @overload"]
    #[link_name = "\u{1}_ZNK2cv3Mat3ptrEPKi"]
    pub fn cv_Mat_ptr7(this: *const cv_Mat, idx: *const ::std::os::raw::c_int) -> *const uchar;
}
extern "C" {
    #[doc = "! and the standard allocator"]
    #[link_name = "\u{1}_ZN2cv3Mat15getStdAllocatorEv"]
    pub fn cv_Mat_getStdAllocator() -> *mut cv_MatAllocator;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv3Mat19getDefaultAllocatorEv"]
    pub fn cv_Mat_getDefaultAllocator() -> *mut cv_MatAllocator;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv3Mat19setDefaultAllocatorEPNS_12MatAllocatorE"]
    pub fn cv_Mat_setDefaultAllocator(allocator: *mut cv_MatAllocator);
}
extern "C" {
    #[doc = "! internal use method: updates the continuity flag"]
    #[link_name = "\u{1}_ZN2cv3Mat20updateContinuityFlagEv"]
    pub fn cv_Mat_updateContinuityFlag(this: *mut cv_Mat);
}
extern "C" {
    #[doc = "These are various constructors that form a matrix. As noted in the AutomaticAllocation, often"]
    #[doc = "the default constructor is enough, and the proper matrix will be allocated by an OpenCV function."]
    #[doc = "The constructed matrix can further be assigned to another matrix or matrix expression or can be"]
    #[doc = "allocated with Mat::create . In the former case, the old content is de-referenced."]
    #[link_name = "\u{1}_ZN2cv3MatC1Ev"]
    pub fn cv_Mat_Mat(this: *mut cv_Mat);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param rows Number of rows in a 2D array."]
    #[doc = "@param cols Number of columns in a 2D array."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[link_name = "\u{1}_ZN2cv3MatC1Eiii"]
    pub fn cv_Mat_Mat1(
        this: *mut cv_Mat,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param size 2D array size: Size(cols, rows) . In the Size() constructor, the number of rows and the"]
    #[doc = "number of columns go in the reverse order."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[link_name = "\u{1}_ZN2cv3MatC1ENS_5Size_IiEEi"]
    pub fn cv_Mat_Mat2(this: *mut cv_Mat, size: cv_Size, type_: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param rows Number of rows in a 2D array."]
    #[doc = "@param cols Number of columns in a 2D array."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[doc = "@param s An optional value to initialize each matrix element with. To set all the matrix elements to"]
    #[doc = "the particular value after the construction, use the assignment operator"]
    #[doc = "Mat::operator=(const Scalar& value) ."]
    #[link_name = "\u{1}_ZN2cv3MatC1EiiiRKNS_7Scalar_IdEE"]
    pub fn cv_Mat_Mat3(
        this: *mut cv_Mat,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param size 2D array size: Size(cols, rows) . In the Size() constructor, the number of rows and the"]
    #[doc = "number of columns go in the reverse order."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[doc = "@param s An optional value to initialize each matrix element with. To set all the matrix elements to"]
    #[doc = "the particular value after the construction, use the assignment operator"]
    #[doc = "Mat::operator=(const Scalar& value) ."]
    #[link_name = "\u{1}_ZN2cv3MatC1ENS_5Size_IiEEiRKNS_7Scalar_IdEE"]
    pub fn cv_Mat_Mat4(
        this: *mut cv_Mat,
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param ndims Array dimensionality."]
    #[doc = "@param sizes Array of integers specifying an n-dimensional array shape."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[link_name = "\u{1}_ZN2cv3MatC1EiPKii"]
    pub fn cv_Mat_Mat5(
        this: *mut cv_Mat,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param sizes Array of integers specifying an n-dimensional array shape."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKSt6vectorIiSaIiEEi"]
    pub fn cv_Mat_Mat6(
        this: *mut cv_Mat,
        sizes: *const [u64; 3usize],
        type_: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param ndims Array dimensionality."]
    #[doc = "@param sizes Array of integers specifying an n-dimensional array shape."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[doc = "@param s An optional value to initialize each matrix element with. To set all the matrix elements to"]
    #[doc = "the particular value after the construction, use the assignment operator"]
    #[doc = "Mat::operator=(const Scalar& value) ."]
    #[link_name = "\u{1}_ZN2cv3MatC1EiPKiiRKNS_7Scalar_IdEE"]
    pub fn cv_Mat_Mat7(
        this: *mut cv_Mat,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param sizes Array of integers specifying an n-dimensional array shape."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[doc = "@param s An optional value to initialize each matrix element with. To set all the matrix elements to"]
    #[doc = "the particular value after the construction, use the assignment operator"]
    #[doc = "Mat::operator=(const Scalar& value) ."]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKSt6vectorIiSaIiEEiRKNS_7Scalar_IdEE"]
    pub fn cv_Mat_Mat8(
        this: *mut cv_Mat,
        sizes: *const [u64; 3usize],
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied"]
    #[doc = "by these constructors. Instead, the header pointing to m data or its sub-array is constructed and"]
    #[doc = "associated with it. The reference counter, if any, is incremented. So, when you modify the matrix"]
    #[doc = "formed using such a constructor, you also modify the corresponding elements of m . If you want to"]
    #[doc = "have an independent copy of the sub-array, use Mat::clone() ."]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKS0_"]
    pub fn cv_Mat_Mat9(this: *mut cv_Mat, m: *const cv_Mat);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param rows Number of rows in a 2D array."]
    #[doc = "@param cols Number of columns in a 2D array."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[doc = "@param data Pointer to the user data. Matrix constructors that take data and step parameters do not"]
    #[doc = "allocate matrix data. Instead, they just initialize the matrix header that points to the specified"]
    #[doc = "data, which means that no data is copied. This operation is very efficient and can be used to"]
    #[doc = "process external data using OpenCV functions. The external data is not automatically deallocated, so"]
    #[doc = "you should take care of it."]
    #[doc = "@param step Number of bytes each matrix row occupies. The value should include the padding bytes at"]
    #[doc = "the end of each row, if any. If the parameter is missing (set to AUTO_STEP ), no padding is assumed"]
    #[doc = "and the actual step is calculated as cols*elemSize(). See Mat::elemSize."]
    #[link_name = "\u{1}_ZN2cv3MatC1EiiiPvm"]
    pub fn cv_Mat_Mat10(
        this: *mut cv_Mat,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        step: size_t,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param size 2D array size: Size(cols, rows) . In the Size() constructor, the number of rows and the"]
    #[doc = "number of columns go in the reverse order."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[doc = "@param data Pointer to the user data. Matrix constructors that take data and step parameters do not"]
    #[doc = "allocate matrix data. Instead, they just initialize the matrix header that points to the specified"]
    #[doc = "data, which means that no data is copied. This operation is very efficient and can be used to"]
    #[doc = "process external data using OpenCV functions. The external data is not automatically deallocated, so"]
    #[doc = "you should take care of it."]
    #[doc = "@param step Number of bytes each matrix row occupies. The value should include the padding bytes at"]
    #[doc = "the end of each row, if any. If the parameter is missing (set to AUTO_STEP ), no padding is assumed"]
    #[doc = "and the actual step is calculated as cols*elemSize(). See Mat::elemSize."]
    #[link_name = "\u{1}_ZN2cv3MatC1ENS_5Size_IiEEiPvm"]
    pub fn cv_Mat_Mat11(
        this: *mut cv_Mat,
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        step: size_t,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param ndims Array dimensionality."]
    #[doc = "@param sizes Array of integers specifying an n-dimensional array shape."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[doc = "@param data Pointer to the user data. Matrix constructors that take data and step parameters do not"]
    #[doc = "allocate matrix data. Instead, they just initialize the matrix header that points to the specified"]
    #[doc = "data, which means that no data is copied. This operation is very efficient and can be used to"]
    #[doc = "process external data using OpenCV functions. The external data is not automatically deallocated, so"]
    #[doc = "you should take care of it."]
    #[doc = "@param steps Array of ndims-1 steps in case of a multi-dimensional array (the last step is always"]
    #[doc = "set to the element size). If not specified, the matrix is assumed to be continuous."]
    #[link_name = "\u{1}_ZN2cv3MatC1EiPKiiPvPKm"]
    pub fn cv_Mat_Mat12(
        this: *mut cv_Mat,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        steps: *const size_t,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param sizes Array of integers specifying an n-dimensional array shape."]
    #[doc = "@param type Array type. Use CV_8UC1, ..., CV_64FC4 to create 1-4 channel matrices, or"]
    #[doc = "CV_8UC(n), ..., CV_64FC(n) to create multi-channel (up to CV_CN_MAX channels) matrices."]
    #[doc = "@param data Pointer to the user data. Matrix constructors that take data and step parameters do not"]
    #[doc = "allocate matrix data. Instead, they just initialize the matrix header that points to the specified"]
    #[doc = "data, which means that no data is copied. This operation is very efficient and can be used to"]
    #[doc = "process external data using OpenCV functions. The external data is not automatically deallocated, so"]
    #[doc = "you should take care of it."]
    #[doc = "@param steps Array of ndims-1 steps in case of a multi-dimensional array (the last step is always"]
    #[doc = "set to the element size). If not specified, the matrix is assumed to be continuous."]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKSt6vectorIiSaIiEEiPvPKm"]
    pub fn cv_Mat_Mat13(
        this: *mut cv_Mat,
        sizes: *const [u64; 3usize],
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        steps: *const size_t,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied"]
    #[doc = "by these constructors. Instead, the header pointing to m data or its sub-array is constructed and"]
    #[doc = "associated with it. The reference counter, if any, is incremented. So, when you modify the matrix"]
    #[doc = "formed using such a constructor, you also modify the corresponding elements of m . If you want to"]
    #[doc = "have an independent copy of the sub-array, use Mat::clone() ."]
    #[doc = "@param rowRange Range of the m rows to take. As usual, the range start is inclusive and the range"]
    #[doc = "end is exclusive. Use Range::all() to take all the rows."]
    #[doc = "@param colRange Range of the m columns to take. Use Range::all() to take all the columns."]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKS0_RKNS_5RangeES5_"]
    pub fn cv_Mat_Mat14(
        this: *mut cv_Mat,
        m: *const cv_Mat,
        rowRange: *const cv_Range,
        colRange: *const cv_Range,
    );
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied"]
    #[doc = "by these constructors. Instead, the header pointing to m data or its sub-array is constructed and"]
    #[doc = "associated with it. The reference counter, if any, is incremented. So, when you modify the matrix"]
    #[doc = "formed using such a constructor, you also modify the corresponding elements of m . If you want to"]
    #[doc = "have an independent copy of the sub-array, use Mat::clone() ."]
    #[doc = "@param roi Region of interest."]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKS0_RKNS_5Rect_IiEE"]
    pub fn cv_Mat_Mat15(this: *mut cv_Mat, m: *const cv_Mat, roi: *const cv_Rect);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied"]
    #[doc = "by these constructors. Instead, the header pointing to m data or its sub-array is constructed and"]
    #[doc = "associated with it. The reference counter, if any, is incremented. So, when you modify the matrix"]
    #[doc = "formed using such a constructor, you also modify the corresponding elements of m . If you want to"]
    #[doc = "have an independent copy of the sub-array, use Mat::clone() ."]
    #[doc = "@param ranges Array of selected ranges of m along each dimensionality."]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKS0_PKNS_5RangeE"]
    pub fn cv_Mat_Mat16(this: *mut cv_Mat, m: *const cv_Mat, ranges: *const cv_Range);
}
extern "C" {
    #[doc = " @overload"]
    #[doc = "@param m Array that (as a whole or partly) is assigned to the constructed matrix. No data is copied"]
    #[doc = "by these constructors. Instead, the header pointing to m data or its sub-array is constructed and"]
    #[doc = "associated with it. The reference counter, if any, is incremented. So, when you modify the matrix"]
    #[doc = "formed using such a constructor, you also modify the corresponding elements of m . If you want to"]
    #[doc = "have an independent copy of the sub-array, use Mat::clone() ."]
    #[doc = "@param ranges Array of selected ranges of m along each dimensionality."]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKS0_RKSt6vectorINS_5RangeESaIS4_EE"]
    pub fn cv_Mat_Mat17(this: *mut cv_Mat, m: *const cv_Mat, ranges: *const [u64; 3usize]);
}
extern "C" {
    #[doc = "! download data from GpuMat"]
    #[link_name = "\u{1}_ZN2cv3MatC1ERKNS_4cuda6GpuMatE"]
    pub fn cv_Mat_Mat18(this: *mut cv_Mat, m: *const cv_cuda_GpuMat);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv3MatC1EOS0_"]
    pub fn cv_Mat_Mat19(this: *mut cv_Mat, m: *mut cv_Mat);
}
extern "C" {
    #[doc = "! destructor - calls release()"]
    #[link_name = "\u{1}_ZN2cv3MatD1Ev"]
    pub fn cv_Mat_Mat_destructor(this: *mut cv_Mat);
}
impl cv_Mat {
    #[inline]
    pub unsafe fn getUMat(
        &self,
        accessFlags: cv_AccessFlag,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_Mat_getUMat(self, accessFlags, usageFlags)
    }
    #[inline]
    pub unsafe fn row(&self, y: ::std::os::raw::c_int) -> cv_Mat {
        cv_Mat_row(self, y)
    }
    #[inline]
    pub unsafe fn col(&self, x: ::std::os::raw::c_int) -> cv_Mat {
        cv_Mat_col(self, x)
    }
    #[inline]
    pub unsafe fn rowRange(
        &self,
        startrow: ::std::os::raw::c_int,
        endrow: ::std::os::raw::c_int,
    ) -> cv_Mat {
        cv_Mat_rowRange(self, startrow, endrow)
    }
    #[inline]
    pub unsafe fn rowRange1(&self, r: *const cv_Range) -> cv_Mat {
        cv_Mat_rowRange1(self, r)
    }
    #[inline]
    pub unsafe fn colRange(
        &self,
        startcol: ::std::os::raw::c_int,
        endcol: ::std::os::raw::c_int,
    ) -> cv_Mat {
        cv_Mat_colRange(self, startcol, endcol)
    }
    #[inline]
    pub unsafe fn colRange1(&self, r: *const cv_Range) -> cv_Mat {
        cv_Mat_colRange1(self, r)
    }
    #[inline]
    pub unsafe fn diag(&self, d: ::std::os::raw::c_int) -> cv_Mat {
        cv_Mat_diag(self, d)
    }
    #[inline]
    pub unsafe fn diag1(d: *const cv_Mat) -> cv_Mat {
        cv_Mat_diag1(d)
    }
    #[inline]
    pub unsafe fn clone(&self) -> cv_Mat {
        cv_Mat_clone(self)
    }
    #[inline]
    pub unsafe fn copyTo(&self, m: cv_OutputArray) {
        cv_Mat_copyTo(self, m)
    }
    #[inline]
    pub unsafe fn copyTo1(&self, m: cv_OutputArray, mask: cv_InputArray) {
        cv_Mat_copyTo1(self, m, mask)
    }
    #[inline]
    pub unsafe fn convertTo(
        &self,
        m: cv_OutputArray,
        rtype: ::std::os::raw::c_int,
        alpha: f64,
        beta: f64,
    ) {
        cv_Mat_convertTo(self, m, rtype, alpha, beta)
    }
    #[inline]
    pub unsafe fn assignTo(&self, m: *mut cv_Mat, type_: ::std::os::raw::c_int) {
        cv_Mat_assignTo(self, m, type_)
    }
    #[inline]
    pub unsafe fn setTo(&mut self, value: cv_InputArray, mask: cv_InputArray) -> *mut cv_Mat {
        cv_Mat_setTo(self, value, mask)
    }
    #[inline]
    pub unsafe fn reshape(&self, cn: ::std::os::raw::c_int, rows: ::std::os::raw::c_int) -> cv_Mat {
        cv_Mat_reshape(self, cn, rows)
    }
    #[inline]
    pub unsafe fn reshape1(
        &self,
        cn: ::std::os::raw::c_int,
        newndims: ::std::os::raw::c_int,
        newsz: *const ::std::os::raw::c_int,
    ) -> cv_Mat {
        cv_Mat_reshape1(self, cn, newndims, newsz)
    }
    #[inline]
    pub unsafe fn reshape2(
        &self,
        cn: ::std::os::raw::c_int,
        newshape: *const [u64; 3usize],
    ) -> cv_Mat {
        cv_Mat_reshape2(self, cn, newshape)
    }
    #[inline]
    pub unsafe fn t(&self) -> cv_MatExpr {
        cv_Mat_t(self)
    }
    #[inline]
    pub unsafe fn inv(&self, method: ::std::os::raw::c_int) -> cv_MatExpr {
        cv_Mat_inv(self, method)
    }
    #[inline]
    pub unsafe fn mul(&self, m: cv_InputArray, scale: f64) -> cv_MatExpr {
        cv_Mat_mul(self, m, scale)
    }
    #[inline]
    pub unsafe fn cross(&self, m: cv_InputArray) -> cv_Mat {
        cv_Mat_cross(self, m)
    }
    #[inline]
    pub unsafe fn dot(&self, m: cv_InputArray) -> f64 {
        cv_Mat_dot(self, m)
    }
    #[inline]
    pub unsafe fn zeros(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr {
        cv_Mat_zeros(rows, cols, type_)
    }
    #[inline]
    pub unsafe fn zeros1(size: cv_Size, type_: ::std::os::raw::c_int) -> cv_MatExpr {
        cv_Mat_zeros1(size, type_)
    }
    #[inline]
    pub unsafe fn zeros2(
        ndims: ::std::os::raw::c_int,
        sz: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr {
        cv_Mat_zeros2(ndims, sz, type_)
    }
    #[inline]
    pub unsafe fn ones(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr {
        cv_Mat_ones(rows, cols, type_)
    }
    #[inline]
    pub unsafe fn ones1(size: cv_Size, type_: ::std::os::raw::c_int) -> cv_MatExpr {
        cv_Mat_ones1(size, type_)
    }
    #[inline]
    pub unsafe fn ones2(
        ndims: ::std::os::raw::c_int,
        sz: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr {
        cv_Mat_ones2(ndims, sz, type_)
    }
    #[inline]
    pub unsafe fn eye(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> cv_MatExpr {
        cv_Mat_eye(rows, cols, type_)
    }
    #[inline]
    pub unsafe fn eye1(size: cv_Size, type_: ::std::os::raw::c_int) -> cv_MatExpr {
        cv_Mat_eye1(size, type_)
    }
    #[inline]
    pub unsafe fn create(
        &mut self,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) {
        cv_Mat_create(self, rows, cols, type_)
    }
    #[inline]
    pub unsafe fn create1(&mut self, size: cv_Size, type_: ::std::os::raw::c_int) {
        cv_Mat_create1(self, size, type_)
    }
    #[inline]
    pub unsafe fn create2(
        &mut self,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) {
        cv_Mat_create2(self, ndims, sizes, type_)
    }
    #[inline]
    pub unsafe fn create3(&mut self, sizes: *const [u64; 3usize], type_: ::std::os::raw::c_int) {
        cv_Mat_create3(self, sizes, type_)
    }
    #[inline]
    pub unsafe fn addref(&mut self) {
        cv_Mat_addref(self)
    }
    #[inline]
    pub unsafe fn release(&mut self) {
        cv_Mat_release(self)
    }
    #[inline]
    pub unsafe fn deallocate(&mut self) {
        cv_Mat_deallocate(self)
    }
    #[inline]
    pub unsafe fn copySize(&mut self, m: *const cv_Mat) {
        cv_Mat_copySize(self, m)
    }
    #[inline]
    pub unsafe fn reserve(&mut self, sz: size_t) {
        cv_Mat_reserve(self, sz)
    }
    #[inline]
    pub unsafe fn reserveBuffer(&mut self, sz: size_t) {
        cv_Mat_reserveBuffer(self, sz)
    }
    #[inline]
    pub unsafe fn resize(&mut self, sz: size_t) {
        cv_Mat_resize(self, sz)
    }
    #[inline]
    pub unsafe fn resize1(&mut self, sz: size_t, s: *const cv_Scalar) {
        cv_Mat_resize1(self, sz, s)
    }
    #[inline]
    pub unsafe fn push_back_(&mut self, elem: *const ::std::os::raw::c_void) {
        cv_Mat_push_back_(self, elem)
    }
    #[inline]
    pub unsafe fn push_back(&mut self, m: *const cv_Mat) {
        cv_Mat_push_back(self, m)
    }
    #[inline]
    pub unsafe fn pop_back(&mut self, nelems: size_t) {
        cv_Mat_pop_back(self, nelems)
    }
    #[inline]
    pub unsafe fn locateROI(&self, wholeSize: *mut cv_Size, ofs: *mut cv_Point) {
        cv_Mat_locateROI(self, wholeSize, ofs)
    }
    #[inline]
    pub unsafe fn adjustROI(
        &mut self,
        dtop: ::std::os::raw::c_int,
        dbottom: ::std::os::raw::c_int,
        dleft: ::std::os::raw::c_int,
        dright: ::std::os::raw::c_int,
    ) -> *mut cv_Mat {
        cv_Mat_adjustROI(self, dtop, dbottom, dleft, dright)
    }
    #[inline]
    pub unsafe fn isContinuous(&self) -> bool {
        cv_Mat_isContinuous(self)
    }
    #[inline]
    pub unsafe fn isSubmatrix(&self) -> bool {
        cv_Mat_isSubmatrix(self)
    }
    #[inline]
    pub unsafe fn elemSize(&self) -> size_t {
        cv_Mat_elemSize(self)
    }
    #[inline]
    pub unsafe fn elemSize1(&self) -> size_t {
        cv_Mat_elemSize1(self)
    }
    #[inline]
    pub unsafe fn type_(&self) -> ::std::os::raw::c_int {
        cv_Mat_type(self)
    }
    #[inline]
    pub unsafe fn depth(&self) -> ::std::os::raw::c_int {
        cv_Mat_depth(self)
    }
    #[inline]
    pub unsafe fn channels(&self) -> ::std::os::raw::c_int {
        cv_Mat_channels(self)
    }
    #[inline]
    pub unsafe fn step1(&self, i: ::std::os::raw::c_int) -> size_t {
        cv_Mat_step1(self, i)
    }
    #[inline]
    pub unsafe fn empty(&self) -> bool {
        cv_Mat_empty(self)
    }
    #[inline]
    pub unsafe fn total(&self) -> size_t {
        cv_Mat_total(self)
    }
    #[inline]
    pub unsafe fn total1(
        &self,
        startDim: ::std::os::raw::c_int,
        endDim: ::std::os::raw::c_int,
    ) -> size_t {
        cv_Mat_total1(self, startDim, endDim)
    }
    #[inline]
    pub unsafe fn checkVector(
        &self,
        elemChannels: ::std::os::raw::c_int,
        depth: ::std::os::raw::c_int,
        requireContinuous: bool,
    ) -> ::std::os::raw::c_int {
        cv_Mat_checkVector(self, elemChannels, depth, requireContinuous)
    }
    #[inline]
    pub unsafe fn ptr(&mut self, i0: ::std::os::raw::c_int) -> *mut uchar {
        cv_Mat_ptr(self, i0)
    }
    #[inline]
    pub unsafe fn ptr1(&self, i0: ::std::os::raw::c_int) -> *const uchar {
        cv_Mat_ptr1(self, i0)
    }
    #[inline]
    pub unsafe fn ptr2(
        &mut self,
        row: ::std::os::raw::c_int,
        col: ::std::os::raw::c_int,
    ) -> *mut uchar {
        cv_Mat_ptr2(self, row, col)
    }
    #[inline]
    pub unsafe fn ptr3(
        &self,
        row: ::std::os::raw::c_int,
        col: ::std::os::raw::c_int,
    ) -> *const uchar {
        cv_Mat_ptr3(self, row, col)
    }
    #[inline]
    pub unsafe fn ptr4(
        &mut self,
        i0: ::std::os::raw::c_int,
        i1: ::std::os::raw::c_int,
        i2: ::std::os::raw::c_int,
    ) -> *mut uchar {
        cv_Mat_ptr4(self, i0, i1, i2)
    }
    #[inline]
    pub unsafe fn ptr5(
        &self,
        i0: ::std::os::raw::c_int,
        i1: ::std::os::raw::c_int,
        i2: ::std::os::raw::c_int,
    ) -> *const uchar {
        cv_Mat_ptr5(self, i0, i1, i2)
    }
    #[inline]
    pub unsafe fn ptr6(&mut self, idx: *const ::std::os::raw::c_int) -> *mut uchar {
        cv_Mat_ptr6(self, idx)
    }
    #[inline]
    pub unsafe fn ptr7(&self, idx: *const ::std::os::raw::c_int) -> *const uchar {
        cv_Mat_ptr7(self, idx)
    }
    #[inline]
    pub unsafe fn getStdAllocator() -> *mut cv_MatAllocator {
        cv_Mat_getStdAllocator()
    }
    #[inline]
    pub unsafe fn getDefaultAllocator() -> *mut cv_MatAllocator {
        cv_Mat_getDefaultAllocator()
    }
    #[inline]
    pub unsafe fn setDefaultAllocator(allocator: *mut cv_MatAllocator) {
        cv_Mat_setDefaultAllocator(allocator)
    }
    #[inline]
    pub unsafe fn updateContinuityFlag(&mut self) {
        cv_Mat_updateContinuityFlag(self)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat1(__bindgen_tmp.as_mut_ptr(), rows, cols, type_);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(size: cv_Size, type_: ::std::os::raw::c_int) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat2(__bindgen_tmp.as_mut_ptr(), size, type_);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat3(__bindgen_tmp.as_mut_ptr(), rows, cols, type_, s);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new4(size: cv_Size, type_: ::std::os::raw::c_int, s: *const cv_Scalar) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat4(__bindgen_tmp.as_mut_ptr(), size, type_, s);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new5(
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat5(__bindgen_tmp.as_mut_ptr(), ndims, sizes, type_);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new6(sizes: *const [u64; 3usize], type_: ::std::os::raw::c_int) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat6(__bindgen_tmp.as_mut_ptr(), sizes, type_);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new7(
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat7(__bindgen_tmp.as_mut_ptr(), ndims, sizes, type_, s);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new8(
        sizes: *const [u64; 3usize],
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat8(__bindgen_tmp.as_mut_ptr(), sizes, type_, s);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new9(m: *const cv_Mat) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat9(__bindgen_tmp.as_mut_ptr(), m);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new10(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        step: size_t,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat10(__bindgen_tmp.as_mut_ptr(), rows, cols, type_, data, step);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new11(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        step: size_t,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat11(__bindgen_tmp.as_mut_ptr(), size, type_, data, step);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new12(
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        steps: *const size_t,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat12(__bindgen_tmp.as_mut_ptr(), ndims, sizes, type_, data, steps);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new13(
        sizes: *const [u64; 3usize],
        type_: ::std::os::raw::c_int,
        data: *mut ::std::os::raw::c_void,
        steps: *const size_t,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat13(__bindgen_tmp.as_mut_ptr(), sizes, type_, data, steps);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new14(
        m: *const cv_Mat,
        rowRange: *const cv_Range,
        colRange: *const cv_Range,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat14(__bindgen_tmp.as_mut_ptr(), m, rowRange, colRange);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new15(m: *const cv_Mat, roi: *const cv_Rect) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat15(__bindgen_tmp.as_mut_ptr(), m, roi);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new16(m: *const cv_Mat, ranges: *const cv_Range) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat16(__bindgen_tmp.as_mut_ptr(), m, ranges);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new17(m: *const cv_Mat, ranges: *const [u64; 3usize]) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat17(__bindgen_tmp.as_mut_ptr(), m, ranges);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new18(m: *const cv_cuda_GpuMat) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat18(__bindgen_tmp.as_mut_ptr(), m);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new19(m: *mut cv_Mat) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_Mat_Mat19(__bindgen_tmp.as_mut_ptr(), m);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        cv_Mat_Mat_destructor(self)
    }
}
#[doc = " @todo document"]
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct cv_UMat {
    pub _bindgen_opaque_blob: [u64; 10usize],
}
pub const cv_UMat_MAGIC_VAL: ::std::os::raw::c_uint = 1124007936;
pub const cv_UMat_AUTO_STEP: ::std::os::raw::c_uint = 0;
pub const cv_UMat_CONTINUOUS_FLAG: ::std::os::raw::c_uint = 16384;
pub const cv_UMat_SUBMATRIX_FLAG: ::std::os::raw::c_uint = 32768;
pub type cv_UMat__bindgen_ty_1 = ::std::os::raw::c_uint;
pub const cv_UMat_MAGIC_MASK: ::std::os::raw::c_uint = 4294901760;
pub const cv_UMat_TYPE_MASK: ::std::os::raw::c_uint = 4095;
pub const cv_UMat_DEPTH_MASK: ::std::os::raw::c_uint = 7;
pub type cv_UMat__bindgen_ty_2 = ::std::os::raw::c_uint;
#[test]
fn bindgen_test_layout_cv_UMat() {
    assert_eq!(
        ::std::mem::size_of::<cv_UMat>(),
        80usize,
        concat!("Size of: ", stringify!(cv_UMat))
    );
    assert_eq!(
        ::std::mem::align_of::<cv_UMat>(),
        8usize,
        concat!("Alignment of ", stringify!(cv_UMat))
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv4UMat6getMatENS_10AccessFlagE"]
    pub fn cv_UMat_getMat(this: *const cv_UMat, flags: cv_AccessFlag) -> cv_Mat;
}
extern "C" {
    #[doc = "! returns a new matrix header for the specified row"]
    #[link_name = "\u{1}_ZNK2cv4UMat3rowEi"]
    pub fn cv_UMat_row(this: *const cv_UMat, y: ::std::os::raw::c_int) -> cv_UMat;
}
extern "C" {
    #[doc = "! returns a new matrix header for the specified column"]
    #[link_name = "\u{1}_ZNK2cv4UMat3colEi"]
    pub fn cv_UMat_col(this: *const cv_UMat, x: ::std::os::raw::c_int) -> cv_UMat;
}
extern "C" {
    #[doc = "! ... for the specified row span"]
    #[link_name = "\u{1}_ZNK2cv4UMat8rowRangeEii"]
    pub fn cv_UMat_rowRange(
        this: *const cv_UMat,
        startrow: ::std::os::raw::c_int,
        endrow: ::std::os::raw::c_int,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv4UMat8rowRangeERKNS_5RangeE"]
    pub fn cv_UMat_rowRange1(this: *const cv_UMat, r: *const cv_Range) -> cv_UMat;
}
extern "C" {
    #[doc = "! ... for the specified column span"]
    #[link_name = "\u{1}_ZNK2cv4UMat8colRangeEii"]
    pub fn cv_UMat_colRange(
        this: *const cv_UMat,
        startcol: ::std::os::raw::c_int,
        endcol: ::std::os::raw::c_int,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv4UMat8colRangeERKNS_5RangeE"]
    pub fn cv_UMat_colRange1(this: *const cv_UMat, r: *const cv_Range) -> cv_UMat;
}
extern "C" {
    #[doc = "! ... for the specified diagonal"]
    #[doc = "! (d=0 - the main diagonal,"]
    #[doc = "!  >0 - a diagonal from the upper half,"]
    #[doc = "!  <0 - a diagonal from the lower half)"]
    #[link_name = "\u{1}_ZNK2cv4UMat4diagEi"]
    pub fn cv_UMat_diag(this: *const cv_UMat, d: ::std::os::raw::c_int) -> cv_UMat;
}
extern "C" {
    #[doc = "! constructs a square diagonal matrix which main diagonal is vector \"d\""]
    #[link_name = "\u{1}_ZN2cv4UMat4diagERKS0_NS_14UMatUsageFlagsE"]
    pub fn cv_UMat_diag1(d: *const cv_UMat, usageFlags: cv_UMatUsageFlags) -> cv_UMat;
}
extern "C" {
    #[doc = "! returns deep copy of the matrix, i.e. the data is copied"]
    #[link_name = "\u{1}_ZNK2cv4UMat5cloneEv"]
    pub fn cv_UMat_clone(this: *const cv_UMat) -> cv_UMat;
}
extern "C" {
    #[doc = "! copies the matrix content to \"m\"."]
    #[link_name = "\u{1}_ZNK2cv4UMat6copyToERKNS_12_OutputArrayE"]
    pub fn cv_UMat_copyTo(this: *const cv_UMat, m: cv_OutputArray);
}
extern "C" {
    #[doc = "! copies those matrix elements to \"m\" that are marked with non-zero mask elements."]
    #[link_name = "\u{1}_ZNK2cv4UMat6copyToERKNS_12_OutputArrayERKNS_11_InputArrayE"]
    pub fn cv_UMat_copyTo1(this: *const cv_UMat, m: cv_OutputArray, mask: cv_InputArray);
}
extern "C" {
    #[doc = "! converts matrix to another datatype with optional scaling. See cvConvertScale."]
    #[link_name = "\u{1}_ZNK2cv4UMat9convertToERKNS_12_OutputArrayEidd"]
    pub fn cv_UMat_convertTo(
        this: *const cv_UMat,
        m: cv_OutputArray,
        rtype: ::std::os::raw::c_int,
        alpha: f64,
        beta: f64,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv4UMat8assignToERS0_i"]
    pub fn cv_UMat_assignTo(this: *const cv_UMat, m: *mut cv_UMat, type_: ::std::os::raw::c_int);
}
extern "C" {
    #[doc = "! sets some of the matrix elements to s, according to the mask"]
    #[link_name = "\u{1}_ZN2cv4UMat5setToERKNS_11_InputArrayES3_"]
    pub fn cv_UMat_setTo(
        this: *mut cv_UMat,
        value: cv_InputArray,
        mask: cv_InputArray,
    ) -> *mut cv_UMat;
}
extern "C" {
    #[doc = "! creates alternative matrix header for the same data, with different"]
    #[link_name = "\u{1}_ZNK2cv4UMat7reshapeEii"]
    pub fn cv_UMat_reshape(
        this: *const cv_UMat,
        cn: ::std::os::raw::c_int,
        rows: ::std::os::raw::c_int,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv4UMat7reshapeEiiPKi"]
    pub fn cv_UMat_reshape1(
        this: *const cv_UMat,
        cn: ::std::os::raw::c_int,
        newndims: ::std::os::raw::c_int,
        newsz: *const ::std::os::raw::c_int,
    ) -> cv_UMat;
}
extern "C" {
    #[doc = "! matrix transposition by means of matrix expressions"]
    #[link_name = "\u{1}_ZNK2cv4UMat1tEv"]
    pub fn cv_UMat_t(this: *const cv_UMat) -> cv_UMat;
}
extern "C" {
    #[doc = "! matrix inversion by means of matrix expressions"]
    #[link_name = "\u{1}_ZNK2cv4UMat3invEi"]
    pub fn cv_UMat_inv(this: *const cv_UMat, method: ::std::os::raw::c_int) -> cv_UMat;
}
extern "C" {
    #[doc = "! per-element matrix multiplication by means of matrix expressions"]
    #[link_name = "\u{1}_ZNK2cv4UMat3mulERKNS_11_InputArrayEd"]
    pub fn cv_UMat_mul(this: *const cv_UMat, m: cv_InputArray, scale: f64) -> cv_UMat;
}
extern "C" {
    #[doc = "! computes dot-product"]
    #[link_name = "\u{1}_ZNK2cv4UMat3dotERKNS_11_InputArrayE"]
    pub fn cv_UMat_dot(this: *const cv_UMat, m: cv_InputArray) -> f64;
}
extern "C" {
    #[doc = "! Matlab-style matrix initialization"]
    #[link_name = "\u{1}_ZN2cv4UMat5zerosEiiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_zeros(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat5zerosENS_5Size_IiEEiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_zeros1(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat5zerosEiPKiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_zeros2(
        ndims: ::std::os::raw::c_int,
        sz: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat4onesEiiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_ones(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat4onesENS_5Size_IiEEiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_ones1(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat4onesEiPKiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_ones2(
        ndims: ::std::os::raw::c_int,
        sz: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat3eyeEiiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_eye(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat3eyeENS_5Size_IiEEiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_eye1(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat;
}
extern "C" {
    #[doc = "! allocates new matrix data unless the matrix already has specified size and type."]
    #[link_name = "\u{1}_ZN2cv4UMat6createEiiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_create(
        this: *mut cv_UMat,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat6createENS_5Size_IiEEiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_create1(
        this: *mut cv_UMat,
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat6createEiPKiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_create2(
        this: *mut cv_UMat,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMat6createERKSt6vectorIiSaIiEEiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_create3(
        this: *mut cv_UMat,
        sizes: *const [u64; 3usize],
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[doc = "! increases the reference counter; use with care to avoid memleaks"]
    #[link_name = "\u{1}_ZN2cv4UMat6addrefEv"]
    pub fn cv_UMat_addref(this: *mut cv_UMat);
}
extern "C" {
    #[doc = "! decreases reference counter;"]
    #[link_name = "\u{1}_ZN2cv4UMat7releaseEv"]
    pub fn cv_UMat_release(this: *mut cv_UMat);
}
extern "C" {
    #[doc = "! deallocates the matrix data"]
    #[link_name = "\u{1}_ZN2cv4UMat10deallocateEv"]
    pub fn cv_UMat_deallocate(this: *mut cv_UMat);
}
extern "C" {
    #[doc = "! internal use function; properly re-allocates _size, _step arrays"]
    #[link_name = "\u{1}_ZN2cv4UMat8copySizeERKS0_"]
    pub fn cv_UMat_copySize(this: *mut cv_UMat, m: *const cv_UMat);
}
extern "C" {
    #[doc = "! locates matrix header within a parent matrix. See below"]
    #[link_name = "\u{1}_ZNK2cv4UMat9locateROIERNS_5Size_IiEERNS_6Point_IiEE"]
    pub fn cv_UMat_locateROI(this: *const cv_UMat, wholeSize: *mut cv_Size, ofs: *mut cv_Point);
}
extern "C" {
    #[doc = "! moves/resizes the current matrix ROI inside the parent matrix."]
    #[link_name = "\u{1}_ZN2cv4UMat9adjustROIEiiii"]
    pub fn cv_UMat_adjustROI(
        this: *mut cv_UMat,
        dtop: ::std::os::raw::c_int,
        dbottom: ::std::os::raw::c_int,
        dleft: ::std::os::raw::c_int,
        dright: ::std::os::raw::c_int,
    ) -> *mut cv_UMat;
}
extern "C" {
    #[doc = "! returns true iff the matrix data is continuous"]
    #[link_name = "\u{1}_ZNK2cv4UMat12isContinuousEv"]
    pub fn cv_UMat_isContinuous(this: *const cv_UMat) -> bool;
}
extern "C" {
    #[doc = "! returns true if the matrix is a submatrix of another matrix"]
    #[link_name = "\u{1}_ZNK2cv4UMat11isSubmatrixEv"]
    pub fn cv_UMat_isSubmatrix(this: *const cv_UMat) -> bool;
}
extern "C" {
    #[doc = "! returns element size in bytes,"]
    #[link_name = "\u{1}_ZNK2cv4UMat8elemSizeEv"]
    pub fn cv_UMat_elemSize(this: *const cv_UMat) -> size_t;
}
extern "C" {
    #[doc = "! returns the size of element channel in bytes."]
    #[link_name = "\u{1}_ZNK2cv4UMat9elemSize1Ev"]
    pub fn cv_UMat_elemSize1(this: *const cv_UMat) -> size_t;
}
extern "C" {
    #[doc = "! returns element type, similar to CV_MAT_TYPE(cvmat->type)"]
    #[link_name = "\u{1}_ZNK2cv4UMat4typeEv"]
    pub fn cv_UMat_type(this: *const cv_UMat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "! returns element type, similar to CV_MAT_DEPTH(cvmat->type)"]
    #[link_name = "\u{1}_ZNK2cv4UMat5depthEv"]
    pub fn cv_UMat_depth(this: *const cv_UMat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "! returns element type, similar to CV_MAT_CN(cvmat->type)"]
    #[link_name = "\u{1}_ZNK2cv4UMat8channelsEv"]
    pub fn cv_UMat_channels(this: *const cv_UMat) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "! returns step/elemSize1()"]
    #[link_name = "\u{1}_ZNK2cv4UMat5step1Ei"]
    pub fn cv_UMat_step1(this: *const cv_UMat, i: ::std::os::raw::c_int) -> size_t;
}
extern "C" {
    #[doc = "! returns true if matrix data is NULL"]
    #[link_name = "\u{1}_ZNK2cv4UMat5emptyEv"]
    pub fn cv_UMat_empty(this: *const cv_UMat) -> bool;
}
extern "C" {
    #[doc = "! returns the total number of matrix elements"]
    #[link_name = "\u{1}_ZNK2cv4UMat5totalEv"]
    pub fn cv_UMat_total(this: *const cv_UMat) -> size_t;
}
extern "C" {
    #[doc = "! returns N if the matrix is 1-channel (N x ptdim) or ptdim-channel (1 x N) or (N x 1); negative number otherwise"]
    #[link_name = "\u{1}_ZNK2cv4UMat11checkVectorEiib"]
    pub fn cv_UMat_checkVector(
        this: *const cv_UMat,
        elemChannels: ::std::os::raw::c_int,
        depth: ::std::os::raw::c_int,
        requireContinuous: bool,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the OpenCL buffer handle on which UMat operates on."]
    #[doc = "The UMat instance should be kept alive during the use of the handle to prevent the buffer to be"]
    #[doc = "returned to the OpenCV buffer pool."]
    #[link_name = "\u{1}_ZNK2cv4UMat6handleENS_10AccessFlagE"]
    pub fn cv_UMat_handle(
        this: *const cv_UMat,
        accessFlags: cv_AccessFlag,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv4UMat8ndoffsetEPm"]
    pub fn cv_UMat_ndoffset(this: *const cv_UMat, ofs: *mut size_t);
}
extern "C" {
    #[doc = "! and the standard allocator"]
    #[link_name = "\u{1}_ZN2cv4UMat15getStdAllocatorEv"]
    pub fn cv_UMat_getStdAllocator() -> *mut cv_MatAllocator;
}
extern "C" {
    #[doc = "! internal use method: updates the continuity flag"]
    #[link_name = "\u{1}_ZN2cv4UMat20updateContinuityFlagEv"]
    pub fn cv_UMat_updateContinuityFlag(this: *mut cv_UMat);
}
extern "C" {
    #[doc = "! default constructor"]
    #[link_name = "\u{1}_ZN2cv4UMatC1ENS_14UMatUsageFlagsE"]
    pub fn cv_UMat_UMat(this: *mut cv_UMat, usageFlags: cv_UMatUsageFlags);
}
extern "C" {
    #[doc = "! constructs 2D matrix of the specified size and type"]
    #[link_name = "\u{1}_ZN2cv4UMatC1EiiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_UMat1(
        this: *mut cv_UMat,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMatC1ENS_5Size_IiEEiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_UMat2(
        this: *mut cv_UMat,
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[doc = "! constructs 2D matrix and fills it with the specified value _s."]
    #[link_name = "\u{1}_ZN2cv4UMatC1EiiiRKNS_7Scalar_IdEENS_14UMatUsageFlagsE"]
    pub fn cv_UMat_UMat3(
        this: *mut cv_UMat,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMatC1ENS_5Size_IiEEiRKNS_7Scalar_IdEENS_14UMatUsageFlagsE"]
    pub fn cv_UMat_UMat4(
        this: *mut cv_UMat,
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[doc = "! constructs n-dimensional matrix"]
    #[link_name = "\u{1}_ZN2cv4UMatC1EiPKiiNS_14UMatUsageFlagsE"]
    pub fn cv_UMat_UMat5(
        this: *mut cv_UMat,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMatC1EiPKiiRKNS_7Scalar_IdEENS_14UMatUsageFlagsE"]
    pub fn cv_UMat_UMat6(
        this: *mut cv_UMat,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
        usageFlags: cv_UMatUsageFlags,
    );
}
extern "C" {
    #[doc = "! copy constructor"]
    #[link_name = "\u{1}_ZN2cv4UMatC1ERKS0_"]
    pub fn cv_UMat_UMat7(this: *mut cv_UMat, m: *const cv_UMat);
}
extern "C" {
    #[doc = "! creates a matrix header for a part of the bigger matrix"]
    #[link_name = "\u{1}_ZN2cv4UMatC1ERKS0_RKNS_5RangeES5_"]
    pub fn cv_UMat_UMat8(
        this: *mut cv_UMat,
        m: *const cv_UMat,
        rowRange: *const cv_Range,
        colRange: *const cv_Range,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMatC1ERKS0_RKNS_5Rect_IiEE"]
    pub fn cv_UMat_UMat9(this: *mut cv_UMat, m: *const cv_UMat, roi: *const cv_Rect);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMatC1ERKS0_PKNS_5RangeE"]
    pub fn cv_UMat_UMat10(this: *mut cv_UMat, m: *const cv_UMat, ranges: *const cv_Range);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMatC1ERKS0_RKSt6vectorINS_5RangeESaIS4_EE"]
    pub fn cv_UMat_UMat11(this: *mut cv_UMat, m: *const cv_UMat, ranges: *const [u64; 3usize]);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv4UMatC1EOS0_"]
    pub fn cv_UMat_UMat12(this: *mut cv_UMat, m: *mut cv_UMat);
}
extern "C" {
    #[doc = "! destructor - calls release()"]
    #[link_name = "\u{1}_ZN2cv4UMatD1Ev"]
    pub fn cv_UMat_UMat_destructor(this: *mut cv_UMat);
}
impl cv_UMat {
    #[inline]
    pub unsafe fn getMat(&self, flags: cv_AccessFlag) -> cv_Mat {
        cv_UMat_getMat(self, flags)
    }
    #[inline]
    pub unsafe fn row(&self, y: ::std::os::raw::c_int) -> cv_UMat {
        cv_UMat_row(self, y)
    }
    #[inline]
    pub unsafe fn col(&self, x: ::std::os::raw::c_int) -> cv_UMat {
        cv_UMat_col(self, x)
    }
    #[inline]
    pub unsafe fn rowRange(
        &self,
        startrow: ::std::os::raw::c_int,
        endrow: ::std::os::raw::c_int,
    ) -> cv_UMat {
        cv_UMat_rowRange(self, startrow, endrow)
    }
    #[inline]
    pub unsafe fn rowRange1(&self, r: *const cv_Range) -> cv_UMat {
        cv_UMat_rowRange1(self, r)
    }
    #[inline]
    pub unsafe fn colRange(
        &self,
        startcol: ::std::os::raw::c_int,
        endcol: ::std::os::raw::c_int,
    ) -> cv_UMat {
        cv_UMat_colRange(self, startcol, endcol)
    }
    #[inline]
    pub unsafe fn colRange1(&self, r: *const cv_Range) -> cv_UMat {
        cv_UMat_colRange1(self, r)
    }
    #[inline]
    pub unsafe fn diag(&self, d: ::std::os::raw::c_int) -> cv_UMat {
        cv_UMat_diag(self, d)
    }
    #[inline]
    pub unsafe fn diag1(d: *const cv_UMat, usageFlags: cv_UMatUsageFlags) -> cv_UMat {
        cv_UMat_diag1(d, usageFlags)
    }
    #[inline]
    pub unsafe fn clone(&self) -> cv_UMat {
        cv_UMat_clone(self)
    }
    #[inline]
    pub unsafe fn copyTo(&self, m: cv_OutputArray) {
        cv_UMat_copyTo(self, m)
    }
    #[inline]
    pub unsafe fn copyTo1(&self, m: cv_OutputArray, mask: cv_InputArray) {
        cv_UMat_copyTo1(self, m, mask)
    }
    #[inline]
    pub unsafe fn convertTo(
        &self,
        m: cv_OutputArray,
        rtype: ::std::os::raw::c_int,
        alpha: f64,
        beta: f64,
    ) {
        cv_UMat_convertTo(self, m, rtype, alpha, beta)
    }
    #[inline]
    pub unsafe fn assignTo(&self, m: *mut cv_UMat, type_: ::std::os::raw::c_int) {
        cv_UMat_assignTo(self, m, type_)
    }
    #[inline]
    pub unsafe fn setTo(&mut self, value: cv_InputArray, mask: cv_InputArray) -> *mut cv_UMat {
        cv_UMat_setTo(self, value, mask)
    }
    #[inline]
    pub unsafe fn reshape(
        &self,
        cn: ::std::os::raw::c_int,
        rows: ::std::os::raw::c_int,
    ) -> cv_UMat {
        cv_UMat_reshape(self, cn, rows)
    }
    #[inline]
    pub unsafe fn reshape1(
        &self,
        cn: ::std::os::raw::c_int,
        newndims: ::std::os::raw::c_int,
        newsz: *const ::std::os::raw::c_int,
    ) -> cv_UMat {
        cv_UMat_reshape1(self, cn, newndims, newsz)
    }
    #[inline]
    pub unsafe fn t(&self) -> cv_UMat {
        cv_UMat_t(self)
    }
    #[inline]
    pub unsafe fn inv(&self, method: ::std::os::raw::c_int) -> cv_UMat {
        cv_UMat_inv(self, method)
    }
    #[inline]
    pub unsafe fn mul(&self, m: cv_InputArray, scale: f64) -> cv_UMat {
        cv_UMat_mul(self, m, scale)
    }
    #[inline]
    pub unsafe fn dot(&self, m: cv_InputArray) -> f64 {
        cv_UMat_dot(self, m)
    }
    #[inline]
    pub unsafe fn zeros(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_UMat_zeros(rows, cols, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn zeros1(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_UMat_zeros1(size, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn zeros2(
        ndims: ::std::os::raw::c_int,
        sz: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_UMat_zeros2(ndims, sz, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn ones(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_UMat_ones(rows, cols, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn ones1(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_UMat_ones1(size, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn ones2(
        ndims: ::std::os::raw::c_int,
        sz: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_UMat_ones2(ndims, sz, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn eye(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_UMat_eye(rows, cols, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn eye1(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> cv_UMat {
        cv_UMat_eye1(size, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn create(
        &mut self,
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) {
        cv_UMat_create(self, rows, cols, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn create1(
        &mut self,
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) {
        cv_UMat_create1(self, size, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn create2(
        &mut self,
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) {
        cv_UMat_create2(self, ndims, sizes, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn create3(
        &mut self,
        sizes: *const [u64; 3usize],
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) {
        cv_UMat_create3(self, sizes, type_, usageFlags)
    }
    #[inline]
    pub unsafe fn addref(&mut self) {
        cv_UMat_addref(self)
    }
    #[inline]
    pub unsafe fn release(&mut self) {
        cv_UMat_release(self)
    }
    #[inline]
    pub unsafe fn deallocate(&mut self) {
        cv_UMat_deallocate(self)
    }
    #[inline]
    pub unsafe fn copySize(&mut self, m: *const cv_UMat) {
        cv_UMat_copySize(self, m)
    }
    #[inline]
    pub unsafe fn locateROI(&self, wholeSize: *mut cv_Size, ofs: *mut cv_Point) {
        cv_UMat_locateROI(self, wholeSize, ofs)
    }
    #[inline]
    pub unsafe fn adjustROI(
        &mut self,
        dtop: ::std::os::raw::c_int,
        dbottom: ::std::os::raw::c_int,
        dleft: ::std::os::raw::c_int,
        dright: ::std::os::raw::c_int,
    ) -> *mut cv_UMat {
        cv_UMat_adjustROI(self, dtop, dbottom, dleft, dright)
    }
    #[inline]
    pub unsafe fn isContinuous(&self) -> bool {
        cv_UMat_isContinuous(self)
    }
    #[inline]
    pub unsafe fn isSubmatrix(&self) -> bool {
        cv_UMat_isSubmatrix(self)
    }
    #[inline]
    pub unsafe fn elemSize(&self) -> size_t {
        cv_UMat_elemSize(self)
    }
    #[inline]
    pub unsafe fn elemSize1(&self) -> size_t {
        cv_UMat_elemSize1(self)
    }
    #[inline]
    pub unsafe fn type_(&self) -> ::std::os::raw::c_int {
        cv_UMat_type(self)
    }
    #[inline]
    pub unsafe fn depth(&self) -> ::std::os::raw::c_int {
        cv_UMat_depth(self)
    }
    #[inline]
    pub unsafe fn channels(&self) -> ::std::os::raw::c_int {
        cv_UMat_channels(self)
    }
    #[inline]
    pub unsafe fn step1(&self, i: ::std::os::raw::c_int) -> size_t {
        cv_UMat_step1(self, i)
    }
    #[inline]
    pub unsafe fn empty(&self) -> bool {
        cv_UMat_empty(self)
    }
    #[inline]
    pub unsafe fn total(&self) -> size_t {
        cv_UMat_total(self)
    }
    #[inline]
    pub unsafe fn checkVector(
        &self,
        elemChannels: ::std::os::raw::c_int,
        depth: ::std::os::raw::c_int,
        requireContinuous: bool,
    ) -> ::std::os::raw::c_int {
        cv_UMat_checkVector(self, elemChannels, depth, requireContinuous)
    }
    #[inline]
    pub unsafe fn handle(&self, accessFlags: cv_AccessFlag) -> *mut ::std::os::raw::c_void {
        cv_UMat_handle(self, accessFlags)
    }
    #[inline]
    pub unsafe fn ndoffset(&self, ofs: *mut size_t) {
        cv_UMat_ndoffset(self, ofs)
    }
    #[inline]
    pub unsafe fn getStdAllocator() -> *mut cv_MatAllocator {
        cv_UMat_getStdAllocator()
    }
    #[inline]
    pub unsafe fn updateContinuityFlag(&mut self) {
        cv_UMat_updateContinuityFlag(self)
    }
    #[inline]
    pub unsafe fn new(usageFlags: cv_UMatUsageFlags) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat(__bindgen_tmp.as_mut_ptr(), usageFlags);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat1(__bindgen_tmp.as_mut_ptr(), rows, cols, type_, usageFlags);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat2(__bindgen_tmp.as_mut_ptr(), size, type_, usageFlags);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new3(
        rows: ::std::os::raw::c_int,
        cols: ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
        usageFlags: cv_UMatUsageFlags,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat3(__bindgen_tmp.as_mut_ptr(), rows, cols, type_, s, usageFlags);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new4(
        size: cv_Size,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
        usageFlags: cv_UMatUsageFlags,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat4(__bindgen_tmp.as_mut_ptr(), size, type_, s, usageFlags);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new5(
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        usageFlags: cv_UMatUsageFlags,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat5(__bindgen_tmp.as_mut_ptr(), ndims, sizes, type_, usageFlags);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new6(
        ndims: ::std::os::raw::c_int,
        sizes: *const ::std::os::raw::c_int,
        type_: ::std::os::raw::c_int,
        s: *const cv_Scalar,
        usageFlags: cv_UMatUsageFlags,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat6(
            __bindgen_tmp.as_mut_ptr(),
            ndims,
            sizes,
            type_,
            s,
            usageFlags,
        );
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new7(m: *const cv_UMat) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat7(__bindgen_tmp.as_mut_ptr(), m);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new8(
        m: *const cv_UMat,
        rowRange: *const cv_Range,
        colRange: *const cv_Range,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat8(__bindgen_tmp.as_mut_ptr(), m, rowRange, colRange);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new9(m: *const cv_UMat, roi: *const cv_Rect) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat9(__bindgen_tmp.as_mut_ptr(), m, roi);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new10(m: *const cv_UMat, ranges: *const cv_Range) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat10(__bindgen_tmp.as_mut_ptr(), m, ranges);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new11(m: *const cv_UMat, ranges: *const [u64; 3usize]) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat11(__bindgen_tmp.as_mut_ptr(), m, ranges);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new12(m: *mut cv_UMat) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_UMat_UMat12(__bindgen_tmp.as_mut_ptr(), m);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        cv_UMat_UMat_destructor(self)
    }
}
#[doc = " Matrix Expressions /////////////////////////////////"]
#[repr(C)]
#[repr(align(8))]
#[derive(Debug, Copy, Clone)]
pub struct cv_MatOp {
    pub _bindgen_opaque_blob: u64,
}
#[test]
fn bindgen_test_layout_cv_MatOp() {
    assert_eq!(
        ::std::mem::size_of::<cv_MatOp>(),
        8usize,
        concat!("Size of: ", stringify!(cv_MatOp))
    );
    assert_eq!(
        ::std::mem::align_of::<cv_MatOp>(),
        8usize,
        concat!("Alignment of ", stringify!(cv_MatOp))
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv5MatOpC2Ev"]
    pub fn cv_MatOp_MatOp(this: *mut cv_MatOp);
}
impl cv_MatOp {
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_MatOp_MatOp(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv5MatOpD1Ev"]
    pub fn cv_MatOp_MatOp_destructor(this: *mut cv_MatOp);
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp11elementWiseERKNS_7MatExprE"]
    pub fn cv_MatOp_elementWise(this: *mut ::std::os::raw::c_void, expr: *const cv_MatExpr)
        -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp3roiERKNS_7MatExprERKNS_5RangeES6_RS1_"]
    pub fn cv_MatOp_roi(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        rowRange: *const cv_Range,
        colRange: *const cv_Range,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp4diagERKNS_7MatExprEiRS1_"]
    pub fn cv_MatOp_diag(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        d: ::std::os::raw::c_int,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp12augAssignAddERKNS_7MatExprERNS_3MatE"]
    pub fn cv_MatOp_augAssignAdd(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        m: *mut cv_Mat,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp17augAssignSubtractERKNS_7MatExprERNS_3MatE"]
    pub fn cv_MatOp_augAssignSubtract(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        m: *mut cv_Mat,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp17augAssignMultiplyERKNS_7MatExprERNS_3MatE"]
    pub fn cv_MatOp_augAssignMultiply(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        m: *mut cv_Mat,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp15augAssignDivideERKNS_7MatExprERNS_3MatE"]
    pub fn cv_MatOp_augAssignDivide(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        m: *mut cv_Mat,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp12augAssignAndERKNS_7MatExprERNS_3MatE"]
    pub fn cv_MatOp_augAssignAnd(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        m: *mut cv_Mat,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp11augAssignOrERKNS_7MatExprERNS_3MatE"]
    pub fn cv_MatOp_augAssignOr(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        m: *mut cv_Mat,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp12augAssignXorERKNS_7MatExprERNS_3MatE"]
    pub fn cv_MatOp_augAssignXor(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        m: *mut cv_Mat,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp3addERKNS_7MatExprES3_RS1_"]
    pub fn cv_MatOp_add(
        this: *mut ::std::os::raw::c_void,
        expr1: *const cv_MatExpr,
        expr2: *const cv_MatExpr,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp3addERKNS_7MatExprERKNS_7Scalar_IdEERS1_"]
    pub fn cv_MatOp_add1(
        this: *mut ::std::os::raw::c_void,
        expr1: *const cv_MatExpr,
        s: *const cv_Scalar,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp8subtractERKNS_7MatExprES3_RS1_"]
    pub fn cv_MatOp_subtract(
        this: *mut ::std::os::raw::c_void,
        expr1: *const cv_MatExpr,
        expr2: *const cv_MatExpr,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp8subtractERKNS_7Scalar_IdEERKNS_7MatExprERS5_"]
    pub fn cv_MatOp_subtract1(
        this: *mut ::std::os::raw::c_void,
        s: *const cv_Scalar,
        expr: *const cv_MatExpr,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp8multiplyERKNS_7MatExprES3_RS1_d"]
    pub fn cv_MatOp_multiply(
        this: *mut ::std::os::raw::c_void,
        expr1: *const cv_MatExpr,
        expr2: *const cv_MatExpr,
        res: *mut cv_MatExpr,
        scale: f64,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp8multiplyERKNS_7MatExprEdRS1_"]
    pub fn cv_MatOp_multiply1(
        this: *mut ::std::os::raw::c_void,
        expr1: *const cv_MatExpr,
        s: f64,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp6divideERKNS_7MatExprES3_RS1_d"]
    pub fn cv_MatOp_divide(
        this: *mut ::std::os::raw::c_void,
        expr1: *const cv_MatExpr,
        expr2: *const cv_MatExpr,
        res: *mut cv_MatExpr,
        scale: f64,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp6divideEdRKNS_7MatExprERS1_"]
    pub fn cv_MatOp_divide1(
        this: *mut ::std::os::raw::c_void,
        s: f64,
        expr: *const cv_MatExpr,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp3absERKNS_7MatExprERS1_"]
    pub fn cv_MatOp_abs(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp9transposeERKNS_7MatExprERS1_"]
    pub fn cv_MatOp_transpose(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp6matmulERKNS_7MatExprES3_RS1_"]
    pub fn cv_MatOp_matmul(
        this: *mut ::std::os::raw::c_void,
        expr1: *const cv_MatExpr,
        expr2: *const cv_MatExpr,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp6invertERKNS_7MatExprEiRS1_"]
    pub fn cv_MatOp_invert(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
        method: ::std::os::raw::c_int,
        res: *mut cv_MatExpr,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp4sizeERKNS_7MatExprE"]
    pub fn cv_MatOp_size(this: *mut ::std::os::raw::c_void, expr: *const cv_MatExpr) -> cv_Size;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv5MatOp4typeERKNS_7MatExprE"]
    pub fn cv_MatOp_type(
        this: *mut ::std::os::raw::c_void,
        expr: *const cv_MatExpr,
    ) -> ::std::os::raw::c_int;
}
#[doc = " @brief Matrix expression representation"]
#[doc = "@anchor MatrixExpressions"]
#[doc = "This is a list of implemented matrix operations that can be combined in arbitrary complex"]
#[doc = "expressions (here A, B stand for matrices ( Mat ), s for a scalar ( Scalar ), alpha for a"]
#[doc = "real-valued scalar ( double )):"]
#[doc = "-   Addition, subtraction, negation: `A+B`, `A-B`, `A+s`, `A-s`, `s+A`, `s-A`, `-A`"]
#[doc = "-   Scaling: `A*alpha`"]
#[doc = "-   Per-element multiplication and division: `A.mul(B)`, `A/B`, `alpha/A`"]
#[doc = "-   Matrix multiplication: `A*B`"]
#[doc = "-   Transposition: `A.t()` (means A<sup>T</sup>)"]
#[doc = "-   Matrix inversion and pseudo-inversion, solving linear systems and least-squares problems:"]
#[doc = "`A.inv([method]) (~ A<sup>-1</sup>)`,   `A.inv([method])*B (~ X: AX=B)`"]
#[doc = "-   Comparison: `A cmpop B`, `A cmpop alpha`, `alpha cmpop A`, where *cmpop* is one of"]
#[doc = "`>`, `>=`, `==`, `!=`, `<=`, `<`. The result of comparison is an 8-bit single channel mask whose"]
#[doc = "elements are set to 255 (if the particular element or pair of elements satisfy the condition) or"]
#[doc = "0."]
#[doc = "-   Bitwise logical operations: `A logicop B`, `A logicop s`, `s logicop A`, `~A`, where *logicop* is one of"]
#[doc = "`&`, `|`, `^`."]
#[doc = "-   Element-wise minimum and maximum: `min(A, B)`, `min(A, alpha)`, `max(A, B)`, `max(A, alpha)`"]
#[doc = "-   Element-wise absolute value: `abs(A)`"]
#[doc = "-   Cross-product, dot-product: `A.cross(B)`, `A.dot(B)`"]
#[doc = "-   Any function of matrix or matrices and scalars that returns a matrix or a scalar, such as norm,"]
#[doc = "mean, sum, countNonZero, trace, determinant, repeat, and others."]
#[doc = "-   Matrix initializers ( Mat::eye(), Mat::zeros(), Mat::ones() ), matrix comma-separated"]
#[doc = "initializers, matrix constructors and operators that extract sub-matrices (see Mat description)."]
#[doc = "-   Mat_<destination_type>() constructors to cast the result to the proper type."]
#[doc = "@note Comma-separated initializers and probably some other operations may require additional"]
#[doc = "explicit Mat() or Mat_<T>() constructor calls to resolve a possible ambiguity."]
#[doc = ""]
#[doc = "Here are examples of matrix expressions:"]
#[doc = "@code"]
#[doc = "SVD svd(A);"]
#[doc = "Mat pinvA = svd.vt.t()*Mat::diag(1./svd.w)*svd.u.t();"]
#[doc = ""]
#[doc = "x -= (A.t()*A + lambda*Mat::eye(A.cols,A.cols,A.type())).inv(DECOMP_CHOLESKY)*(A.t()*err);"]
#[doc = ""]
#[doc = "Mat blurred; double sigma = 1, threshold = 5, amount = 1;"]
#[doc = "GaussianBlur(img, blurred, Size(), sigma, sigma);"]
#[doc = "Mat lowContrastMask = abs(img - blurred) < threshold;"]
#[doc = "Mat sharpened = img*(1+amount) + blurred*(-amount);"]
#[doc = "img.copyTo(sharpened, lowContrastMask);"]
#[doc = "@endcode"]
#[repr(C)]
#[repr(align(8))]
pub struct cv_MatExpr {
    pub _bindgen_opaque_blob: [u64; 44usize],
}
#[test]
fn bindgen_test_layout_cv_MatExpr() {
    assert_eq!(
        ::std::mem::size_of::<cv_MatExpr>(),
        352usize,
        concat!("Size of: ", stringify!(cv_MatExpr))
    );
    assert_eq!(
        ::std::mem::align_of::<cv_MatExpr>(),
        8usize,
        concat!("Alignment of ", stringify!(cv_MatExpr))
    );
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr4sizeEv"]
    pub fn cv_MatExpr_size(this: *const cv_MatExpr) -> cv_Size;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr4typeEv"]
    pub fn cv_MatExpr_type(this: *const cv_MatExpr) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr3rowEi"]
    pub fn cv_MatExpr_row(this: *const cv_MatExpr, y: ::std::os::raw::c_int) -> cv_MatExpr;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr3colEi"]
    pub fn cv_MatExpr_col(this: *const cv_MatExpr, x: ::std::os::raw::c_int) -> cv_MatExpr;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr4diagEi"]
    pub fn cv_MatExpr_diag(this: *const cv_MatExpr, d: ::std::os::raw::c_int) -> cv_MatExpr;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr1tEv"]
    pub fn cv_MatExpr_t(this: *const cv_MatExpr) -> cv_MatExpr;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr3invEi"]
    pub fn cv_MatExpr_inv(this: *const cv_MatExpr, method: ::std::os::raw::c_int) -> cv_MatExpr;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr3mulERKS0_d"]
    pub fn cv_MatExpr_mul(this: *const cv_MatExpr, e: *const cv_MatExpr, scale: f64) -> cv_MatExpr;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr3mulERKNS_3MatEd"]
    pub fn cv_MatExpr_mul1(this: *const cv_MatExpr, m: *const cv_Mat, scale: f64) -> cv_MatExpr;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr5crossERKNS_3MatE"]
    pub fn cv_MatExpr_cross(this: *const cv_MatExpr, m: *const cv_Mat) -> cv_Mat;
}
extern "C" {
    #[link_name = "\u{1}_ZNK2cv7MatExpr3dotERKNS_3MatE"]
    pub fn cv_MatExpr_dot(this: *const cv_MatExpr, m: *const cv_Mat) -> f64;
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv7MatExpr4swapERS0_"]
    pub fn cv_MatExpr_swap(this: *mut cv_MatExpr, b: *mut cv_MatExpr);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv7MatExprC1Ev"]
    pub fn cv_MatExpr_MatExpr(this: *mut cv_MatExpr);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv7MatExprC1ERKNS_3MatE"]
    pub fn cv_MatExpr_MatExpr1(this: *mut cv_MatExpr, m: *const cv_Mat);
}
extern "C" {
    #[link_name = "\u{1}_ZN2cv7MatExprC1EPKNS_5MatOpEiRKNS_3MatES6_S6_ddRKNS_7Scalar_IdEE"]
    pub fn cv_MatExpr_MatExpr2(
        this: *mut cv_MatExpr,
        _op: *const cv_MatOp,
        _flags: ::std::os::raw::c_int,
        _a: *const cv_Mat,
        _b: *const cv_Mat,
        _c: *const cv_Mat,
        _alpha: f64,
        _beta: f64,
        _s: *const cv_Scalar,
    );
}
impl cv_MatExpr {
    #[inline]
    pub unsafe fn size(&self) -> cv_Size {
        cv_MatExpr_size(self)
    }
    #[inline]
    pub unsafe fn type_(&self) -> ::std::os::raw::c_int {
        cv_MatExpr_type(self)
    }
    #[inline]
    pub unsafe fn row(&self, y: ::std::os::raw::c_int) -> cv_MatExpr {
        cv_MatExpr_row(self, y)
    }
    #[inline]
    pub unsafe fn col(&self, x: ::std::os::raw::c_int) -> cv_MatExpr {
        cv_MatExpr_col(self, x)
    }
    #[inline]
    pub unsafe fn diag(&self, d: ::std::os::raw::c_int) -> cv_MatExpr {
        cv_MatExpr_diag(self, d)
    }
    #[inline]
    pub unsafe fn t(&self) -> cv_MatExpr {
        cv_MatExpr_t(self)
    }
    #[inline]
    pub unsafe fn inv(&self, method: ::std::os::raw::c_int) -> cv_MatExpr {
        cv_MatExpr_inv(self, method)
    }
    #[inline]
    pub unsafe fn mul(&self, e: *const cv_MatExpr, scale: f64) -> cv_MatExpr {
        cv_MatExpr_mul(self, e, scale)
    }
    #[inline]
    pub unsafe fn mul1(&self, m: *const cv_Mat, scale: f64) -> cv_MatExpr {
        cv_MatExpr_mul1(self, m, scale)
    }
    #[inline]
    pub unsafe fn cross(&self, m: *const cv_Mat) -> cv_Mat {
        cv_MatExpr_cross(self, m)
    }
    #[inline]
    pub unsafe fn dot(&self, m: *const cv_Mat) -> f64 {
        cv_MatExpr_dot(self, m)
    }
    #[inline]
    pub unsafe fn swap(&mut self, b: *mut cv_MatExpr) {
        cv_MatExpr_swap(self, b)
    }
    #[inline]
    pub unsafe fn new() -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_MatExpr_MatExpr(__bindgen_tmp.as_mut_ptr());
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new1(m: *const cv_Mat) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_MatExpr_MatExpr1(__bindgen_tmp.as_mut_ptr(), m);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn new2(
        _op: *const cv_MatOp,
        _flags: ::std::os::raw::c_int,
        _a: *const cv_Mat,
        _b: *const cv_Mat,
        _c: *const cv_Mat,
        _alpha: f64,
        _beta: f64,
        _s: *const cv_Scalar,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        cv_MatExpr_MatExpr2(
            __bindgen_tmp.as_mut_ptr(),
            _op,
            _flags,
            _a,
            _b,
            _c,
            _alpha,
            _beta,
            _s,
        );
        __bindgen_tmp.assume_init()
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Landmark {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub visibility: f32,
    pub presence: f32,
}
#[test]
fn bindgen_test_layout_Landmark() {
    assert_eq!(
        ::std::mem::size_of::<Landmark>(),
        20usize,
        concat!("Size of: ", stringify!(Landmark))
    );
    assert_eq!(
        ::std::mem::align_of::<Landmark>(),
        4usize,
        concat!("Alignment of ", stringify!(Landmark))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Landmark>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Landmark),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Landmark>())).y as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(Landmark),
            "::",
            stringify!(y)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Landmark>())).z as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Landmark),
            "::",
            stringify!(z)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Landmark>())).visibility as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(Landmark),
            "::",
            stringify!(visibility)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Landmark>())).presence as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(Landmark),
            "::",
            stringify!(presence)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Pose {
    pub data: [Landmark; 33usize],
}
#[test]
fn bindgen_test_layout_Pose() {
    assert_eq!(
        ::std::mem::size_of::<Pose>(),
        660usize,
        concat!("Size of: ", stringify!(Pose))
    );
    assert_eq!(
        ::std::mem::align_of::<Pose>(),
        4usize,
        concat!("Alignment of ", stringify!(Pose))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Pose>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Pose),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct PoseGraph {
    pub poller: *mut ::std::os::raw::c_void,
    pub graph: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_PoseGraph() {
    assert_eq!(
        ::std::mem::size_of::<PoseGraph>(),
        16usize,
        concat!("Size of: ", stringify!(PoseGraph))
    );
    assert_eq!(
        ::std::mem::align_of::<PoseGraph>(),
        8usize,
        concat!("Alignment of ", stringify!(PoseGraph))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PoseGraph>())).poller as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PoseGraph),
            "::",
            stringify!(poller)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PoseGraph>())).graph as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(PoseGraph),
            "::",
            stringify!(graph)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN9PoseGraph7processEPKN2cv3MatER4Pose"]
    pub fn PoseGraph_process(this: *mut PoseGraph, input: *const cv_Mat, output: *mut Pose)
        -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZN9PoseGraphC1EPKcS1_"]
    pub fn PoseGraph_PoseGraph(
        this: *mut PoseGraph,
        graph_config: *const ::std::os::raw::c_char,
        output_node: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN9PoseGraphD1Ev"]
    pub fn PoseGraph_PoseGraph_destructor(this: *mut PoseGraph);
}
impl PoseGraph {
    #[inline]
    pub unsafe fn process(&mut self, input: *const cv_Mat, output: *mut Pose) -> bool {
        PoseGraph_process(self, input, output)
    }
    #[inline]
    pub unsafe fn new(
        graph_config: *const ::std::os::raw::c_char,
        output_node: *const ::std::os::raw::c_char,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        PoseGraph_PoseGraph(__bindgen_tmp.as_mut_ptr(), graph_config, output_node);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        PoseGraph_PoseGraph_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Hand {
    pub data: [Landmark; 21usize],
}
#[test]
fn bindgen_test_layout_Hand() {
    assert_eq!(
        ::std::mem::size_of::<Hand>(),
        420usize,
        concat!("Size of: ", stringify!(Hand))
    );
    assert_eq!(
        ::std::mem::align_of::<Hand>(),
        4usize,
        concat!("Alignment of ", stringify!(Hand))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<Hand>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Hand),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct HandsGraph {
    pub poller: *mut ::std::os::raw::c_void,
    pub graph: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_HandsGraph() {
    assert_eq!(
        ::std::mem::size_of::<HandsGraph>(),
        16usize,
        concat!("Size of: ", stringify!(HandsGraph))
    );
    assert_eq!(
        ::std::mem::align_of::<HandsGraph>(),
        8usize,
        concat!("Alignment of ", stringify!(HandsGraph))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HandsGraph>())).poller as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(HandsGraph),
            "::",
            stringify!(poller)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<HandsGraph>())).graph as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(HandsGraph),
            "::",
            stringify!(graph)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10HandsGraph7processEPKN2cv3MatER4HandS5_"]
    pub fn HandsGraph_process(
        this: *mut HandsGraph,
        input: *const cv_Mat,
        left: *mut Hand,
        right: *mut Hand,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZN10HandsGraphC1EPKcS1_"]
    pub fn HandsGraph_HandsGraph(
        this: *mut HandsGraph,
        graph_config: *const ::std::os::raw::c_char,
        output_node: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN10HandsGraphD1Ev"]
    pub fn HandsGraph_HandsGraph_destructor(this: *mut HandsGraph);
}
impl HandsGraph {
    #[inline]
    pub unsafe fn process(
        &mut self,
        input: *const cv_Mat,
        left: *mut Hand,
        right: *mut Hand,
    ) -> bool {
        HandsGraph_process(self, input, left, right)
    }
    #[inline]
    pub unsafe fn new(
        graph_config: *const ::std::os::raw::c_char,
        output_node: *const ::std::os::raw::c_char,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        HandsGraph_HandsGraph(__bindgen_tmp.as_mut_ptr(), graph_config, output_node);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        HandsGraph_HandsGraph_destructor(self)
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FaceMesh {
    pub data: [Landmark; 478usize],
}
#[test]
fn bindgen_test_layout_FaceMesh() {
    assert_eq!(
        ::std::mem::size_of::<FaceMesh>(),
        9560usize,
        concat!("Size of: ", stringify!(FaceMesh))
    );
    assert_eq!(
        ::std::mem::align_of::<FaceMesh>(),
        4usize,
        concat!("Alignment of ", stringify!(FaceMesh))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FaceMesh>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FaceMesh),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug)]
pub struct FaceMeshGraph {
    pub poller: *mut ::std::os::raw::c_void,
    pub graph: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_FaceMeshGraph() {
    assert_eq!(
        ::std::mem::size_of::<FaceMeshGraph>(),
        16usize,
        concat!("Size of: ", stringify!(FaceMeshGraph))
    );
    assert_eq!(
        ::std::mem::align_of::<FaceMeshGraph>(),
        8usize,
        concat!("Alignment of ", stringify!(FaceMeshGraph))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FaceMeshGraph>())).poller as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(FaceMeshGraph),
            "::",
            stringify!(poller)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<FaceMeshGraph>())).graph as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(FaceMeshGraph),
            "::",
            stringify!(graph)
        )
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13FaceMeshGraph7processEPKN2cv3MatER8FaceMesh"]
    pub fn FaceMeshGraph_process(
        this: *mut FaceMeshGraph,
        input: *const cv_Mat,
        mesh: *mut FaceMesh,
    ) -> bool;
}
extern "C" {
    #[link_name = "\u{1}_ZN13FaceMeshGraphC1EPKcS1_"]
    pub fn FaceMeshGraph_FaceMeshGraph(
        this: *mut FaceMeshGraph,
        graph_config: *const ::std::os::raw::c_char,
        output_node: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    #[link_name = "\u{1}_ZN13FaceMeshGraphD1Ev"]
    pub fn FaceMeshGraph_FaceMeshGraph_destructor(this: *mut FaceMeshGraph);
}
impl FaceMeshGraph {
    #[inline]
    pub unsafe fn process(&mut self, input: *const cv_Mat, mesh: *mut FaceMesh) -> bool {
        FaceMeshGraph_process(self, input, mesh)
    }
    #[inline]
    pub unsafe fn new(
        graph_config: *const ::std::os::raw::c_char,
        output_node: *const ::std::os::raw::c_char,
    ) -> Self {
        let mut __bindgen_tmp = ::std::mem::MaybeUninit::uninit();
        FaceMeshGraph_FaceMeshGraph(__bindgen_tmp.as_mut_ptr(), graph_config, output_node);
        __bindgen_tmp.assume_init()
    }
    #[inline]
    pub unsafe fn destruct(&mut self) {
        FaceMeshGraph_FaceMeshGraph_destructor(self)
    }
}
