use crate::Error;

use uuid::Uuid;

pub trait UuidExt: Sized {
    fn parse(src: &[u8]) -> Result<Self, Error>;

    fn parse_simple(src: &[u8]) -> Result<Self, Error>;

    fn parse_hyphenated(src: &[u8]) -> Result<Self, Error>;
}

impl UuidExt for Uuid {
    #[inline]
    fn parse(src: &[u8]) -> Result<Self, Error> {
        crate::parse(src).map(Uuid::from_bytes)
    }

    #[inline]
    fn parse_simple(src: &[u8]) -> Result<Self, Error> {
        crate::parse_simple(src).map(Uuid::from_bytes)
    }

    #[inline]
    fn parse_hyphenated(src: &[u8]) -> Result<Self, Error> {
        crate::parse_hyphenated(src).map(Uuid::from_bytes)
    }
}
