specialize_for!("avx2", simd_abstraction::AVX2);

#[cfg(target_feature = "avx2")]
#[test]
fn test_parse() {
    crate::tests::test_parse_ok(|s| unsafe { parse(s.as_bytes()) });
    crate::tests::test_parse_err(|s| unsafe { parse(s.as_bytes()) });
}

#[cfg(target_feature = "avx2")]
#[test]
fn test_format() {
    crate::tests::test_format_simple(|src, upper| unsafe {
        format_simple(src, upper) //
    });
    crate::tests::test_format_hypenated(|src, upper| unsafe {
        format_hyphenated(src, upper) //
    });
}
