#![cfg_attr(not(any(feature = "std", test)), no_std)]

#![deny(clippy::all, clippy::cargo)]
#![allow(clippy::missing_safety_doc)] // TODO

#[allow(unused_macros)]
macro_rules! item_group {
    ($($item:item)*) => {
        $($item)*
    }
}

//
//
//
//
//

#[cfg(test)]
mod tests;

mod polyfill;

#[macro_use]
mod generic;

#[cfg(any(target_arch = "x86", target_arch = "x86_64"))]
item_group! {
    pub mod avx2;
    pub mod sse41;
}

mod auto;

pub mod fallback;

pub use self::auto::*;

//
//
//
//
//
//

use core::fmt;

#[derive(Debug)]
pub struct Error(());

pub(crate) const ERROR: Error = Error(());

impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.write_str("UUID Error")
    }
}

#[cfg(feature = "std")]
impl std::error::Error for Error {}
