use std::sync::{Arc, Mutex, MutexGuard};

#[derive(Debug, Default)]
pub struct Plugin<T> {
    p: Option<Arc<Mutex<T>>>,
}

impl<T> Plugin<T> {
    pub fn none() -> Self {
        Self { p: None }
    }
    pub fn new(m: T) -> Self {
        Self {
            p: Some(Arc::new(Mutex::new(m))),
        }
    }
    pub fn copy_from(&mut self, p: &Self) {
        self.p = p.p.clone();
    }
    pub fn is_plugged_in(&self) -> bool {
        self.p.is_some()
    }
    pub fn unwrap(&self) -> MutexGuard<T> {
        match &self.p {
            Some(v) => v.lock().unwrap(),
            None => panic!("empty plugin."),
        }
    }
}
