use ggez::Context;
use ggez::mint::Point2;
use ggez::graphics::Text;
pub type Pos = Point2<f32>;
pub type Size = Point2<f32>;

pub fn new_pos(x: f32, y: f32) -> Pos {
    Pos { x, y }
}
pub fn new_size(x: f32, y: f32) -> Size {
    Size { x, y }
}

pub fn get_corners(pos: Pos, size: Size) -> [Pos; 4] {
    [
        pos,
        new_pos(pos.x + size.x, pos.y),
        new_pos(pos.x + size.x, pos.y + size.y),
        new_pos(pos.x, pos.y + size.y),
    ]
}
pub fn get_corners_from_middle(pos: Pos, size: Size) -> [Pos; 4] {
    [
        new_pos(pos.x - size.x/2.0, pos.y - size.y/2.0),
        new_pos(pos.x + size.x/2.0, pos.y - size.y/2.0),
        new_pos(pos.x + size.x/2.0, pos.y + size.y/2.0),
        new_pos(pos.x - size.x/2.0, pos.y + size.y/2.0),
    ]
}
pub fn get_middle(pos: Pos, size: Size) -> Pos {
    new_pos(pos.x + size.x / 2.0, pos.y + size.y / 2.0)
}

pub fn get_rect_center(size: Size, rect: (Pos, Size)) -> Pos {
    new_pos(rect.0.x + (rect.1.x - size.y) / 2.0, rect.0.y + (rect.1.y - size.y) / 2.0)
}
pub fn get_text_center(text: Text, rect: (Pos, Size), ctx: &mut Context) -> Pos {
    new_pos(rect.0.x + (rect.1.x - text.width(ctx)) / 2.0, rect.0.y + (rect.1.y - text.height(ctx)) / 2.0)
}

#[cfg(feature = "rand")]
pub fn random_zome_rect(default_pos: Pos, size: Size) -> Pos {
    use rand::Rng;

    let mut rng = rand::thread_rng();
    let random_x: f32 = rng.gen_range(0.0..size.x);
    let random_y: f32 = rng.gen_range(0.0..size.y);
    new_pos(default_pos.x + random_x, default_pos.y + random_y)
}