use super::{Color, Context, GameError, Text, TypeInter, graphics};
use super::Interfacing;
use super::{Pos, new_size, Size};


pub struct Writer {
    pos: Pos,
    text: Text,
    _value: &'static str,
    t: TypeInter,
    color: Color,
}

impl Writer {
    pub fn new(pos: Pos, text: &'static str, color: Color) -> Self {
        Self {
            pos,
            text: Text::new(text),
            _value: text,
            t: TypeInter::Text,
            color
        }
    }
}

impl Interfacing for Writer {
    fn draw_self(&self, ctx: &mut Context) -> Result<(), GameError> {
        graphics::draw(ctx, &self.text, (self.pos, self.color))
    }
    fn get_type(&self) -> &TypeInter {
        &self.t
    }

    fn get_pos(&self) -> &Pos {
        &self.pos
    }

    fn set_pos(&mut self, pos: Pos) -> () {
        self.pos = pos;
    }

    fn draw_recurs(&self, ctx: &mut Context, _i: u8) -> Result<(), GameError> {
        self.draw_self(ctx)
    }

    fn draw_all(&self, ctx: &mut Context) -> Result<(), GameError> {
        self.draw_self(ctx)
    }

    fn get_size(&self) -> &Size { &new_size(0.0, 0.0) }
    fn set_size(&mut self, _ctx: &mut Context, _size: crate::pos::Size) -> () { }

    fn add_composant(&mut self, _name: &'static str, _comp: &'static mut dyn Interfacing) -> () { }

    fn is_click(&self, _pos: Pos) -> bool { false }

    fn get_text(&self) -> &'static str {
        self._value
    }
    fn set_text(&mut self, v: &'static str) -> () {
        self._value = v;
        self.text = Text::new(v);
    }
}