use ggez::{self, Context, GameError, graphics::{self, DrawMode, Mesh, Rect, Color, Text}};
use crate::pos::*;

pub mod containers;
pub mod writers;

pub enum TypeInter {
    Container,
    Text
}

pub trait Interfacing {
    fn draw_self(&self, ctx: &mut Context) -> Result<(), GameError>;

    fn draw_recurs(&self, ctx: &mut Context, i: u8) -> Result<(), GameError>;

    fn draw_all(&self, ctx: &mut Context) -> Result<(), GameError>;

    fn get_type(&self) -> &TypeInter;

    fn get_pos(&self) -> &Pos;
    fn set_pos(&mut self, pos: Pos) -> ();

    fn get_size(&self) -> &Size;
    fn set_size(&mut self, ctx: &mut Context, size: Size) -> ();

    fn add_composant(&mut self, name: &'static str, comp: &'static mut dyn Interfacing) -> ();

    fn is_click(&self, pos: Pos) -> bool;

    fn get_text(&self) -> &'static str;
    fn set_text(&mut self, v: &'static str) -> ();
}

fn create_simple_rectangle(ctx: &mut Context, size: Size) -> Mesh {
    Mesh::new_rectangle(ctx, DrawMode::fill(), Rect::new(0.0, 0.0, size.x, size.y), Color::WHITE).unwrap()
}
