use usiagent::shogi::*;
use usiagent::event::*;
use usiagent::rule::Validate;

#[allow(unused)]
use usiagent::shogi::KomaKind::{
	SFu,
	SKyou,
	SKei,
	SGin,
	SKin,
	SKaku,
	SHisha,
	SOu,
	SFuN,
	SKyouN,
	SKeiN,
	SGinN,
	SKakuN,
	SHishaN,
	GFu,
	GKyou,
	GKei,
	GGin,
	GKin,
	GKaku,
	GHisha,
	GOu,
	GFuN,
	GKyouN,
	GKeiN,
	GGinN,
	GKakuN,
	GHishaN,
	Blank
};
#[test]
fn test_moved_validate() {
	let input_and_expected:Vec<(Moved,bool)> = vec![
		(Moved::To(MovedKind::SOu,(0,1),(8,2),false),false),
		(Moved::To(MovedKind::SOu,(10,1),(8,2),false),false),
		(Moved::To(MovedKind::SOu,(9,0),(8,2),false),false),
		(Moved::To(MovedKind::SOu,(9,10),(8,2),false),false),
		(Moved::To(MovedKind::SOu,(9,1),(0,2),false),false),
		(Moved::To(MovedKind::SOu,(9,1),(10,2),false),false),
		(Moved::To(MovedKind::SOu,(9,1),(8,0),false),false),
		(Moved::To(MovedKind::SOu,(9,1),(8,10),false),false),
		(Moved::To(MovedKind::SOu,(0,1),(8,2),true),false),
		(Moved::To(MovedKind::SOu,(10,1),(8,2),true),false),
		(Moved::To(MovedKind::SOu,(9,0),(8,2),true),false),
		(Moved::To(MovedKind::SOu,(9,10),(8,2),true),false),
		(Moved::To(MovedKind::SOu,(9,1),(0,2),true),false),
		(Moved::To(MovedKind::SOu,(9,1),(10,2),true),false),
		(Moved::To(MovedKind::SOu,(9,1),(8,0),true),false),
		(Moved::To(MovedKind::SOu,(9,1),(8,10),true),false),
		(Moved::Put(MochigomaKind::Fu,(0,1)),false),
		(Moved::Put(MochigomaKind::Fu,(10,1)),false),
		(Moved::Put(MochigomaKind::Fu,(9,0)),false),
		(Moved::Put(MochigomaKind::Fu,(9,10)),false),
		(Moved::To(MovedKind::Kin,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::SOu,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::GOu,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::FuN,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::KyouN,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::KeiN,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::GinN,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::KakuN,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::HishaN,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::Blank,(9,1),(8,2),true),false),
		(Moved::To(MovedKind::Blank,(9,1),(8,2),false),false),

		(Moved::Put(MochigomaKind::Fu,(9,1)),true),
		(Moved::To(MovedKind::Fu,(9,1),(8,2),true),true),
		(Moved::To(MovedKind::Kyou,(9,1),(8,2),true),true),
		(Moved::To(MovedKind::Kei,(9,1),(8,2),true),true),
		(Moved::To(MovedKind::Gin,(9,1),(8,2),true),true),
		(Moved::To(MovedKind::Kin,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::SOu,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::GOu,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::Kaku,(9,1),(8,2),true),true),
		(Moved::To(MovedKind::Hisha,(9,1),(8,2),true),true),
		(Moved::To(MovedKind::Fu,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::Kyou,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::Kei,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::Gin,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::Kaku,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::Hisha,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::FuN,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::KyouN,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::KeiN,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::GinN,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::KakuN,(9,1),(8,2),false),true),
		(Moved::To(MovedKind::HishaN,(9,1),(8,2),false),true),
	];

	for (i,r) in input_and_expected.into_iter() {
		assert_eq!(i.validate(),r);
	}
}