#[allow(warnings)]
#[macro_use]
pub mod macros {
    /// as_to!() Example
    /// convert type
    /// ```rust
    ///  let s = as_to!(5., i64);
    ///  assert_eq!(5, s);
    /// ```
    #[macro_export]
    macro_rules! as_to {
        ( $a:expr,$type:ty ) => {
            ($a as $type)
        };
    }
    use std::any::Any;
    pub fn is_i8(s: &dyn Any) -> bool {
        if s.is::<i8>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i16(s: &dyn Any) -> bool {
        if s.is::<i16>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i32(s: &dyn Any) -> bool {
        if s.is::<i32>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i64(s: &dyn Any) -> bool {
        if s.is::<i64>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i128(s: &dyn Any) -> bool {
        if s.is::<i64>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_f32(s: &dyn Any) -> bool {
        if s.is::<f32>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_f64(s: &dyn Any) -> bool {
        if s.is::<f64>() {
            return true;
        } else {
            return false;
        }
    }

    pub fn pow<T>(a: T, b: T) -> T
    where
        f64: From<T>,
        T: 'static
            + std::ops::MulAssign
            + std::fmt::Display
            + std::ops::Mul<Output = T>
            + Copy
            + std::convert::From<f64>,
    {
        let mut re = a;
        let aa: f64 = a.into();
        let bb: f64 = b.into();
        re = f64::powf(aa, bb).into();
        re
    }
    /// powf!(a,b) Example
    /// a to the power of b
    /// ```rust
    /// let p = powf!(2.,2.);
    /// assert_eq!(p,4.0);
    /// ```
    #[macro_export]
    macro_rules! powf {
        ($a:expr,$b:expr) => {
            f64::powf($a, $b)
        };
    }
    /// arg!() Example
    ///get argument and collect to Vec\<String\>
    /// ```rust
    /// //cargo run -- -n 100
    /// let arg = args!();
    /// assert_eq!(arg,vec![format!("-n"),format!("100")]);
    /// ```
    #[macro_export]
    macro_rules! args {
        () => {
            std::env::args().skip(1).collect::<Vec<String>>()
        };
    }
    /// input!() Example
    /// get user input from terminal
    /// ```rust
    /// let s = input!();
    /// println!("{:?}",s);
    /// ```
    #[macro_export]
    macro_rules! input {
        () => {{
            let mut string = String::new();
            std::io::stdin().read_line(&mut string).unwrap();
            string = string.to_string().trim().to_owned();
            string
        }};
    }
    /// split_to_vec!() Example
    /// a:&str split by b:&str and collect to Vec\<String\>
    /// ```rust
    /// let s = split_to_vec!("aa.bb",".");
    /// assert_eq!(s,vec![format!("aa"),format!("bb")]);
    /// ```
    #[macro_export]
    macro_rules! split_to_vec {
        ($a:expr,$b:expr) => {
            $a.to_string()
                .split($b)
                .filter(|s| !s.is_empty())
                .map(|s| s.to_string())
                .collect::<Vec<String>>()
        };
    }
    /// read_csv!() Example
    /// read .csv file and return Vec\<Vec\<String\>\>
    /// ```rust
    ///let s = read_csv!("./data.csv");
    ///assert_eq!(s,vec![vec![format!("a"), format!("b"), format!("c")],vec![format!("1"), format!("2"), format!("3")],vec![format!("10"), format!("20"), format!("30")]]);
    /// ```
    #[macro_export]
    macro_rules! read_csv {
        ($path:expr) => {{
            let data = std::fs::read($path).unwrap();
            let data_vec = split_to_vec!(&String::from_utf8_lossy(&data), "\r\n");
            let data_each_vec = data_vec
                .iter()
                .map(|s| split_to_vec!(s, ","))
                .collect::<Vec<_>>();
            data_each_vec
        }};
    }
    /// sorted!() Example
    /// return sorted new Vec,
    /// type can be Vec\<i32\> Vec\<i64\> Vec\<i128\> Vec\<f32\> Vec\<f64\>   
    /// ```rust
    /// let s1 = sorted!(vec![1.2, 2.6, 0.2]);
    /// let s2 = sorted!(vec![8, 1_i128, 5_i128]);
    /// assert_eq!(s1,vec![0.2,1.2,2.6]);
    /// assert_eq!(s2,vec![1,5,8]);
    /// ```
    #[macro_export]
    macro_rules! sorted {
        ($vec:expr) => {{
            let mut vec = $vec.clone();
            vec.sort_by(|a, b| a.partial_cmp(b).unwrap());
            vec
        }};
    }
    /// deduped_sorted!() Example
    /// return sorted and deduped new Vec,
    /// type can be Vec\<i32\> Vec\<i64\> Vec\<i128\> Vec\<f32\> Vec\<f64\>   
    /// ```rust
    /// let s1 = deduped_sorted!(vec![1.2, 1.2,2.6, 0.2]);
    /// let s2 = deduped_sorted!(vec![8, 1_i128, ,8,5_i128]);
    /// assert_eq!(s1,vec![0.2,1.2,2.6]);
    /// assert_eq!(s2,vec![1,5,8]);
    /// ```
    #[macro_export]
    macro_rules! deduped_sorted {
        ($vec:expr) => {{
            let mut vec1 = $vec.clone();
            let mut vec2 = sorted!(vec1);
            vec2.dedup();
            vec2
        }};
    }
    /// vec_parse!() Example
    /// parse vec item to f64,
    /// type can be Vec\<i32\> Vec\<i64\> Vec\<i128\> Vec\<f32\> Vec\<f64\>,
    /// return Vec\<f64\>
    /// ```rust
    ///let v1 = vec_parse!(vec!["15.", "2.9"]);
    ///let v2 = vec_parse!(vec!["15", "2"]);
    ///let v3 = vec_parse!(vec![".15", ".2"]);
    ///assert_eq!(vec![15.0, 2.9], v1);
    ///assert_eq!(vec![15.0, 2.0], v2);
    ///assert_eq!(vec![0.15, 0.2], v3);
    /// ```
    #[macro_export]
    macro_rules! vec_parse {
        ($vec:expr) => {{
            let mut v2: Vec<f64> = Vec::new();
            if $vec.len() > 0 {
                match &$vec[0].parse::<f64>() {
                    Ok(r) => {
                        let vec1 = $vec.clone();
                        v2 = vec1
                            .iter()
                            .map(|x| x.to_string().parse::<f64>().unwrap())
                            .collect::<Vec<_>>();
                    }
                    Err(e) => {}
                }
            }
            v2
        }};
    }
    /// vec_as_string!() used to
    /// convert vec item to String,
    /// type can be Vec\<i32\> Vec\<i64\> Vec\<i128\> Vec\<f32\> Vec\<f64\>,Vec\<&str\>
    /// return Vec\<String\>
    /// ```rust
    ///let v1 = vec_as_string!(vec!["15.", "2.9"]);
    ///let v2 = vec_as_string!(vec![15, 2]);
    ///let v3 = vec_as_string!(vec![0.15, 0.2]);
    ///assert_eq!(vec!["15.", "2.9"], v1);
    ///assert_eq!(vec!["15", "2"], v2);
    ///assert_eq!(vec!["0.15", "0.2"], v3);
    /// ```
    #[macro_export]
    macro_rules! vec_as_string {
        ($vec:expr) => {{
            let mut v2: Vec<String> = Vec::new();
            if $vec.len() > 0 {
                let vec1 = $vec.clone();
                v2 = vec1
                    .iter()
                    .map(|x| format!("{}", &x))
                    .collect::<Vec<String>>();
            }
            v2
        }};
    }
    /// snail_sort!() return the array elements arranged from outermost elements to the middle element, traveling clockwise.n x n
    /// type can be Vec\<Vec\<T\>\>
    /// return Vec\<T\>
    /// ```rust
    ///let v1 = snail_sort!(vec![vec![1, 2, 3], vec![4, 5, 6], vec![7, 8, 9]]);
    ///let v2 =  snail_sort!(vec![vec![1.1, 2.1, 3.1],vec![4.1, 5.1, 6.1],vec![7.1, 8.1, 9.1]]);
    ///assert_eq!(vec![1, 2, 3, 6, 9, 8, 7, 4, 5], v1);
    ///assert_eq!(vec![1.1, 2.1, 3.1, 6.1, 9.1, 8.1, 7.1, 4.1, 5.1], v2);
    /// ```
    #[macro_export]
    macro_rules! snail_sort {
        ($vec:expr) => {{
            fn snail<T: Copy>(matrix: &[Vec<T>]) -> Vec<T> {
                let mut ret = Vec::new();
                if matrix.len() == 0 {
                    return ret;
                }
                let mut width = matrix[0].len();
                let mut height = matrix.len();
                let mut cycle = 0;
                while width > 0 && height > 0 {
                    for x in cycle..width {
                        ret.push(matrix[cycle][x]);
                    }
                    for y in cycle + 1..height {
                        ret.push(matrix[y][width - 1]);
                    }
                    for x in (cycle..width - 1).rev() {
                        ret.push(matrix[height - 1][x]);
                    }
                    for y in (cycle + 1..height - 1).rev() {
                        ret.push(matrix[y][cycle]);
                    }
                    cycle += 1;
                    width -= 1;
                    height -= 1;
                }
                ret
            }
            let vec = $vec.clone();
            snail(&vec)
        }};
    }

    /// multiply_matrix!() return the mutiply result of two matrix
    /// take two matrix and type can be Vec\<Vec\<f64\>\>
    /// return Vec\<f64\>
    /// ```rust
    ///let m1: Vec<Vec<f64>> = vec![vec![1.0, 2.0], vec![1.0, 2.0]];
    ///let m2: Vec<Vec<f64>> = vec![vec![0.0, 0.0], vec![0.0, 0.5]];
    ///let mul_result = multiply_matrix!(&m2, &m1);
    ///assert_eq!(mul_result, vec![[0.0, 0.0], [0.5, 1.0]]);
    /// ```
    #[macro_export]
    macro_rules! multiply_matrix {
        ($vec1:expr,$vec2:expr) => {{
            pub fn new(m: usize, n: usize) -> Vec<Vec<f64>> {
                //returb 0 created n*m matrix
                let mut mat = Vec::new();
                for i in 0..m {
                    mat.push(vec![0; n].iter().map(|s| *s as f64).collect::<Vec<_>>());
                }
                let vec = mat.clone();
                vec
            }
            pub fn multiply_matrix<'a>(
                matrix1: &'a Vec<Vec<f64>>,
                matrix2: &'a Vec<Vec<f64>>,
            ) -> Vec<Vec<f64>> {
                let m = &matrix2.len();
                let n = &matrix1[0].len();
                let mut matrix3: Vec<Vec<f64>> = new(*&matrix2.len(), *&matrix2[0].len());
                for i in 0..*&matrix2.len() {
                    for j in 0..*&matrix2[0].len() {
                        for k in 0..*m {
                            matrix3[i][j] += matrix1[i][k] * matrix2[k][j];
                        }
                    }
                }
                matrix3
            }
            let vec1 = $vec1.clone();
            let vec2 = $vec2.clone();
            multiply_matrix(&vec1, &vec2)
        }};
    }
    pub fn run() {}
}

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
