# collections of useful macros
## example
```rust
use useful_macro::*;
//get argument and into Vec<String>
//cargo run -- -n 100
let arg = args!();
assert_eq!(arg,vec![format!("-n"),format!("100")]);

//get input and into String
let s = input!();
println!("{:?}",s);

//power of two f64 number
let p = powf!(2.,2.);
assert_eq!(p,4.0);

//split a:&str by b:&str and collect into Vec<String>  
let s = split_to_vec!("aa.bb",".");
assert_eq!(s,vec![format!("aa"),format!("bb")]);

// read .csv file and return Vec<Vec<String>>
let s = read_csv!("./data.csv");
assert_eq!(s,vec![vec![format!("a"), format!("b"), format!("c")],vec![format!("1"), format!("2"), format!("3")],vec![format!("10"), format!("20"), format!("30")]]);

//return sorted vec
// type can be Vec<i8> Vec<i16> Vec<i32> Vec<i64> Vec<i128> Vec<f32> Vec<f64>
let s1 = sorted!(vec![1.2, 2.6, 0.2]);
let s2 = sorted!(vec![8, 1_i128, 5_i128]);
assert_eq!(s1,vec![0.2,1.2,2.6]);
assert_eq!(s2,vec![1,5,8]);

// return sorted and deduped new Vec
// type can be Vec<i8> Vec<i16> Vec<i32> Vec<i64> Vec<i128> Vec<f32> Vec<f64>
let s1 = deduped_sorted!(vec![1.2, 1.2,2.6, 0.2]);
let s2 = deduped_sorted!(vec![8, 1_i128, ,8,5_i128]);
assert_eq!(s1,vec![0.2,1.2,2.6]);
assert_eq!(s2,vec![1,5,8]);

//parse Vec element to f64,
//type can be Vec<&str>
//return Vec<f64>
let v1 = vec_parse!(vec!["15.", "2.9"]);
let v2 = vec_parse!(vec!["15", "2"]);
let v3 = vec_parse!(vec![".15", ".2"]);
assert_eq!(vec![15.0, 2.9], v1);
assert_eq!(vec![15.0, 2.0], v2);
assert_eq!(vec![0.15, 0.2], v3);

 //vec_as_string!() used to
// convert vec item to String,
// type can be Vec<i32> Vec<i64> Vec<i128> Vec<f32> Vec<f64>,Vec<&str>
// return Vec<String>
let v1 = vec_as_string!(vec!["15.", "2.9"]);
let v2 = vec_as_string!(vec![15, 2]);
let v3 = vec_as_string!(vec![0.15, 0.2]);
assert_eq!(vec!["15.", "2.9"], v1);
assert_eq!(vec!["15", "2"], v2);
assert_eq!(vec!["0.15", "0.2"], v3);
```
```rust
//snail_sort!() return the array elements arranged from outermost 
//elements to the middle element, traveling clockwise.n x n
//type can be Vec<Vec<T>>
//return Vec<T>
```
<div align="center">
<img src="https://www.haan.lu/files/2513/8347/2456/snail.png"/>
</div>

```rust
let v1 = snail_sort!(vec![vec![1, 2, 3], vec![4, 5, 6], vec![7, 8, 9]]);
let v2 =  snail_sort!(vec![vec![1.1, 2.1, 3.1],vec![4.1, 5.1, 6.1],vec![7.1, 8.1, 9.1]]);
assert_eq!(vec![1, 2, 3, 6, 9, 8, 7, 4, 5], v1);
assert_eq!(vec![1.1, 2.1, 3.1, 6.1, 9.1, 8.1, 7.1, 4.1, 5.1], v2);

// multiply_matrix!() return the mutiply result of two matrix
// take two matrix and type can be Vec<Vec<f64>>
// return Vec<f64>
let m1: Vec<Vec<f64>> = vec![vec![1.0, 2.0], vec![1.0, 2.0]];
let m2: Vec<Vec<f64>> = vec![vec![0.0, 0.0], vec![0.0, 0.5]];
let mul_result = multiply_matrix!(&m2, &m1);
assert_eq!(mul_result, vec![[0.0, 0.0], [0.5, 1.0]]);
```
