#[allow(warnings)]
#[macro_use]
pub mod macros {
    /// as_to!() Example
    /// convert type
    /// ```rust
    ///  let s = as_to!(5., i64);
    ///  assert_eq!(5, s);
    /// ```
    #[macro_export]
    macro_rules! as_to {
        ( $a:expr,$type:ty ) => {
            ($a as $type)
        };
    }
    use std::any::Any;
    pub fn is_i8(s: &dyn Any) -> bool {
        if s.is::<i8>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i16(s: &dyn Any) -> bool {
        if s.is::<i16>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i32(s: &dyn Any) -> bool {
        if s.is::<i32>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i64(s: &dyn Any) -> bool {
        if s.is::<i64>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i128(s: &dyn Any) -> bool {
        if s.is::<i64>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_f32(s: &dyn Any) -> bool {
        if s.is::<f32>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_f64(s: &dyn Any) -> bool {
        if s.is::<f64>() {
            return true;
        } else {
            return false;
        }
    }

    pub fn pow<T>(a: T, b: T) -> T
    where
        f64: From<T>,
        T: 'static
            + std::ops::MulAssign
            + std::fmt::Display
            + std::ops::Mul<Output = T>
            + Copy
            + std::convert::From<f64>,
    {
        let mut re = a;
        let aa: f64 = a.into();
        let bb: f64 = b.into();
        re = f64::powf(aa, bb).into();
        re
    }
    /// powf!(a,b) Example
    /// a to the power of b
    /// ```rust
    /// let p = powf!(2.,2.);
    /// assert_eq!(p,4.0);
    /// ```
    #[macro_export]
    macro_rules! powf {
        ($a:expr,$b:expr) => {
            f64::powf($a, $b)
        };
    }
    /// arg!() Example
    ///get argument and collect to Vec\<String\>
    /// ```rust
    /// //cargo run -- -n 100
    /// let arg = args!();
    /// assert_eq!(arg,vec![format!("-n"),format!("100")]);
    /// ```
    #[macro_export]
    macro_rules! args {
        () => {
            std::env::args().skip(1).collect::<Vec<String>>()
        };
    }
    /// input!() Example
    /// get user input from terminal
    /// ```rust
    /// let s = input!();
    /// println!("{:?}",s);
    /// ```
    #[macro_export]
    macro_rules! input {
        () => {{
            let mut string = String::new();
            std::io::stdin().read_line(&mut string).unwrap();
            string = string.to_string().trim().to_owned();
            string
        }};
    }
    /// split_to_vec!() Example
    /// a:&str split by b:&str and collect to Vec\<String\>
    /// ```rust
    /// let s = split_to_vec!("aa.bb",".");
    /// assert_eq!(s,vec![format!("aa"),format!("bb")]);
    /// ```
    #[macro_export]
    macro_rules! split_to_vec {
        ($a:expr,$b:expr) => {
            $a.to_string()
                .split($b)
                .filter(|s| !s.is_empty())
                .map(|s| s.to_string())
                .collect::<Vec<String>>()
        };
    }
    /// read_csv!() Example
    /// read .csv file and return Vec\<Vec\<String\>\>
    /// ```rust
    ///let s = read_csv!("./data.csv");
    ///assert_eq!(s,vec![vec![format!("a"), format!("b"), format!("c")],vec![format!("1"), format!("2"), format!("3")],vec![format!("10"), format!("20"), format!("30")]]);
    /// ```
    #[macro_export]
    macro_rules! read_csv {
        ($path:expr) => {{
            let data = std::fs::read($path).unwrap();
            let data_vec = split_to_vec!(&String::from_utf8_lossy(&data), "\r\n");
            let data_each_vec = data_vec
                .iter()
                .map(|s| split_to_vec!(s, ","))
                .collect::<Vec<_>>();
            data_each_vec
        }};
    }
    /// sorted!() Example
    /// return sorted new Vec,
    /// type can be Vec\<i32\> Vec\<i64\> Vec\<i128\> Vec\<f32\> Vec\<f64\>   
    /// ```rust
    /// let s1 = sorted!(vec![1.2, 2.6, 0.2]);
    /// let s2 = sorted!(vec![8, 1_i128, 5_i128]);
    /// assert_eq!(s1,vec![0.2,1.2,2.6]);
    /// assert_eq!(s2,vec![1,5,8]);
    /// ```
    #[macro_export]
    macro_rules! sorted {
        ($vec:expr) => {{
            let mut vec = $vec.clone();
            vec.sort_by(|a, b| a.partial_cmp(b).unwrap());
            vec
        }};
    }
    /// deduped_sorted!() Example
    /// return sorted and deduped new Vec,
    /// type can be Vec\<i32\> Vec\<i64\> Vec\<i128\> Vec\<f32\> Vec\<f64\>   
    /// ```rust
    /// let s1 = deduped_sorted!(vec![1.2, 1.2,2.6, 0.2]);
    /// let s2 = deduped_sorted!(vec![8, 1_i128, ,8,5_i128]);
    /// assert_eq!(s1,vec![0.2,1.2,2.6]);
    /// assert_eq!(s2,vec![1,5,8]);
    /// ```
    #[macro_export]
    macro_rules! deduped_sorted {
        ($vec:expr) => {{
            let mut vec1 = $vec.clone();
            let mut vec2 = sorted!(vec1);
            vec2.dedup();
            vec2
        }};
    }
    /// vec_parse!() Example
    /// parse vec item to f64,
    /// type can be Vec\<i32\> Vec\<i64\> Vec\<i128\> Vec\<f32\> Vec\<f64\>,
    /// return Vec\<f64\>
    /// ```rust
    ///let v1 = vec_parse!(vec!["15.", "2.9"]);
    ///let v2 = vec_parse!(vec!["15", "2"]);
    ///let v3 = vec_parse!(vec![".15", ".2"]);
    ///assert_eq!(vec![15.0, 2.9], v1);
    ///assert_eq!(vec![15.0, 2.0], v2);
    ///assert_eq!(vec![0.15, 0.2], v3);
    /// ```
    #[macro_export]
    macro_rules! vec_parse {
        ($vec:expr) => {{
            let mut v2: Vec<f64> = Vec::new();

            if $vec.len() > 0 {
                match &$vec[0].parse::<f64>() {
                    Ok(r) => {
                        let vec1 = $vec.clone();
                        v2 = vec1
                            .iter()
                            .map(|x| x.to_string().parse::<f64>().unwrap())
                            .collect::<Vec<_>>();
                    }
                    Err(e) => {}
                }
            }
            v2
        }};
    }

    pub fn run() {
        let v1 = vec_parse!(vec!["15.", "2.9"]);
        let v2 = vec_parse!(vec!["15", "2"]);
        let v3 = vec_parse!(vec![".15", ".2"]);
        assert_eq!(vec![15.0, 2.9], v1);
        assert_eq!(vec![15.0, 2.0], v2);
        assert_eq!(vec![0.15, 0.2], v3);
    }
}

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
