# collections of useful macros
## example
```rust
use useful_macro::*;
//get argument and into Vec<String>
//cargo run -- -n 100
let arg = args!();
assert_eq!(arg,vec![format!("-n"),format!("100")]);

//get input and into String
let s = input!();
println!("{:?}",s);

//power of two f64 number
let p = powf!(2.,2.);
assert_eq!(p,4.0);

//split a:&str by b:&str and collect into Vec<String>  
let s = split_to_vec!("aa.bb",".");
assert_eq!(s,vec![format!("aa"),format!("bb")]);

// read .csv file and return Vec<Vec<String>>
let s = read_csv!("./data.csv");
assert_eq!(s,vec![vec![format!("a"), format!("b"), format!("c")],vec![format!("1"), format!("2"), format!("3")],vec![format!("10"), format!("20"), format!("30")]]);

// return sorted new Vec ,type can be Vec<i32> Vec<i64> Vec<i128> Vec<f32> Vec<f64> 
let s1 = sorted!(vec![1.2, 2.6, 0.2]);
let s2 = sorted!(vec![8, 1_i128, 5_i128]);
assert_eq!(s1,vec![0.2,1.2,2.6]);
assert_eq!(s2,vec![1,5,8]);

// return sorted and deduped new Vec
// type can be Vec<i32> Vec<i64> Vec<i128> Vec<f32> Vec<f64>
let s1 = deduped_sorted!(vec![1.2, 1.2,2.6, 0.2]);
let s2 = deduped_sorted!(vec![8, 1_i128, ,8,5_i128]);
assert_eq!(s1,vec![0.2,1.2,2.6]);
assert_eq!(s2,vec![1,5,8]);
```
