#[allow(warnings)]
#[macro_use]
pub mod macros {
    /// as_to!() Example
    /// convert type
    /// ```rust
    /// let s = as_to!(5.,i64);
    /// println!("{:?}",s);
    /// ```
    #[macro_export]
    macro_rules! as_to {
        ( $a:expr,$type:ty ) => {
            ($a as $type)
        };
    }
    use std::any::Any;
    pub fn is_i8(s: &dyn Any) -> bool {
        if s.is::<i8>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i16(s: &dyn Any) -> bool {
        if s.is::<i16>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i32(s: &dyn Any) -> bool {
        if s.is::<i32>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i64(s: &dyn Any) -> bool {
        if s.is::<i64>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_i128(s: &dyn Any) -> bool {
        if s.is::<i64>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_f32(s: &dyn Any) -> bool {
        if s.is::<f32>() {
            return true;
        } else {
            return false;
        }
    }
    pub fn is_f64(s: &dyn Any) -> bool {
        if s.is::<f64>() {
            return true;
        } else {
            return false;
        }
    }

    pub fn pow<T>(a: T, b: T) -> T
    where
        f64: From<T>,
        T: 'static
            + std::ops::MulAssign
            + std::fmt::Display
            + std::ops::Mul<Output = T>
            + Copy
            + std::convert::From<f64>,
    {
        let mut re = a;
        let aa: f64 = a.into();
        let bb: f64 = b.into();
        re = f64::powf(aa, bb).into();
        re
    }
    /// powf!(a,b) Example
    /// a to the power of b
    /// ```rust
    /// let p = powf!(2.,2.);
    /// println!("{:?}",p);
    /// ```
    #[macro_export]
    macro_rules! powf {
        ($a:expr,$b:expr) => {
            f64::powf($a, $b)
        };
    }
    /// arg!() Example
    ///get argument and collect to Vec<String>
    /// ```rust
    /// let arg = args!();
    /// println!("{:?}",arg);
    /// ```
    #[macro_export]
    macro_rules! args {
        () => {
            std::env::args().skip(1).collect::<Vec<String>>()
        };
    }
    /// input!() Example
    /// get user input from terminal
    /// ```rust
    /// let s = input!();
    /// println!("{:?}",s);
    /// ```
    #[macro_export]
    macro_rules! input {
        () => {{
            let mut string = String::new();
            std::io::stdin().read_line(&mut string).unwrap();
            string = string.to_string().trim().to_owned();
            string
        }};
    }
    /// split_to_vec!() Example
    /// a:&str split by b:&str and collect to Vec<String>
    /// ```rust
    /// let s = split_to_vec!("aa.bb",".");
    /// println!("{:?}",s);
    /// ```
    #[macro_export]
    macro_rules! split_to_vec {
        ($a:expr,$b:expr) => {
            $a.to_string()
                .split($b)
                .filter(|s| !s.is_empty())
                .map(|s| s.to_string())
                .collect::<Vec<String>>()
        };
    }
    /// read_csv!() Example
    /// read .csv file and return Vec<Vec<String>>
    /// ```rust
    /// let s = read_csv!("./data.csv");
    /// println!("{:?}",s);
    /// ```
    #[macro_export]
    macro_rules! read_csv {
        ($path:expr) => {{
            let data = std::fs::read($path).unwrap();
            let data_vec = split_to_vec!(&String::from_utf8_lossy(&data), "\r\n");
            let data_each_vec = data_vec
                .iter()
                .map(|s| split_to_vec!(s, ","))
                .collect::<Vec<_>>();
            data_each_vec
        }};
    }
    pub fn run() {
        // println!("{:?}", powf!(4., 2.));
        // println!("{:?}", split_to_vec!("dnrops.gitee.io", "."));
        // println!("{:?}", args!()); //get argument Vec<String>
        // println!("{:?}", input!()); //get input from treminal to String
        println!("{:?}", read_csv!("./data.csv"));
    }
}

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
