# usb-compat-01-sys
[![Crates.io](https://img.shields.io/crates/v/usb-compat-01-sys)](https://crates.io/crates/usb-compat-01-sys)

**Warning:** If you just need to use libusb, you might be better off with the [`libusb` crate](https://crates.io/crates/libusb).

This crate exists mainly to provide linkage to [`libusb-compat-0.1`](https://github.com/alexrsagen/libusb-compat-0.1), which is useful for creating Rust bindings to projects which utilize libusb 0.1.

In summary, it provides:
- Low-level bindings to `libusb-compat-0.1`, generated by [`bindgen`](https://crates.io/crates/bindgen)
- [Metadata](https://doc.rust-lang.org/cargo/reference/build-scripts.html#the-links-manifest-key) which allows dependent crates to find the `libusb/usb.h` header, compile native code that depends on `libusb-compat-0.1` or link to it in Rust code.
- Vendored submodule copy of `libusb-compat-0.1` (with build tweaks for `x86_64-pc-windows-msvc`), which means you don't have to separately install `libusb-compat-0.1` to use this crate.

## Usage
Add `usb-compat-01-sys` as a dependency in your project's `Cargo.toml` file:
```toml
[dependencies]
usb-compat-01-sys = "0.2"
```

Import the `usb_compat_01_sys` crate in your project, then you can use all functions starting with `usb_` from `libusb-compat-0.1`.

See the [`libusb-compat-0.1` wiki](https://github.com/libusb/libusb-compat-0.1/wiki) or [`libusb-compat-0.1` examples](https://github.com/libusb/libusb-compat-0.1/tree/v0.1.7/examples) for information on how to use it. The API is the same, as this is just a binding.
