/// List of domains for some known
/// URL shortening services.
pub(crate) static SERVICES: [&str; 86] = [
    "adf.ly",
    "adfoc.us",
    "amzn.to",
    "atominik.com",
    "ay.gy",
    "b.link",
    "bit.ly",
    "bit.do",
    "bn.gy",
    "branch.io",
    "buff.ly",
    "ceesty.com",
    "chollo.to",
    "cli.re",
    "cli.fm",
    "cutt.ly",
    "cutt.us",
    "db.tt",
    "f.ls",
    "fa.by",
    "fb.me",
    "flip.it",
    "fumacrom.com",
    "git.io",
    "goo.gl",
    "gns.io",
    "hmm.rs",
    "ht.ly",
    "hyperurl.co",
    "is.gd",
    "intamema.com",
    "ity.im",
    "j.gs",
    "j.mp",
    "kutt.it",
    "ldn.im",
    "linklyhq.com",
    "microify.com",
    "mzl.la",
    "nmc.sg",
    "nowlinks.net",
    "ow.ly",
    "plu.sh",
    "q.gs",
    "qr.ae",
    "qr.net",
    "rb.gy",
    "rebrand.ly",
    "rlu.ru",
    "rotf.lol",
    "s.coop",
    "s.id",
    "sh.st",
    "soo.gd",
    "short.gy",
    "shortcm.xyz",
    "shorturl.at",
    "smu.sg",
    "smq.tc",
    "snip.ly",
    "snipr.com",
    "snipurl.com",
    "snurl.com",
    "split.to",
    "t.co",
    "t.ly",
    "t2m.io",
    "tiny.cc",
    "tiny.pl",
    "tinyium.com",
    "tinyurl.com",
    "tiny.one",
    "tny.im",
    "tny.sh",
    "tr.im",
    "trib.al",
    "u.to",
    "v.gd",
    "virg.in",
    "vzturl.com",
    "waa.ai",
    "washex.am",
    "x.co",
    "y2u.be",
    "yourwish.es",
    "zpr.io",
];

/// Check and tell which URL Shortner Service is used
pub(crate) fn which_service(url: &str) -> Option<&'static str> {
    SERVICES.iter().find(|&x| url.contains(x)).copied()
}
