/// List of domains for some known
/// URL shortening services.
pub(crate) static SERVICES: [&str; 70] = [
    "adf.ly",
    "adfoc.us",
    "amzn.to",
    "atominik.com",
    "b.link",
    "bit.ly",
    "bit.do",
    "bn.gy",
    "buff.ly",
    "chollo.to",
    "cli.re",
    "cli.fm",
    "cutt.ly",
    "db.tt",
    "fa.by",
    "fb.me",
    "flip.it",
    "fumacrom.com",
    "git.io",
    "goo.gl",
    "gns.io",
    "hmm.rs",
    "hyperurl.co",
    "is.gd",
    "intamema.com",
    "ity.im",
    "j.gs",
    "j.mp",
    "kutt.it",
    "ldn.im",
    "linklyhq.com",
    "mzl.la",
    "nmc.sg",
    "nowlinks.net",
    "ow.ly",
    "q.gs",
    "qr.ae",
    "rb.gy",
    "rebrand.ly",
    "rlu.ru",
    "rotf.lol",
    "s.coop",
    "s.id",
    "sh.st",
    "soo.gd",
    "short.gy",
    "shortcm.xyz",
    "shorturl.at",
    "smu.sg",
    "snipr.com",
    "snipurl.com",
    "snurl.com",
    "split.to",
    "t.co",
    "t.ly",
    "t2m.io",
    "tiny.cc",
    "tiny.pl",
    "tinyurl.com",
    "tiny.one",
    "tny.im",
    "tny.sh",
    "tr.im",
    "u.to",
    "v.gd",
    "virg.in",
    "x.co",
    "y2u.be",
    "yourwish.es",
    "zpr.io",
];

/// Check and tell which URL Shortner Service is used
pub(crate) fn which_service(url: &str) -> Option<&'static str> {
    SERVICES.iter().find(|&x| url.contains(x)).copied()
}
