#![forbid(unsafe_code)]

/// Encode an entire URL.
pub fn encode_uri(s: impl AsRef<str>) -> String {
    let mut encoded = String::with_capacity(s.as_ref().len());
    for c in s.as_ref().as_bytes() {
        match c {
            b'A'..=b'Z'
            | b'a'..=b'z'
            | b'0'..=b'9'
            | b'-'
            | b'_'
            | b'.'
            | b'!'
            | b'~'
            | b'*'
            | b'\''
            | b'('
            | b')'
            | b';'
            | b','
            | b'/'
            | b'?'
            | b':'
            | b'@'
            | b'&'
            | b'='
            | b'+'
            | b'$'
            | b'#' => encoded.push(char::from_u32(*c as _).unwrap()),
            c => {
                encoded.push('%');
                encoded.push_str(&format!("{:02x}", c));
            }
        }
    }
    encoded
}

/// Encode an URL component, such as a path segment.
pub fn encode_uri_component(s: impl AsRef<str>) -> String {
    let mut encoded = String::with_capacity(s.as_ref().len());
    for c in s.as_ref().as_bytes() {
        match c {
            b'A'..=b'Z'
            | b'a'..=b'z'
            | b'0'..=b'9'
            | b'-'
            | b'_'
            | b'.'
            | b'!'
            | b'~'
            | b'*'
            | b'\''
            | b'('
            | b')' => encoded.push(char::from_u32(*c as _).unwrap()),
            c => {
                encoded.push('%');
                encoded.push_str(&format!("{:02x}", c));
            }
        }
    }
    encoded
}

/// Encode a query name or value.
pub fn encode_query_param(s: impl AsRef<str>) -> String {
    let mut encoded = String::with_capacity(s.as_ref().len());
    for c in s.as_ref().as_bytes() {
        match c {
            b' ' => encoded.push('+'),
            b'A'..=b'Z'
            | b'a'..=b'z'
            | b'0'..=b'9'
            | b'-'
            | b'_'
            | b'.'
            | b'!'
            | b'~'
            | b'*'
            | b'\''
            | b'('
            | b')'
            | b';'
            | b','
            | b'/'
            | b'?'
            | b':'
            | b'@'
            | b'&'
            | b'='
            | b'+'
            | b'$'
            | b'#' => encoded.push(char::from_u32(*c as _).unwrap()),
            c => {
                encoded.push('%');
                encoded.push_str(&format!("{:02x}", c));
            }
        }
    }
    encoded
}
