export async function fetcher(key: string) {
  const response = await fetch(key);
  if (response.ok) {
    return await response.json();
  } else {
    throw await response.text();
  }
}

export function construct(query: string, args: string[]) {
  let result = query;
  args.forEach((arg) => {
    arg = arg.replaceAll("\"", "\\\"");
    result = result.replace("#", `"${arg}"`);
  });
  return result;
}
